<?
include ("dbdrv/php-txt-db-api/pre_sql_parser.php");

$to_int = array ("BIT", "BIGINT", "NUMERIC", "BOOLEAN", "TINYINT", "INTEGER", "INT", "SMALLINT", "TIMESTAMP");
$to_str = array ("CHAR", "TEXT", "DATE", "TIME", "FLOAT", "DOUBLE", "STRING", "DECIMAL", "VARCHAR", "LONGVARCHAR", "LONGTEXT", "longtext");
$string_markers = array ("'", "`", "\"");
$ban = array ("NOT", "NULL", "IF", "EXISTS", "PRIMARY", "KEY");

function wptxtdb_adapt_query ($query) {
	global $to_int, $to_str, $string_markers, $ban;

	// Initializing SQL Pre-parser
	$sql = new SQL_Parser (false, false);

	// Pre-parsing of query
	$result = $sql->parse ($query);

	//print_r ($result);
	// Initializing some variables for parsing
	$new_query = array ();
	$sub_parents = 0;
	$last_parents = 0;
	$in_string = false;
	$let_build = true;
	$add_comma = false;

	if ($result[0]["command"] != "CREATE TABLE" && $result[0]["command"] != "DROP TABLE") {
		$new_query = $query;
		$let_build = false;
	}

	// Analyzing parse results
	for ($i=0;$i<count($result[0]["result"]) && $let_build;$i++) {
		if ($result[0]["result"][$i] == "(") $sub_parents++;
		if ($result[0]["result"][$i] == ")") {
			$sub_parents--;
			if ($sub_parents == 1) continue;
		}
		if (in_array ($result[0]["result"][$i], $string_markers) && $result[0]["result"][$i-1] != "\\") $in_string = !$in_string;
		switch ($result[0]["command"]) {
			case "CREATE TABLE":
				if ($last_parents == 1 && $sub_parents == 0) {
					$new_query[] = ");";
					$i = count($result[0]["result"]);
					break;
				}
				if ($sub_parents > 1) continue;
				if (in_array ($result[0]["result"][$i], $sql->types)) {
					if (in_array ($result[0]["result"][$i], $to_str)) {
						$new_query[] = "STR";
					}
					elseif (in_array ($result[0]["result"][$i], $to_int)) {
						$new_query[] = "INT";
					}
					else {
						$new_query[] = $result[0]["result"][$i];
					}
					$tipo = count ($new_query)-1;
				}
				elseif ($result[0]["result"][$i] == "auto_increment") {
					$new_query[$tipo] = "INC";
				}
				elseif (in_array($result[0]["result"][$i], $ban) && !$in_string) {
					continue;
				}
				elseif ($result[0]["result"][$i] == "DEFAULT") {
					$new_query[] = $result[0]["result"][$i];
					$new_query[] = "'".$result[0]["result"][++$i]."'";
				}
				elseif ($result[0]["result"][$i] == ",") {
					$add_comma = true;
				}
				else {
					if ($add_comma == true && $result[0]["result"][$i] != ")") {
						$new_query[] = ",";
						$add_comma = false;
					}
					$new_query[] = $result[0]["result"][$i];
				}
				$last_parents = $sub_parents;
				break;
			case "DROP TABLE":
				if (!in_array ($result[0]["result"][$i], $ban)) {
					$new_query[] = $result[0]["result"][$i];
				}
				break;
		}
	}

	$build = "";
	if ($let_build) {
		for ($i=0;$i<count($new_query);$i++) {
			if (!in_array ($new_query[$i], $string_markers) && !in_array ($new_query[$i-1], $string_markers))
				$build .= " ";
			$build .= $new_query[$i];
		}
	}
	else {
		$build = $new_query;
	}

	return $build;
}
?>