<?
// Funzioni di uso generale per i database
function field_type ($type, $len) {
	switch ($type) {
		case "string":
			return "varchar($len)";
			break;
		case "blob":
			switch ($len) {
				case 65535:
					return "text";
					break;
				case 16*1024*1024-1:
					return "longtext";
					break;
			}
			break;
		default:
			return $type."($len)";
	}
}

// Funzioni per i login
function is_logged () {
	global $login, $prefix;
	if (isset($login)) {
		//$sessione = base_64_decode ($sessione);
		$sessione = explode (":", $login);
		$result = db_query ("SELECT * FROM ".$prefix."users WHERE id='".$sessione[0]."' AND uname='".$sessione[1]."' AND pass='".$sessione[2]."' AND level='".$sessione[3]."';");
		if (db_num_rows ($result) == 1) {
			return true;
		} else {
			return false;
		}
	} else {
		return false;
	}
}

function is_level ($level) {
	if (level() == $level) return true;
	else return false;
}

function level () {
	global $login, $prefix;
	$sessione = explode (":", $login);
	if (count ($sessione) == 1) {
		return LEVEL_GUEST;
	} elseif (count($sessione) == 4) {
		if (is_logged()) {
			$result = db_query ("SELECT * FROM ".$prefix."users WHERE id='".$sessione[0]."' AND uname='".$sessione[1]."' AND pass='".$sessione[2]."' AND level='".$sessione[3]."';");
			if (db_num_rows ($result) == 1) {
				return $sessione[3];
			} else {
				return LEVEL_GUEST;
			}
		} else {
			return LEVEL_GUEST;
		}
	}
}

function user_id () {
	global $login;
	$sessione = explode (":", $login);
	if (count ($sessione) == 1) {
		return -1;
	} elseif (count ($sessione) == 4) {
		return $sessione[0];
	} else {
		return -1;
	}
}

function user_name () {
	global $login;
	$sessione = explode (":", $login);
	if (count ($sessione) == 1) {
		return -1;
	} elseif (count ($sessione) == 4) {
		return $sessione[1];
	} else {
		return -1;
	}
}

function control_login_query ($uname, $pass) {
	if (strstr ($uname, "'") || strstr ($pass, "'")) {
		log_add_line ("***** Possibile tentativo di SQL Injection da parte di questo utente *****");
		return false;
	}
	return true;
}

function get_user_name ($id) {
	global $prefix;

	$result = db_query ("SELECT * FROM ".$prefix."users WHERE id='$id';");
	if (db_num_rows($result) == 0) return -1;
	else {
		$result = db_fetch_array ($result);
		return $result["uname"];
	}
}

// Funzioni per le lingue
function load_language (){
	global $lang, $lang_path, $std_lang;
	if (file_exists ($lang_path.$lang.".wpl")) load_language_from_file ($lang_path.$lang.".wpl");
	elseif (file_exists ($lang_path.$lang."/index.php")) include ($lang_path.$lang."/index.php");
	else include ($lang_path.$std_lang."/index.php");
}

function load_language_from_file ($file) {
	$wpl = file ($file);
	for ($i=0;$i<count($wpl);$i++) {
		$value = strstr ($wpl[$i], "=");
		if ($value == false) continue;
		$name = substr ($wpl[$i], 0, strlen($wpl[$i])-strlen($value));
		$value = substr ($value, 1, strlen($value)-2);
		define ($name, $value);
	}
}

// Funzioni per i temi
function load_theme () {
	global $theme, $theme_path;
	if (file_exists ($theme_path.$theme."/index.php")) {
		include ($theme_path.$theme."/index.php");
	} else {
		load_error (ERR_THEME_NOT_FOUND, true);
	}
}

function theme_img ($name, $alt = "", $align = "") {
	global $theme_path, $theme;
	if (file_exists ($theme_path.$theme."/images/".$name)) {
		$src = $theme_path.$theme."/images/".$name;
	} else {
		$src = "images/".$name;
	}
	$sizes = @getimagesize ($src);
	$code = "<img border=0 src=\"".$src."\" width=\"".$sizes[0]."\" height=\"".$sizes[1]."\"";
	if ($alt != "") $code .= " alt=\"".$alt."\" title=\"".$alt."\"";
	if ($align != "") $code .= " align=\"".$align."\"";
	$code .= ">";
	echo $code;
}

function theme_img_path ($name) {
	global $theme_path, $theme;
	if (file_exists ($theme_path.$theme."/images/".$name)) {
		$src = $theme_path.$theme."/images/".$name;
	} else {
		$src = "images/".$name;
	}
	return $src;
}

function theme_load_style () {
	global $theme, $theme_path;
	if (file_exists($theme_path.$theme."/general.css")) {
		echo "<link rel=\"stylesheet\" href=\"".$theme_path.$theme."/general.css\">\n";
	} else {
		_theme_load_style ();
	}
}

// Funzioni per gli errori
function load_error ($error, $alone = false) {
	global $can_module, $lang;
	$can_module = false;
	include ("errordocs/$lang/err_".$error.".php");
	if ($alone == true) {
		module_show ();
		die ();
	}
}

// Funzioni per i moduli
function load_module () {
	global $site_title, $can_module, $mod_title, $m, $prefix, $mod_path, $lang, $lang_path, $std_lang;

	if ($can_module == false) return;

	$result = db_query ("SELECT * FROM ".$prefix."modules WHERE id='$m';");
	if (db_num_rows ($result) > 0) {
		$modulo = db_fetch_array ($result);
		include ($mod_path.$modulo["name"]."/def.php");
		if ($modulo["level"] < level()) {
			load_error (ERR_MOD_TOO_LOW_LEVEL);
		}
		if (isset ($use_loader)) {
			include ("loaders/$use_loader/mod_languages.php");
		} elseif (file_exists ($mod_path.$modulo["name"]."/".$lang_path.$lang.".wpl")) {
			load_language_from_file ($mod_path.$modulo["name"]."/".$lang_path.$lang.".wpl");
		} else if (file_exists($mod_path.$modulo["name"]."/".$lang_path.$lang."/index.php")) {
			include ($mod_path.$modulo["name"]."/".$lang_path.$lang."/index.php");
		} elseif (file_exists ($mod_path.$modulo["name"]."/".$lang_path.$std_lang.".wpl")) {
			load_language_from_file ($mod_path.$modulo["name"]."/".$std_lang_path.$lang.".wpl");
		} elseif (file_exists($mod_path.$modulo["name"]."/".$lang_path.$std_lang."/index.php")) {
			include ($mod_path.$modulo["name"]."/".$lang_path.$std_lang."/index.php");
		} else {
			load_error (ERR_MOD_LANG_NOT_FOUND);
		}
		if ($can_module == true) {
			if (!isset($use_loader)) {
				include ($mod_path.$modulo["name"]."/index.php");
				module_init ();
			} else {
				include ("loaders/$use_loader/mod_shower.php");
			}
		}
	} else {
		load_error (ERR_MOD_NOT_FOUND);
	}
	// Impostazione della pagina secondo il modulo
	if (isset($mod_title) && $mod_title != "") $site_title .= " - ".$mod_title;
}

function module_print () {
	global $__buffer_backup, $output_before_module, $output_after_module;

	$output_before_module = output_save ();
	module_show ();
	$output_after_module = output_save ();
}

function module_path () {
	global $m, $prefix, $mod_path;
	$result = db_query ("SELECT * FROM ".$prefix."modules WHERE id='$m';");
	$mod = db_fetch_array ($result);
	return $mod_path.$mod["name"]."/";
}

function module_admin_path () {
	global $prefix, $mod_path, $mid;

	$result = db_query ("SELECT * FROM ".$prefix."modules WHERE id='$mid';");
	$mod = db_fetch_array ($result);
	return $mod_path.$mod["name"]."/";
}

function module_id ($name) {
	global $prefix;
	$result = db_query ("SELECT * FROM ".$prefix."modules WHERE name='$name';");
	$mod = db_fetch_array ($result);
	return $mod["id"];
}

function load_module_block ($name) {
	global $module_blocks;
	$module_blocks[count($module_blocks)] = $name;
}

function load_module_page ($name, $file) {
	global $module_pages;
	$module_pages[$name] = $file;
}

function show_module_page () {
	global $f, $module_pages;
	if (isset($f)) {
		if (file_exists (module_path().$module_pages[$f]) && $module_pages[$f] != "") {
			include (module_path().$module_pages[$f]);
		} else {
			load_error (ERR_MOD_PAGE_NOT_FOUND);
		}
	}
}

function module_exists ($module) {
	global $prefix;
	$result = db_query ("SELECT * FROM ".$prefix."modules WHERE name='$module';");
	if (db_num_rows($result) == 1) return true;
	else return false;
}

// Funzioni per i blocchi
function ret_blocks ($pos) {
	global $level, $prefix;
	$result = db_query ("SELECT * FROM ".$prefix."blocks WHERE position='$pos' AND level>='".level()."' ORDER BY bl_order;");
	$blocchi = array();
	for ($i=0;$i<db_num_rows($result);$i++) {
		$blocco = db_fetch_array ($result);
		$blocchi[count($blocchi)] = "blocks/".$blocco["name"]."/";
	}
	return $blocchi;
}

function load_block_language ($blk_path) {
	global $lang, $std_lang;

	if (file_exists ($blk_path."languages/".$lang.".wpl")) {
		load_language_from_file ($blk_path."languages/".$lang.".wpl");
	} elseif (file_exists ($blk_path."languages/".$lang."/index.php")) {
		include ($blk_path."languages/".$lang."/index.php");
	} elseif (file_exists ($blk_path."languages/".$std_lang.".wpl")) {
		load_language_from_file ($blk_path."languages/".$std_lang.".wpl");
	} elseif (file_exists ($blk_path."languages/".$std_lang."/index.php")) {
		include ($blk_path."languages/".$std_lang."/index.php");
	}
}

// Funzioni per le date
function strdata_from_8char ($stringa) {
	$giorno = substr ($stringa, 6, 2);
	$mese = substr ($stringa, 4, 2);
	$anno = substr ($stringa, 0, 4);
	return $giorno."/".$mese."/".$anno;
}

function strdata_from_12char ($stringa) {
	$giorno = substr ($stringa, 6, 2);
	$mese = substr ($stringa, 4, 2);
	$anno = substr ($stringa, 0, 4);
	$ora = substr ($stringa, 8, 2);
	$minuti = substr ($stringa, 10, 2);
	return $giorno."/".$mese."/".$anno." ".$ora.":".$minuti;
}

function gettime_from_14char ($stringa) {
	$giorno = substr ($stringa, 6, 2);
	$mese = substr ($stringa, 4, 2);
	$anno = substr ($stringa, 0, 4);
	$ora = substr ($stringa, 8, 2);
	$minuti = substr ($stringa, 10, 2);
	$secondi = substr ($stringa, 12, 2);
	return mktime ($ora, $minuti, $secondi, $mese, $giorno, $anno);
}

// Funzioni per le variabili di sistema
function variable_set ($var_name, $var_value) {
	global $prefix;
	$result = db_query ("SELECT * FROM ".$prefix."variables WHERE nome='".$var_name."';");
	if (db_num_rows($result) == 1) {
		db_query ("UPDATE ".$prefix."variables SET valore='$var_value' WHERE nome='$var_name';");
	} else {
		db_query ("INSERT INTO ".$prefix."variables VALUES ('', '$var_name', '$var_value');");
	}
}

function variable_val ($var_name) {
	global $prefix;
	$result = db_query ("SELECT * FROM ".$prefix."variables WHERE nome='".$var_name."';");
	if (db_num_rows($result) == 1) {
		$variabile = db_fetch_array ($result);
		return $variabile["valore"];
	} else {
		return "";
	}
}

// Funzioni per le librerie
function load_library ($lib_name) {
	global $lib_path;
	require_once ($lib_path.$lib_name."/index.php");
}

function library_exists ($lib_name) {
	global $lib_path;
	return file_exists ($lib_path.$lib_name."/index.php");
}

function library_load_file ($file_name, $lib_name) {
	global $lib_path;
	if (file_exists($lib_path.$lib_name."/".$file_name))
		require_once ($lib_path.$lib_name."/".$file_name);
}

// Funzioni per la sicurezza
function simple_ip_crypt ($str_ip) {
	$str_ip = explode (".", $str_ip);
	$crypted = chr ($str_ip[0]);
	$crypted .= chr ($str_ip[1]);
	$crypted .= chr ($str_ip[2]);
	$crypted .= chr ($str_ip[3]);
	return $crypted;
}

// Funzioni per i files
function file_size_format ($size) {
	$signs = array ("B", "KB", "MB", "GB");
	$sign = 0;
	$value = $size;
	do {
		$value = $value / 1024;
		$sign++;
	} while ($value >= 1);
	$value *= 1024;
	$sign--;
	if ($sign == 0) $dec = 0;
	else $dec = 2;
	return number_format ($value, $dec, ",", ".")." ".$signs[$sign];
}

// Funzioni per i wrappers
function wrapper_install ($name) {
	if (file_exists (wrapper_root($name)."index.php")) {
		include (wrapper_root($name)."index.php");
	}
}

function wrapper_root ($name) {
	if (is_dir ("addons/wrappers/$name")) {
		return "addons/wrappers/$name/";
	} else {
		return false;
	}
}

// Funzioni per il registro

?>