<?
	/* This will manage the errors and exceptions caused by the WebPortal scripts
	   suppressing the PHP management */

function wpErrHandler_error ($errno, $errstr, $errfile, $errline) {
	global $error_messages, $WPErrorHandler_errors;

	if (array_search ($errno, $WPErrorHandler_errors) === false) return;

	switch ($errno) {
		case E_ERROR:
			$errno = "FATAL";
			break;
		case E_WARNING:
			$errno = "WARNING";
			break;
		case E_NOTICE:
			$errno = "NOTICE";
			break;
		case E_PARSE:
			$errno = "PARSE";
			break;
		default:
			$errno = "UNKNOWN";
			break;
	}
	if (error_reporting())
		$error_messages[count($error_messages)] = "[$errno] - $errstr nel file $errfile alla riga $errline";
	return;
}

function wpErrHandler_activate () {
	global $WPErrorHandler;
	if ($WPErrorHandler == true) {
		set_error_handler ("wpErrHandler_error");
		error_reporting (E_ALL);
	}
}

wpErrHandler_activate();

$error_messages = array();

function error_control () {
	global $error_messages, $output_before_module, $output_after_module;

	if (count($error_messages) == 0) return;

	@ob_clean();
	echo $output_before_module;
	for ($i=0;$i<count($error_messages);$i++) {
		log_add_line ("ERROR: ".$error_messages[$i]."\n");
	}
	load_error (ERR_IN_CODE);
	echo substr($output_page, strlen($output_after_module));
}
?>