<?
function wrapper_tar_list_files ($filename) {
	$results = array ();

	exec ("tar -tvf $filename", &$results);

	for ($i=0;$i<count($results);$i++) {
		$line = $results[$i];
		$results[$i] = array();
		for ($k=0;$k<=WRAPPER_TAR_FILE;$k++) {
			$results[$i][$k] = wrapper_tar_fileinfo ($line, $k);
		}
	}

	return $results;
}

function is_tar ($filename) {
	if (is_file ($filename)) {
		$filename = explode (".", $filename);
		return ($filename[count($filename)-1] == "tar");
	}
}

function wrapper_tar_intar_path ($path) {
	$tar = wrapper_tar_tarfile_path ($path);
	if ($tar == false) return false;
	return substr($path, strlen($tar)+1);
}

function wrapper_tar_tarfile_path ($path) {
	$new_path = "";
	$percorso = explode ("/", $path);

	for ($i=0;$i<count($percorso);$i++) {
		$new_path .= $percorso[$i];
		if (is_dir ($new_path)) {
			$new_path .= "/";
		}
		elseif (is_tar($new_path)) {
			return $new_path;
		}
		else {
			return false;
		}
	}
	return false;
}

function wrapper_tar_fileinfo ($line, $info) {
	$line = explode (" ", $line);
	$line[WRAPPER_TAR_OWNER] = explode("/", $line[WRAPPER_TAR_OWNER]);

	switch ($info) {
		case WRAPPER_TAR_PERMISSIONS:
			return $line[0];
			break;
		case WRAPPER_TAR_OWNER:
			return $line[1][0];
			break;
		case WRAPPER_TAR_GROUP:
			return $line[1][1];
		default:
			if ($info >= WRAPPER_TAR_FILE) {
				return false;
			}
			return $line[count($line)-1-WRAPPER_TAR_FILE+$info];
	}
}

function wrapper_tar_parse_url ($url) {
	$path = substr(strstr ($url, "://"), 3);
	$protocol = substr($url, 0, strlen($url)-strlen($path)-3);
	$result = array ();
	$result["path"] = $path;
	$result["protocol"] = $protocol;
	return $result;
}
?>