<?
/**
 XIP Class - Proxy Detection and IP Functions class for PHP - File Name: iplog.php
 Copyright (C) 2004-2006 Volkan Kkakar. All Rights Reserved.
 (Volkan Kucukcakar)
 http://www.developera.com

 You are requested to retain this copyright notice in order to use
 this software.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the  Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
?>
<?     /*
       XIP Class - EXAMPLE 4 - iplog.php
       This example demonstrates:
       IP Log example using a flat text file (with exclusive file lock support via flock and semaphore files)
       Note: This is an extra example file that I have written upon request and may be a little out of XIP Class's scope
       */
?>
<?
function iplog($logfile,$ip){
     $lck=@fopen($logfile.'.lck', 'a+');//semaphore lock file
     if ($lck===false) return false;
     if ( flock($lck,LOCK_EX) ){
        //flock may not work on some file systems
        //You can handle a flock error here, it will try to continue working even if you do not handle. (ofcourse without file lock support)
        //May be you can use another way of exclusive file locking, ie. sem_acquire() approach
        //read php help for more info http://www.php.net/manual/en/function.flock.php
     }
     $fp = @fopen($logfile, 'a+');
     if ($fp===false) {
        fclose($lck);
        return false;
     }
     $logline=gmdate("M d Y H:i:s")." GMT, $ip\r\n";
     if (false===fwrite($fp,$logline)) return false;
     fclose($fp);
     flock($lck, LOCK_UN);
     fclose($lck);
     return true;
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<META HTTP-EQUIV="CACHE-CONTROL" CONTENT="NO-CACHE">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<title>XIP Class - developera.com/xip</title>
<body bgcolor="#FFFFFF" text="#000000">
<center>
<p><a href="proxydetect.php">Proxy Detection</a> | <a href="ipfunctions.php">IP Functions</a> | <a href="blacklist_local.php">Blacklist (Local)</a> | IP Log | <a href="CheckRBL.php">Blacklist (Check RBL)</a></p>
<p align="left"><font color="#FF6666">XIP Class - EXAMPLE 4 - iplog.php - </font><font color="#707070">IP Log example using a flat text file (with exclusive file lock support via flock and semaphore files)<br>Note: This is an extra example file that I have written upon request and may be a little out of XIP Class's scope</font></p>
<p>&nbsp; </p>
  <table width="600" border="1" cellspacing="0" cellpadding="0">
    <tr>
      <td width="300">Your Proxy IP is</td>
      <td width="300">&nbsp;

<?
   require('../class.XIP.php');
   $XIP=new XIP();
   echo $XIP->IP['proxy'];
?>

      </td>
    </tr>
    <tr>
      <td>Your Client IP is</td>
      <td>&nbsp;
      
<? echo $XIP->IP['client']; ?>
      
      </td>
    </tr>
  </table>
<p>
<?
   /*
    * Do not forget that client IP is always reported by gateway (or client unfortinately)
      By the way, this is a property of http proxy connection; not a weakness of XIP Class.
    * You can separately use/save $_SERVER['REMOTE_ADDR'] (or $XIP->IP['proxy']) in your logs for security.
    * To increase security, you can use $XIP->IP['client'] in conjunction with $XIP->IP['proxy'] (equals to $_SERVER['REMOTE_ADDR']),
      or you can do something with $XIP->IP['all']
   */
   //So, log both proxy and client IP for security!
   $ip=$XIP->IP['proxy']." (".$XIP->IP['client'].")";
   $logfile="log/iplog.txt";
   if (!iplog($logfile,$ip)) die("IP Log error, make sure you have created the log directory '".dirname($logfile)."' or copy the files '$logfile' and '$logfile.lck', make sure you have set the right permissions");
   echo "Your Proxy IP and Client IP addresses are successfully written to log file.";
?>
</p>
  <p>&nbsp; </p>
  <p><strong>XIP Class<br>
  </strong>Proxy Detection and IP Functions class for PHP<strong><br>
  </strong><a href="http://www.developera.com/xip">www.developera.com/xip</a></p>
  <p>&nbsp; </p>
</center>
</body>
</html>
