<?
/**
 XIP Class - Proxy Detection and IP Functions class for PHP - File Name: CheckRBL.php
 Copyright (C) 2004-2006 Volkan Kkakar. All Rights Reserved.
 (Volkan Kucukcakar)
 http://www.developera.com

 You are requested to retain this copyright notice in order to use
 this software.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the  Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
?>
<?     /*
       XIP Class - EXAMPLE 5 - CheckRBL.php
       This example demonstrates:
       Checking the existance of visitor's IP in RBL (Real-Time Blackhole List) using 3rd party services
       Note 1: This is an extra example file that I have written upon request and may be a little out of XIP Class's scope
       Note 2: Two RBL services implemented in this example (spamcop.net and spamhaus.org), these services may not be available in the future,               but any other RBL service can be implemented in similar way.
               This file is created as an example to show you where to start.
       Note 3: This example parses html using regular expressions, some settings (patterns) may need to be changed in the future.
       Note 4: This example shows http based RBL, it simply retrieves the remote html and parse it.
               You can also continue querying a DNSBL (DNS-based Blackhole List) service if it also supports http queries.
               If your RBL service is only DNS-based, you may need a DNS query component written in PHP.
               I do not have an example for it yet.
       */
?>
<?
   //Checking the existance of visitor's IP in RBL (Realtime Black List) - SPAMCOP
   function CheckRBL_spamcop($ip,$timeout=10){
       $handle = fopen("http://www.spamcop.net/w3m?action=checkblock&ip=$ip", "rb");
       stream_set_timeout($handle,$timeout);
       $contents = '';
       while (!feof($handle)) {
          $contents .= fread($handle, 8192);
       }
       fclose($handle);
       if ( preg_match("/$ip\s*listed in \w*\.spamcop\.net/",$contents) ){
          return 1;
       }elseif ( preg_match("/$ip\s*not listed in \w*\.spamcop\.net/",$contents) ){
          return 0;
       }else return -1; //timeout or html parse error or service unavailable;
       /*
      To check service availibility, copy/paste service URL to browser and test the service;
      If needed, make necessary changes on regex pattern to correctly parse html.
      */
   }

   //Checking the existance of visitor's IP in RBL (Realtime Black List) - SPAMHAUS
   function CheckRBL_spamhaus($ip,$timeout=10){
       $handle = fopen("http://www.spamhaus.org/query/bl?ip=$ip", "rb");
       stream_set_timeout($handle,$timeout);
       $contents = '';
       while (!feof($handle)) {
          $contents .= fread($handle, 8192);
       }
       fclose($handle);
       if ( preg_match("/$ip\s*is listed in the SBL/",$contents) || preg_match("/$ip\s*is listed in the XBL/",$contents) ){
          return 1;
       }elseif ( preg_match("/$ip\s*is not listed in the SBL/",$contents) && preg_match("/$ip\s*is not listed in the XBL/",$contents) ){
          return 0;
       }else return -1; //timeout or html parse error or service unavailable;
       /*
      To check service availibility, copy/paste service URL to browser and test the service;
      If needed, make necessary changes on regex pattern to correctly parse html.
      */
   }
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<META HTTP-EQUIV="CACHE-CONTROL" CONTENT="NO-CACHE">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<title>XIP Class - developera.com/xip</title>
<body bgcolor="#FFFFFF" text="#000000">
<center>
<p><a href="proxydetect.php">Proxy Detection</a> | <a href="ipfunctions.php">IP Functions</a> | <a href="blacklist_local.php">Blacklist (Local)</a> | <a href="iplog.php">IP Log</a> | Blacklist (Check RBL)</p>
<p align="left"><font color="#FF6666">XIP Class - EXAMPLE 5 - CheckRBL.php - </font><font color="#707070">Checking the existance of visitor's IP in RBL (Real-Time Blackhole List) using 3rd party services<br>Note 1: This is an extra example file that I have written upon request and may be a little out of XIP Class's scope<br>Note 2: Two RBL services implemented in this example (spamcop.net and spamhaus.org), these services may not be available in the future,  but any other RBL service can be implemented in similar way. This file is created as an example to show you where to start.<br>Note 3: This example parses html using regular expressions, some settings (patterns) may need to be changed in the future.  There are other notes commented in file. </font></p>
<p>&nbsp; </p>
  <table width="600" border="1" cellspacing="0" cellpadding="0">
    <tr>
      <td width="300">Your Proxy IP is</td>
      <td width="300">&nbsp;

<?
   require('../class.XIP.php');
   $XIP=new XIP();
   echo $XIP->IP['proxy'];
   $test_ip=!(empty($_POST['t_ip'])) ? trim($_POST['t_ip']) : $XIP->IP['client'];
?>

      </td>
    </tr>
    <tr>
      <td>Your Client IP is</td>
      <td>&nbsp;
      
<? echo $XIP->IP['client']; ?>
      
      </td>
    </tr>
  </table>
  <form name="form1" method="post" action="">
    <p>Test IP:
      <input type="text" name="t_ip" value="<? echo $test_ip; ?>" size="32" maxlength="15">
</p>
    <p><u>RBL Service:</u><br>
      <label>
      <input name="rblservice" type="radio" value="spamcop" <? if (empty($_POST['rblservice']) || "spamcop"==$_POST['rblservice']) echo "checked"; ?>>
      <a href="http://www.spamcop.net/w3m?action=checkblock&ip=<? echo $test_ip; ?>" target="_blank">SPAMCOP</a></label>
      <br>
      <label>
      <input type="radio" name="rblservice" value="spamhaus" <? if ("spamhaus"==$_POST['rblservice']) echo "checked"; ?>>
      <a href="http://www.spamhaus.org/query/bl?ip=<? echo $test_ip; ?>" target="_blank">SPAMHAUS</a></label>
    </p>
    <p>
      <input type="submit" name="Submit" value="Check RBL">
    </p>
  </form>
<p>
<?
   if ($XIP->isPublic($test_ip)){
      switch ($_POST['rblservice']){
      case "spamcop" :
          $rresult=CheckRBL_spamcop($test_ip,20);
          break;
      case "spamhaus" :
          $rresult=CheckRBL_spamhaus($test_ip,20);
          break;
      }
      if ($rresult===1) {
         echo "$test_ip is listed in RBL";
      }elseif ($rresult===0){
         echo "$test_ip is NOT listed in RBL";
      }elseif ($rresult===-1) {
         echo "Timeout or html parse error, select another RBL service or read comments in file...";
      }else echo "Click button to search IP in RBL";
   }else{
      echo "Please write a valid and public IP to search in RBL";
   }
?>
</p>
  <p>&nbsp; </p>
  <p><strong>XIP Class<br>
  </strong>Proxy Detection and IP Functions class for PHP<strong><br>
  </strong><a href="http://www.developera.com/xip">www.developera.com/xip</a></p>
  <p>&nbsp; </p>
</center>
</body>
</html>
