<?php
// ----------------------------------------------------------------------
// Copyright (C) 2007 by Khaled Al-Shamaa.
// http://www.al-shamaa.com/
// ----------------------------------------------------------------------
// LICENSE
//
// This program is open source product; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// To read the license please visit http://www.gnu.org/copyleft/gpl.html
// ----------------------------------------------------------------------
// Class Name: Translate English word into Hieroglyphics
// Filename:   Hiero.class.php
// Original    Author(s): Khaled Al-Sham'aa <khaled.alshamaa@gmail.com>
// Purpose:    Translate English word into Hieroglyphics
// ----------------------------------------------------------------------

class Hiero {
     var $font = array();

     function Hiero(){
			$this->font['A']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAIwAeAwERAAIRAQMRAf/EAHkAAAIDAQAAAAAAAAAAAAAAAAUHAAIGAQEAAwEBAAAAAAAAAAAAAAAAAAIDAQQQAAIBAwMDAwIHAQAAAAAAAAECAxEEBQASBiExEyIyFHEVUWFCYnJDUwcRAAICAgEDBQAAAAAAAAAAAAABEQISAyExcQRhsSJiE//aAAwDAQACEQMRAD8Ae2d/6AMXk4LJ7FooZ2KJkrp1htiVUO+2m+Q0X9nU9NRW1D4MK8Ozs+bwiZGUIplkkCLHUAIrlV7k9aDTa75KRWoD2qGE0AZTmXF8XkUtL2+QmHHlzIF/ykA3mlD7doP0rrh8vxFtqlk6r0La92DmE+5lLnO47i96ba2gk+YI/KZEoI91WCx7QBuRgF9TMenUddGquvRXGs+5l7Wu5Yw+PZyzzONjvrU+lxSSM+5HHuQ/TXZS6spRNoJ1GmMKTRrJG0biqOCrD8j00AL/AOz43kFpLDk4fjSYuNhaZKGRWnUI7pJGVoeiGP2tXoR2OoW1qy5HTgC45s1wq/XISK1zgLgrHdyqpUoN1B5Iqt45I6/xPavbUKJ6n9TXD7jT+4WfwPneVfiePy+avp2U3bq/TXcTBmbyfI7cyJjMP88hCY5WnjiXfTsVbrTU72a6IaqT6sWmK4bzKPIWU+Sxc86JJcXWQEd8sZmurlgzMtG9EIH9f6j31CrvKlFrKkcMal5jZJjIyBHjuEMd1azV8cikU7r2NOnY1GumCAGg4PDHxO44+WZ7aeQOIWkYqiCVZPGr03UO38NT/L44m5cms1YU5oAtoAmgD//Z';
			$this->font['A']['h'] = 35;
			$this->font['A']['w'] = 30;
			$this->font['B']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAIgAYAwERAAIRAQMRAf/EAH0AAAMAAwEAAAAAAAAAAAAAAAIFBgABBAgBAAMBAQEAAAAAAAAAAAAAAAADBAUBAhAAAgAFAgQEBwAAAAAAAAAAAQIAEQMEBTEGIWESB7EiExRRgcFCUiMWEQABBAEDAwUBAAAAAAAAAAABAAIDBBFRcSJBchMhMWEjMwX/2gAMAwEAAhEDEQA/APU8cQkW9M3dYPb1zlLVEetRNMKtQEr56gQz6SD90JsS+Nhd74VFWESSBh9Mo9m5q5zWAt8jdIiVqpqBlpzCeSoyCQJP4wVpfIwO1XLUIikLNE6hyQpbuajNsjLSE+mkriWvlqKT4RPbGYnbKqkcTM7kXbNSuzLCev7SfnWePFD8W7L1/QP3u3VMSBqddIsUanO4V3aUdmZY13Cq9u9NOMp1HEkA5lomtOAjdnRUVGl0rQNQi7cy/i8UQZg0SePHiXYnxgqDETdl26czP7iujclxuihSonAWVveOxb3C3FU0ulQJr0SHEk8xDZC4DiEqINzyOAoHLbI7k7lb3GXr2lH0yxoWPqN6acwEV1mfiSTGZYqzzNwXBuy1q12CA8Wl3yVf7NxN5h9uWWOvHR69urBjTn0gM7MoEwCZAyjRrxljA09Fl2ZRJIXDqU4Gg+usNSVuBCwQIX//2Q==';
			$this->font['B']['h'] = 34;
			$this->font['B']['w'] = 24;
			$this->font['C']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAIgATAwERAAIRAQMRAf/EAHsAAAEEAwAAAAAAAAAAAAAAAAYAAQUHAgQIAQADAQEAAAAAAAAAAAAAAAAAAwQFBhAAAQMDAwMCBwAAAAAAAAAAARECAwAEBSEGBzFRE3ESIlIjsxQVJhEAAgEDAgUFAAAAAAAAAAAAAAERAgMEMwUhgbESE0FRcXIG/9oADAMBAAIRAxEAPwDpDd2fGBwF1lfH5TAGhrFQFz3BoU9lOtKu3OymR2PZ8lap9wW2ByJks/lZcbkLRlvKIvyIXxqB7VaEc0k/Noajws9XizMwPFQqk/WCwFNaJmgdy4AdhZFeiw/ebUmbpst27WXPoA3GEn98Gp0sC0nqurT3NYH5/g38s1910F9l0LqrqTmwS5XY52xck0BSfEg7/WZU+WptsswHF1czU2dx3+nyMOZuLoyXxthDLCwARBU1Dj8RqTb9tWOpmWxmXnO6u2OEhwhrUM8g98Y27yW2ruztI/LcSmMsjUBfbI1x1PpSr1DqpgdYuKiuWTcIIYAQhSmoSZ0AM6gBxQAqAP/Z';
			$this->font['C']['h'] = 34;
			$this->font['C']['w'] = 19;
			$this->font['D']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAFQAoAwERAAIRAQMRAf/EAHoAAAEEAwAAAAAAAAAAAAAAAAEDBQYHAAIIAQACAwEAAAAAAAAAAAAAAAAABAECBQMQAAEDAwMDAgcAAAAAAAAAAAECEgMAEQQhBQZBExRhBzFRcYGRIkIRAAICAQIGAwAAAAAAAAAAAAABEQIDMQQhgZESIjJhEyP/2gAMAwEAAhEDEQA/AOqCoCgBq3blfHtoWY9x3CHGlCQsxrV+7ToCEi6jVXdLVl647W0Umu18w4zuqxHgblBPIfhGFNWfolViarXLW3BNMm2K9VLTQ7PHzFdDnIQoGgCtvePC5RJjYORtEmSYI1LRPBidxzlWKZFdu5IS2k95W8eA7srY1bz0KlXDyR4kz/KUYgBFJOZC3U9VDo7SsjI83z0NzFXBxXiuYYMafJlCUJVPMpTmxgySFXolNyTpSvZldpSc9Bt3wVpDde3kyc422+8UeOhERzhCAGBc8DwPVynfmtPs3camR9mxnRk79ucfk8O2ZQ5B3/KVkXiGQsLUI+2gWBClf1etHarIqfp7GZvHid/z9SXdaZFQFli61ut6hwCE0eK49trr6tte/wBqhRJLkUNqsQYKAP/Z';
			$this->font['D']['h'] = 21;
			$this->font['D']['w'] = 40;
			$this->font['E']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAIgARAwERAAIRAQMRAf/EAHYAAQACAwEAAAAAAAAAAAAAAAYABwECBQgBAAMBAQAAAAAAAAAAAAAAAAADBAECEAABAwMCBQEJAAAAAAAAAAABAgMEABIFEQYhMUEUBxNRYaHBIpIjYwgRAAICAgEFAAAAAAAAAAAAAAABEQIDBBIhMUFRIv/aAAwDAQACEQMRAD8A9KboyycTt/IZEm3tY7jiCdNLwk2Djw4q0rjJfipMtaFIW8Tb8m7ngTI+SSgZLHLQHXGxaHW3QShdnQ/SQelLwZeaF4snJD2njQH5oyBi7IdZSq1c19lge8BXqKH2t1NtP4gTsOKMJfz+kDJ55X6oo+LlK1PIrU7F01cVgLyvs7O7kgQxi1tkwlOOORlm1ThUkBNquQt48/bU+xjdl0EZ8bug74LhSYeW3HGlNKYlR0xW3WlgBQP5T86VqJpuTNenFNFva1YUGSK0A/httvwN0Z7MrdSpGX7b02kg6o7dooNxPPUml1pDb9mJQ2d/Q0w02oAlAEoA/9k=';
			$this->font['E']['h'] = 34;
			$this->font['E']['w'] = 17;
			$this->font['F']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAFQAlAwERAAIRAQMRAf/EAHoAAAMBAQEAAAAAAAAAAAAAAAABBgUCCAEBAAMBAAAAAAAAAAAAAAAAAAEDBAIQAAEDAwEGBAcAAAAAAAAAAAIBAwQAEQUSITFRExQGYaEVB0FxgSIyIzQRAAEEAQQBBQAAAAAAAAAAAAABEQIDBCFhEhMiMVFxkUL/2gAMAwEAAhEDEQA/APQ3cPfeDwOSiY6eRDKnWSIAq2us1LSgWU0Ub8SRB8b1AKISuiX2LwWpAKqUA0WgCgJnursLt3uEDcnwmnJvKJtmWQIRhe9vml13VlyMWNnui7FtVqx+CPhh714yKGMRYksWP1tTzbVx4mx2ApWcAL24jfjWWeVkQ8evlu5d11yV+TIJzA+8k0VcezzsdzejbLcVoU8PxI/OqVyM6S6VxRN5HfVQnrJVNrESvdHEAjWWhtZ9i/8ASwbbEkU4EC6W3PpprbXdb+4fSuUThB/GRW+qPemdb0Ujmab9FpHnX3abatPnWvlo5S2rGgtq6IOdnxoA+2gGtqAVAf/Z';
			$this->font['F']['h'] = 21;
			$this->font['F']['w'] = 37;
			$this->font['G']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAGQAcAwERAAIRAQMRAf/EAHkAAAIDAQAAAAAAAAAAAAAAAAYHAQUIAgEAAwEBAQEAAAAAAAAAAAAAAAMFBAIBBhAAAQMDAwMDBAMAAAAAAAAAAQIDBAARBSESBkEiBzGBE1FhkcEyMxURAAICAQMEAwAAAAAAAAAAAAABAgMREgQFMUEyUlETFP/aAAwDAQACEQMRAD8A0vyHLO4nGOzm4bs4tWKo7Ft+3qrXTt9a8bAXh8+Yoaf40z0voWz+6T+mr2Q/8tvqy74f5Qa5RkjDi4eXHQhO56S5s+NGhKQqxv3W0ruFsZdGcWVSh5LAddKYLBnyNmUYriGRkEgOuNmOwL6lb3YPwCT7Um+emLY7b165pGf8LgZWWi5SVHdaabxbXylC1JSXSD/WndbXaFG/1qJTttafY+hv3n1ySxkLvC2YjxOSuxHFhIyLG1voC62rcge6VKtWjjZpNr5M3LV5ipLsPjpVkgg7zPh0Lk+NTFkOLZcZV8kd1JuErsR3JOihrSrqlOOBtFzrlqQrHvCXImpBCFRpDY/isK26fcKTUufHS6JliHKQflEv+LeGnIk9iflpY3R1pdbjRrjuTYjc4dugI9EgVo2+x0PLZm3PJOcXFLGRq2NqoksmgDk9KAJFAE0Af//Z';
			$this->font['G']['h'] = 25;
			$this->font['G']['w'] = 28;
			$this->font['H']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAIwATAwERAAIRAQMRAf/EAHMAAAMBAQEAAAAAAAAAAAAAAAEFBgcECAEAAwEBAAAAAAAAAAAAAAAAAAIDAQQQAAEDBAECBAcAAAAAAAAAAAECAwQAERIFBkETISMUFjFRYSIyYgcRAAICAgEFAAAAAAAAAAAAAAABEQIxAxIhcSIyBP/aAAwDAQACEQMRAD8A9Lcj3KNLpZe0Wgupioz7YNsjcAC/TxNJe3FSZZwhfxbk03aSZsGfETFmwQ0p0NuB1spfTmiyh1t8aTVt5ShaWko6sOKOXOBvjO0cUx6hKYrpLFr5fYfCk2+rMtglP44gN6ac1mmR25IHrk384FpCgLnx8vLCuf5MMnpfiaFXWVOXaJcXrZSGhd1TLgQD1UUm1LfDMeCG/iof9sSFKBSwqWvsoUBkCEpDn49O5e1c3yTxfcnpXiaHXWVFHKYm0l6Z6JrFJbkycWi8o49ttZs4tP7BF7Ul02uhjmBTxjikjjm3ksa8j2/JaQ4GFE5NykWQopHycSMj9anq1cHC9Ra1gq71ccNABoAFAH//2Q==';
			$this->font['H']['h'] = 35;
			$this->font['H']['w'] = 19;
			$this->font['I']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAFwAZAwERAAIRAQMRAf/EAIAAAQABBQAAAAAAAAAAAAAAAAUDAAEEBggBAAIDAQEAAAAAAAAAAAAAAAMEAAIFAQYQAAEDBAEDAgcAAAAAAAAAAAERAgMAIQQFMRIiE3FiQWGBoUIUBhEAAQMCBAILAAAAAAAAAAAAAQACAxEEIUESBTIUMVFhcYGR0SJCEyP/2gAMAwEAAhEDEQA/AOm8/cYeDLFHkOLTKe0pYXAUn60rcXkcLmteaFxoEWOFzwSMlFm77ExM6HDm6g+b8k7QCUBJ9apcX8cMjWPNC/oXY4HPaSMkk0ghRTqCr1FEV/Q6kbDBcxoWZiui+ClLtX3cVmbrYczCWjiy70xbTmN1clrmMDutS7AlQ7LX90HVbyMAT1VLH3V56Ou4WhidhcReeHrmtB/4Sh44Hpv+X2/7mL4ZSf2IQA5eS3gE/McGtrZNw5iKjsJGYOCSvINDqjhKdUVtJRUUS9RRGQYumbsppYXxnOevka2QdQC37Qbd3NuaRijtxM4s0/b8qHHxCM90mgA105KTCj07ciY4hh87nEzeNzS7qW6obX+9FhEIc7Rp1V91OvtVXF1BWtFn2plDX//Z';
			$this->font['I']['h'] = 23;
			$this->font['I']['w'] = 25;
			$this->font['J']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAIAAhAwERAAIRAQMRAf/EAH4AAAEFAQEAAAAAAAAAAAAAAAABAgQFBgcIAQEAAwEAAAAAAAAAAAAAAAAAAQIDBBAAAgEDAwEFCAMAAAAAAAAAAQIDAAQFERIGITFBMhMHUWFxkaHRIxRScpIRAAMAAQIEBwAAAAAAAAAAAAABAhEhMUFRAwRhcZGxEhQF/9oADAMBAAIRAxEAPwD0Hnn56mVjfDLYPjFT8kdyZBIz/wBl8I9mgrK6pbLQvKlrVknj3KLbIYK3yV48Vm8hdJUaRdqvG7RsAzad69KtFfJZIucPBIHLOMFxGMvZFydAv7EWpP8AqrZKlmjq6h1IZWAKsOoIPeDUgdQCMoIIIoDKz+mHCZ7yS7mxcck0p3SFiSCfhrXG+x6bb318WbrubXL0QzJ+mHEL2yktv0EgDrtDR6jTpoDtPSqP87pcMp+bJ+1fHVGX9LLPL8b5bmOH3V215j4YFu8cX1/EN+x1UdiqwdToOw61p211morefYr1pWjWzOrV1mIUAUAUBjEtzB6rSTv0S6xJEBPYWjnXzB8tprmicdWnzSNa1hGy1rpMhaAKAKArsnilvLqwuQ/ly2M/nKwHiVo2jdD7mD1DRKZN2n+R+n2qSuD/2Q==';
			$this->font['J']['h'] = 32;
			$this->font['J']['w'] = 33;
			$this->font['K']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAFQAlAwERAAIRAQMRAf/EAIgAAAEEAwEAAAAAAAAAAAAAAAMAAQYHAgQFCAEAAwADAAAAAAAAAAAAAAAAAAIDAQQFEAACAQIEBAQHAQAAAAAAAAABAgMRBAASEwUhMQYHIiMUFUFRYXFSFhcyEQABAwEGBAQHAAAAAAAAAAACAAERAyExUXESBEFhEwWBIjJCkcFSgpKiFf/aAAwDAQACEQMRAD8A9B9U9b2/T11DFc2rvBKueS6qFiiXNlq5oaccam63g0WttJ7ma904BOS4X9i2szBktHfbS2Q7qJAbYMVrQtT50H3ONL+yDDaJdT6Pcm6Vt/lx4LFO8u0h2e4tHtrBgTbbjI40JqGnlsF44w/eQiBEiPiLeoc0NSxeG4Pjkjxd2rBg6S7dcQXIQzR2z01JIUBZ5E+BVVFTU8sVpd1p1CZgksXa4c0pU3Fpez5qRft+1exe8+PQzaejl83VzZdLL+VcdDqtEqepoROpemdu3+w9LeJXKweGQCpRxyNDwP1BxPcbYaouL2TgnEoVT7l2j6nt5zJarDdVlzqiFIrAIAF8ViwK56D/AErY4NXtVUfTaMX3VPzVerOf6/Ba1l2w6zmnWM2UcLB2EpvXjlsQpJJa3tkqyGuFpdpqk8F5R5WH9xe5lkqjePO7wwVk9Ndt9p2iwnhmkkvrq7ha2uLuZiziFgQYo6k5U48sdzb7IKQwzNbg0KBPqvRv57tP677JrT6Wt6j1GfzdTlWtPx4Yt0G06VPQ0QpViydLhgQm4YEJ8CEsCF//2Q==';
			$this->font['K']['h'] = 21;
			$this->font['K']['w'] = 37;
			$this->font['L']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAFwAoAwERAAIRAQMRAf/EAIEAAAMBAQAAAAAAAAAAAAAAAAMFBgcIAQACAwEAAAAAAAAAAAAAAAAEBQECAwYQAAEDAgUCBQEJAAAAAAAAAAIBAwQRBQAhEhMGMVFhIkIUB0FxodHhMlJiJBURAAEEAAQGAgMAAAAAAAAAAAEAEQIDIUESBGGBoSJiEzEFUXEV/9oADAMBAAIRAxEAPwDqKbMZhxXZL5aWWQIzJewpVcRIsHUgOWCxe/8AzJyW3SEuiCyFtM1abtRAivLSnm3EX9qKq9ssJ6ftfbYYRHxnkj7Njoi5PJatxvlNs5FZY93trm5GfGqp6gMf1Nmn0IVyXDcFAEMkNovV8u1uG6pd41vF9xwAhusiW2oGooBqTgEp+WqplgeNhIdwP2tZRALMVV2v36xA9+4y7Iz1ORxIW1SuSohKS9PHBEHbFZSZ8EO9zbVGgn/puNBFdRWzF6iierLTpXrits4xHcQBxUxBJwXM/I7EfIOcyxgwyhWGHpiwzFskAmmiopiZZ1cLPV2+zCXc7ymqEtBi+QGKaU7eyRGt+aouNtO8cjPt2aa9FiSHiMmkcVRVxAQVQUoXb8emEv8AX3AzTA7Gn8Ixtg9LUnhV1yQak68QESkVa6iIqfVPu8MAWX2zxJJ5oiEax8ALSvjFyUsGY04X9dlwUYCtdNRqSJ1yx1v0dkpUdxdIvsoxFmCoL7G447sleyjoIKWykkxAaqnmohKiLlhpcIN3s3FBVGb9rvwS8IXx+geQ4GiqVo63p8PVgUR2nh0Wz3+XVEVngPqW25rlUmOvhn1xoY7fPR0VXt8kYA4UlNK27LsrHTL8sTD0Pho6Kp9mepM4SW7bX2Ozt1z2dOmtP4ZdMEQ0t2s3BZF81//Z';
			$this->font['L']['h'] = 23;
			$this->font['L']['w'] = 40;
			$this->font['M']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAJAAgAwERAAIRAQMRAf/EAHgAAAEFAQAAAAAAAAAAAAAAAAYAAQQFBwgBAAMBAQEAAAAAAAAAAAAAAAACAwQBBRAAAgEDAwIEAwkBAAAAAAAAAQIDEQQFACESMQZRYSITQRQVcYHRMkJSIzNDBxEAAwEBAQEBAQAAAAAAAAAAAAECEQMhMRIi/9oADAMBAAIRAxEAPwDpTuHLyYqxW4ihWZzIkfB39tQGNCxajUp9mlptLwCB233Nd5W8uIbi3ht1jRXjWKYTkGpEiu6gJUemnGvXy0sXv061gSaocFoAq+4LSW4tEeKaWB4HEnOEKW40Kts4ZWFDWhGp9Y/SwaaxmaXdxeduXvyllKZo44E+n3kpJYRP/IxjWLhGVLMahlJ2G/SmLXy8XpV/16HPZvdn1m2MVyoiv4vzL0Eij/RV+HmPhrXx6/pE6nAmBqNWEGYCmgALitsLlCcFPHKstt7xs5eHEqLdxE4jfp6Sw28DqNQq8YyeArdxX+BvYryEGWK2kAivEVljck/1sTWnuDr1G+sj5vnSa+FW1SNUxeRtshZRXds3KGUVHiD0KnzB216E0mtIMhZrLZaz4LYYqTI81JYpJHGFOwA9ZHjpOlNLxaU5yn9eABgOyu7L7NjIZhrnH8jdzSsl0GCy3JHD5eNaqntj91a01nibqvVha6hTiesOs1hIrrH3NkYTLa3lv8vNGlOakCiSLUqKr+GtNTpmRV/847dz2FxIhyk/JmrygYhiGDUEnIH9S9RpeUNfTtPQw2p92qiiFNAD7U0AIUptoA//2Q==';
			$this->font['M']['h'] = 36;
			$this->font['M']['w'] = 32;
			$this->font['N']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAJAAZAwERAAIRAQMRAf/EAH4AAAICAwAAAAAAAAAAAAAAAAQHBQYAAQgBAAIDAQEAAAAAAAAAAAAAAAIEAAEFAwYQAAIBAwMCBAUFAAAAAAAAAAECAxEEBQAhEhMGMUFRImFxgUIVscFSFAcRAAIBAwQBBQEAAAAAAAAAAAECABEDBCFBURIiMWHR8TIF/9oADAMBAAIRAxEAPwDpm9zmPs5OlM56gXmyojOVT+TcQeI+eubXADSGtskVENhmjmiWWJg0bgMjDwIPgdGDWCRSQ9n3A113Pf4hFAjsIo2d/uLyb0+VNAHqxHENrdFB5k3rpOcqWbspIslcK9zJaQZUQrHexUrFPDX2MSCOEg9dq6Svp5Gugbfj7jdl/EaVK7cybgFlg8GA0hFpYw+53NW4oNyT6n9dMqAi+ugi5Jdvcykf5LdTZPI9w5mcEPdzpSvktXYL9FIGlcNuxZuTHs9OgROBGTp6Z0q/f3cthg8UpvbQ3sV2xh6FVVTtX3FvAfTS+RcVV8ozi2GuPRTQxMZzvbN5W2NjLcMuMRyYbWvJgo3VZJaLzK+X7nWHdymcdR+Z6PHwEQ9m/UbP+TYw2fa6ytTleStNt6AKm+w80OtnCQLbEwP6FzvdJ40l203EoHk8TjsnD0L+2juYd/ZKoYCopUVGx+WhZQRQwldlNQaRH9/9ljtyazix9tK9lInB7yRgxlndyRGwWiqabCg+GsjNxAKdRN7AzSwbudfiOvt7HfjcLY2P3W8KI/xenvP1auta2tFAmFcbsxMkdHAmakkEyP43or/f6fR6icerSnU5DhSvny8NUabyxXaFLSm2rlTepJP/2Q==';
			$this->font['N']['h'] = 36;
			$this->font['N']['w'] = 25;
			$this->font['O']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAJAAZAwERAAIRAQMRAf/EAGoAAAIDAQEAAAAAAAAAAAAAAAUHAAQGAQgBAQEBAAAAAAAAAAAAAAAAAAABAhAAAQMDAwQBAwUAAAAAAAAAAgEDBAAFBhESEyExQQdxURQVgSIyQlIRAQEBAAAAAAAAAAAAAAAAAAABEf/aAAwDAQACEQMRAD8A9UKSIunmgw0/2eRz5UTHLDNyEYLhMzJcZW2o4uj/ACbbcdIeQx8oNTQcxHM7RlEFyRB5Gn4xqzOgvjsfjvJ3bdDwtIDu6qMB7acya0WtMix6YLMtlBhyIbibm3xkuC03t/y624eol861AqsS9a3e6WWXZCt4xrxap5MP32RPcT7PQhfVY0VpNqqQH0JV6rqq1NG+9YaXP2NmeR29VKyPLHgtP+H5EcEF11NETyPX5pA1a0BGX423kdiftZPlFNwm3WJIIhE28y4LrZ7V01RDBNU16/VKlCyv8G/t3JzC4Fz+8yXLHEl5FdWmkYCLBbbFheNsVLapAG1NS1X9agamOY9a8es0W0WtlGYUQNjYd1Ve5ES+SJeqr9a0CVBxV6UC09SiV4vWVZe+K806cUGNr/SPE0RBT5VakDMqiUE8UFW2/jeAvx/Dwbz3cG3bya/v129N27vUgtVRKD//2Q==';
			$this->font['O']['h'] = 36;
			$this->font['O']['w'] = 25;
			$this->font['P']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAGwAUAwERAAIRAQMRAf/EAH0AAQACAwAAAAAAAAAAAAAAAAcABgIFCAEAAgMBAAAAAAAAAAAAAAAAAAQCAwUGEAACAQMCBQIHAAAAAAAAAAABAgMAEQQSBSExUQYHIhRBYUJSEyMIEQABBAADBgcAAAAAAAAAAAABABECA3GBBCFhEiITBUFRscHRMkL/2gAMAwEAAhEDEQA/AH3vPyJtPamRjQ7gjE5Ss0ZBP0EA/A9aR1mrlSzQM38ldXCJHNIRWjxvOPbM+XBipFIZMiRIo7aiLu4QcdIHM0rX3OyUgDVIZhSNVfhMEpG1HRqtx6VsJdDH9BJtzZ+yDLeZf1z6BCqte7R3vqK1mdy6jDgbNDV/skI12BNiO/7XoyMppfdY5VWiS2r8qniQ5rOqlfxhxFtxPwFKMKAeUyfBdY29NdIoqkeRPG8fd2XhTvOYvaI6KoawOsqbn0t9tZ2uovm3TMRi/srICo/cHJVvbfBGPhbjiZq5bM2LNHOFLXBMbBuWgdOtJVaPWCQMpVtuEn9VYRpxtiJPilvjo+dq3kusqEKUIUoQv//Z';
			$this->font['P']['h'] = 27;
			$this->font['P']['w'] = 20;
			$this->font['Q']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAGwAbAwERAAIRAQMRAf/EAHIAAAICAwAAAAAAAAAAAAAAAAAHBggBBAUBAQEBAQAAAAAAAAAAAAAAAAABAgMQAAEDAwIEAwkAAAAAAAAAAAIBAwQABQYRITFBEwdRIghhcYGRMmIjJBURAQEBAAIDAAAAAAAAAAAAAAABAhEDITES/9oADAMBAAIRAxEAPwC1G1Bp3q72+z2uRc57nSiRQVx0+K6JyROarypwIZgfd23Zfen7ZHtz8Qm2VkMuukBIbYkgLqg/SXm4b1dZsSUwKiscN1oET6gsuR6bDxmM7+Nn9m4onBS2VpsvcmpfKu/RnyxuuR6eiUs6k+H851V+LzW1Tv8AcXEWOri0j+Wx82kxgZxiTChuFr1pEwXDJE00TpiG2vtWgTkj085vLluSZd5hPvPKRuvH1icMyXdSVRrrO3hn5S3td2hvWH5C9dJs6PKadilGQGRNCRSMD18yfZXPWra1JxDWqAoCgKAoP//Z';
			$this->font['Q']['h'] = 27;
			$this->font['Q']['w'] = 27;
			$this->font['R']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAFAAmAwERAAIRAQMRAf/EAHgAAAMAAwAAAAAAAAAAAAAAAAAFBgEECAEAAgMBAAAAAAAAAAAAAAAAAAQCAwUBEAABAgQEBgIDAAAAAAAAAAACAQMAEQQFITESBkFRgRMVB6EiYUMUEQACAwACAgEFAQAAAAAAAAAAARECAwQFITESkaGxMlIG/9oADAMBAAIRAxEAPwDqV+pp2G1cecFpscVM1QUTqscbBImbl7O2XQEQHcBfcHMKcSeXHLEEUfmKNOXnT20M04etoir8i1v3LtUjQSZrQFcjVlJS54FOXSF12eLcSMPq9kpgf2bfG1bwgpQ3Fo3CWSNGvbcnyQT0qvSG6b0t6Yppx9KfsmPJjKfCLSkn91bHsu5Rb8gjqOsiQtOtGoqKEqKv1WYLlxSKtcVdQy/DkWyc1Ik/Ud9tv1s1wp3mOAVTSg4mf7G56uqRh8voKa+VZpmnTtv6Rhn1/v11RR163UyavsaK66un8JpBISz/AMuk5dmTt2tI8JjWh9OWonv6bxVvV7+WkJU7aT4CLePzG3xuqyyUKfqxPTs9LevH3/JaeCtniPEdpfH9vs9nWc9HLXPX8xo/FRAh8nMm/EiIQAEABAAYwAf/2Q==';
			$this->font['R']['h'] = 20;
			$this->font['R']['w'] = 38;
			$this->font['S']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAFQAlAwERAAIRAQMRAf/EAHYAAAICAwAAAAAAAAAAAAAAAAAGAQQCBQgBAQADAQAAAAAAAAAAAAAAAAACAwQBEAABAgUDAwQDAAAAAAAAAAABAgMAEQQFBiESEzFBB2EiFBYywhURAAEEAgEEAwAAAAAAAAAAAAABEQIDEgQhMVFhFJEyE//aAAwDAQACEQMRAD8A6nKkAyJAMcVUQC5nmXLxmxG5sMJqnOVDQaUooElTKjMA9EpMVXXYRcv16f0li7FPIM8etWQY/a2qQPN3lcnXSuRaSSkJIAnPVUJ3MqJ3OV05RVX+o4BSSOoi1ykJpl6QAtZR4/sGSVbNVcecOsJ40cLqmxtnPVI0MV2VJLqW13LDoIXkfxjabVYE1tobq36pD7aS2VqeGxUwTskekZNjWTHg26u2qzaRUyHxlS0mTWCjo2616huBIrX571NbNpmFpT7NNZnvEZ6qJOJKvcVYSdhwT4YxhP41dwkexfB/SL/Th5M/uz8fA0/XKL69/B5X/icPx+XkPNtlKfJ13Rpw4Yy5cubWJEQMu8AY+ycASfSAD3QB/9k=';
			$this->font['S']['h'] = 21;
			$this->font['S']['w'] = 37;
			$this->font['T']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAEgAbAwERAAIRAQMRAf/EAGoAAAMBAQAAAAAAAAAAAAAAAAAFBgcIAQEBAQEAAAAAAAAAAAAAAAAAAQIDEAABAwQABgIDAAAAAAAAAAABAgMEABEFBiExYRITB0EIUdIUEQEBAAIDAQAAAAAAAAAAAAAAARECMRITFP/aAAwDAQACEQMRAD8A6X2HP43X8RIymRc8cWOm6jzKieASkfJJqyZS1ic77FbEqaVQMTFbhBVktyFOLdUOpQUhJt0Ndfn2Z7tK9dezcbuLLrQaMPJxgDIiKV3Ap5d6FcLpvwrltrZcVqXK0qKQbfpeJ2uEzDyi30x2XA6lDDnjuoCw7uBvarLgSZ+v2i/Dk4dPOP0rXpWesNNZ9Q6trmYay2Ocl/1tJUgeR0KSUrFiFJCRf81Nt7eVkwt6yooCgKAoP//Z';
			$this->font['T']['h'] = 18;
			$this->font['T']['w'] = 27;
			$this->font['1']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAFwAmAwERAAIRAQMRAf/EAH4AAQACAwAAAAAAAAAAAAAAAAEEBQYHCAEAAwEBAAAAAAAAAAAAAAAAAAEDAgQQAAEDAwMCAwcFAAAAAAAAAAECAwQAEQUhEgYxE0FhB1GBsdEiQtKDkySENREAAgEDAgUFAAAAAAAAAAAAAAECERIDIVExQVIEFIGRMmIT/9oADAMBAAIRAxEAPwDo/k/LcXx1hlyaHXHJKiiPHYRvcWoC5sLj41PJlUFVmJzUVVkDH+pvC5jPcOSbirBstiUQ04k+wpVWF3MGq1EssdyQPUDhRP8AtRP3U0/IhuH6x3E8/wCFeObhj9ZHzo8iG4LLHcsxm8QccckJjJgJG4yt6e2Be1917dapeqV5G7kYd6uSYTePgNycc3MLjyg2+8txttghN9xW0Qu5HS1c/dcFpUnlenCpRcZyeIGNbQ7wN5SLHtvR2EyELHS+57avXzvUsbSWsCcXp8S3XlsGnQcEmn+ix+Vbuj0P2NXLpA5nEkWTwKbroP4TAHv16a0r10DUvqQ8TxjKRuKZzv4XdHnTmZUPjm5J2soeaUtHXaCdhNulOON2vTnw9RKLtZs9wN/fa3nXW6cy4p2W+m1vC1MB0oANKAGgD//Z';
			$this->font['1']['h'] = 23;
			$this->font['1']['w'] = 38;
			$this->font['U']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAHwAWAwERAAIRAQMRAf/EAHoAAAMBAQAAAAAAAAAAAAAAAAQGBwUIAQEAAwEAAAAAAAAAAAAAAAADAQIEABAAAQMDAwIFAgcAAAAAAAAAAQIDBREEBgASEyEUQXEiFQcyQjFRYYFSckQRAQABBAECBwAAAAAAAAAAAAEAESECEgNREzFBccEyIxT/2gAMAwEAAhEDEQA/AOkMqyuJxqMN/IqVtUoNsstjc464rolCE+JOq5ZAS2GDk0Ilj5luLNxt2fxm/iYt5QCJBfrQkK+krBSgD9lHQnP1GP8Am6IsfvfIn2b3jum/bOLn7qvo46V3abYpWZ9WtIofJ8fJi+gMgtLNcixCXKnbqxaFXFIWkDekeJRTpo+XFaJ5ReJLjCceyGQysSSJKAdjsdLYQwu/G154kEO1aP0pA/A6ky2L+EqmrZvJ1FrfX8DTDDxPZNSKGbZW7/Kb9gmh/KilaM+DHT7D09peSQOp1pmSTbL8hlcqdexbDiHGlnimpwdWGGz0UyhX3uHx2+H66LLJbEbjDG7GUYLEDCFYlQ9gWOEr+7dXdy/25PX56ntmusjuu20MymFjpaN4ZO8etI9tQduuJ7t0uISDVDrgorjNetFDz1dIYwiBbgW4phEGbcxaU0tzaFCmaD+JRVJ89cSGaOpnT//Z';
			$this->font['U']['h'] = 31;
			$this->font['U']['w'] = 22;
			$this->font['V']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAFQAlAwERAAIRAQMRAf/EAHoAAAMBAQEAAAAAAAAAAAAAAAABBgUCCAEBAAMBAAAAAAAAAAAAAAAAAAEDBAIQAAEDAwEGBAcAAAAAAAAAAAIBAwQAEQUSITFRExQGYaEVB0FxgSIyIzQRAAEEAQQBBQAAAAAAAAAAAAABEQIDBCFhEhMiMVFxkUL/2gAMAwEAAhEDEQA/APQ3cPfeDwOSiY6eRDKnWSIAq2us1LSgWU0Ub8SRB8b1AKISuiX2LwWpAKqUA0WgCgJnursLt3uEDcnwmnJvKJtmWQIRhe9vml13VlyMWNnui7FtVqx+CPhh714yKGMRYksWP1tTzbVx4mx2ApWcAL24jfjWWeVkQ8evlu5d11yV+TIJzA+8k0VcezzsdzejbLcVoU8PxI/OqVyM6S6VxRN5HfVQnrJVNrESvdHEAjWWhtZ9i/8ASwbbEkU4EC6W3PpprbXdb+4fSuUThB/GRW+qPemdb0Ujmab9FpHnX3abatPnWvlo5S2rGgtq6IOdnxoA+2gGtqAVAf/Z';
			$this->font['V']['h'] = 21;
			$this->font['V']['w'] = 37;
			$this->font['W']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAJAAcAwERAAIRAQMRAf/EAIMAAAICAwEAAAAAAAAAAAAAAAAFAQcDBAYIAQACAwEBAQAAAAAAAAAAAAAAAwQFBwIBBhAAAgEDAwIFAwUAAAAAAAAAAQIDEQQFACESEwYxQSIyFGGBUlGhIyUWEQACAgEDAwIHAQAAAAAAAAAAAQIDBBEhBTFBEmEiUYHB4fETFAb/2gAMAwEAAhEDEQA/APSHcncseEhiY2s91JOSsawoSgYeHOT2pWu1dRMzMjj1uyXRDaqnN6IMB3ImVMkbwG2njVZOmTyBRyRUGg8Cu+2o3F8tXmRbht4vc6vx3W9GOdWggNACrua0kucNcpEvKRQJETfcxsHpt+vHbUDlMd3Y0611lEdjz8ZplZS5m+s76CTHpIZZl4288VaVJqxeoKcFoK8hXfbwOs04u+3GcpRl4uL9yfp20+L/AD2L6+pWJJll9vZ6PJwFJAI72GguIgarX80Pmh8v31pHF8nXmVecfmu6KG6l1vRjfVkJI8RoArbuq3iwuUYuClnecpbd1FQrKavGfu3pH11nX+n4iUbv2wXtn29S8wclSjo+xo2eeitLuC9s360qKXaCIF5JITQsvTUFvUNwaeNNQ+B/pxshNQk4vaS0+vTYZlxhOD1ZZ3zv6z5vRkr0et8en8vt5cOP5eWtQ1PnzDmMpNjrZZYrC5yDM3Ho2qozgU9x5tGKffQ2epHE5m57ozeTt5f8zci0x8Ustrb3L2oWS8cGONph1TSNFZj6STU/TUeacnvHYfDxS6/Y63tLGNj+3LC0mjeOaGBUmWUqz86essVLDdqnY6dXHSImctWOKClPLXZyTtoANtABtoANtAH/2Q==';
			$this->font['W']['h'] = 36;
			$this->font['W']['w'] = 28;
			$this->font['X']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAFQAlAwERAAIRAQMRAf/EAIgAAAEEAwEAAAAAAAAAAAAAAAMAAQYHAgQFCAEAAwADAAAAAAAAAAAAAAAAAAIDAQQFEAACAQIEBAQHAQAAAAAAAAABAgMRBAASEwUhMQYHIiMUFUFRYXFSFhcyEQABAwEGBAQHAAAAAAAAAAACAAERAyExUXESBEFhEwWBIjJCkcFSgpKiFf/aAAwDAQACEQMRAD8A9B9U9b2/T11DFc2rvBKueS6qFiiXNlq5oaccam63g0WttJ7ma904BOS4X9i2szBktHfbS2Q7qJAbYMVrQtT50H3ONL+yDDaJdT6Pcm6Vt/lx4LFO8u0h2e4tHtrBgTbbjI40JqGnlsF44w/eQiBEiPiLeoc0NSxeG4Pjkjxd2rBg6S7dcQXIQzR2z01JIUBZ5E+BVVFTU8sVpd1p1CZgksXa4c0pU3Fpez5qRft+1exe8+PQzaejl83VzZdLL+VcdDqtEqepoROpemdu3+w9LeJXKweGQCpRxyNDwP1BxPcbYaouL2TgnEoVT7l2j6nt5zJarDdVlzqiFIrAIAF8ViwK56D/AErY4NXtVUfTaMX3VPzVerOf6/Ba1l2w6zmnWM2UcLB2EpvXjlsQpJJa3tkqyGuFpdpqk8F5R5WH9xe5lkqjePO7wwVk9Ndt9p2iwnhmkkvrq7ha2uLuZiziFgQYo6k5U48sdzb7IKQwzNbg0KBPqvRv57tP677JrT6Wt6j1GfzdTlWtPx4Yt0G06VPQ0QpViydLhgQm4YEJ8CEsCF//2Q==';
			$this->font['X']['h'] = 21;
			$this->font['X']['w'] = 37;
			$this->font['Y']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAJAAZAwERAAIRAQMRAf/EAHoAAAEEAwEAAAAAAAAAAAAAAAIABQYHAQMECAEAAwEBAAAAAAAAAAAAAAAAAAIEAQMQAAIBBAEEAAQHAQAAAAAAAAECAwARBAUGITESB0EiEyNRkbHBQqIUFREAAgICAgEFAAAAAAAAAAAAAAERAgMEITEiQVFxEiP/2gAMAwEAAhEDEQA/APSXK+QQce0eTtpo2mTHC2hQgM5ZgoUXsL9aS91VSxbWVVLC0fI9dutHDuMJycSVC/zAhlK9GVgfwIrK5FZSja2TUjfwnneq5ZjTyYayQz4rBcjGlADL5C6sCCQVaimRW6MrdW6JLXQYq731sTHpNfrlPXKyfquAbHxhX9PJxUm3bxSJdq0VgbOAbL/D6e3uUAftz5aRi/8AKRVUf2esxOMbNx2/KRs9BEpyvZxC4U4EZPXv4TWH5eRpdN8sTUcpl71cWFJ+8cHdTbjGzP8AJK2qx4Ai5KjyQSOxL38blfh3qHaq5n0IdtWfwcXHNftth6cz8XWY75Esm0cyIncxRlWJANiRdQLCsSbxQvcZJvFCD9FI8fM9pG4KuuAoZSCCG+v2IP702tw2g1FEl7VaWGueCGeF4pUWSN1Kuji6kEWIINY1INEV9baSTUanYYjYzYsX/TzXxomBH2GlJjIv8Cvakx1hC1UAY+ikxvaGRtIMYx4mTqljnnVbI065BPUju3jR9fKQVYZL7mugwVACFqAF0vQBj5aAP//Z';
			$this->font['Y']['h'] = 36;
			$this->font['Y']['w'] = 25;
			$this->font['Z']['image'] = '/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAPAAA/+4ADkFkb2JlAGTAAAAAAf/bAIQABgQEBAUEBgUFBgkGBQYJCwgGBggLDAoKCwoKDBAMDAwMDAwQDA4PEA8ODBMTFBQTExwbGxscHx8fHx8fHx8fHwEHBwcNDA0YEBAYGhURFRofHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8f/8AAEQgAEwAnAwERAAIRAQMRAf/EAHcAAAIDAQAAAAAAAAAAAAAAAAAFAQQGCAEBAQEBAAAAAAAAAAAAAAAAAAMCBBAAAQIEBAQHAQAAAAAAAAAAAQIDABEEBSExQRIiMhMHYXGRIxQkBhURAAIABAUFAAAAAAAAAAAAAAABEZECAzFBURIEIYEiUgX/2gAMAwEAAhEDEQA/AOqCRlAEEoAmTICAKn9mzyT92n4lbE+6jFQ0GOcZ3rU1tehbBSRMYxoySJSgBRffzNLeVtKeqqunLIIT8V9TM90ubbnlE67aqxKW7jpyXdREVf2voKqldp03e6ILiSkKVVKcTiNUKElCJPjUtYuZZcpp4UyRlldiH1S3XdPEdrg+OJdMap4ubzwjmXzV7M7H9ZuPijXUnbS3MMNsi6XJSWwAPsqA9AJAeAjqXGWrOJ8lvKmQ0t35KkoGKxhusrHU1rXRWp59S1IElCbZPKrizjVNlJQ6k6rrbjBSHYixInWACACADWAP/9k=';
			$this->font['Z']['h'] = 19;
			$this->font['Z']['w'] = 39;
     }

      function en2hiero($word){
			$word = strtoupper($word);
			$word = str_replace('TH', '1', $word);
			$chars = preg_split('//', $word, -1, PREG_SPLIT_NO_EMPTY);
			
			$total_w = 0;
			$max_h   = 0;
			
			foreach($chars as $char){
			  $total_w += $this->font[$char]['w'];
			  if($this->font[$char]['h']>$max_h){ $max_h = $this->font[$char]['h']; }
			}
			
			$im  = @imagecreatetruecolor($total_w, $max_h);
			$bck = ImageColorAllocate($im, 255,255,255);
			ImageFill($im, 0, 0, $bck);
			
			$current_x = 0;
			
			foreach($chars as $char){
			  $image = imagecreatefromstring(base64_decode($this->font[$char]['image']));
			  imagecopy ($im, $image, $current_x, $max_h-$this->font[$char]['h'], 0, 0, $this->font[$char]['w'], $this->font[$char]['h']);
			  $current_x += $this->font[$char]['w'];
			}
			
			return $im;
     }
}
?>