<?php

/*
 * DynamicPage Class
 * Version 1.2
 * Author: Marcos Bezerra [mbezerra AT gmail DOT com]
 * Date version: 2007-01-20
 * Requires 'dynamic_page_exception.class.php' in same path for exceptions treatment
 * Exceptions throws:
 * [1]: No File passed to Constructor method. Throws in case Constructor method calls
 *      without parameter;
 * [2]: File passed to Constructor method not exists [path_file/name_file]. Throws
 *      in case Constructor method calls with inexistent file in path.
 * [3]: $target parameter not passed to replaceInPage method. Throws in case 
 *      replaceInPage method calls without $target parameter.
 * [4]: $target parameter [target_name], passed to replaceInPage method, was not found.
 *      Throws in case replaceInPage method calls with inexistent target_name in page.
 * [5]: $content parameter not passed to replaceInPage method. Throws in case
 *      replaceInPage method calls without $content parameter.
 * ------------------------------------------------------------------------------------
 *
 * Copyright (C) 2007  Marcos Bezerra
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * ---------------------------------------------------------------------------------
 *
 * BASIC INSTRUCTIONS:
 * 
 * This class receives a HTML page, previously formatted with HTML comments tags type, 
 * which indicate the corresponding positions for the dynamic content to be 
 * produced by the PHP script.
 * i.e.: <--user --> to indicate a mark for username place.  
 *  
 * The page, as well as your relative path, in case it exists, they should be 
 * passed to the constructor method of the class when the object is initialized.   
 * i.e.: $myPage = new DynamicPage("same_dir/same_page.html");  
 * 
 * The tags can be substituted in time of execution through the    
 * replaceInPage($target, $content, $tagPersist) method.
 * The parameters sends to method:  
 * 
 *   $target - a string with the name of the tag to be substituted;  
 *   $content - a string with the dynamic content that will substitute the tag.
 *   $tagPersist - a boolean value; input 'true' to republishing the tag or omit that for not.
 * 
 * i.e.: $myPage->replaceInPage("user", "Marcos", true);  // republishing tag
 *          or
 *       $myPage->replaceInPage("user", "Marcos");  // not republishing tag
 *
 * Note: Parameter "user" is passed without "<--" and " -->" elements of tag.
 * This will change the tag '<!--user -->' existent in 'same_dir/same_page.html' 
 * by the string 'Marcos'. Case boolean 'true' has been pased in 3rd parameter the tag
 * '<!--user -->' will be carry on the HTML page after recent content.
 * 
 * Finished the operation of substitution of dynamic content in the page, 
 * call the showPage() method.  
 * i.e.: $myPage->showPage();  
 * 
 * At the end, it is advisable that the object is destroyed. When passing the 
 * object for the unset() function the destructor method is automatically call.  
 * i.e.: unset($myPage); 
 *
 * Use try { // your_code } catch(DynamicPageException $dpe) { echo $dpe; }
 * construction code for a correct exception treatment provides by class.
 * i.e.:
 * <?php
 *
 * require_once("dynamic_page.class.php");
 *
 * try {
 *
 *	   $myPage = new DynamicPage("dynamic_page_test.html");
 *
 *	   $myPage->replaceInPage("user", "Marcos", true); 
 *	   $myPage->replaceInPage("user", " Bezerra");
 *	   $myPage->showPage();
 *
 * } catch(DynamicPageException $dpe) {
 *
 *	   echo $dpe;
 *
 * }
 *
 * unset($myPage);
 *
 * ?>
 */

// Load class of exceptions treatment 
require_once("dynamic_page_exception.class.php");

class DynamicPage {
	
	// Private propertie
	private $page;
	
	// Constructor method
	public function __construct($htmlPage = '') {
		
		if ($htmlPage == '') {
		
			throw new DynamicPageException('No File passed to Constructor method.', 1);
		
		} elseif (!file_exists($htmlPage)) {
		
    		throw new DynamicPageException('File passed to Constructor method not exists ['.$htmlPage.'].', 2);
			
		} else {
		
			$this->setPage(join("", file($htmlPage)));
		
		}
		
	}
	
	// Destructor method
	public function __destruct() {}
	
	// Get method
	public function getPage() {
		
		return $this->page;
		
	}
	
	// Set method
	public function setPage($newPage) {
		
		$this->page = $newPage;
		
	}
	
	// Method for string replace in page
	public function replaceInPage($target = '', $content = '', $tagPersist = false) {
		
		if ($target == '') {
		
			throw new DynamicPageException('$target parameter not passed to replaceInPage method.', 3);
		
		} elseif(!strstr($this->getPage(), '<!--'.$target.' -->')) {
		
			throw new DynamicPageException('$target parameter ['.$target.'], passed to replaceInPage method, was not found.', 4);
		
		}
		
		if ($content == '') {
		
			throw new DynamicPageException('$content parameter not passed to replaceInPage method.', 5);
		
		} 
		
		if($tagPersist == true)
			$tag = '<!--'.$target.' -->';
		else
			$tag = '';
		
		$this->setPage(str_replace('<!--'.$target.' -->', $content.$tag, $this->getPage()));
		
	}
	
	// Method for show page
	public function showPage() {
		
		echo $this->getPage();
		
	}
	
}

?>