<?php
/* 
 * Fibonacci iterator class simply generates Fibonacci numbers.
 */

/**
 * Fibonacci iterator.
 *
 * @author Artur Barseghyan
 */
class Fibonacci implements Iterator {
    private $_a;
    private $_b;
    private $_key;

    public function __construct() {
        $this->rewind();
    }

    public function current() {
        return $this->_b;
    }

    public function next () {
        $b = $this->_b;
        $this->_b = $this->_a + $this->_b;
        $this->_a = $b;
        ++$this->_key;
    }

    public function key () {
        return $this->_key;
    }

    public function valid () {
        return true;
    }

    public function rewind () {
        $this->_a = 0;
        $this->_b = 1;
        $this->_key = 0;
    }
}
