<?php
// Classicus, an ancient latin generator
// Version: 1.1
// Made by: Tobias Kappe (http://www.ntlabs.org)

class classicus
{
	// This wil generate the forms of a noun like lupus, femina or senex-senes
	// String Nomev (Nominativus Singularis)
	// String Nommv (Nominativus Pluralis if needed)
	function znw($nomev, $nommv = "")
	{
		$woord = $nomev;
		if(!empty($nommv)) { $drie = true; $mv = $nommv; }
		
		if(substr($woord,-1) == "a")
		{
			$groep = 1;
			$stam = substr($woord,0,-1);
			$woorden["Nominativus"]["Ev"] = $stam."a";
			$woorden["Nominativus"]["Mv"] = $stam."ae";
			$woorden["Genitivus"]  ["Ev"] = $stam."ae";
		    $woorden["Genitivus"]  ["Mv"] = $stam."arum";
			$woorden["Dativus"]    ["Ev"] = $stam."ae";
			$woorden["Dativus"]    ["Mv"] = $stam."is";
			$woorden["Accusativus"]["Ev"] = $stam."am";
			$woorden["Accusativus"]["Mv"] = $stam."as";
			$woorden["Ablativus"]  ["Ev"] = $stam."a";
			$woorden["Ablativus"]  ["Mv"] = $stam."is";
		}
		elseif(substr($woord,-2) == "us" && !$drie)
		{
			$groep = 2;
			$stam = substr($woord,0,-2);
			$woorden["Nominativus"]["Ev"] = $stam."us";
			$woorden["Nominativus"]["Mv"] = $stam."i";
			$woorden["Genitivus"]  ["Ev"] = $stam."i";
			$woorden["Genitivus"]  ["Mv"] = $stam."orum";
			$woorden["Dativus"]    ["Ev"] = $stam."o";
			$woorden["Dativus"]    ["Mv"] = $stam."is";
			$woorden["Accusativus"]["Ev"] = $stam."um";
			$woorden["Accusativus"]["Mv"] = $stam."os";
			$woorden["Ablativus"]  ["Ev"] = $stam."o";
			$woorden["Ablativus"]  ["Mv"] = $stam."is";
	
			if(substr($stam,-1) == "i")
			{
				$woorden["Vocativus"]["Ev"] = $stam;
			}
			else
			{
				$woorden["Vocativus"]  ["Ev"] = $stam."e";
			}
		}
		elseif($drie && !empty($mv) && (substr($mv,-2) == "es" || substr($mv,-1) == "a"))
		{
			$groep = 3;
			if(substr($mv,-2) == "es") { $stam = substr($mv,0,-2); }
			else { $stam = substr($mv,0,-1); $r = 1; }	

			$woorden["Nominativus"]["Ev"] = $woord;
			$woorden["Nominativus"]["Mv"] = $mv;
			$woorden["Genitivus"]  ["Ev"] = $stam."is";
			$woorden["Genitivus"]  ["Mv"] = $stam."um";
			$woorden["Dativus"]    ["Ev"] = $stam."i";
			$woorden["Dativus"]    ["Mv"] = $stam."ibus";
			if($r)
			{
				$woorden["Accusativus"]["Ev"] = $woord;
				$woorden["Accusativus"]["Mv"] = $mv;
			}
			else
			{
				$woorden["Accusativus"]["Ev"] = $stam."em";
				$woorden["Accusativus"]["Mv"] = $stam."es";
			}
			$woorden["Ablativus"]  ["Ev"] = $stam."e";
			$woorden["Ablativus"]  ["Mv"] = $stam."ibus";
		}
		return(array($woorden,$groep));
	}
	
	// This will generate a verb like venire, clamare, facere or ferre
	// String woord, this is the noun
	// Boolean medk, if positive this will indicate whether its a consonant verb or not
	function ww($woord,$medk)
	{
		if(substr($woord,-2) == "re")
		{
			$stam = substr($woord,0,-2);
			if (substr($stam,-1) == "a") { $woorden["Praesens"]["Ev"]["1e"] = substr($stam,0,-1)."o"; }
			else { $woorden["Praesens"]["Ev"]["1e"] = $stam."o"; }
			if (substr($stam,-1) == "i") { $imp = "eba"; }	
			else { $imp = "ba"; }
			$prf = "v";
		}
	
		if($woord == "adesse") { $woord = "esse"; $bijz = "ad"; }
		
		if($woord == "esse")
		{
			$woorden["Praesens"]["Ev"]["1e"] = "sum";
			$woorden["Praesens"]["Ev"]["2e"] = "es";
			$woorden["Praesens"]["Ev"]["3e"] = "est";
			$woorden["Praesens"]["Mv"]["1e"] = "sumus";
			$woorden["Praesens"]["Mv"]["2e"] = "estis";
			$woorden["Praesens"]["Mv"]["3e"] = "sunt";	
		}		
		elseif($woord == "posse")
		{
			$woorden["Praesens"]["Ev"]["1e"] = "possum";
			$woorden["Praesens"]["Ev"]["2e"] = "potes";
			$woorden["Praesens"]["Ev"]["3e"] = "potest";
			$woorden["Praesens"]["Mv"]["1e"] = "possumus";
			$woorden["Praesens"]["Mv"]["2e"] = "potestis";
			$woorden["Praesens"]["Mv"]["3e"] = "possunt";	
		}
		elseif ($medk)
		{
			$woorden["Praesens"]["Ev"]["1e"] = substr($stam,0,-1)."o";
			$woorden["Praesens"]["Ev"]["2e"] = substr($stam,0,-1)."is";
			$woorden["Praesens"]["Ev"]["3e"] = substr($stam,0,-1)."it";
			$woorden["Praesens"]["Mv"]["1e"] = substr($stam,0,-1)."imus";
			$woorden["Praesens"]["Mv"]["2e"] = substr($stam,0,-1)."itis";
			$woorden["Praesens"]["Mv"]["3e"] = substr($stam,0,-1)."unt";
		}
		else
		{
			$woorden["Praesens"]["Ev"]["2e"] = $stam."s";
			$woorden["Praesens"]["Ev"]["3e"] = $stam."t";
			$woorden["Praesens"]["Mv"]["1e"] = $stam."mus";
			$woorden["Praesens"]["Mv"]["2e"] = $stam."tis";
			if (substr($stam,-1) == "i")
			{
				$woorden["Praesens"]["Mv"]["3e"] = $stam."unt";
			}
			else
			{
				$woorden["Praesens"]["Mv"]["3e"] = $stam."nt";
			}
		}
		
		if($woord == "esse") 
		{ 
			$woorden["Imperfectum"]["Ev"]["1e"] = "eram";
			$woorden["Imperfectum"]["Ev"]["2e"] = "eras";
			$woorden["Imperfectum"]["Ev"]["3e"] = "erat";
			$woorden["Imperfectum"]["Mv"]["1e"] = "eramus";
			$woorden["Imperfectum"]["Mv"]["2e"] = "eratis";
			$woorden["Imperfectum"]["Mv"]["3e"] = "erant";
		}
		elseif($woord == "posse") 
		{ 
			$stam = "potera"; 
			$woorden["Imperfectum"]["Ev"]["1e"] = "poteram";
			$woorden["Imperfectum"]["Ev"]["2e"] = "poteras";
			$woorden["Imperfectum"]["Ev"]["3e"] = "poterat";
			$woorden["Imperfectum"]["Mv"]["1e"] = "poteramus";
			$woorden["Imperfectum"]["Mv"]["2e"] = "poteratis";
			$woorden["Imperfectum"]["Mv"]["3e"] = "poterant";
		}
		else
		{
			$woorden["Imperfectum"]["Ev"]["1e"] = $stam."bam";
			$woorden["Imperfectum"]["Ev"]["2e"] = $stam."bas";
			$woorden["Imperfectum"]["Ev"]["3e"] = $stam."bat";
			$woorden["Imperfectum"]["Mv"]["1e"] = $stam."bamus";
			$woorden["Imperfectum"]["Mv"]["2e"] = $stam."batis";
			$woorden["Imperfectum"]["Mv"]["3e"] = $stam."bant";			
		}


		if($woord == "esse")
		{
			$woorden["Perfectum"]["Ev"]["1e"] = $stam."fui";
			$woorden["Perfectum"]["Ev"]["2e"] = $stam."fuisti";
			$woorden["Perfectum"]["Ev"]["3e"] = $stam."fuit";
			$woorden["Perfectum"]["Mv"]["1e"] = $stam."fuimus";
			$woorden["Perfectum"]["Mv"]["2e"] = $stam."fuistis";
			$woorden["Perfectum"]["Mv"]["3e"] = $stam."fuerunt";

			$woorden["Plusquamperfectum"]["Ev"]["1e"] = $stam."fueram";
			$woorden["Plusquamperfectum"]["Ev"]["2e"] = $stam."fueras";
			$woorden["Plusquamperfectum"]["Ev"]["3e"] = $stam."fuerat";
			$woorden["Plusquamperfectum"]["Mv"]["1e"] = $stam."fueramus";
			$woorden["Plusquamperfectum"]["Mv"]["2e"] = $stam."fueratis";
			$woorden["Plusquamperfectum"]["Mv"]["3e"] = $stam."fuerant";
		}		
		elseif($woord == "posse")
		{
			$stam = "potu";
			$woorden["Perfectum"]["Ev"]["1e"] = $stam."potui";
			$woorden["Perfectum"]["Ev"]["2e"] = $stam."potuisti";
			$woorden["Perfectum"]["Ev"]["3e"] = $stam."potuit";
			$woorden["Perfectum"]["Mv"]["1e"] = $stam."potuimus";
			$woorden["Perfectum"]["Mv"]["2e"] = $stam."potuistis";
			$woorden["Perfectum"]["Mv"]["3e"] = $stam."potuerunt";

			$woorden["Plusquamperfectum"]["Ev"]["1e"] = $stam."potueram";
			$woorden["Plusquamperfectum"]["Ev"]["2e"] = $stam."potueras";
			$woorden["Plusquamperfectum"]["Ev"]["3e"] = $stam."potuerat";
			$woorden["Plusquamperfectum"]["Mv"]["1e"] = $stam."potueramus";
			$woorden["Plusquamperfectum"]["Mv"]["2e"] = $stam."potueratis";
			$woorden["Plusquamperfectum"]["Mv"]["3e"] = $stam."potuerant";
		}
		elseif (substr($stam,-1) == "e" && !$medk)
		{
			$woorden["Perfectum"]["Ev"]["1e"] = substr($stam,0,-1)."ui";
			$woorden["Perfectum"]["Ev"]["2e"] = substr($stam,0,-1)."uisti";
			$woorden["Perfectum"]["Ev"]["3e"] = substr($stam,0,-1)."uit";
			$woorden["Perfectum"]["Mv"]["1e"] = substr($stam,0,-1)."uimus";
			$woorden["Perfectum"]["Mv"]["2e"] = substr($stam,0,-1)."uistis";
			$woorden["Perfectum"]["Mv"]["3e"] = substr($stam,0,-1)."uerunt";

			$woorden["Plusquamperfectum"]["Ev"]["1e"] = substr($stam,0,-1)."ueram";
			$woorden["Plusquamperfectum"]["Ev"]["2e"] = substr($stam,0,-1)."ueras";
			$woorden["Plusquamperfectum"]["Ev"]["3e"] = substr($stam,0,-1)."uerat";
			$woorden["Plusquamperfectum"]["Mv"]["1e"] = substr($stam,0,-1)."ueramus";
			$woorden["Plusquamperfectum"]["Mv"]["2e"] = substr($stam,0,-1)."ueratis";
			$woorden["Plusquamperfectum"]["Mv"]["3e"] = substr($stam,0,-1)."uerant";
		}
		elseif($medk)
		{
			//$stam = You can  make your own custom perfectum verb code here, prolly through a DB
			if($stam[1])
			{
				echo("<b>Perfectumstam gevonden, maar deze staat nog in de wachtrij</b><p>");
				$stam = substr($woord,0,-2); 
			}
			elseif(!empty($stam['perfectum']))
			{
				$stam = $stam['perfectum']; 
			}
			else
			{
				$stam = substr($woord,0,-2); 
			}
					
			$woorden["Perfectum"]["Ev"]["1e"] = $stam."i";
			$woorden["Perfectum"]["Ev"]["2e"] = $stam."isti";
			$woorden["Perfectum"]["Ev"]["3e"] = $stam."it";
			$woorden["Perfectum"]["Mv"]["1e"] = $stam."imus";
			$woorden["Perfectum"]["Mv"]["2e"] = $stam."istis";
			$woorden["Perfectum"]["Mv"]["3e"] = $stam."erunt";

			$woorden["Plusquamperfectum"]["Ev"]["1e"] = $stam."eram";
			$woorden["Plusquamperfectum"]["Ev"]["2e"] = $stam."eras";
			$woorden["Plusquamperfectum"]["Ev"]["3e"] = $stam."erat";
			$woorden["Plusquamperfectum"]["Mv"]["1e"] = $stam."eramus";
			$woorden["Plusquamperfectum"]["Mv"]["2e"] = $stam."eratis";
			$woorden["Plusquamperfectum"]["Mv"]["3e"] = $stam."erant";
			$ops = $stam."i";
			$stam = substr($woord,0,-2);
		}
		else
		{	
			// $stam = you can insert custom perfectum verbs code here
			if($stam[1])
			{
				$stam = substr($woord,0,-2); 				
				$woorden["Perfectum"]["Ev"]["1e"] = $stam.$prf."i";
				$woorden["Perfectum"]["Ev"]["2e"] = $stam.$prf."uisti";
				$woorden["Perfectum"]["Ev"]["3e"] = $stam.$prf."uit";
				$woorden["Perfectum"]["Mv"]["1e"] = $stam.$prf."uimus";
				$woorden["Perfectum"]["Mv"]["2e"] = $stam.$prf."uistis";
				$woorden["Perfectum"]["Mv"]["3e"] = $stam.$prf."uerunt";
	
				$woorden["Plusquamperfectum"]["Ev"]["1e"] = $stam.$prf."ueram";
				$woorden["Plusquamperfectum"]["Ev"]["2e"] = $stam.$prf."ueras";
				$woorden["Plusquamperfectum"]["Ev"]["3e"] = $stam.$prf."uerat";
				$woorden["Plusquamperfectum"]["Mv"]["1e"] = $stam.$prf."ueramus";
				$woorden["Plusquamperfectum"]["Mv"]["2e"] = $stam.$prf."ueratis";
				$woorden["Plusquamperfectum"]["Mv"]["3e"] = $stam.$prf."uerant";
			}
			elseif(!empty($stam['perfectum']))
			{
				$stam = $stam['perfectum']; 
				$woorden["Perfectum"]["Ev"]["1e"] = $stam."i";
				$woorden["Perfectum"]["Ev"]["2e"] = $stam."isti";
				$woorden["Perfectum"]["Ev"]["3e"] = $stam."it";
				$woorden["Perfectum"]["Mv"]["1e"] = $stam."imus";
				$woorden["Perfectum"]["Mv"]["2e"] = $stam."istis";
				$woorden["Perfectum"]["Mv"]["3e"] = $stam."erunt";
	
				$woorden["Plusquamperfectum"]["Ev"]["1e"] = $stam."eram";
				$woorden["Plusquamperfectum"]["Ev"]["2e"] = $stam."eras";
				$woorden["Plusquamperfectum"]["Ev"]["3e"] = $stam."erat";
				$woorden["Plusquamperfectum"]["Mv"]["1e"] = $stam."eramus";
				$woorden["Plusquamperfectum"]["Mv"]["2e"] = $stam."eratis";
				$woorden["Plusquamperfectum"]["Mv"]["3e"] = $stam."erant";
			}
			else
			{
				$stam = substr($woord,0,-2); 
				// You can insert database code for custom perfectum code here
				
				$woorden["Perfectum"]["Ev"]["1e"] = $stam.$prf."i";
				$woorden["Perfectum"]["Ev"]["2e"] = $stam.$prf."uisti";
				$woorden["Perfectum"]["Ev"]["3e"] = $stam.$prf."uit";
				$woorden["Perfectum"]["Mv"]["1e"] = $stam.$prf."uimus";
				$woorden["Perfectum"]["Mv"]["2e"] = $stam.$prf."uistis";
				$woorden["Perfectum"]["Mv"]["3e"] = $stam.$prf."uerunt";
	
				$woorden["Plusquamperfectum"]["Ev"]["1e"] = $stam.$prf."ueram";
				$woorden["Plusquamperfectum"]["Ev"]["2e"] = $stam.$prf."ueras";
				$woorden["Plusquamperfectum"]["Ev"]["3e"] = $stam.$prf."uerat";
				$woorden["Plusquamperfectum"]["Mv"]["1e"] = $stam.$prf."ueramus";
				$woorden["Plusquamperfectum"]["Mv"]["2e"] = $stam.$prf."ueratis";
				$woorden["Plusquamperfectum"]["Mv"]["3e"] = $stam.$prf."uerant";
			}
		}
		return($woorden);
	}
	
	// This will make comparisions like fortis, fortius, fortissimus and bonus, melior, optimus
	// String bnw: this is the adjective
	function vtrap($bnw)
	{
		$bnw = strtolower($bnw);
		
		if($bnw == "bonus")
		{
			$woorden["Positivus"]   ["Adjectum"] = "bonus";
			$woorden["Comperativus"]["Adjectum"] = "melior";
			$woorden["Superlativus"]["Adjectum"] = "optimus";
			$woorden["Positivus"]   ["Adverbum"] = "bene";
			$woorden["Comperativus"]["Adverbum"] = "melius";
			$woorden["Superlativus"]["Adverbum"] = "optime";
		}
		elseif($bnw == "malus")
		{
			$woorden["Positivus"]   ["Adjectum"] = "malus";
			$woorden["Comperativus"]["Adjectum"] = "peior";
			$woorden["Superlativus"]["Adjectum"] = "pessimus";
			$woorden["Positivus"]   ["Adverbum"] = "male";
			$woorden["Comperativus"]["Adverbum"] = "peius";
			$woorden["Superlativus"]["Adverbum"] = "pessime";
		}
		elseif($bnw == "multus")
		{
			$woorden["Positivus"]   ["Adjectum"] = "multus";
			$woorden["Comperativus"]["Adjectum"] = "plus";
			$woorden["Superlativus"]["Adjectum"] = "plurimus";
			$woorden["Positivus"]   ["Adverbum"] = "multum";
			$woorden["Comperativus"]["Adverbum"] = "plus";
			$woorden["Superlativus"]["Adverbum"] = "plurimum";
		}
		elseif($bnw == "magnus")
		{
			$woorden["Positivus"]   ["Adjectum"] = "magnus";
			$woorden["Comperativus"]["Adjectum"] = "maior";
			$woorden["Superlativus"]["Adjectum"] = "maximus";
			$woorden["Positivus"]   ["Adverbum"] = "magnopere";
			$woorden["Comperativus"]["Adverbum"] = "magis";
			$woorden["Superlativus"]["Adverbum"] = "maxime";
		}
		elseif($bnw == "parvus")
		{
			$woorden["Positivus"]   ["Adjectum"] = "parvus";
			$woorden["Comperativus"]["Adjectum"] = "minor";
			$woorden["Superlativus"]["Adjectum"] = "minimus";
			$woorden["Positivus"]   ["Adverbum"] = "paulum";
			$woorden["Comperativus"]["Adverbum"] = "minus";
			$woorden["Superlativus"]["Adverbum"] = "minime";
		}
		else
		{
			if(substr($bnw,-2) == "us" || substr($bnw,-2) == "er" && $bnw != "acer") // Longus groep
			{
				if(substr($bnw,-2) == "er") { $stam = $bnw; $t = "r"; }
				else { $stam = substr($bnw,0,-2); }
				
				if($bnw == "pulcher") { $woorden["Comperativus"]["Adjectum"] = "pulchrior"; }
				else { $woorden["Comperativus"]["Adjectum"] = $stam."ior"; } 
				
				$woorden["Positivus"]   ["Adjectum"] = $bnw;
				$woorden["Comperativus"]["Adjectum"] = $stam."ior";
				$woorden["Superlativus"]["Adjectum"] = $stam.$t."issimus";
				$woorden["Positivus"]   ["Adverbum"] = $stam."e";
				$woorden["Comperativus"]["Adverbum"] = $stam."ius";
				$woorden["Superlativus"]["Adverbum"] = $stam."issime";
			}
			elseif(substr($bnw,-2) == "is") // Fortis groep
			{
				$stam = substr($bnw,0,-2);
				if(substr($bnw,-3) == "lis") { $t = "lime"; $u = "limus"; }
				elseif($bnw == "acer") { $t = "rime"; $u = "rimus"; }
				else{ $t = "issime"; $u = "issimus"; }
				
				$woorden["Positivus"]   ["Adjectum"] = $bnw;
				$woorden["Comperativus"]["Adjectum"] = $stam."ior";
				$woorden["Superlativus"]["Adjectum"] = $stam.$u;
				$woorden["Positivus"]   ["Adverbum"] = $stam."iter";
				$woorden["Comperativus"]["Adverbum"] = $stam."ius";
				$woorden["Superlativus"]["Adverbum"] = $stam.$t;
			}
			elseif(substr($bnw,-2) == "ns") // Ingens groep
			{
				if($bnw == "audax") { $stam = "audac"; }
				else { $stam = substr($bnw,0,-1)."t"; }
				
				$woorden["Positivus"]   ["Adjectum"] = $bnw;
				$woorden["Comperativus"]["Adjectum"] = $stam."ior";
				$woorden["Superlativus"]["Adjectum"] = $stam."issimus";
				$woorden["Positivus"]   ["Adverbum"] = $stam."er";
				$woorden["Comperativus"]["Adverbum"] = $stam."ius";
				$woorden["Superlativus"]["Adverbum"] = $stam."issime";
			}
		}
		return($woorden);
	}
	
	// This will get the comparisions from one word, and get the combinations with a noun with it
	// String Znw: the noun in nominativus singularis
	// String Bnw: the adjective
	// Boolean drie: indicate whether its a word of group three (senex-senes) or not
	// String geslacht: m for male, v for female and o for neuter
	// String mv: nominativus pluralis, if needed
	function btrap($znw,$bnw,$drie,$geslacht,$mv)
	{
		$trap = $this->vtrap($bnw);
		$woorden["Positivus"]["Adjectum"] = $this->bnw($znw,$bnw,$drie,$geslacht,$mv);
		$woorden["Comperativus"]["Adjectum"] = $this->bnw($znw,$trap["Comperativus"]["Adjectum"],$drie,$geslacht,$mv);
		$woorden["Superlativus"]["Adjectum"] = $this->bnw($znw,$trap["Superlativus"]["Adjectum"],$drie,$geslacht,$mv);
		$woorden["Positivus"]   ["Adverbum"] = $trap["Positivus"]["Adverbum"];
		$woorden["Comperativus"]["Adverbum"] = $trap["Comperativus"]["Adverbum"];
		$woorden["Superlativus"]["Adverbum"] = $trap["Superlativus"]["Adverbum"];
		return($woorden);
	}
	
	// This will generate and adjective with a noun
	// String Znw: the noun in nominativus singularis
	// String Bnw: the adjective
	// Boolean drie: indicate whether its a word of group three (senex-senes) or not
	// String geslacht: m for male, v for female and o for neuter
	// String mv: nominativus pluralis, if needed
	function bnw($znw,$bnw,$drie,$geslacht,$mv)
	{
		if(!$drie)
		{ 
			if(substr($znw,-2) == "us") { $geslacht = "m"; $stam = substr($znw,0,-2); }
			elseif(substr($znw,-1) == "r") { $geslacht = "m"; $stam = substr($znw,0,-1); }
			elseif(substr($znw,-1) == "a") { $geslacht = "v"; $stam = substr($znw,0,-1); }
			elseif(substr($znw,-2) == "um") { $geslacht = "o"; $stam = substr($znw,0,-2); }
		}
		else
		{
			if(substr($mv,-2) == "es") { $stam = substr($mv,0,-2); }
			elseif (substr($mv,-1) == "a") { $stam = substr($mv,0,-1); $geslacht = "o"; }
		}
	
		if(substr($bnw,-2) == "us") // Longus groep
		{
			$bstam = substr($bnw,0,-2);
	
			if(!$drie)
			{
				if($geslacht == "m") // Lijkt me duidelijk
				{
					$woorden["Nominativus"]["Ev"] = $stam."us ".$bstam."us";
					$woorden["Nominativus"]["Mv"] = $stam."i ".$bstam."i";
					$woorden["Genitivus"]  ["Ev"] = $stam."i ".$bstam."i";
					$woorden["Genitivus"]  ["Mv"] = $stam."orum ".$bstam."orum";
					$woorden["Dativus"]    ["Ev"] = $stam."o ".$bstam."o";
					$woorden["Dativus"]    ["Mv"] = $stam."is ".$bstam."is";
					$woorden["Accusativus"]["Ev"] = $stam."um ".$bstam."um";
					$woorden["Accusativus"]["Mv"] = $stam."os ".$bstam."os";
					$woorden["Ablativus"]  ["Ev"] = $stam."o ".$bstam."o";
					$woorden["Ablativus"]  ["Mv"] = $stam."is ".$bstam."is";
				}
				elseif($geslacht == "v")
				{
					$woorden["Nominativus"]["Ev"] = $stam."a ".$bstam."a";
					$woorden["Nominativus"]["Mv"] = $stam."ae ".$bstam."ae";
					$woorden["Genitivus"]  ["Ev"] = $stam."ae ".$bstam."ae";
					$woorden["Genitivus"]  ["Mv"] = $stam."arum ".$bstam."arum";
					$woorden["Dativus"]    ["Ev"] = $stam."ae ".$bstam."ae";
					$woorden["Dativus"]    ["Mv"] = $stam."is ".$bstam."is";
					$woorden["Accusativus"]["Ev"] = $stam."am ".$bstam."am";
					$woorden["Accusativus"]["Mv"] = $stam."as ".$bstam."as";
					$woorden["Ablativus"]  ["Ev"] = $stam."a ".$bstam."a";
					$woorden["Ablativus"]  ["Mv"] = $stam."is ".$bstam."is";
				}
				elseif($geslacht == "o")
				{
					$woorden["Nominativus"]["Ev"] = $stam."um ".$bstam."um";
					$woorden["Nominativus"]["Mv"] = $stam."a ".$bstam."a";
					$woorden["Genitivus"]  ["Ev"] = $stam."i ".$bstam."i";
					$woorden["Genitivus"]  ["Mv"] = $stam."orum ".$bstam."orum";
					$woorden["Dativus"]    ["Ev"] = $stam."o ".$bstam."o";
					$woorden["Dativus"]    ["Mv"] = $stam."is ".$bstam."is";
					$woorden["Accusativus"]["Ev"] = $stam."um ".$bstam."um";
					$woorden["Accusativus"]["Mv"] = $stam."a ".$bstam."a";
					$woorden["Ablativus"]  ["Ev"] = $stam."o ".$bstam."o";
					$woorden["Ablativus"]  ["Mv"] = $stam."is ".$bstam."is";
				}
			}
			else
			{
				if($geslacht == "m")
				{
					$woorden["Nominativus"]["Ev"] = $znw." ".$bstam."us";
					$woorden["Nominativus"]["Mv"] = $stam."es ".$bstam."i";
					$woorden["Genitivus"]  ["Ev"] = $stam."is ".$bstam."i";
					$woorden["Genitivus"]  ["Mv"] = $stam."um ".$bstam."orum";
					$woorden["Dativus"]    ["Ev"] = $stam."i ".$bstam."o";
					$woorden["Dativus"]    ["Mv"] = $stam."ibus ".$bstam."is";
					$woorden["Accusativus"]["Ev"] = $stam."em ".$bstam."um";
					$woorden["Accusativus"]["Mv"] = $stam."es ".$bstam."os";
					$woorden["Ablativus"]  ["Ev"] = $stam."e ".$bstam."o";
					$woorden["Ablativus"]  ["Mv"] = $stam."ibus ".$bstam."is";
				}
				elseif($geslacht == "v")
				{
					$woorden["Nominativus"]["Ev"] = $znw." ".$bstam."a";
					$woorden["Nominativus"]["Mv"] = $stam."es ".$bstam."ae";
					$woorden["Genitivus"]  ["Ev"] = $stam."is ".$bstam."ae";
					$woorden["Genitivus"]  ["Mv"] = $stam."um ".$bstam."arum";
					$woorden["Dativus"]    ["Ev"] = $stam."i ".$bstam."ae";
					$woorden["Dativus"]    ["Mv"] = $stam."ibus ".$bstam."is";
					$woorden["Accusativus"]["Ev"] = $stam."em ".$bstam."am";
					$woorden["Accusativus"]["Mv"] = $stam."es ".$bstam."as";
					$woorden["Ablativus"]  ["Ev"] = $stam."e ".$bstam."a";
					$woorden["Ablativus"]  ["Mv"] = $stam."ibus ".$bstam."is";
				}
				elseif($geslacht == "o")
				{
					$woorden["Nominativus"]["Ev"] = $znw." ".$bstam."um";
					$woorden["Nominativus"]["Mv"] = $stam."a ".$bstam."a";
					$woorden["Genitivus"]  ["Ev"] = $stam."is ".$bstam."i";
					$woorden["Genitivus"]  ["Mv"] = $stam."um ".$bstam."orum";
					$woorden["Dativus"]    ["Ev"] = $stam."i ".$bstam."o";
					$woorden["Dativus"]    ["Mv"] = $stam."ibus ".$bstam."is";
					$woorden["Accusativus"]["Ev"] = $znw." ".$bstam."um";
					$woorden["Accusativus"]["Mv"] = $stam."a ".$bstam."a";
					$woorden["Ablativus"]  ["Ev"] = $stam."e ".$bstam."o";
					$woorden["Ablativus"]  ["Mv"] = $stam."ibus ".$bstam."is";
				}
			}
	
		}
		elseif(substr($bnw,-2) == "is" || substr($bnw,-2) == "or") // Fortis groep
		{
	
			if(substr($bnw,-2) == "is") {  $bstam = substr($bnw,0,-2); }
			else { $bstam = $bnw; }
			if(!$drie)
			{
				if($geslacht == "m") // Lijkt me duidelijk opnieuw
				{
					$woorden["Nominativus"]["Ev"] = $stam."us ".$bstam."is";
					$woorden["Nominativus"]["Mv"] = $stam."i ".$bstam."es";
					$woorden["Genitivus"]  ["Ev"] = $stam."i ".$bstam."is";
					$woorden["Genitivus"]  ["Mv"] = $stam."orum ".$bstam."ium";
					$woorden["Dativus"]    ["Ev"] = $stam."o ".$bstam."i";
					$woorden["Dativus"]    ["Mv"] = $stam."is ".$bstam."ibus";
					$woorden["Accusativus"]["Ev"] = $stam."um ".$bstam."em";
					$woorden["Accusativus"]["Mv"] = $stam."os ".$bstam."es";
					$woorden["Ablativus"]  ["Ev"] = $stam."o ".$bstam."i";
					$woorden["Ablativus"]  ["Mv"] = $stam."is ".$bstam."ibus";
				}
				elseif($geslacht == "v")
				{
					$woorden["Nominativus"]["Ev"] = $stam."a ".$bstam."is";
					$woorden["Nominativus"]["Mv"] = $stam."ae ".$bstam."es";
					$woorden["Genitivus"]  ["Ev"] = $stam."ae ".$bstam."is";
					$woorden["Genitivus"]  ["Mv"] = $stam."arum ".$bstam."ium";
					$woorden["Dativus"]    ["Ev"] = $stam."ae ".$bstam."i";
					$woorden["Dativus"]    ["Mv"] = $stam."ae ".$bstam."ibus";
					$woorden["Accusativus"]["Ev"] = $stam."am ".$bstam."em";
					$woorden["Accusativus"]["Mv"] = $stam."as ".$bstam."es";
					$woorden["Ablativus"]  ["Ev"] = $stam."a ".$bstam."i";
					$woorden["Ablativus"]  ["Mv"] = $stam."is ".$bstam."ibus";
				}
				elseif($geslacht == "o")
				{
					$woorden["Nominativus"]["Ev"] = $stam."um ".$bstam."is";
					$woorden["Nominativus"]["Mv"] = $stam."a ".$bstam."es";
					$woorden["Genitivus"]  ["Ev"] = $stam."i ".$bstam."is";
					$woorden["Genitivus"]  ["Mv"] = $stam."orum ".$bstam."ium";
					$woorden["Dativus"]    ["Ev"] = $stam."o ".$bstam."i";
					$woorden["Dativus"]    ["Mv"] = $stam."is ".$bstam."ibus";
					$woorden["Accusativus"]["Ev"] = $stam."um ".$bstam."em";
					$woorden["Accusativus"]["Mv"] = $stam."a ".$bstam."es";
					$woorden["Ablativus"]  ["Ev"] = $stam."o ".$bstam."i";
					$woorden["Ablativus"]  ["Mv"] = $stam."is ".$bstam."ibus";
				}
			}
			else
			{
				if($geslacht != "o")
				{
					$woorden["Nominativus"]["Ev"] = $znw." ".$bstam."is";
					$woorden["Nominativus"]["Mv"] = $stam."es ".$bstam."es";
					$woorden["Genitivus"]  ["Ev"] = $stam."is ".$bstam."is";
					$woorden["Genitivus"]  ["Mv"] = $stam."um ".$bstam."ium";
					$woorden["Dativus"]    ["Ev"] = $stam."i ".$bstam."i";
					$woorden["Dativus"]    ["Mv"] = $stam."ibus ".$bstam."ibus";
					$woorden["Accusativus"]["Ev"] = $stam."em ".$bstam."em";
					$woorden["Accusativus"]["Mv"] = $stam."es ".$bstam."es";
					$woorden["Ablativus"]  ["Ev"] = $stam."e ".$bstam."i";
					$woorden["Ablativus"]  ["Mv"] = $stam."ibus ".$bstam."ibus";
				}
				else
				{
					$woorden["Nominativus"]["Ev"] = $znw." ".$bstam."e";
					$woorden["Nominativus"]["Mv"] = $stam."a ".$bstam."ia";
					$woorden["Genitivus"]  ["Ev"] = $stam."is ".$bstam."is";
					$woorden["Genitivus"]  ["Mv"] = $stam."um ".$bstam."ium";
					$woorden["Dativus"]    ["Ev"] = $stam."i ".$bstam."i";
					$woorden["Dativus"]    ["Mv"] = $stam."ibus ".$bstam."ibus";
					$woorden["Accusativus"]["Ev"] = $znw." ".$bstam."e";
					$woorden["Accusativus"]["Mv"] = $stam."a ".$bstam."ia";
					$woorden["Ablativus"]  ["Ev"] = $stam."e ".$bstam."i";
					$woorden["Ablativus"]  ["Mv"] = $stam."ibus ".$bstam."ibus";
				}
			}
		}
		elseif(substr($bnw,-2) == "ns") // Ingens groep
		{
			$bstam = substr($bnw,0,-2);
			if(!$drie)
			{
				if($geslacht == "m") // Lijkt me duidelijk opnieuw
				{
					$woorden["Nominativus"]["Ev"] = $stam."us ".$bstam."ns";
					$woorden["Nominativus"]["Mv"] = $stam."i ".$bstam."ntes";
					$woorden["Genitivus"]  ["Ev"] = $stam."i ".$bstam."ntis";
					$woorden["Genitivus"]  ["Mv"] = $stam."orum ".$bstam."ntium";
					$woorden["Dativus"]    ["Ev"] = $stam."o ".$bstam."nti";
					$woorden["Dativus"]    ["Mv"] = $stam."is ".$bstam."ntibus";
					$woorden["Accusativus"]["Ev"] = $stam."um ".$bstam."ntem";
					$woorden["Accusativus"]["Mv"] = $stam."os ".$bstam."ntes";
					$woorden["Ablativus"]  ["Ev"] = $stam."o ".$bstam."nti";
					$woorden["Ablativus"]  ["Mv"] = $stam."is ".$bstam."ntibus";
				}
				elseif($geslacht == "v")
				{
					$woorden["Nominativus"]["Ev"] = $stam."a ".$bstam."ns";
					$woorden["Nominativus"]["Mv"] = $stam."ae ".$bstam."ntes";
					$woorden["Genitivus"]  ["Ev"] = $stam."ae ".$bstam."ntis";
					$woorden["Genitivus"]  ["Mv"] = $stam."arum ".$bstam."ntium";
					$woorden["Dativus"]    ["Ev"] = $stam."ae ".$bstam."nti";
					$woorden["Dativus"]    ["Mv"] = $stam."ae ".$bstam."ntibus";
					$woorden["Accusativus"]["Ev"] = $stam."am ".$bstam."ntem";
					$woorden["Accusativus"]["Mv"] = $stam."as ".$bstam."ntes";
					$woorden["Ablativus"]  ["Ev"] = $stam."a ".$bstam."nti";
					$woorden["Ablativus"]  ["Mv"] = $stam."is ".$bstam."ntibus";
				}
				elseif($geslacht == "o")
				{
					$woorden["Nominativus"]["Ev"] = $stam."um ".$bstam."ns";
					$woorden["Nominativus"]["Mv"] = $stam."a ".$bstam."ntia";
					$woorden["Genitivus"]  ["Ev"] = $stam."i ".$bstam."ntis";
					$woorden["Genitivus"]  ["Mv"] = $stam."orum ".$bstam."ntium";
					$woorden["Dativus"]    ["Ev"] = $stam."o ".$bstam."nti";
					$woorden["Dativus"]    ["Mv"] = $stam."is ".$bstam."ntibus";
					$woorden["Accusativus"]["Ev"] = $stam."um ".$bstam."ns";
					$woorden["Accusativus"]["Mv"] = $stam."a ".$bstam."ntia";
					$woorden["Ablativus"]  ["Ev"] = $stam."o ".$bstam."nti";
					$woorden["Ablativus"]  ["Mv"] = $stam."is ".$bstam."ntibus";
				}
			}
			else
			{
				if($geslacht != "o")
				{
					$woorden["Nominativus"]["Ev"] = $znw." ".$bstam."ns";
					$woorden["Nominativus"]["Mv"] = $stam."es ".$bstam."ntes";
					$woorden["Genitivus"]  ["Ev"] = $stam."is ".$bstam."ntis";
					$woorden["Genitivus"]  ["Mv"] = $stam."um ".$bstam."ntium";
					$woorden["Dativus"]    ["Ev"] = $stam."i ".$bstam."nti";
					$woorden["Dativus"]    ["Mv"] = $stam."ibus ".$bstam."ntibus";
					$woorden["Accusativus"]["Ev"] = $stam."em ".$bstam."ntem";
					$woorden["Accusativus"]["Mv"] = $stam."es ".$bstam."ntes";
					$woorden["Ablativus"]  ["Ev"] = $stam."e ".$bstam."nti";
					$woorden["Ablativus"]  ["Mv"] = $stam."ibus ".$bstam."ntibus";
				}
				else
				{
					$woorden["Nominativus"]["Ev"] = $znw." ".$bstam."ns";
					$woorden["Nominativus"]["Mv"] = $stam."a ".$bstam."ntia";
					$woorden["Genitivus"]  ["Ev"] = $stam."is ".$bstam."ntis";
					$woorden["Genitivus"]  ["Mv"] = $stam."um ".$bstam."ntium";
					$woorden["Dativus"]    ["Ev"] = $stam."i ".$bstam."nti";
					$woorden["Dativus"]    ["Mv"] = $stam."ibus ".$bstam."ntibus";
					$woorden["Accusativus"]["Ev"] = $znw." ".$bstam."ns";
					$woorden["Accusativus"]["Mv"] = $stam."a ".$bstam."ntia";
					$woorden["Ablativus"]  ["Ev"] = $stam."e ".$bstam."nti";
					$woorden["Ablativus"]  ["Mv"] = $stam."ibus ".$bstam."ntibus";
				}
			}
		}
		return($woorden);
	}
	
	// Decimal to roman
	// Int number: the number to be converted
	function dec2roman ($number) 
	{
	
		# Making input compatible with script.
		$number = floor($number);
		if($number < 0) {
			$linje = "-";
			$number = abs($number);
		}
		
		# Defining arrays
		$romanNumbers = array(1000, 500, 100, 50, 10, 5, 1);
		$romanLettersToNumbers = array("M" => 1000, "D" => 500, "C" => 100, "L" => 50, "X" => 10, "V" => 5, "I" => 1);
		$romanLetters = array_keys($romanLettersToNumbers);
		
		# Looping through and adding letters.
		while ($number) {
			for($pos = 0; $pos <= 6; $pos++) {
				
				# Dividing the remaining number with one of the roman numbers.
				$dividend = $number / $romanNumbers[$pos];
	
				# If that division is >= 1, round down, and add that number of letters to the string.
				if($dividend >= 1) {
					$linje .= str_repeat($romanLetters[$pos], floor($dividend));
	
					# Reduce the number to reflect what is left to make roman of.
					$number -= floor($dividend) * $romanNumbers[$pos];
				}
			}
		}
	
	
		# If I find 4 instances of the same letter, this should be done in a different way.
		# Then, subtract instead of adding (smaller number in front of larger).
		$numberOfChanges = 1;
		while($numberOfChanges) {
			$numberOfChanges = 0;
	
			for($start = 0; $start < strlen($linje); $start++) {
				$chunk = substr($linje, $start, 1);
				if($chunk == $oldChunk && $chunk != "M") {
					$appearance++;
				} else {
					$oldChunk = $chunk;
					$appearance = 1;
				}
	
				# Was there found 4 instances.
				if($appearance == 4) {
					$firstLetter = substr($linje, $start - 4, 1);
					$letter = $chunk;
					$sum = $firstNumber + $letterNumber * 4;
	
					$pos = array_search($letter, $romanLetters);
	
					if($romanLetters[$pos - 1] == $firstLetter) {
						$oldString = $firstLetter . str_repeat($letter, 4);
						$newString = $letter . $romanLetters[$pos - 2];
					} else {
						$oldString = str_repeat($letter, 4);
						$newString = $letter . $romanLetters[$pos - 1];
					}
					$numberOfChanges++;
					$linje = str_replace($oldString, $newString, $linje);
				}
			}
		}
		return $linje;
	}
	
	// Roman to decimal
	// Int linje: the number to be converted
	function roman2dec ($linje) {
		# Fixing variable so it follows my convention
		$linje = strtoupper($linje);
		
		# Removing all not-roman letters
		$linje = ereg_replace("[^IVXLCDM]", "", $linje);
		
		# Defining variables
		$romanLettersToNumbers = array("M" => 1000, "D" => 500, "C" => 100, "L" => 50, "X" => 10, "V" => 5, "I" => 1);
	
		$oldChunk = 1001;
	
		# Looping through line
		for($start = 0; $start < strlen($linje); $start++) {
			$chunk = substr($linje, $start, 1);
			
			$chunk = $romanLettersToNumbers[$chunk];
			
			if($chunk <= $oldChunk) {
				$calculation .= " + $chunk";
			} else {
				$calculation .= " + " . ($chunk - (2 * $oldChunk));
			}
			
		
			$oldChunk = $chunk;
		}
		
		# Summing it up
		eval("\$b = $calculation;");
		return $b;
	
	}
}
?>