<?PHP
/**
* @name botrecognize.php
* using example for bot_recognizer class
* @Author Alexander Selifonov <alex (at) selifan [dot] ru>
*/

$dbengine = 'CDbEngine'; # CDbEngine wrapper will be used to manipulate SQL data
# $dbengine = 'zend'; # uncomment this if You use Zend Framework data access modules

$dbhost = 'localhost';
$dbuser = 'user';
$dbpass = 'password';
$dbname = 'my_db_name'; # edit these values as needed !

if($dbengine==='zend') {
  require_once('Zend/Db.php');
  require_once('Zend/Db/Table.php');
  require_once('Zend/Db/Adapter/Pdo/Mysql.php');
  $mydb = new Zend_Db_Adapter_Pdo_Mysql(
  array( 'host'=> $dbhost,
         'username' => $dbuser,
         'password' => $dbpass,
         'dbname'   => $dbname));
  Zend_Db_Table::setDefaultAdapter($mydb);
}
else {
  require_once('as_dbutils.php');
  $mydb = new CDbEngine(DBTYPE_MYSQL,$dbhost,$dbuser,$dbpass,$dbname);
}

require_once('bot_recognizer.php');

$botrec = new CBotRecognizer(array(
#  'sourcefile' => './bot-defs.txt', # uncomment if "file storage" is used instead of SQL DB, and here You can pass Your own definition file
#  'verbose' => 1, # turn on debug printing
  'dbobject'=>$mydb
));

# $botrec->SetSearchMode(CBotRecognizer::SEARCH_IP_ONLY); # for IP only checking
# $botrec->SetSearchMode(CBotRecognizer::SEARCH_AGENT_ONLY);

# test the page as if requested by one of bots:
# uncomment one of following lines
# $botrec->EmulateBot('65.55.211.115','msnbot/2.0b (+http://search.msn.com/msnbot.htm)');
# $botrec->EmulateBot('','badguy'); # emulate malicious bot
$botrec->EmulateBot('','Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)'); # Google bot

/*
$newrecs = $botrec->ImportBotsFromUrl('yahoo','E:/bot-lists/inktomi.txt',0);
echo "Imported bot definitions for yahoo: $newrecs<br />";
*/

$botrec->SetHandlerForBots('MSN_Handler','msn');
# $botrec->SetHandlerForBots('Google_Handler','google');
$botrec->SetHandlerForTypes('IndexerBots',0);
$botrec->SetHandlerForBots('UndefinedBots',CBotRecognizer::UNDEFINED_BOT);

$botrec->SetMaliciousHandler('MaliciousTrap');

/*
$bot_name = $botrec->GetBotId();
echo "<br />Recognized bot : $bot_name<br />";
*/

$botrec->Dispatch();

if($template_file!='' && file_exists($template_file)) {
  include $template_file;
}
function IndexerBots() {
  global $botrec;
  echo "<h2>This is one of INDEXING bots (bot id - " . $botrec->GetBotId() . ")</h2>";
}
function MSN_Handler() {
  global $template_file;
  echo "<h2>This request has come from Microsoft bot (msn)</h2>";
  $template_file = 'template-msn.htm';
}

function Google_Handler() {
  echo "<h2>This request has come from one of GOOGLE bots</h2>";
}
function MaliciousTrap() {
  echo "<h2>MALICIOUS BOT ! ACCESS DENIED !</h2>";
}
function UndefinedBots() {
  echo "<h3>Some bot detected, but we're not sure wich one of them...</h3>";
}
?>