<?PHP
/**
* @name import-botdefs.php :
* Importing bot definitions from text file into SQL DB.
* @Author Alexander Selifonov <alex (at) selifan [dot] ru>
* @Copyright 2009 Alexander Selifonov
* @license BSD : http://www.opensource.org/licenses/bsd-license.php
* @link http://www.selifan.ru
* @link http://www.phpclasses.org/browse/author/267915.html
* Last modified: 02.09.2009
*/
require_once('as_dbutils.php');
require_once('bot_recognizer.php');

# write here Your MySQL host params :
$dbhost = 'localhost';
$dbuser = '';
$dbpass = '';
$dbname = 'db_name'; # edit these values as needed !

$mydb = new CDbEngine(DBTYPE_MYSQL,$dbhost,$dbuser,$dbpass,$dbname);

# Or uncomment and use Zend Framework, here is example (using PDO_MySQL)
/*
require_once('Zend/Db.php');
require_once('Zend/Db/Table.php');
require_once('Zend/Db/Adapter/Pdo/Mysql.php');
$mydb = new Zend_Db_Adapter_Pdo_Mysql(
  array( 'host'=> $dbhost,
         'username' => $dbuser,
         'password' => $dbpass,
         'dbname'   => $dbname
  )
);

Zend_Db_Table::setDefaultAdapter($mydb);

*/
$botrec = new CBotRecognizer(array('dbobject'=>$mydb, 'verbose'=>1));


$added = $botrec->LoadBotDefinitionsFile('./bot-defs.$$$',1); # re-create table and load initial definitions list
/**
# load some "famous" bot definitions from iplists.com
$botdef_urls = array(
 'google'   => 'http://www.iplists.com/google.txt',
 'yahoo'    => 'http://www.iplists.com/inktomi.txt',
 'lycos'    => 'http://www.iplists.com/lycos.txt',
 'infoseek' => 'http://www.iplists.com/infoseek.txt',
 'altavista' => 'http://www.iplists.com/altavista.txt',
 'excite'   => 'http://www.iplists.com/excite.txt',
 'northernlight' => 'http://www.iplists.com/northernlight.txt'
);
foreach($botdef_urls as $botid=>$burl) {
  $cnt = $botrec->ImportBotsFromUrl($botid, $burl,0,1,0);
  if($cnt) echo "bot: $botid, imported $cnt records from $burl ".$botdef->GetErrorMessage()."<br />";
  elseif($botrec->GetErrorMessage()) echo $botrec->GetErrorMessage()."<br />";
}
**/

echo "$added Bot definitions imported !";

