<?php

/*
Copyright (c) 2008, Matt Johnston
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the 
following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of conditions and the 
      following disclaimer.

    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the
      following disclaimer in the documentation and/or other materials provided with the distribution.

    * Neither the name of the Team Carnage nor the names of its contributors may be used to endorse or promote
      products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

class Factoring {
	private $factor_array;
	private $factored;
	private $original_num;
	private static $loop;
	
	function __construct()
	{
		$this->factor_array = array();
		$this->loop = 0;
	}
	
    public function is_prime($number)
    {
		return !preg_match('/^1?$|^(11+?)\1+$/x', str_repeat('1', $number));
    }
    
	public function factor_number($number)
	{
		if($number == 0 || $number == 1)
		{
			return "Number may not be 1 or 0";
		}
		
		if($this->loop == 0) //this if statement is to store the original number for display
		{
			$this->original_num = $number;
		}
		
		$this->loop += 1; //the loop counter will count how many times the loop has ran
		
		if($this->is_prime($number) === FALSE) //if the number is not prime
		{
			for($i = 2; $i <= $number; $i++) //create our loop to find the first number it is divisible by
			{
				if($number % $i == 0) //if after division there are no remainders we found our first divisor
				{
					$this->factor_array[] = $i; //add the current $i number to our factor array
					$number = $number / $i; //divide the number by the divisor
				
					if($this->is_prime($number)) //if the number is now prime we tack on the final number
						$this->factor_array[] = $number;
					
					$this->factor_number($number); //if it's not prime, loop through until the number is prime
					break;
				}
			}
		}
		elseif($this->is_prime($number) === TRUE)
		{
			foreach($this->factor_array as $key=>$value)
			{
				if($key != count($this->factor_array) - 1) //if the current key of the array is not the last
				{
					$this->factored .= number_format($value) . " * ";
				}
				else //else its the last digit and we don't need the * sign
				{
					$this->factored .= number_format($value);
				}
			}
		}
		else
		{
			return "Number is already factored!"; //if the number is prime, it will return prime
		}
	return $this->original_num . " factored is: " . $this->factored; //return the answer for $number factored
	}
	
	public function get_loop_count() // you can use this to return how many times the function ran
	{
		return $this->loop;
	}
	
	public function get_factored_array()
	{
		return $this->factor_array;
	}
}

?>
