<?php
/**
 * This is the main Package responsable for Parsing BBCode and UnParsing
 * Parsed Html supporing 4 types of parsing/unparsing tags (Direct Tags ,
 * Direct Words , Indirect Non Recursive , Indirect Recursive)
 * @package Parser
 * @author Mohammed Yousef Bassyouni <harrrrpo@gmail.com>
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */
/**
 * include the configuration file
 */
require_once "Config.php";
/**
 * include DB Operations Interfacing class
 */
require_once "BBE_DB_Op.php";
/**
 * The Common Parsing Operations class
 */
require_once "Gen_Parsing.php";

$DBOp=new BBE_DB_Operations();
/**
 * This is the BBCode UnParser (i.e. it takes an Html and outputs BBCode , very
 * useful for editing)
 * it also do the 4 types of UnParsing
 * @package Parser
 */
class UnParser
{
    /**
     * Current tag being parsed in the string
     */
    public $CTag;
    /**
     * Instaance of General_Parsing for using it's common operations
     */
    public $GParse;
    /**
     * Class Constructor, it just creates instance of General_Parsing and assigns it to GParse
     */
    public function __construct()
    {
        $this->GParse=new General_Parsing();
    }
    /**
     * An Optimization step , this function detects Separators in text to be parsed
     * so that it grabs them only from DB
     * @param String $str String to be Parsed
     */
    public function Get_used_Tags($str)
    {
        global $DBOp;
        $Tags=array();
        preg_match_all("#<!-- Block_(.*?) -->#s",$str,$Tags);
        $Tags=array_unique($Tags[1]);
        $DB_Tags=$DBOp->Get_Tags_From_Array($Tags,'UnParse');
        return $DB_Tags;
    }
    /**
     * Method respnsable for UnParsing indrect tags depends on calling a
     * middle method with preg_replace_callback and than that method calls user
     * function from DB on Content enclosed in BBCode passing it's argument's also
     *
     * @param Reference $str Reference to string to be parsed
     * @param Array     $Tag Array Representing DB row containing Tag
     */
    public function Replace_Indirect_BB(&$str,$Tag)
    {
        $Sep=preg_quote($Tag["Sep"],'#');
        $Sep="!-- Block_{$Sep} --";
        $this->CTag=$Tag;
        if ($Tag['Recursive']==1)
        $str=preg_replace_callback($this->GParse->Recursive_RE_Generator($Sep,"<",">"),array($this,"Indirect_Replacer_Recursive"),$str);
        else if($Tag['Recursive']==0)
        $str=preg_replace_callback($this->GParse->Recursive_RE_Generator($Sep,"<",">"),array($this,"Indirect_Replacer_Non_Recursive"),$str);
    }
    /**
     * the Callback method called for UnParsing tags recursively
     * it calls the user defined method for tag giving it one param 
     * $Data => data enclosed by BBCode
     *
     * @param Array $match Matched substrings from main tobe-parsed string
     */
    public function Indirect_Replacer_Recursive($match)
    {
        $Sep=preg_quote($this->CTag["Sep"],'#');
        $Sep="!-- Block_{$Sep} --";
        $match[2]=preg_replace_callback($this->GParse->Recursive_RE_Generator($Sep,"<",">"),array($this,"Indirect_Replacer_Recursive"),$match[2]);
        $Func=create_function('$Data',$this->CTag["R_Func"]);
        $match[2]=$Func($match[2]);
        return $match[2];
    }
    /**
     * the Callback method called for UnParsing tags non-recursively
     * it calls the user defined method for tag giving it two params $Args => BBcode arguments
     * $Data => data enclosed by BBCode
     *
     * @param Array $match Matched substrings from main tobe-unparsed string
     */
    public function Indirect_Replacer_Non_Recursive($match)
    {
        $Func=create_function('$Data',$this->CTag["R_Func"]);
        $match[2]=$Func($match[2]);
        return $match[2];
    }
     /**
     * method to compare to tags in order of thier UnParsing Priority (DESC)
     * it's used with usrot() for sorting Tags
     *
     * @param Array $a Tag1
     * @param Array $b Tag2
     */
    function Cmp_Tag_Priority($a, $b)
    {
        return ($a['Priority'] < $b['Priority']) ? +1 : -1;
    }
    /**
     * Tiny function (Maybe it's in stdlib and i missed it)
     * it just swaps to attrubutes of a Tag
     */
    function BB_Swap(&$a,&$b)
    {
        $c=$a;
        $a=$b;
        $b=$c;
    }
    /**
     * The Main UnParsing function ,
     * it loops over all tags in documents (identified by Get_used_Tags) after ordering
     * them DESC in according to thier Priorities
     *
     * @param Reference $str reference to the string to be parsed
     */
    public function UnParse($str)
    {
        $Arr_Tags=$this->Get_used_Tags($str);
        $Arr_Tags=array_merge($Arr_Tags[0],$Arr_Tags[1],$Arr_Tags[2]);
        usort($Arr_Tags,array($this,"Cmp_Tag_Priority"));
        for ($i=0;$i<count($Arr_Tags);$i++)
        {
            if(isset($Arr_Tags[$i]['Word']))
            {
                $this->BB_Swap($Arr_Tags[$i]["Word"],$Arr_Tags[$i]["Mapped_Tag"]);
                $this->GParse->Replace_Direct_Word_BB($str,$Arr_Tags[$i]);
            }
            else if(isset($Arr_Tags[$i]['Func']))
            {
                $this->Replace_Indirect_BB($str,$Arr_Tags[$i]);
            }
            else
            {
                $this->BB_Swap($Arr_Tags[$i]["Tag"],$Arr_Tags[$i]["Mapped_Tag"]);
                $this->GParse->Replace_Direct_Tag_BB($str,$Arr_Tags[$i],"UnParse",array('<','>'),array('[',']'));
            }
        }
        return $str;
    }
}
$str='<!-- Block GCode Separator Start --><b>[b]asd</b><u>we <img style="vertical-align: middle;" emoid=":D" src="http://arabteam2000-forum.com/style_emoticons/default/biggrin.gif" border="0"> </u><i><u>asd<!-- Block Parsed Url Start --><a href="http://google.com">http://google.com</a><!-- Block Parsed Url End --></i>[/i]</u>[asasd]<img style="vertical-align: middle;" emoid=":D" src="http://arabteam2000-forum.com/style_emoticons/default/biggrin.gif" border="0"> <!-- Block GCode Separator End -->asasas';
$str='<!-- Block_List --><ul></li><li>One<!-- Block_List --><ol type="1"></li><li>One/One<!-- Block_List --><ol type="A"></li><li>One/One</li><li>One/Two</ol></!-- Block_List --></li><li>One/Two</ol></!-- Block_List --></ul></!-- Block_List --><!-- Block_List --><ul></li><li>Two<!-- Block_List --><ol type="1"></li><li>Two/One</li><li>Two/Two</ol></!-- Block_List --></ul></!-- Block_List -->';
$str='<!-- Block_Parsed Url --><a href="http://google.com">My Engine</a></!-- Block_Parsed Url --><br><!-- Block_Email --><a href="mailto:harrrrpo@gmail.com">My Email</a></!-- Block_Email --><br><!-- Block_Image --><img src="http://localhost/phpmyadmin/themes/original/img/logo_left.png"></!-- Block_Image --><br><!-- Block_Text Size --><span style="font-size: 20px;">Big Label</span></!-- Block_Text Size --><br><!-- Block_Google Video --><embed style="width: 400px; height: 325px;" id="VideoPlayback" type="application/x-shockwave-flash" src="http://video.google.com/googleplayer.swf?docId=3966673435136338279&amp;hl=en"></!-- Block_Google Video -->';
$str='<!-- Block_List --><ul></li><li>One<!-- Block_List --><ol type="1"></li><li>One/One<!-- Block_List --><ol type="A"></li><li>One/One</li><li>One/Two</ol></!-- Block_List --></li><li>One/Two</ol></!-- Block_List --></ul></!-- Block_List --><!-- Block_List --><ul></li><li>Two<!-- Block_List --><ol type="1"></li><li>Two/One</li><li>Two/Two</ol></!-- Block_List --></ul></!-- Block_List --><br><!-- Block_Parsed Url --><a href="http://google.com">My Engine</a></!-- Block_Parsed Url --><br><!-- Block_Email --><a href="mailto:harrrrpo@gmail.com">My Email</a></!-- Block_Email --><br><!-- Block_Image --><img src="http://localhost/phpmyadmin/themes/original/img/logo_left.png"></!-- Block_Image --><br><!-- Block_Text Size --><span style="font-size: 20px;">Big <!-- Block_Text Size --><span style="font-size: 40px;">Big Label</span></!-- Block_Text Size --> Label</span></!-- Block_Text Size --><br><!-- Block_Google Video --><embed style="width: 400px; height: 325px;" id="VideoPlayback" type="application/x-shockwave-flash" src="http://video.google.com/googleplayer.swf?docId=3966673435136338279&amp;hl=en"></!-- Block_Google Video -->';
$p=new UnParser();
$p->UnParse($str);
?>