<?php
/**
 * This is the main Package responsable for Parsing BBCode and UnParsing
 * Parsed Html supporing 4 types of parsing/unparsing tags (Direct Tags ,
 * Direct Words , Indirect Non Recursive , Indirect Recursive)
 * @package Parser
 * @author Mohammed Yousef Bassyouni <harrrrpo@gmail.com>
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */
/**
 * This class holds common functionality between Parser and UnParser
 * @package Parser
 */
class General_Parsing
{
    /**
     * Direct Tags Parser ,
     * This Method moves through text and replaces given BBcode/Tags with
     * Tags/BBCodes assuring that a properly idented set of BBCodes/Tags
     * is replaced
     * it's used by both Parser and UnParser
     * Example is [b][/b] => <strong></strong>
     * 
     * @param Reference $str          reference to the string to be parsed
     * @param Array     $Tag          Tag to be Replaced from string (Which is DB Retrieved Row)
     * @param Array     $Tag_Start    an array containg Start and end brackets of tag
     * @param Array     $Mapped_Start an array containg Start and end brackets of
     *                                the Mapped tag
     */
    public function Replace_Direct_Tag_BB(&$str,$Tag,$Mode,$Tag_Start,$Mapped_Start)
    {
        $Tclosed=$Tag_Start[0]."/".$Tag["Tag"].$Tag_Start[1];
        $MTclosed=$Mapped_Start[0]."/".$Tag["Mapped_Tag"].$Mapped_Start[1];
        if ($Mode=="Parse")
        {
            $Topen=$Tag_Start[0].$Tag["Tag"].$Tag_Start[1];
            $MTopen=$Mapped_Start[0].$Tag["Mapped_Tag"].' '.$Tag["Mapped_Tag_Args"].$Mapped_Start[1];    
        }
        else if ($Mode=="UnParse")
        {
            $Topen=$Tag_Start[0].$Tag["Tag"].' '.$Tag["Mapped_Tag_Args"].$Tag_Start[1];
            $MTopen=$Mapped_Start[0].$Tag["Mapped_Tag"].$Mapped_Start[1];        
        }
        while(1)
        {
            $P1=stripos($str,$Topen);
            $P2=stripos($str,$Tclosed);
            if (($P1 !==false) AND ($P2 !==false) AND ($P1 <$P2))
            {
                $this->First_Occurance_replace($str,$Topen,$MTopen,$P1);
                $P2=stripos($str,$Tclosed);
                $this->First_Occurance_replace($str,$Tclosed,$MTclosed,$P2);
            }
            else
            {break;}
        }
    }
    /**
     * Direct word Parser ,
     * This method Directly replaces given words from String to be Parsed
     * Examples are :) => Smile Image
     *
     * @param Reference $str          reference to the string to be parsed
     * @param Array     $Tag          Tag to be Replaced from string (Which is DB Retrieved Row)
     */
    public function Replace_Direct_Word_BB(&$str,$Tag)
    {
        $str=str_ireplace($Tag["Word"],$Tag["Mapped_Tag"],$str);
    }
    /**
     * Small function to replace the first occurance of a substring in a string
     * by other substring
     * used by Replace_Direct_Tag_BB
     */
    public function First_Occurance_replace(&$str,$search,$replace,$pos)
    {
        $str=substr($str,0,$pos).$replace.substr($str,$pos+strlen($search));
    }
    /**
     * A Template for the recursive tags matcher RE
     * it generates it for a given tag open bracket and closing one
     * @param String $tag Tag to be parsed recursively
     * @param String $O   Opeening brackets of tag
     * @param String $C   Closing brackets of tag
     */
    public function Recursive_RE_Generator($tag,$O,$C)
    {
        $re="#{$O}({$tag}.*?){$C}((?>{$O}(?!/?{$tag}[^{$O}]*?{$C})|[^{$O}]|(?R))*){$O}/{$tag}{$C}#is";
        return $re;
    }
    /**
     * A Template for the Non recursive tags matcher RE
     * it generates it for a given tag open bracket and closing one
     * @param String $tag Tag to be parsed recursively
     * @param String $O   Opeening brackets of tag
     * @param String $C   Closing brackets of tag
     */
    public function Non_Recursive_RE_Generator($tag,$O,$C)
    {
        $re="#{$O}({$tag}.*?){$C}(.*?){$O}/{$tag}{$C}#is";
        return $re;
    }   
}
?>