<?php
/**
 * This is a some examples about common operations of class
 * In order for Parsing & UnParsing examples to be useful
 * you must import the DB Backup given in DB Stated in your
 * Config file
 * @package Examples
 * @author Mohammed Yousef Bassyouni <harrrrpo@gmail.com>
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License 
 */
/**
 * Examples on Inserting Types of Tags to DB
 */
require ("../Config.php");
require ("../BBE_DB_Op.php");
$DBOp=new BBE_DB_Operations();
/**
 * First Adding a Direct Tag
 * our example here is the [center] famout BBCode
 * we replace it with <div> that has the arguments style="text-align: center;"
 * and give it a priority 1.23 (really just another number and for this case does't have impact)
 */
$DBOp->Add_Direct_Tag_BB("center","div","style=\"text-align: center;\"",1.23);
//-------------------------------
/**
 * Second Adding a Direct word
 * our example here is the famout :happy: smile
 * we directly replace it with an image
 * NOTE : Here a direct Case insensitive replace happen so be careful
 */
$DBOp->Add_Direct_Word_BB(":happy:","<img src=\"http://arabteam2000-forum.com/style_emoticons/default/happy.gif\" border=\"0\">",3.8);
//-----------------------------------
/**
 * Third Adding an Indirect Recursive tag
 * our example here is for a strange tag UPP to converts to upper case and optionally takes
 * a Strart and End points (e.g. [UPP Startm Start=2 End=4]Another Sad Story[/UPP])
 * First we provide the Replacing function (using heredoc NOTE TAKE CARE OF ESCAPING $ in heredoc
 * A very Appealing alternative is newdoc if you are using PHP >=5.3)
 * which is passed two varaibles Start and End
 *
 * After that the reversing function which converts BBCode to Html
 * In inserting we specify tag as recursive (as we can write [UPP] QQ CC[UPP]BB NN MM[/UPP]VV BB[/UPP])
 */
$Func=<<<EOF
if (!isset(\$Args['Start']) ||!isset(\$Args['End']))
return strtoupper(\$Data);
else
return strtolower(substr(\$Data,0,\$Args['Start'])).strtoupper(substr(\$Data,\$Args['Start'],\$Args['End']-\$Args['Start']+1)).strtolower(substr(\$Data,\$Args['End']+1));
EOF;
$R_Func=<<<EOF
\$c=0;
\$st=-1;
for (\$i=0;\$i<strlen(\$Data);\$i++)
{
    if (\$Data[\$i]<="Z" && \$Data[\$i]>="A")
    {
        \$c++;
        if (\$st==-1)\$st=\$i;
    }
}
\$end=\$st+\$c-1;
return "[UPP Start={\$st} End={\$end}]".strtolower(\$Data)."[/UPP]";
EOF;
$DBOp->Add_Indirect_BB("UPP","",mysql_real_escape_string($Func),"Upper Maker",3.9,1,mysql_real_escape_string($R_Func));
?>