<?php
/**
 * This is the part responsable for Encapsulating DB Operations
 * it has Abstract interface to isolate any DBMS specific things
 * from the rest of the BBEngine
 * The Package is a minimalistic abstract DB interface for the
 * Specefic needs of the BBEngine
 * @package DB Layer
 * @author Mohammed Yousef Bassyouni <harrrrpo@gmail.com>
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */
/**
 * Include the Script with the Abstrct Class representing DB Operations
 */
include("General_DB.php");
/**
 * This is the MySQL DB class , it overrides all abstract methods
 * for MySQL Specific functionality
 * @package DB Layer
 * @todo More Error Checking
 */
class MySQL extends DB_Handler
{
    /**
     * The Initialization method , for MySQL it grabs Configurations for Server
     * User...etc , which is availabe in global space accessed for $GLOBALS
     * (It's there as the user including this class must also include the
     * Configuration file)
     */
    public function Init()
    {
        $this->Handler=mysql_connect($GLOBALS['G_Conf']['Host'],$GLOBALS['G_Conf']['User'],$GLOBALS['G_Conf']['Pass']);
        mysql_select_db($GLOBALS['G_Conf']['DB'],$this->Handler);
    }
    /**
     * MySQL Straight forward insert to the DB in MySQL SQL Syntax
     * @param string $table The Table name
     * @param Array  $Arr_values An array of values to be inserted
     */
    public function Insert($table,$Arr_values)
    {
        $Query="INSERT INTO `$table` VALUES (".implode(",",$Arr_values).")";
        mysql_query($Query,$this->Handler);
        print mysql_error();
    }
    /**
     * MySQL Straight forward Delete from the DB in MySQL SQL Syntax
     * @param string $table The Table name
     * @param string $field The Field name to which the value will be matched
     *                      for the Delete Condition
     * @param string $val   The Value 
     */
    public function Delete($table,$field,$val)
    {
        $Query="DELETE * FROM `$table` WHERE `$field`=`$val`";
        mysql_query($Query,$this->Handler);
    }
    /**
     * This Method retrieves all rows matching array of values and a column
     * it uses 'IN' as a condition in the Select statement for specifying
     * mulitple values
     * @param string $table The Table name
     * @param string $field The Field name to which the value will be matched
     *                      for the Delete Condition
     * @param Array $T_Arr  This is an array of Values to be matched with field ,
     *                      all rows matched should be returned
     */
    public function Get_Tags($table,$field,$T_Arr)
    {
        $Query="SELECT * FROM `$table` WHERE `$field` IN ('".implode("','",$T_Arr)."')";
        return $this->Get_Select_Result($Query);
    }
    /**
     * Retrieve all rows from a table inconditionally
     * @param string $table The Table name 
     */
    public function Get_All_Tags($table)
    {
        $Query="SELECT * FROM `$table` ";
        return $this->Get_Select_Result($Query);
    }
    /**
     * A helper function used in returning Select statement's result
     * for functions Get_Tags & Get_All_Tags
     * @param string $Query The Select Query tobe executed for returning
     *                      it's result
     */
    function Get_Select_Result($Query)
    {
        $res  = mysql_query($Query,$this->Handler);
        $tag_info=array();
        while($row  = mysql_fetch_assoc($res))
        {
            $tag_info[]=$row;
        }
        return $tag_info;
    }
    /**
    public function CurrentRowCount($table)
    {
        $Query= "SELECT COUNT(`Id`) FROM `$table`";
        $res  = mysql_query($Query,$this->Handler);
        $row  = mysql_fetch_array($res);
        return $row["COUNT(`Id`)"];
    }
    **/
}
?>