<?php
/**
 * This is the part responsable for Encapsulating DB Operations
 * it has Abstract interface to isolate any DBMS specific things
 * from the rest of the BBEngine
 * The Package is a minimalistic abstract DB interface for the
 * Specefic needs of the BBEngine
 * @package DB Layer
 * @author Mohammed Yousef Bassyouni <harrrrpo@gmail.com>
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */
/**
 * The DB_Handler class
 * This is an abstract class resbonsable for encasulation all
 * DB operations and any DBMS specific thing from the rest of
 * the BBEngine
 * @package DB Layer
 * @abstract
 * @todo Write Classes for more DBMS
 */
abstract class DB_Handler
{
    /**
     * This is the varaible that holds connection resource
     * @var Resource
     */
    public $Handler;
    /**
     * This is a void function responsable for Initializing DB Class
     * (Making Connection and choosing DB)
     * it has no arguments as it depends on the Config file in Initializing
     * @abstract
     */
    abstract public function Init           ();
    /**
     * This function Encapsulates SQL Insert Operations Taking Table name
     * and array of values to be inserted as arguments
     * @param string $table The Table name
     * @param Array  $Arr_values An array of values to be inserted
     */
    abstract public function Insert         ($table,$Arr_values);
    /**
     * This function Encapsulates SQL Delete Operations Taking Table name
     * and a field and it's value as Condition to delete statement
     * @param string $table The Table name
     * @param string $field The Field name to which the value will be matched
     *                      for the Delete Condition
     * @param string $val   The Value
     */
    abstract public function Delete         ($table,$field,$val);
    /**
     * This function is used to get Tags rows from DB matching a filed and value
     * condition which is used in a Select Statement
     * @param string $table The Table name
     * @param string $field The Field name to which the value will be matched
     *                      for the Delete Condition
     * @param Array $T_Arr  This is an array of Values to be matched with field ,
     *                      in the backgroud all rows matched should be returned
     *                      (i.e. Through 'IN' SQL Condition )
     */
    abstract public function Get_Tags       ($table,$field,$T_Arr);
    /**
     * This is another version of previous function that returns all rows with
     * no condition
     * @param string $table The Table name
     */
    abstract public function Get_All_Tags   ($table);
}
?>