<?php
/**
 * This is the part responsable for Encapsulating DB Operations
 * it has Abstract interface to isolate any DBMS specific things
 * from the rest of the BBEngine
 * The Package is a minimalistic abstract DB interface for the
 * Specefic needs of the BBEngine
 * @package DB Layer
 * @author Mohammed Yousef Bassyouni <harrrrpo@gmail.com>
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */
/**
 * The one interface (as means of dealing not an oop interface) that deals with
 * DB Classes to do BBEngine required DB operations exposing all required DB methods
 * @package DB Layer
 */
class BBE_DB_Operations
{
    /**
     * @var DB_Handler An instance of any of DB_Handler any extenders (like MySQL)
     */
    var $DB_Engine;
    /**
     * Class Constructor , Initialize DB_Handler from configuration 
     */
    function __construct()
    {
        require_once("DB_Layer/".$GLOBALS['G_Conf']['DB_Engine'].".php");
        $this->DB_Engine=new $GLOBALS['G_Conf']['DB_Engine']();
        $this->DB_Engine->Init();
    }
    /**
     * Insert a BBCode Directly replaced tag
     */
    function Add_Direct_Tag_BB($name,$replace,$replace_Tag_Args="",$Priority=1)
    {
        $this->DB_Engine->Insert($GLOBALS['G_Conf']['Direct_Tag_Table_Name'],array("0","'$name'","'$replace'","$Priority","'$replace_Tag_Args'"));
    }
    /**
     * Insert a BBCode Directly replaced word
     */
    function Add_Direct_Word_BB($name,$replace,$Priority=1)
    {
        $this->DB_Engine->Insert($GLOBALS['G_Conf']['Direct_Word_Table_Name'],array("0","'$name'","$Priority","'$replace'"));
    }
    /**
     * Insert an Indirect BBCode that's wrapped in a function and unparsed in reverse function
     */
    function Add_Indirect_BB($name,$args,$Func,$Sep,$Priority=1,$Recursive=0,$R_Func=null)
    {
        $this->DB_Engine->Insert($GLOBALS['G_Conf']['Indirect_Table_Name'],array("0","'$name'","'$args'","'$Func'","'$R_Func'","'$Sep'","'$Priority'","'$Recursive'"));
    }
    /**
     * Get all tags info based on :-
     *  1) thier name if we are Parsing tags
     *  2) thier Separator if we are UnParsing Html/Parsed tags
     */
    function Get_Tags_From_Array($Tag_Array,$Type)
    {
        if ($Type=='Parse')
        {
            $field='Tag';
            $Tags[0]   = $this->DB_Engine->Get_Tags($GLOBALS['G_Conf']['Direct_Tag_Table_Name'],$field,$Tag_Array);
            $Tags[1]   = $this->DB_Engine->Get_Tags($GLOBALS['G_Conf']['Indirect_Table_Name']  ,$field,$Tag_Array);
            $Tags[2]   = $this->DB_Engine->Get_All_Tags($GLOBALS['G_Conf']['Direct_Word_Table_Name']);
        }
        else if($Type=='UnParse')
        {
            $field='Sep';
            $Tags[0]   = $this->DB_Engine->Get_Tags($GLOBALS['G_Conf']['Indirect_Table_Name'],$field,$Tag_Array);
            $Tags[1]   = $this->DB_Engine->Get_All_Tags($GLOBALS['G_Conf']['Direct_Tag_Table_Name']);
            $Tags[2]   = $this->DB_Engine->Get_All_Tags($GLOBALS['G_Conf']['Direct_Word_Table_Name']);
        }
        return $Tags;
    }
}
?>