<?php
/**
 * keywordPosition.php :: Google Keyword Position class
 *
 * Class version 1.0.0.0
 * copyright (c) 2009 by Sandeep Kumar
 * Google Keyword Position is an open source PHP class library for easily know about google keyword position. 
 
 * KeywordPosition is released under the terms of the LGPL license
 * http://www.gnu.org/copyleft/lesser.html#SEC3
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * @package Search Engline
 * @copyright Copyright (c) 2009-20010  by Sandeep Kumar
 * @license http://www.gnu.org/copyleft/lesser.html#SEC3 LGPL License
 */
class KeywordPosition
{
	var $url='';
	var $keywords='';
	var $maxPosition=1;
	function KeywordPosition($url,$keywords,$maxPosition)
	{
		$url=str_replace('http://www.','',$url);
		//$url=str_replace('www.','',$url);
		$this->url=$url;
		$this->keywords=$keywords;
		if($maxPosition<1)
		$maxPosition=1;
		$this->maxPosition=$maxPosition;	
	}
	function GetPosition()
	{
		if(isset($this->url) && isset($this->keywords)) 
		{
   			 $make_url = 'http://www.google.com/search?hl=en&q=' . urlencode($this->keywords) . '&start=';
			 $index=0; // counting start from here
			 $found=false; // set this flag to true when position found
   			 for ($page = 0; $page < $this->maxPosition; $page++) 
			 {
     			if($found==true) // break the loop when position found
	 			break;
	 			$readPage = fopen($make_url . $page  . 0 ,'r');
     			$contains = '';
      			if ($readPage) 
				{
        			while (!feof($readPage)) 
					{
            			$buffer = fgets($readPage, 4096);
            			$contains .= $buffer;
        			}
        			fclose($readPage);
      		     }
				$results = array();
				preg_match_all('/a href="([^"]+)" class=l.+?>.+?<\/a>/',$contains,$results);
				foreach ($results[1] as $link) 
				{
				$link = preg_replace('(^http://|/$)','',$link);
				$index=$index+1;
				if (strlen(stristr($link,$this->url))>0) 
				{
				$found=true;
				break;
				}
				}
			}	
			if($found==true)
			return $index;
			else
			return -1;
        }
   	return -1;	
   }
}
?>