<?php

/********************************************
*
* Include class file
*
********************************************/
include_once("class.googlepr.php");

/********************************************
*
* Init class
*
********************************************/
$gpr = new GooglePR();

/********************************************
*
* Set Options
*
********************************************/
//Override user agent
//Default : "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.2.1) Gecko/20021204";
$gpr->userAgent = $_SERVER["HTTP_USER_AGENT"];

//Override cache directory
//You must permissions to create directories and files in cache directory
//Default : "/tmp";
$gpr->cacheDir = dirname(__FILE__)."/prcache";

//Override maximum cache age (in seconds)
//Cache file will be expired in $maxCacheAge seconds
//Default : 86400;
$gpr->maxCacheAge = 86400;

//Enable cache support
//if true, cache option is enabled
//Default : false
$gpr->useCache = false;

//Turn debugging on
//Default : false;
$gpr->debug = true;


/********************************************
*
* Query now
*
********************************************/
echo "PageRank : " .$gpr->GetPR("http://www.mrdbs.com/") ."\n";


/********************************************
*
* Debug query
*
********************************************/
echo "<pre>";
print_r($gpr->debugResult);
echo "</pre>";

?>
