<?php

//**************************************************
// Very accurate Atomic Time class
// Gets the time from NIST, accurate to 0.01 sec
// The NIST time is Official U.S time and is extremely
// accurate and precise and is a National Standard Time
//  Author : Al Dev (alavoor[at]yahoo.com)
//**************************************************

// Usage:-
//   Nightly cron job -
//		You can run this script as nightly cron job to set the 
//		system date and time. Login as root and do 'crontab -e'
//		and put a line like
// 14,15 0,5,12 * * * (/usr/bin/php /www/html/atomictime.php >> $HOME/cron.out 2>&1 ; date >> $HOME/cron.out)
//
//   Console mode - At unix bash prompt type
// 		bash$ php atomictime.php
//
// On Windows NT/2000/95/98, you must download the PHP for windows
// from http://prdownloads.sourceforge.net/phptriad or from 
// http://www.phpgeek.com and run a MSDOS 
// batch file syncatom.bat having a line -
// 	  c:\apache\php\php.exe c:\atomtime\AtomicTime.php
// You can run this batch file every-day automatically thru scheduler
// I strongly recommend phpTriad for MS Windows instead of http://www.php.net
//
//   Web-browser - Inside MS IE or netscape
//		http://<yourhost>/atomictime.php
//

// Atomic time resources : -
//
//	Gets the most accurate time from 
//		http://nist.time.gov  (IP 132.163.4.213)
//		http://nist.time.gov/timezone.cgi?Central/d/-6
//		http://nist.time.gov/timezone.cgi?Pacific/d/-8
//
//		http://www.atomictime.net/time_tel.html?4  (all time zones)
//		http://www.atomictime.net/time_tel.html?2
//
//		http://www.worldtimeserver.com  (whole world time)
//		http://www.worldtimeserver.com/time.asp?locationid=US-TX
//

$tm = new AtomicTime();
$tm->display();

class AtomicTime
{
	// Public variables
	var $current_time;
	var $current_date;
	var $current_year;
	var $current_month; // 1 to 12
	var $current_day; // 1 to 31
	var $sync_atomic = 'Y';  // default is "yes" - But run as root user

	// Private variables

	var $_time_url = array();
	var $_time_page = array();
	var $_page_contents;
	var $_max_urls;
	var $_which_system;

function display() // public function
{
	print "\n<b>Time:</b> $this->current_time<br>";
	print "\n<b>Date:</b> $this->current_date<br>";
	if ($this->sync_atomic == "Y")
		$this->set_system_time();  // If you want set system time - run a root
}

// Will set the unix system's date and time - But run as root
function set_system_time() // public function
{
	// bash$ man date
	// bash$ date +"%T %A, %B %e, %Y"

	$this->AtomicTime(); // get current time before doing set time..

	// Make sure the date and time got are correct values, because you
	// are going to set the cpu's system time !!
	$this->current_year = intval(substr($this->current_date, strlen($this->current_date) - 4));
	//print "\n\n<br>the this->current_year is : $this->current_year";

	$wx_start = strpos($this->current_date, ',');  // see also strrpos()
	$wx_end = strrpos($this->current_date, ',');  // see also strrpos()
	$this->current_month = substr($this->current_date, $wx_start +1, $wx_end - $wx_start - 3);
	$this->month_to_numbers();
	//print "\n\n<br>the this->current_month is : $this->current_month";

	$this->current_day = substr($this->current_date, strlen($this->current_date) - 8, 2);
	//print "\n\n<br>the this->current_day is : $this->current_day";

	if ($this->current_year < 2000 )
	{
		print "\n<br>Year is : $this->current_year . \n";
		print "\n<br>Something is going wrong! Check the url\n";
		return;
	}
	if ($this->current_month < 1 || $this->current_month > 12)
	{
		print "\n<br>Month is : $this->current_month . \n";
		print "\n<br>Something is going wrong! Check the url\n";
		return;
	}
	if ($this->current_day < 1 || $this->current_day > 31)
	{
		print "\n<br>Day is : $this->current_day . \n";
		print "\n<br>Something is going wrong! Check the url\n";
		return;
	}

	// Check if the NIST site is working
	if ( (trim($this->current_time) != "") && (trim($this->current_date) != "") )
	{
		// The NIST site is working, now then get the CURRENT ACCURATE time
		$this->current_time = "";
		$this->current_date = "";
		print "\n\n<br><br><b>Localhost Server time: </b>";
		// Reduce the number of commands between get time and set time, in order
		// to reduce the time lag between get and set....
		if ($this->_which_system == "windows")
		{
			// For MS Windows enter command as "c\:>time hh:mm:ss.ss" and "c\:>date mm-dd-yyyy"
			$this->_get_accurate_time(0, false);
			if ($this->current_time = "")
				return;
			$this->_get_accurate_time(0, true); // repeat command to get more accurate time
			$syscmd = "time " . $this->current_time;
			system($syscmd, $return_status);
			if (!$return_status)
				print "\n\nThe system time synchronized to Atomic clock \n\n";
			else
				print "\n\nError: The system command failed. \nYour command was $syscmd \n\n";
			$syscmd = "date " . $this->current_month . "-" . $this->current_day . "-" . $this->current_year;
			system($syscmd, $return_status);
			if (!$return_status)
				print "\n\nThe system date and time synchronized to Atomic clock \n\n";
			else
				print "\n\nError: The system command failed. \nYour command was $syscmd \n\n";
		}
		else
		if ($this->_which_system == "unix")
		{
			$this->_get_accurate_time(0, false);
			if ($this->current_time = "")
				return;
			$syscmd = "date +'%A, %B %e, %Y %T'  -s '" . $this->current_date . " ";
			$this->_get_accurate_time(0, true); // repeat command to get more accurate time
			$syscmd .= $this->current_time . "'";
			system($syscmd, $return_status);
			if (!$return_status)
				print "\n\nThe system date and time synchronized to Atomic clock \n\n";
			else
				print "\n\nError: The system command failed. \nYour command was $syscmd \n\n";
		}
		//print "\n\nsyscmd is : $syscmd \n";
	}
}

function AtomicTime()  // constructor
{
	//$this->_time_url[0] = "http://nist.time.gov/timezone.cgi?Central/d/-6";
	$this->_time_url[0] = "http://132.163.4.213/timezone.cgi?Central/d/-6";
	//$this->_time_url[1] = " http://www.atomictime.net/time_tel.html?4";
	//$this->_time_url[2] = "http://www.worldtimeserver.com/time.asp?locationid=US-TX";
	$this->_max_urls = count($this->_time_url);
	$this->_find_which_OS();

	$this->_open_timeurl();
}

function _find_which_OS() // private function only for internal use
{
	// Find the underlying operating system

	// Problem is - php_uname works only for PHP version greater than 4.0
	//if (substr(php_uname(), 0, 7) == "Windows") // system is MS Windows

	if (file_exists("c:\winnt\system32\doskey.exe"))  // MS Windows 2000 or NT system
		$this->_which_system = "windows";
	else
	if (file_exists("c:\windows\command\Doskey.com"))  // MS Windows 95/98/ME
		$this->_which_system = "windows";
	else
	if (file_exists("/usr/ls"))  // unix system
		$this->_which_system = "unix";
	else
		$this->_which_system = "unix";
	//print "\n\nwhich_system is : $this->_which_system ";
}

function _open_timeurl()  // private function only for internal use
{
	for ($tmsource = 0; $tmsource < $this->_max_urls; $tmsource++)
	{
		for ($counter = 0; $counter < 4; $counter++)  // make 3 attempts
		{
			$this->_get_accurate_time($tmsource, false);
			if ($this->current_time != "") 
				break;
		}
		if (trim($this->_page_contents) != '')
			break;
	}
}

function _get_accurate_time($tmsource, $time_only)  // private function only for internal use
{
	// This function is called after verifying that nist site is working

	//print "\n<br>the parameter passed to _get_accurate_time() is : $tmsource";

	$this->_time_page[$tmsource] = $this->_time_url[$tmsource];
	$handle = fopen($this->_time_page[$tmsource],  "r"); 
	if ($handle) 
	{
		$this->_page_contents = fread($handle, 2000); // fread is faster than file() ??
		//fclose($handle);  // commented to speed-up and increase time accuracy
		//$this->_page_contents = join( '', file($this->_time_page[$tmsource]));

		if ($wx_start = strpos($this->_page_contents, "Right now, the official U.S. time is:" ))
		{
			// Find content
			$wx_content = substr($this->_page_contents, $wx_start + 193, 100 ); // trial prints 193, 100

			// Find current time
			$this->current_time = substr($wx_content, 0, 8); // get 0,8 by trial prints  

			if ($time_only)
				return; // return immdly for greater accuracy

			// Find current date
			$this->current_date = substr($wx_content, 65);
			$wx_end = strpos($this->current_date, '<');  // see also strrpos()
			$this->current_date = substr($this->current_date, 0, $wx_end);

			//print "\n\n<br>the wx_content is : $wx_content";
			//print "\n\n<br>the this->current_time is : $this->current_time";
			//print "\n\n<br>the this->current_date is : $this->current_date";
			//print "\n\n<br>";
		}
	}
}

function month_to_numbers()  // public function - converts month "January" to numbe
{
	$month = strtoupper(trim($this->current_month));

	if ($month == "JANUARY")
		$this->current_month = 1;
	else
	if ($month == "FEBRAURY")
		$this->current_month = 2;
	else
	if ($month == "MARCH")
		$this->current_month = 3;
	else
	if ($month == "APRIL")
		$this->current_month = 4;
	else
	if ($month == "MAY")
		$this->current_month = 5;
	else
	if ($month == "JUNE")
		$this->current_month = 6;
	else
	if ($month == "JULY")
		$this->current_month = 7;
	else
	if ($month == "AUGUST")
		$this->current_month = 8;
	else
	if ($month == "SEPTEMBER")
		$this->current_month = 9;
	else
	if ($month == "OCTOBER")
		$this->current_month = 10;
	else
	if ($month == "NOVEMBER")
		$this->current_month = 11;
	else
	if ($month == "DECEMBER")
		$this->current_month = 12;
}

function month_to_string()  // public function - converts month number to string "January"
{
	$month = intval($this->current_month);

	switch ($month)
	{
		case 1:
			$month = "JANUARY";
			break;
		case 2:
			$month = "FEBRAURY";
			break;
		case 3:
			$month = "MARCH";
			break;
		case 4:
			$month = "APRIL";
			break;
		case 5:
			$month = "MAY";
			break;
		case 6:
			$month = "JUNE";
			break;
		case 7:
			$month = "JULY";
			break;
		case 8:
			$month = "AUGUST";
			break;
		case 9:
			$month = "SEPTEMBER";
			break;
		case 10:
			$month = "OCTOBER";
			break;
		case 11:
			$month = "NOVEMBER";
			break;
		case 12:
			$month = "DECEMBER";
			break;
		default:
			$month = "NO_MATCH!!";
			break;
	}
	//$this->current_month = $month;
	$this->current_month = strtolower($month);  // if you want all lowercase
}

}

?>
