<?php

/*

class anagram
-------------
This example shows a faster filtering from
all anagrams, but implementation is a bit
more difficult.

Besides initials, this faster performance
can also perform anagrams forced by terminals:
in this case, the user should also add bonds
for any letter as in the code below,
where we are filtering all anagrams beginning
with 'BI' and ending with 'IT'.

*/

require_once( 'anagram.php' );

$anagrams = new anagram();

$anagrams->insert_word( "biscuit" );

// insert the base-1 index of the letter
$anagrams->add_bond( 1 ); // letter B
$anagrams->add_bond( 2 ); // letter I
$anagrams->add_bond( 0 ); // 0 means that any letter can be set here
$anagrams->add_bond( 0 ); // 0 means that any letter can be set here
$anagrams->add_bond( 0 ); // 0 means that any letter can be set here
$anagrams->add_bond( 6 ); // letter I
$anagrams->add_bond( 7 ); // letter T

$anagrams->set_save_file( true ) ;
$anagrams->set_save_file_name( "ex4.html" ) ;
$anagrams->go();

?>
