<?php

/**
* Class for show time in page load
*
* @author Bruce Torres <bruce.torres@gmail.com>
*/

	Class cronometro{

		/* time:  Is the total time page loading*/		
		var $time 		= 0;
		
		/* time1: Is the time at init page loading */		
		var $time1 		= 0;
		
		/* time2: Is the time at finish page loading */		
		var $time2 		= 0;
		
		/* text: Text to display */		
		var $text		= 'This page as load in : %s seconds';
		
		/* decimal: Decimal length the time */		
		var $decimal 	= 5;
				
		/**
		* @return cronometro
		* @desc Constructor
		*/
		function cronometro(){
			$this->start();	
		}	
		
		/**
		* @return void
		* @desc Init the counter
		*/
		function start(){			
			$this->time1 = $this->getTime();
		}	
		
		/**
		* @return void
		* @desc Stop the counter
		*/
		function stop(){
			$this->time2 = $this->getTime();
		}
		
		/**
		* @return String
		* @desc Show the time the load page
		*/
		function show(){
			$this->stop();
			$time = $this->time2 - $this->time1;
			$this->time = number_format($time, $this->decimal, '.', '');			
			echo  sprintf($this->text,$this->time);
		}		
				
		/**
		* @return timestamp 
		* @desc Get a timestamp formatted
		*/
		function getTime(){
			$mtime = microtime();
			$mtime = explode(" ",$mtime); 
			$mtime = $mtime[1] + $mtime[0]; 			
			return $mtime;
		}			
		
		/**
		* @return void
		* @param String $text
		* @desc Configure the message to display
		*/
		function setMsg($text){
			if (strlen($text)>0){
				$this->text = $text;	
			}
		}	
		
		/**
		* @return void
		* @param int $decimal
		* @desc Configure the len the result
		*/
		function setDec($decimal){
			if ($decimal > 0 && $decimal < 15){
				$this->decimal = $decimal;	
			}
		}	

	}	
	
?>


