<?php
/**
 * Configuration tool examples
 * @package ConfigTool
 */
// Set notices off from error reporting if you want to use simpliest
// and straight way to get configuration variable names.
error_reporting( E_ALL ^ E_NOTICE );
// In development environment you should have:
// error_reporting( E_ALL );
/**
* include class and make object for the advanced example
*/
include( "../ConfigTool.php" );
$conf = new ConfigTool();
// to get configuration information from the text file
// any relative path can be used BUT absolute path must be used
// if you want to make changes and save new configuration files!
// absolute path is made by custom getPath() function.
$conf->setConfigFromFile( getPath() . "example_config_file.txt" );
// set indent vallue. this is the number of characters between
// start of key name and start of value
$conf->setIndent( 15 );
/************************************************************
**                         PART ONE
************************************************************/
// show hello variables
echo "CONFIG CONTENTS (example_config_file.txt): <br />";
echo "<br />hello1 = " . $conf->get( 'hello1' );
echo "<br />hello2 = " . $conf->get( 'hello2' );
echo "<br />hello3 = " . $conf->get( 'hello3' );
// edit name value pair
$conf->updateKeyValue( "hello1", "Greetings!!!" );
// delete name value pair
$conf->deleteKey( "hello2" );
// add new name value pair
$conf->addKeyValue( "hello3", "'Greetings from Norway!'" );
/************************************************************
**                         PART TWO
************************************************************/
// show again hello variables
echo "<br /><br />CONFIG CONTENTS AFTER EDIT, IN MEMORY ONLY: <br />";
echo "<br />hello1 = " . $conf->get( 'hello1' );
echo "<br />hello2 = " . $conf->get( 'hello2' );
echo "<br />hello3 = " . $conf->get( 'hello3' );
// save modified object to another file
$conf->setFileName( getPath() . "my_conf.txt" );
$conf->saveToFile();
/************************************************************
**                         PART THREE
************************************************************/
// make new object and get new configuration from file
// we want to see, if above modified object was really saved...
$conf2 = new ConfigTool();
$conf2->setConfigFromFile( getPath() . "my_conf.txt" );
// show hello variables
echo "<br /><br />NEW CONFIG CONTENTS FROM FILE: <br />";
echo "<br />hello1 = " . $conf2->get( 'hello1' );
echo "<br />hello2 = " . $conf2->get( 'hello2' );
echo "<br />hello3 = " . $conf2->get( 'hello3' );
/************************************************************
**                   GETPATH FUNCTION
************************************************************/
/**
 * Additional function to get current script absolute path
 * @access public
 * @return string path
 */
function getPath()
{
	$path = pathinfo( $_SERVER['PHP_SELF'] );
	$path = substr( $_SERVER['DOCUMENT_ROOT'], 0, -1 ) . $path['dirname'] . "/";
	return $path;
}
/************************************************************
**            END OF ADVANCED EXAMPLE SCRIPT
************************************************************/
?>