<?php
/*
 * vim:ts=2:sts=2:foldmethod=marker:foldmarker={{{,}}}
 *
 * Martin Tournoij <carpetsmoker@rwxrwxrwx.net>
 *
 * Mailview is licensed under a Creative Commons Attribution 3.0 Unported 
 * License: http://creativecommons.org/licenses/by/3.0/
 */

$start = microtime(True);

/* Template stuff */
function HtmlTemplate($page=NULL, $exit=True, $overload=False) /* Template engine. {{{ */
{
	global $maillink;

	$r_uri = $_SERVER['REQUEST_URI'];
	$er_uri = htmlentities($r_uri);

	if (isset($page))
		$_GET['page'] = $page;

	if (!file(TEMPLATE . "/{$_GET['page']}.htm"))
		$_GET['page'] = 'login';

	if(function_exists('Get_'.$_GET['page']))
	{
		$f = 'Get_' . $_GET['page'];
		$extravars = $f();
		
		if (!empty($extravars))
		{
			foreach ($extravars as $name => $value)
				$$name = $value;
		}
	}

	if ($maillink)
	{
		$l = mview_List($maillink, '{'.$_SESSION['server'] . ':' . $_SESSION['port'].'}', '*');
		$height = (count($l) * 1.4) + 10;
	}

	$page = file_get_contents(TEMPLATE . "/{$_GET['page']}.htm");

	/* This will allow us to include other templates which will also be parsed. */
	if (!$overload)
	{
		preg_match_all('|<include page=\"[\w]*\.htm\" \/>|', $page, $match);
		foreach ($match['0'] as $m)
		{
			preg_match('|[\w]*\.htm|', $m, $p);
			$inc = HtmlTemplate(str_replace('.htm', '', $p['0']), False, True);
			$page = str_replace('<include page="'.$p['0'].'" />', $inc, $page);
		}
	}
	
	ob_start();
	eval("?> $page");
	$page = ob_get_contents();
	ob_clean();

	if ($exit)
	{
		if (DEBUG)
		{
			$end = microtime(True);
			$GLOBALS['debug']['exectime'] = $end - $start;
			$GLOBALS['debug']['imap_alerts'] = imap_alerts();
			$GLOBALS['debug']['imap_errors'] = imap_errors();
		}
		mview_Exit($page);
	}

	return $page;
} /*}}}*/
function Get_login()                             /* Login form {{{ */
{
	$var = array('val'=>'', 'pop3'=>'', 'imap'=>'', 'ssl'=>'', 'tls'=>'', 'none'=>'',
		'pass'=>'', 'use_file'=>'', 'flat'=>'', 'thread'=>'', 'week'=>'', 'month'=>'',
		'month3'=>'', 'month6'=>'', 'year'=>'');

	if (!isset($_SERVER['HTTPS']) && !SECUREONLY && !ENCPASSWORD)
		$var['https'] = 'Warning!<br />You are using a non-secure HTTP connection!';
	elseif (!isset($_SERVER['HTTPS']))
		trigger_error('You must use a secure (https) connection', E_USER_ERROR);

	if (PROTO == 'pop3')
		$var['pop3'] = ' checked="checked"';
	elseif(PROTO == 'imap')
		$var['imap'] = ' checked="checked"';
	else
		trigger_error('PROTO is set to something I can\'t understand', E_USER_WARNING);

	if (CONN == 'none' && !SECUREONLY)
		$var['none'] = ' checked="checked"';
	elseif (CONN == 'none' && SECUREONLY)
		trigger_error('SECUREONLY is set to True, but CONN is set to none', E_USER_NOTICE);
	elseif (CONN == 'tls')
		$var['tls'] = ' checked="checked"';
	elseif (CONN == 'ssl')
		$var['ssl'] = ' checked="checked"';
	else
		trigger_error('CONN is set to something I can\'t understand', E_USER_WARNING);

	if (VAL)
		$var['val'] = ' checked="checked"';

	if (USE_FILE)
		$var['use_file'] = ' checked="checked"';

	if (VIEWMODE == 'flat')
		$var['flat'] = ' selected="selected"';
	else
		$var['threads'] = ' selected="selected"';

	if (SAVE == 604800)
		$var['week'] = ' selected="selected"';
	elseif (SAVE == 2592000)
		$var['month'] = ' selected="selected"';
	elseif (SAVE == 5184000)
		$var['month3'] = ' selected="selected"';
	elseif (SAVE == 15552000)
		$var['month6'] = ' selected="selected"';
	elseif (SAVE == 31104000)
		$var['year'] = ' selected="selected"';
	elseif (SAVE == 0)
		$var['false'] = ' selected="selected"';
	else
		trigger_error('SAVE is set to something I can\'t understand', E_USER_WARNING);

	/* Don't show password to user */
	if (PASS)
		$pass = '********';

	/* XXX CHARSET and TZ */

/*XXX	if (!in_array(CHARSET, mb_list_encodings()))
	trigger_error('CHARSET is set to something I can\'t understand', E_USER_WARNING);
 */

	return $var;
} /*}}}*/
function Get_menu()                              /* The menu {{{ */
{
	global $maillink;

	$list = mview_List($maillink, '{'.$_SESSION['server'] . ':' . $_SESSION['port'].'}', '*');
	sort($list);

	$i = 0;
	foreach ($list as $key => $folder)
	{
		mview_Reopen($maillink, $folder, $GLOBALS['options']);

		$m = mview_NumMsg($maillink);
		$r = mview_NumRecent($maillink);

		if (empty($r))
			$r = 0;

		$folder = str_replace('{'.$_SESSION['server'] . ':' . $_SESSION['port'] .'}', '', $folder);

		if (!empty($_SESSION['separator']))
		{
			$n = explode($_SESSION['separator'], $folder);
			$c = count($n) - 1;
			$pf = $c - 1;
			$pname = '';
			$nk = $key + 1;
			$nextfolder = str_replace("{{$_SESSION['server']}:{$_SESSION['port']}}", '', $list["$nk"]);
			$last = False;
			if (stristr($nextfolder, $n["$pf"]))
				$last= True;
			foreach ($n as $k => $v)
			{
				if ($k == 0)
					continue;
				if ($last)
				{
					$pname .= '&nbsp;&nbsp;&nbsp;';
				}
				else
				{
					$pname .= '&nbsp;&nbsp;&nbsp;';
				}
			}

			$pname = $pname . $n["$c"];
		}
		else
		{
			if (!$_SESSION['use_file'])
				$folder = str_replace('{'.$_SESSION['server'] . ':' . $_SESSION['port'] .'}', '', $folder);
			else
				$folder = basename($folder);
			$pname = $folder;
		}

		$menu['folders']["$i"]['name'] = $folder;
		$menu['folders']["$i"]['pname'] = $pname;
		$menu['folders']["$i"]['num_msg'] = $m;
		$menu['folders']["$i"]['num_recent'] = $r;
		$i++;
	}

	return $menu;
} /*}}}*/
function Get_mail_list()                         /* Get list of all emails in $_GET['folder'] {{{ */
{
	global $maillink;
	$i = 0; $j=-1;

	$m = mview_NumMsg($maillink);

	/* Mailbox is empty */
	if ($m == 0)
		return array('empty' => True);

	if (!isset($_GET['pagenr']))
		$_GET['pagenr'] = 0;

	/* Threaded view */
	if ($_SESSION['viewmode'] == 'threads')
	{
		$msglist2 = $all_thread = $all_tree = array();
		$thr = mview_Thread($maillink);

		include('threads.php');
		$threads = new IMAP_Thread($thr);
		
		$msglist = $threads->messageList(False);

		foreach ($msglist as $m)
		{
			$g = $threads->getThreadBase($m);
			if (empty($g))
				$g = $m;

			if (in_array($g, $msglist2))
				continue;
			$msglist2[] = $g;
			$thread = $threads->getThread($g);
			$tree = $threads->getThreadImageTree($thread, False);

			$thread[] = $j;
			$tree[] = '';
			$j--;
			$all_thread = array_merge($all_thread, $thread);
			$all_tree = array_merge($all_tree, $tree);
		}
		$all = array_combine($all_thread, $all_tree);

		$i = 0;
		foreach ($all as $msgno => $indent)
		{
			if ($msgno <= -1)
			{
				$newthread = True;
				continue;
			}

			$mailarr = mview_FetchOverview($maillink, "$msgno:$msgno");
			$mailh = $mailarr['0'];
			//$mailh = mview_HeaderInfo($maillink, $msgno);

			if ($newthread === True || !isset($newthread))
			{
				$subject = htmlentities(substr(iconv_mime_decode($mailh->subject), 0, 60),
					ENT_COMPAT, CHARSET);
				if (empty($subject))
					$subject = '&nbsp;'; /* Grmpf */
				$newthread = False;
			}
			else
				$subject = '&nbsp;';

			$date = date('d-m-Y H:i', strtotime($mailh->date));
	
			$from = substr(preg_replace('/<.*>|"/', '', iconv_mime_decode($mailh->from)), 0, 19);
			$from = htmlentities(trim($from), ENT_COMPAT, CHARSET);

			$flags = '';
			if ($mailh->flagged)
				$flags .= '!';
			if ($mailh->answered)
				$flags .= 'r';
			if ($mailh->deleted)
				$flags .= 'D';
			if (!$mailh->seen)
			{
				$flags .= 'N';
				$r['maillist']["$i"]['new'] = True;
			}
			else
				$r['maillist']["$i"]['new'] = False;
			

			$r['maillist']["$i"]['subject'] = $indent . $subject;
			$r['maillist']["$i"]['msgno'] = $msgno;
			$r['maillist']["$i"]['from'] = $from;
			$r['maillist']["$i"]['date'] = $date;
			$r['maillist']["$i"]['flags'] = $flags;
			$i++;
		}
	}
	/* Flat view */
	elseif($_SESSION['viewmode'] == 'flat')
	{
		$mailarr_all = mview_FetchOverview($maillink, "1:$m"); /*XXX slow!*/
		$mailarr_chunks = array_chunk($mailarr_all, PAGESIZE, True);
		$mailarr = $mailarr_chunks["{$_GET['pagenr']}"];
		$r['maillist']['numberofpages'] = count($mailarr_chunks);

		foreach ($mailarr as $mailh)
		{
			$subject = htmlentities(iconv_mime_decode($mailh->subject), ENT_COMPAT, CHARSET);
			if (empty($subject))
				$subject = '&nbsp;';

			$date = date('d-m-Y H:i', strtotime($mailh->date));
	
			$from = preg_replace('/<.*>|"/', '', iconv_mime_decode($mailh->from));
			$from = htmlentities(trim($from), ENT_COMPAT, CHARSET);

			/* Flags from mutt:
			Implemented:
			D   message is deleted (is marked for deletion) 
			!   message is flagged 
			N   message is new 
			r   message has been replied to 

			not implemented
			d   message have attachments marked for deletion 
			K   contains a PGP public key 
		  O   message is old 
			P   message is PGP encrypted 
			S   message is signed, and the signature is successfully verified 
			s   message is signed 
			*   message is tagged

			Furthermore, the following flags reflect who the message is addressed 
			to. They can be customized with the $to_chars variable. 
			+   message is to you and you only 
			T   message is to you, but also to or cc'ed to others 
			C   message is cc'ed to you 
			F   message is from you 
			L   message is sent to a subscribed mailing list
			*/

			$flags = '';
			if ($mailh->flagged)
				$flags .= '!';
			if ($mailh->answered)
				$flags .= 'r';
			if ($mailh->deleted)
				$flags .= 'D';
			if (!$mailh->seen)
			{
				$flags .= 'N';
				$r['maillist']["$i"]['new'] = True;
			}
			else
				$r['maillist']["$i"]['new'] = False;

			$r['maillist']["$i"]['subject'] = $subject . $padding;
			$r['maillist']["$i"]['msgno'] = $mailh->msgno;
			$r['maillist']["$i"]['from'] = $from;
			$r['maillist']["$i"]['date'] = $date;
			$r['maillist']["$i"]['flags'] = $flags;
			$i++;
		}
	}
	return $r;
} /*}}}*/
function Get_mail_menu()                         /* Show some options for mail(pager) view {{{ */
{
	/*XXX*/
	$menu['previous'] = $_GET['msgno'] - 1;
	$menu['next'] = $_GET['msgno'] + 1;

	return $menu;
} /*}}}*/
function Get_mail_header()                       /* email header {{{ */
{
	global $maillink;

	$h = imap_rfc822_parse_headers(mview_FetchHeader($maillink, $_GET['msgno']));

	$vars['subject'] = htmlentities(iconv_mime_decode($h->subject), ENT_COMPAT, CHARSET);
	$vars['from'] = htmlentities(iconv_mime_decode($h->fromaddress), ENT_COMPAT, CHARSET);
	$vars['to'] = htmlentities(iconv_mime_decode($h->toaddress), ENT_COMPAT, CHARSET);
	$vars['date'] = $h->date;
	$vars['cc'] = htmlentities(iconv_mime_decode($h->ccaddress), ENT_COMPAT, CHARSET);

	return $vars;
} /*}}}*/
function Get_mail_body()                         /* email body {{{ */
{
	global $maillink;

	$struct = mview_FetchStructure($maillink, $_GET['msgno']);

	if ($struct->type == 1) /* multipart */
		$parts = MailParts($struct);
	else
	{
		$parts = array('1' => $struct);
		$parts['1']->partno = 1;
	}

	$i = 0;
	foreach ($parts as $p)
	{
		if ($p->type == 0 || $p->type == 2) /* text */
		{
			if ($p->disposition == 'attachment' || strtolower($p->subtype) != 'plain' )
				$att = True;
		}
		elseif ($p->type == 1) /* mutltipart, should never occur here */
			echo 'MULTIPART!';
//		elseif ($p->type == 2) /* message */
//		{ }
		elseif ($p->type == 3) /* application */
			$att = True;
		elseif ($p->type == 4) /* audio */
			$att = True;
		elseif ($p->type == 5) /* image */
			$att = True;
		elseif ($p->type == 6) /* video */
			$att = True;
		elseif ($p->type == 7) /* other */
			$att = True;

		if ($att)
		{
			$mime = Mime($p);
			$return['attachments']["$i"]['view'] = $mime['1'];
			$mime = $mime['0'] .'/'. strtolower($p->subtype);
			$name = SearchParameter($p, 'filename');
			if (empty($name))
				$name = SearchParameter($p, 'name');
			if (empty($name))
				$name = "Untitled-$p->partno";

			$return['attachments']["$i"]['partno'] = $p->partno;
			$return['attachments']["$i"]['name'] = $name;
			$return['attachments']["$i"]['mime'] = $mime;
			$return['attachments']["$i"]['size'] = round($p->bytes / 1024, 1) . 'Kb';
			$return['attachments']["$i"]['encoding'] = $p->encoding;
			$att = False;
			$i++;
		}
		else
			$return['body'] .= MailText($p);
	}

	return $return;
} /*}}}*/

function Init()                                  /* Define constants, check for required extensions {{{ */
{
	error_reporting(0);
	set_error_handler("Error");

	define('VERSION', '1.2');

	if (is_file('configuration.php') || is_link('configuration.php'))
		include('configuration.php');

	if (!defined('TITLE'))				{ define('TITLE', 'mailview ' . VERSION); }
	if (!defined('USER'))					{ define('USER', ''); }
	if (!defined('PASS'))					{ define('PASS', ''); }
	if (!defined('SERVER'))				{ define('SERVER', 'localhost'); }
	if (!defined('PORT'))					{ define('PORT', '993'); }
	if (!defined('PROTO'))				{ define('PROTO', 'imap'); }
	if (!defined('CONN'))					{ define('CONN', 'ssl'); }
	if (!defined('VAL'))					{ define('VAL', False); }
	if (!defined('FILENAME'))			{ define('FILENAME', ''); }
	if (!defined('USE_FILE'))			{ define('USE_FILE', False); }
	if (!defined('CHARSET'))			{ define('CHARSET', 'UTF-8'); }
	if (!defined('SECUREONLY'))		{ define('SECUREONLY', False); }
	if (!defined('ENCPASSWORD'))	{ define('ENCPASSWORD', False); }
	if (!defined('SAVE'))					{ define('SAVE', False); }
	if (!defined('NOMENU'))				{ define('NOMENU', False); }
	if (!defined('AUTOLOGIN'))		{ define('AUTOLOGIN', False); }
	if (!defined('TEMPLATE'))			{ define('TEMPLATE', 'templates/default'); }
	if (!defined('VIEWMODE'))			{ define('VIEWMODE', 'threads'); }
	if (!defined('SEPARATOR'))    { define('SEPARATOR', '.'); }
	if (!defined('DEBUG'))        { define('DEBUG', False); }
	if (!defined('TZ'))           { define('TZ', 0); }
	if (!defined('LANG'))         { define('LANG', 'en_EN'); }
	if (!defined('PAGESIZE'))     { define('PAGESIZE', 200); }

	if (!extension_loaded('pcre'))			{ trigger_error(_('pcre extension not loaded, bye!'), E_USER_ERROR); }
	if (!extension_loaded('session'))		{ trigger_error(_('session extension not loaded, bye!'), E_USER_ERROR); }
	if (!extension_loaded('imap'))			{ trigger_error(_('imap extension not loaded, bye!'), E_USER_ERROR); }
	if (!extension_loaded('iconv'))			{ trigger_error(_('iconv extension not loaded, bye!'), E_USER_ERROR); }

	/* Default template uses short tags */
	if (!ini_get('short_open_tag') && !ini_set('short_open_tags', True))
		trigger_error(_('short_open_tags is not enabled, and I can\'t seem to enable it.'), E_USER_ERROR);

	ini_set('include_path', TEMPLATE .':'. ini_get('include_path'));
	ini_set('date.timezone', TZ);
	
	iconv_set_encoding('output_encoding', CHARSET);
	iconv_set_encoding('internal_encoding', CHARSET);
	
	/* gettext: TODO
	textdomain('mailview');
	bindtextdomain('mailview', realpath('./locale/'));
	bind_textdomain_codeset('mailview', LANG);
	*/

	if (!isset($_GET['folder']))
		$_GET['folder'] = 'INBOX';
	if (!isset($_GET['page']))
		$_GET['page'] = 'mail_list';

	session_start();
} /*}}}*/
function Login()                                 /* Log the user in, set $_SESSION vars {{{ */
{
	/* XXX validate values the user gives us */

	if ($_POST['save'] && !AUTOLOGIN)
		$expire = time() + $_POST['save'];
	else
		$expire = 0;

	setcookie('PHPSESSID', session_id(), $expire);

	if (AUTOLOGIN)
	{
		$_SESSION['user'] = USER; $_SESSION['pass'] = PASS;
		$_SESSION['server'] = SERVER; $_SESSION['port'] = PORT; $_SESSION['proto'] = PROTO;
		$_SESSION['conn'] = CONN; $_SESSION['SEPARATOR'] = SEPARATOR;
		$_SESSION['val'] = VAL;	$_SESSION['charset'] = CHARSET;
		$_SESSION['viewmode'] = VIEWMODE;
		$_SESSION['use_file'] = USE_FILE; $_SESSION['filename'] = FILENAME;
		return;
	}

	if (PASS)
		$_SESSION['pass'] = PASS;
	else
		$_SESSION['pass'] = $_POST['pass'];

	$_SESSION['user'] = $_POST['user'];
	$_SESSION['server'] = $_POST['server']; $_SESSION['port'] = $_POST['port'];
	$_SESSION['proto'] = $_POST['proto']; $_SESSION['conn'] = $_POST['conn'];
	$_SESSION['val'] = $_POST['val']; $_SESSION['charset'] = $_POST['charset'];
	$_SESSION['separator'] = $_POST['separator']; $_SESSION['viewmode'] = $_POST['viewmode'];
	$_SESSION['use_file'] = $_POST['use_file']; $_SESSION['filename'] = $_POST['filename'];

} /*}}}*/
function Logout()                                /* Log the user out {{{ */
{
	if (AUTOLOGIN)
		return;
	session_destroy();
	HtmlTemplate('logout');
} /*}}}*/
function ImapConnect()                           /* Connect to the mailserver {{{ */
{
	/* XXX pop3 does not work for now ...
	if ($_SESSION['proto'] == 'pop3')
	{
		$GLOBALS['flags'] = '/service=pop3';
	}
	else
	{ */
		$GLOBALS['options'] += OP_READONLY; /* OP_READONLY only works with imap */
		$GLOBALS['flags'] = '/service=imap/readonly';
	//}

	if ($_SESSION['conn'] == 'ssl')
		$GLOBALS['flags'] .= '/ssl';
	elseif ($_SESSION['conn'] == 'tls')
		$GLOBALS['flags'] .= '/tls';
	else
		$GLOBALS['flags'] .= '/notls';

	if (!$_SESSION['val'])
		$GLOBALS['flags'] .= '/novalidate-cert';

	if (DEBUG)
	{
		$GLOBALS['options'] += OP_DEBUG;
		$GLOBALS['flags'] .= '/debug';
	}

	$maillink = mview_Open('{'. $_SESSION['server'] . ':' . $_SESSION['port'] . $GLOBALS['flags'] .'}',
		$_SESSION['user'], $_SESSION['pass'], $GLOBALS['options']);

	return $maillink;
} /*}}}*/
function MailParts($struct)                      /* Returns array of MIME parts {{{ */
{
	global $maillink;

	$i = 1;	/* Start at 1 because part number 0 is the header */
	foreach ($struct->parts as $p)
	{
		if ($p->type == 1)	/* multipart */
		{
			$tmp = MailParts($p);
			$s = 1;
			foreach ($tmp as $a)
			{
				$a->partno = "$i.$s";
				$return["$i.$s"] = $a;
				$s++;
			}
			$i++;
		}
		else
		{
			$p->partno = $i;
			$return["$i"] = $p;
			$i++;
		}
	}

	return $return;

} /*}}}*/
function MailDecode($string, $encoding)          /* Decode mail transfer encodings {{{ */
{
	if ($encoding == 0) /* 7-bit */
		$r = $string;
	elseif ($encoding == 1) /* 8-bit */
		$r = $string;
	elseif ($encoding == 2) /* binary */
		$r = $string;
	elseif ($encoding == 3) /* base64 */
		$r = imap_base64($string);
	elseif ($encoding == 4) /* quoted-printable */
		$r = quoted_printable_decode($string);
	elseif ($encoding == 5) /* other */
		$r = $string;

	return $r;
} /*}}}*/
function MailText($part)                         /* Make text readable and ready for echoing {{{ */
{
	global $maillink;

	$body = MailDecode(mview_FetchBody($maillink, $_GET['msgno'], $part->partno, FT_PEEK), $part->encoding);

	/* Strip any HTML crap, some emails give mime text/plain, but use HTML 
	 * markup anyway :-( */
	$body = strip_tags($body, '<a>');	/* XXX use a (more advanced) regexp */

	/* Colorize quoted stuff (i.e. lines starting with > character) */
	$body = explode("\n", $body);
	foreach ($body as $l)
	{
		if ($l[0] == '>' && !$span_open)
		{
			$newbody .= '<span class="quote">'.htmlentities("$l\n", ENT_COMPAT, CHARSET);
			$span_open = True;
		}
		elseif ($l[0] != '>' && $span_open)
		{
			$newbody .= '</span>'.htmlentities("$l\n", ENT_COMPAT, CHARSET);
			$span_open = False;
		}
		else
		{
			$newbody .= htmlspecialchars("$l\n", ENT_COMPAT, CHARSET);
			//$newbody .= htmlentities("$l\n", ENT_COMPAT, CHARSET);
			//$newbody .= "$l\n";
		}
	}
	$body = $newbody;
	//var_dump($newbody);

	/* Smell links and put <a> tags around it.
	 * I copied this from  "http://www.php.net/manual/en/function.strip-tags.php" 
	 * Posted by "lucky760 at yahoo dot com" 
	 * XXX links without protocol (ie no 'http://', like 'www.foobar.com') are not smelled.
	 * XXX Smell e-mail addresses */
  $body = preg_replace('!(^|([^\'"]\s*))' . '([hf][tps]{2,4}:\/\/[^\s<>"\'()]{4,})!mi', '$2<a href="$3">$3</a>', $body);
  $body = preg_replace('!<a href="([^"]+)[\.:,\]]">!', '<a href="$1">', $body);
	$body = preg_replace('!([\.:,\]])</a>!', '</a>$1', $body);

	/* Detect email addresses */
	$body = preg_replace('! \b[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b !mi', '<a href="mailto:$0">$0</a>', $body);

	/* Add Line breaks */
	$body = preg_replace("/\r?\n/", ('<br />') . "\r\n", $body);
	$body = preg_replace("/\r\n(\t| )+/", ' ', $body);

	/* Character sets */
	if ($charset = SearchParameter($part, 'charset'))
	{
		/* Complain when iconv doesn't support the character set (unlikely) or when 
		 * the specified character set is inavlid (More likely). */
		$return = iconv($charset, CHARSET, $body);
		if (!$return)
		{
			$return = $body . Warning(_('This email is using an invalid or unsupported charset, and may be displayed incorrectly.<br />
				The charset this email specified is:<br />') . $charset);
		}
	}

	return $return;
} /*}}}*/
function SearchParameter($struct, $name)         /* Search for specific parameter as returned by imap_fetchstructure() and return the value (if any) {{{ */
{
	if ($struct->ifparameters)
	{
		foreach ($struct->parameters as $p)
		{
			if ($p->attribute == $name)
				return $p->value;
		}
	}

	if ($struct->ifdparameters)
	{
		foreach ($struct->dparameters as $p)
		{
			if ($p->attribute == $name)
				return $p->value;
		}
	}
	
	return False;
} /*}}}*/
function Warning($string)                        /* Show inline warning message (ie unsupported charset) {{{ */
{
	$warning = '<br />=======================================================<br />';
	$warning .= _('<strong>Warning:</strong><br />') . $string;
	$warning .= '<br />=======================================================<br />';
	return $warning;
} /*}}}*/
function Mime($p)                                /* Convert mime numbers as used by imap_* to proper mime text {{{*/
{
	if ($p->type == 0) /* text */
	{
		$mime['0'] = 'text';
		$mime['1'] = True;
	}
	elseif ($p->type == 1) /* mutltipart */
	{
		$mime['0'] = 'multipart';
		$mime['1'] = True;
	}
	elseif ($p->type == 2) /* message */
	{
		$mime['0'] = 'message';
		$mime['1'] = True;
	}
	elseif ($p->type == 3) /* application */
	{
		$mime['0'] = 'application';
		$mime['1'] = False;
	}
	elseif ($p->type == 4) /* audio */
	{
		$mime['0'] = 'audio';
		$mime['1'] = False;
	}
	elseif ($p->type == 5) /* image */
	{
		$mime['0'] = 'image';
		$mime['1'] = True;
	}
	elseif ($p->type == 6) /* video */
	{
		$mime['0'] = 'video';
		$mime['1'] = False;
	}
	elseif ($p->type == 7) /* other */
	{
		$mime['0'] = 'other';
		$mime['1'] = False;
	}

	return $mime;
} /*}}}*/ 
function OpenFile($filename = '')                /* Open mbox file from filesystem {{{ */
{
/*	if (!is_readable($_SESSION['filename']))
	{
		echo 'Can\'t open file: '. $_SESSION['filename'];
		exit(1);
	}*/

	//$filename = $_SESSION['filename'];
	$_SESSION['separator'] = '';
	$filename = '/data/www/fbsd/2008/freebsd-ports/20080106.freebsd-ports.gz';
	
	if (stristr($filename, '.gz'))
		$fp = gzopen($filename, 'r');
	else
		$fp = fopen($filename, 'r');

	$arr = array('filename' => $filename, 'fp' => $fp);
	$i = 0; $inbody = False;
	while ($line = fgets($fp, 4096))
	{
		//echo $line;
		if (strncmp($line, 'From ', 5) == 0)
		{
			$inbody = False;
			$arr["$i"]['start'] = ftell($fp) - strlen($line);
		}
		elseif ($line == "\n" && !$inbody)
		{
			$inbody = True;
			$arr["$i"]['headl'] = ftell($fp) - $arr["$i"]['start'];
			$i++;

			$a = True;
		}
	}

	return $arr;
} /*}}}*/
function Error($errno, $errstr, $errfile, $errline, $errcontext)  /* Error handler {{{ */
{
	global $maillink;

	$GLOBALS['debug'] = array('misc' => array(), 'notice' => array(), 'warning' => array(), 'error' => array());

	if ($errno == E_NOTICE || $errno == E_USER_NOTICE)
	{
		//return;
		$GLOBALS['debug']['notice'][] .= "$errstr ($errno) in <strong>$errfile</strong> on line <strong>$errline</strong>";
	}
	elseif ($errno ==	E_WARNING || $errno == E_USER_WARNING || $errno == E_CORE_WARNING || $errno == E_COMPILE_WARNING)
		$GLOBALS['debug']['warning'][] .= "$errstr ($errno) in <strong>$errfile</strong> on line <strong>$errline</strong>";
	elseif ($errno ==	E_ERROR || $errno == E_USER_ERROR || $errno ==  E_CORE_ERROR || $errno == E_COMPILE_ERROR)
	{
		$GLOBALS['debug']['error'][] .= "$errstr ($errno) in <strong>$errfile</strong> on line <strong>$errline</strong>";
		session_destroy();
		echo '<pre>';
		print_r($GLOBALS['debug']);
		echo '</pre>';
		mview_Exit();
	}
	else
		$GLOBALS['debug']['misc'][] .= "$errstr ($errno) in <strong>$errfile</strong> on line <strong>$errline</strong>";
} /*}}}*/

/* These are wrappers around php's imap_* functions, and should behave (almost)
 * the same. */
function mview_Open($mailbox, $user=NULL, $pass=NULL, $options=NULL) /*{{{*/
{
	if ($_SESSION['use_file'])
	{
	}
	else
	{
		$maillink = imap_open($mailbox, $user, $pass, $options);
		if (!$maillink)
		{
			$args = "mailbox: $mailbox, user: $user, pass: $pass, options: $options";
			trigger_error(_('Unable to connect to mailserver ' . imap_last_error() . $args), E_USER_ERROR);
		}
		return $maillink;
	}

} /*}}}*/
function mview_Reopen($maillink, $mailbox, $options=NULL, $retry=NULL) /*{{{*/
{
	if ($_SESSION['use_file'])
	{
		return True;
	}
	else
	{
		if (!imap_reopen($maillink, $mailbox, $options, $retry))
		{
			$args = "$maillink, $mailbox, $options, $retry";
			trigger_error(_('Unable to connect to mailserver ' . imap_last_error() . $args), E_USER_ERROR);
		}
		return;
	}

} /*}}}*/
function mview_FetchBody($maillink, $msgno, $part, $options=NULL) /*{{{*/
{
	if ($_SESSION['use_file'])
	{
	}
	else
	{
		return imap_fetchbody($maillink, $msgno, $part, $options);
	}
} /*}}}*/
function mview_FetchHeader($maillink, $msgno, $options=NULL) /*{{{*/
{
	if ($_SESSION['use_file'])
	{
		fseek($maillink['fp'], $maillink["$msgno"]['start']);
		return fread($maillink['fp'], $maillink["$msgno"]['headl']);
	}
	else
	{
		return imap_fetchheader($maillink, $msgno, $options);
	}

} /*}}}*/
function mview_Body($maillink, $msgno, $options=NULL) /*{{{*/
{
	if ($_SESSION['use_file'])
	{
	}
	else
	{
		return imap_body($maillink, $msgno, $options);
	}

} /*}}}*/
function mview_NumMsg($maillink) /*{{{*/
{
	if ($_SESSION['use_file'])
	{
		return count($maillink) - 2;
	}
	else
	{
		return imap_num_msg($maillink);
	}

} /*}}}*/
function mview_List($maillink, $ref, $pattern) /*{{{*/
{
	if ($_SESSION['use_file'])
	{
		return array($maillink['filename']);
	}
	else
	{
		$a = imap_list($maillink, $ref, $pattern);
		return imap_list($maillink, $ref, $pattern);
	}

} /*}}}*/
function mview_NumRecent($maillink) /*{{{*/
{
	if ($_SESSION['use_file'])
	{
		return 0;
	}
	else
	{
		return imap_num_recent($maillink);
	}

} /*}}}*/
function mview_FetchOverview($maillink, $seq, $options=NULL) /*{{{*/
{
	if ($_SESSION['use_file'])
	{
		$overview = array();
		foreach ($maillink as $n => $o)
		{
			if (!is_array($o))
				continue;

			$overview[] = mview_HeaderInfo($maillink, $n);
		}
		return $overview;
	}
	else
	{
		$overview = imap_fetch_overview($maillink, $seq, $options);
		return $overview;
	}

} /*}}}*/
function mview_Thread($maillink, $options=NULL) /*{{{*/
{
	if ($_SESSION['use_file'])
	{
	}
	else
	{
		return imap_thread($maillink, $options);
	}

} /*}}}*/
function mview_FetchStructure($maillink, $msgno, $options=NULL) /*{{{*/
{
	if ($_SESSION['use_file'])
	{
	}
	else
	{
		return imap_fetchstructure($maillink, $msgno, $options);
	}

} /*}}}*/
function mview_HeaderInfo($maillink, $msgno, $froml=NULL, $subjectl=NULL, $host=NULL) /*{{{*/
{
	if ($_SESSION['use_file'])
	{
		$h = mview_FetchHeader($maillink, $msgno);
		$h = explode("\n", $h);
		foreach ($h as $l)
		{
			if (strstr($l, ': '))
			{
				$l = explode(':', $l);
				$k = trim($l['0']);
				$header["$k"] = trim($l['1']);
			}
			else
				$header["$k"] .= $l;
		}

		$headerinfo['toaddress'] = $header['To'];
		$headerinfo['fromaddress'] = $header['From'];
		$headerinfo['ccaddress'] = $header['Cc'];
		$headerinfo['date'] = $header['Date'];
		$headerinfo['subject'] = $header['Subject'];

		//print_r($headerinfo);
		return $headerinfo;
	}
	else
	{
		return imap_headerinfo($maillink, $msgno, $froml, $subjectl, $host);
	}

} /*}}}*/
function mview_Exit($output = NULL) /*{{{*/
{
	global $maillink;

	if ($_SESSION['use_file'])
	{
	}
	else
		imap_close($maillink);

	exit($output);
} /*}}}*/

Init();

/* Login/Logout a user */
if (!isset($_POST['LOGIN']) && !isset($_SESSION['user']) && !AUTOLOGIN) /* Not logged in */
	HtmlTemplate('login');
elseif (AUTOLOGIN) /* Use Autologin */
	Login();
elseif (!isset($_SESSION['user'])) /* User filled in form and we try to login */
	Login();
elseif (isset($_GET['logout'])) /* Bye! */
	Logout();

/* Get handle to server or file */
if ($_SESSION['use_file'])
	$maillink = OpenFile();
else
{
	$maillink = ImapConnect();
	//if (!stristr('pop3', $GLOBALS['flags']))
	mview_Reopen($maillink, '{'. $_SESSION['server'] . ':' . $_SESSION['port'] . '}'.$_GET['folder'], $GLOBALS['options']);

}

/* Display attachment */
if (isset($_GET['attachment']))
{
	header("Content-Type: {$_GET['mime']}");
	if (isset($_GET['view']))
		header('filename="'.$_GET['name'].'"');
	else
		header('Content-Disposition: attachment; filename="'.$_GET['name'].'"');
	$att = mview_FetchBody($maillink, $_GET['msgno'], $_GET['attachment']);
	mview_Exit(MailDecode($att, $_GET['tenc']));
}

if (!empty($_GET['rawmessage']))
{
	header('Content-Type: text/plain');
	mview_Exit(mview_FetchHeader($maillink, $_GET['msgno']) . mview_Body($maillink, $_GET['msgno']));
}

if (isset($_POST['changeoption']))
	$_SESSION["{$_POST['changeoption']}"] = $_POST["{$_POST['changeoption']}"];

$page = HtmlTemplate($_GET['page']);

?>
