<?php
//************************************************************************//
// Script: TweetStream                                                    //
//                                                                        //
// Author: Hudson.Atwell@gmail.com ::: Email me if you have any questions //
//                                                                        //
// DETAILS: This script monitors a keyword based twitter feed and      //
// produces semi-live updates for your website                            //
// go to twitter.com and search out your keyword, grab the rss and plug in//
// below                                                                  //
//************************************************************************//

//declare url location of blog (include trailing slash)
$blog_url ="http://www.yourdomain.com/blog/";

//declare the keyword(s) you would like to focus on
$channel= "treetstream";

//display settings
$display = 1; //options: 1 = Avatars only , 2 = Names only, 3 = names & avatars

//enter in number of tweets to display(limit is 14)
$tweet_count= 10;

//--------- Open Source Code Below editing not neccecary--------------------//

//prepare channel for feed insertion
$channel = str_replace(" ","+",$channel);

//length of tweet to show
$description_length = 200;

//delcare twitter feeds
$feed[0] = "http://search.twitter.com/search.atom?q=$channel";

//prepare social bookmarks
$stitle= "#apple- TweetStream";
$surl = selfURL();
$surl = str_replace("tweetstream.php","",$surl);
function selfURL() { $s = empty($_SERVER["HTTPS"]) ? '' : ($_SERVER["HTTPS"] == "on") ? "s" : ""; $protocol = strleft(strtolower($_SERVER["SERVER_PROTOCOL"]), "/").$s; $port = ($_SERVER["SERVER_PORT"] == "80") ? "" : (":".$_SERVER["SERVER_PORT"]); return $protocol."://".$_SERVER['SERVER_NAME'].$port.$_SERVER['REQUEST_URI']; } function strleft($s1, $s2) { return substr($s1, 0, strpos($s1, $s2)); }
$stitle = str_replace("#","%23",$stitle);
//clean out and prepare datastore.
$count = count($feed);

//prepare arrays that will hold the stream data
for ($j=0;$j<count($feed);$j++)
{
        $url = $feed[$j];
		$string =file_get_contents($url);

		$open = fopen("temp.txt", "w");
		fwrite($open, $string);
		fclose($open);

		$open = fopen("temp.txt", "r");
		$string = fread($open, filesize("temp.txt"));
		fclose($open);

			
			if (strstr($string, "<entry>"))
			{
			  $entry_start = "<?xml";
			  $entry_end ="<entry>";
		    }

			
		//scoop-out feed header information
			$open = fopen("temp.txt", "w");									
		    $start = $entry_start;
		    $end =  $entry_end;
			$remove = get_string_between($string, $start, $end);
			$string = str_replace ($remove, "" , $string);
			fwrite($open, $string);
			fclose($open);
		
		//determine what the title opener looks like		  
			if (strstr($string, "<name>"))
			{
			 $title_start =  "<name>";
			 $title_end =  "</name>";
			}


		//determine what the description opener looks like
			if (strstr($string, '<content type="html">'))
			{
			 $description_start = '<content type="html">';
			 $description_end =  '</content>';
			}
			

		//determine what the link opener looks like
			if (strstr($string, "<uri>"))
			{
			 $link_start = "<uri>";
			 $link_end = "</uri>";
			}
		
		//determine what the avator image opener looks like
			if (strstr($string, "<uri>"))
			{
			 $avatar_start = '<link type="image/png" rel="image" href="';
			 $avatar_end = "/>";
			}

		//count the # of articles in feed
		    
			$count = substr_count($string, $title_start);
			//echo $count;exit;

		//*****************get rss items**********************************************//
			
			$names = array();
			$tweets = array();
			$links = array();
			$avatars = array();
			$imagestypes = array();
			for ($i=0;$i<$count;$i++)
			{		
				$open = fopen("temp.txt", "w");	
				//pull the title from rss
					$start = $title_start;		
					$end = $title_end;
					$title = get_string_between($string, $start, $end);
					$remove = "$start$title$end";
					$string = str_replace_once ($remove, "" , $string);
					
					//celan the part of the name that is in parenthesis
					$meat = get_string_between($title, "(", ")");
					$sandwich = "($meat)";
					$title = str_replace ($sandwich, "" , $title);
					
				//pull the description from rss
					if (strstr($string, $description_start))
					{
					   $start = $description_start;
					   $end = $description_end;					   
					   $description = get_string_between($string, $start, $end);			   
					   $remove = "$start$description$end";
					   $string = str_replace_once ($remove, "" , $string);

						
					}
					
			    //pull the link from rss
				$start = $link_start;
				$end = $link_end;
				$link = get_string_between($string, $start, $end); 
				$remove = "$start$link$end";
				$string = str_replace_once ($remove, "" , $string);	

				
				
				//pull the avatar from rss
				$start = $avatar_start;				
				$end = $avatar_end;
				$avatar = get_string_between($string, $start, $end); 
				$remove = "$start$avatar$end";
				$string = str_replace_once ($remove, "" , $string);	
				$avatar = str_replace(' ', '', $avatar);

				//find out image type
				if (strstr($avatar, 'png')||strstr($avatar, 'PNG'))
				{
				 $imagetype='png';
				}
				if (strstr($avatar, 'gif')||strstr($avatar, 'GIF'))
				{
				 $imagetype='gif';
				}
				if (strstr($avatar, 'jpg')||strstr($avatar, 'JPG')||strstr($avatar, 'jpeg')||strstr($avatar, 'JPEG'))
				{
				 $imagetype='jpg';
				}
				
				$title = htmlspecialchars($title, ENT_QUOTES);
                
				//remove html from description if there
				$description = htmlspecialchars_decode($description);
				$search = array('/<\?((?!\?>).)*\?>/s');
				$description = strip_tags(preg_replace($search, '', $description));
				$description = htmlspecialchars($description, ENT_QUOTES);
				$description = str_replace('&quot;', '"',$description);
				$description = str_replace('&amp;', '&',$description);
				
				//final edits to the title
				$title = str_replace('', '-',$title);
				
						
				//truncate the description to predefined size
				$description = substr($description, 0, $description_length);
				
				//turn urls in description into links
				$description = makelink($description);
				
				//insert tweets item into array
				$names[] = $title;
				$tweets[] = $description;
				$links[] = $link;
				$avatars[]= $avatar;
				$imagetypes[] = $imagetype;
				}
				fwrite($open, $string);
				fclose($open);
			}
			
			//---------------DISPLAY AREA EDITS HERE------------
			?>
			<html>
			<head>

			</head>

			<div width="<?=$width?>" height="<?=$height?>">
			<?php
			echo "<table class='tweetlink' cellspacing=0>";		
			for ($i=0;$i<$tweet_count;$i++)
			{
			   echo "<tr>";
			   echo "<td valign=top align=left style='padding:2px;'>";
			   if ($display==1)
			   {
			       echo "<a rel=nofollow href='$links[$i]' class=\"tweetstream_name\"><b><small><img src='".$blog_url."avatar.php?src=$avatars[$i]&imagetype=$imagetypes[$i]' border=0 width=48 height=48></b></small></a></td>";
			   }
			   if ($display==2)
			   {
				   echo "<a rel=nofollow href='$links[$i]' class=\"tweetstream_name\"><b><small>$names[$i]</b></small></a></td>";
			   }
			   if ($display==3)
			   {
			      echo "<a rel=nofollow href='$links[$i]' class=\"tweetstream_name\"><center><b><small><img src='".$blog_url."blog/avatar.php?src=$avatars[$i]&imagetype=$imagetypes[$i]' border=0 width=48 height=48></b></small></a></center>";
			      echo "<a rel=nofollow href='$links[$i]' class=\"tweetstream_name\"><center><b><small>$names[$i]</b></small></center></a></td>";
			   }
			   echo "<td class=\"tweetstream_description\" > <small>$tweets[$i] </small></td>";
			   echo "</tr>";
			   
			}
			echo "<tr><td align=middle colspan=2><br><br><br>";
			?>
			
			<?php
			echo "</td></tr>";
			echo "</table>";
			?>
			
			</div>
			<?php
           //******************************************//



//function to only remove a sought out string once
function str_replace_once($remove , $replace , $string)
{
	// Looks for the first occurence of $needle in $haystack
	// and replaces it with $replace.
	$pos = strpos($string, $remove);
	if ($pos === false) 
	{
	// Nothing found
	return $haystack;
	}
	return substr_replace($string, $replace, $pos, strlen($remove));
}  

//function to get the string between things
function get_string_between($string, $start, $end){
   $string = " ".$string;
     $ini = strpos($string,$start);
     if ($ini == 0) return "";
     $ini += strlen($start);   
     $len = strpos($string,$end,$ini) - $ini;
     return substr($string,$ini,$len);
}

//funtion to make links out of the urls in tweets
function makeLink($string){

/*** make sure there is an http:// on all URLs ***/
$string = preg_replace("/([^\w\/])(www\.[a-z0-9\-]+\.[a-z0-9\-]+)/i", "$1http://$2",$string);
/*** make all URLs links ***/
$string = preg_replace("/([\w]+:\/\/[\w-?&;#~=\.\/\@]+[\w\/])/i","<a target=\"_blank\" rel= \"nofollow\" href=\"$1\">$1</A>",$string);
/*** make all emails hot links ***/
$string = preg_replace("/([\w-?&;#~=\.\/]+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,3}|[0-9]{1,3})(\]?))/i","<A HREF=\"mailto:$1\">$1</A>",$string);

return $string;
}


?>