<?php

/******************************************************************************
*
*    VisualTextbox V1.1b - Online HTML Editor
*    Copyright (C) 2003  Nicolas Robert-Dehault 
*	 					 visualtextbox@free.fr
*						 http://visualtextbox.free.fr/
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
******************************************************************************/

/**
* Return the path to an image relative to VisualTextbox directory.
* Language to use should be defined as VISUALTEXTBOX_LANG constant.
*/
function getImagePath($filename) {
	
	$lang = preg_match("/[a-z]{2}/", VISUALTEXTBOX_LANG) ? VISUALTEXTBOX_LANG : VISUALTEXTBOX_DEFAULT_LANG;

	if ($filename=="")
		return FALSE;
	else if (is_file(dirname(__FILE__)."/../language/$lang/$filename"))
		return "language/$lang/$filename";
	else
		return "language/common/$filename";
}
	
/**
* Return the message with given name and attributes according to current language.
* Language to use should be defined as VISUALTEXTBOX_LANG constant.
*/
function getMessage($msg_name, $attr = NULL) {
	
	$lang = preg_match("/[a-z]{2}/", VISUALTEXTBOX_LANG) ? VISUALTEXTBOX_LANG : VISUALTEXTBOX_DEFAULT_LANG;
	
	if ($msg_name=="") {
		return "Message to display not specified";
	} else if (!is_file(dirname(__FILE__)."/../language/$lang/msg.php")) {
		return "Message file not found for language $lang";
	} else {
		require dirname(__FILE__)."/../language/$lang/msg.php";
		if (!array_key_exists($msg_name, $msg)) {
			return "Undefined message: $msg_name";
		} else {
			$_msg = $msg[$msg_name];
			// writes attributes in message string
			if ($attr!=NULL && is_array($attr)) {
				for ($i=0; $i<sizeOf($attr); $i++) {
				$_msg = str_replace("{".($i+1)."}", $attr[$i], $_msg);
				}
			} else if ($attr!=NULL) {
				$_msg = str_replace("{1}", $attr, $_msg);
			}
			return $_msg;
		}
	}
}

/**
* Return the charset according to current language.
* Language to use should be defined as VISUALTEXTBOX_LANG constant.
*/
function getCharset() {
	
	$lang = preg_match("/[a-z]{2}/", VISUALTEXTBOX_LANG) ? VISUALTEXTBOX_LANG : VISUALTEXTBOX_DEFAULT_LANG;
	
	if (!is_file(dirname(__FILE__)."/../language/$lang/msg.php")) {
		return VISUALTEXTBOX_DEFAULT_CHARSET;
	} else {
		require dirname(__FILE__)."/../language/$lang/msg.php";
		return ($charset=="") ? VISUALTEXTBOX_DEFAULT_CHARSET : $charset;
	}
}

/**
* Writes a message to log file
*/
function writeLog($msg) {
	if (!is_dir(dirname(__FILE__)."/../log")) {
		mkdir(dirname(__FILE__)."/../log", 0777);
	}
	$fp = fopen(dirname(__FILE__)."/../log/VisualTextbox.log", "a");
	fwrite($fp, $msg."\n");
	fclose($fp);
}

?>