<?

/******************************************************************************
*
*    VisualTextbox V1.1b - Online HTML Editor
*    Copyright (C) 2003  Nicolas Robert-Dehault 
*	 					 visualtextbox@free.fr
*						 http://visualtextbox.free.fr/
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
******************************************************************************/

/**
*
*	Thanks to Karl Seguin (http://www.openmymind.net) for the color picker algorithm
*
*/
	// setup color picker
	$colorCellSize = 8;
	$y0 = 18;
	$x0 = 4;

	$colors = array();
	$y1 = $y0+2;

	// calculates colors	
	for ($j=$y1; $j>2; $j--) {
	    for ($m = 0; $m < 6; $m++) {
	        for ($i = 0; $i < $x0; $i++) {
	            switch ($m) {
		            case 0: $r = floor(0x7f * $j/$y1) + 0x80;	$b = floor(0x80 - ($r - 0x7f));		$g = floor((($r - $b) * $i/$x0) + $b);				break;
		            case 1: $g = floor(0x7f * $j/$y1) + 0x80;	$b = floor(0x80 - ($g - 0x7f));		$r = floor(($g - $b) - (($g - $b) * $i/$x0) + $b);	break;
		            case 2: $g = floor(0x7f * $j/$y1) + 0x80;	$r = floor(0x80 - ($g - 0x7f));		$b = floor((($g - $r) * $i/$x0) + $r);				break;
		            case 3: $b = floor(0x7f * $j/$y1) + 0x80;	$r = floor(0x80 - ($b - 0x7f));		$g = floor(($b - $r) - (($b - $r) * $i/$x0) + $r);	break;
		            case 4: $b = floor(0x7f * $j/$y1) + 0x80;	$g = floor(0x80 - ($b - 0x7f));		$r = floor((($b - $g) * $i/$x0) + $g);				break;
		            case 5: $r = floor(0x7f * $j/$y1) + 0x80;	$g = floor(0x80 - ($r - 0x7f));		$b = floor(($r - $g) - (($r - $g) * $i/$x0) + $g);	break;
	            }
	            $r = dechex($r);					$g = dechex($g);					$b = dechex($b);
	            if (strlen($r) < 2) $r = "0$r";		if (strlen($g) < 2) $g = "0$g";		if (strlen($b) < 2) $b = "0$b";
				array_push($colors, "$r$g$b");
	        }
	    }
	}	
	
	$colors = join("", $colors);
?>

<style>
<!--
	.dialog { background-color:#CCCCCC; position: absolute; }
	.dialogText { font-family: verdana; font-size: 10px; color: #000000; }
	.dialogFormElt { font-family: verdana; font-size: 10px }
	.colorCell { font-size: 1px; height: <?= $colorCellSize ?>px; width: <?= $colorCellSize ?>px; cursor: hand; }
	.spaceColorCell { font-size: 1px; height: <?= $colorCellSize ?>px; width: <?= $colorCellSize ?>px; }
-->
</style>

<span id="visualTextboxDialog" class="dialog" unselectable="on" style="top: 0px; left: 0px; display: none">
	<table border="0" cellspacing="0" unselectable="on" style="border: 1px ridge #CCCCCC; font-family: verdana; font-size: 10px; width: 1%">
		<tr style="background-color:#808080; color: #FFFFFF; cursor: move" unselectable="on">
			<td unselectable="on" onmousedown="moveFloatingWindow('visualTextboxDialog', true)">
				<img src="<?= $path ?>/<?= getImagePath("handledialog.gif") ?>" 
				 	 unselectable="on" vspace="1"
				>
			</td>
			<td unselectable="on" nowrap style="font-size: 11px; font-weight: bold; width: 100%" valign="top" onmousedown="moveFloatingWindow('visualTextboxDialog', true)">
				&nbsp;<span id="visualTextboxDialogTitle"></span>&nbsp;
			</td>
			<td unselectable="on">
				<img src="<?= $path ?>/<?= getImagePath("closedialog.gif") ?>" 
				 	 unselectable="on"
					 style="cursor: hand"
					 onmousedown="hideFloatingWindow('visualTextboxDialog')"
				>
			</td>
		</tr>
		
		<tr unselectable="on">
			<td unselectable="on" colspan="3">

			<?
				/*********************************************************************
				*	
				*	InsertTable
				*
				*********************************************************************/
			?>
				<div id="InsertTable">
		
					<table class="dialogText" align="center">
						<tr><td colspan="2"></td></tr>
						<tr>
							<td align="right" nowrap>
								<?= getMessage("Dialog_Table_NoRows") ?>
							</td>
							<td>
								<input type="text" id="table_rows" style="font-family: verdana" class="dialogFormElt" size="5" value="2">
							</td>
						</tr>
						<tr>
							<td align="right" nowrap>
								<?= getMessage("Dialog_Table_NoCols") ?>
							</td>
							<td>
								<input type="text" id="table_cols" style="font-family: verdana" class="dialogFormElt" size="5" value="2">
							</td>
						</tr>
						<tr>
							<td align="right" nowrap>
								<?= getMessage("Dialog_Table_Align") ?>
							</td>
							<td>
								<select id="table_align" style="font-family: verdana" class="dialogFormElt">
									<option value=""><?= getMessage("Dialog_Table_AlignDefault") ?></option>
									<option value="left"><?= getMessage("Dialog_Table_AlignLeft") ?></option>
									<option value="center"><?= getMessage("Dialog_Table_AlignCenter") ?></option>
									<option value="right"><?= getMessage("Dialog_Table_AlignRight") ?></option>
								</select>
							</td>
						</tr>
						<tr>
							<td align="right" nowrap>
								<?= getMessage("Dialog_Table_Border") ?>
							</td>
							<td>
								<input type="text" id="table_border" style="font-family: verdana" class="dialogFormElt" size="5" value="0">
							</td>
						</tr>
						<tr>
							<td align="right" nowrap>
								<?= getMessage("Dialog_Table_Cellspacing") ?>
							</td>
							<td>
								<input type="text" id="table_cellspacing" style="font-family: verdana" class="dialogFormElt" size="5" value="1">
							</td>
						</tr>
						<tr>
							<td align="right" nowrap>
								<?= getMessage("Dialog_Table_Cellpadding") ?>
							</td>
							<td>
								<input type="text" id="table_cellpadding" style="font-family: verdana" class="dialogFormElt" size="5" value="1">
							</td>
						</tr>
						<tr><td colspan="2"></td></tr>
						<tr>
							<td colspan="2" align="center">
								<input type="button" value="    Ok    " onclick="doAction()" style="font-family: verdana" class="dialogFormElt">
							</td>
						</tr>
						<tr><td colspan="2"></td></tr>
	
					</table>

				</div>
		
			<?
				/*********************************************************************
				*	
				*	EditTable
				*
				*********************************************************************/
			?>
				<div id="EditTable">
		
					<table class="dialogText" align="center">
						<tr><td colspan="2"></td></tr>
						<tr>
							<td align="right" nowrap>
								<?= getMessage("Dialog_Table_Align") ?>
							</td>
							<td>
								<select id="new_table_align" style="font-family: verdana" class="dialogFormElt">
									<option value=""><?= getMessage("Dialog_Table_AlignDefault") ?></option>
									<option value="left"><?= getMessage("Dialog_Table_AlignLeft") ?></option>
									<option value="center"><?= getMessage("Dialog_Table_AlignCenter") ?></option>
									<option value="right"><?= getMessage("Dialog_Table_AlignRight") ?></option>
								</select>
							</td>
						</tr>
						<tr>
							<td align="right" nowrap>
								<?= getMessage("Dialog_Table_Border") ?>
							</td>
							<td>
								<input type="text" id="new_table_border" style="font-family: verdana" class="dialogFormElt" size="5" value="0">
							</td>
						</tr>
						<tr>
							<td align="right" nowrap>
								<?= getMessage("Dialog_Table_Cellspacing") ?>
							</td>
							<td>
								<input type="text" id="new_table_cellspacing" style="font-family: verdana" class="dialogFormElt" size="5" value="1">
							</td>
						</tr>
						<tr>
							<td align="right" nowrap>
								<?= getMessage("Dialog_Table_Cellpadding") ?>
							</td>
							<td>
								<input type="text" id="new_table_cellpadding" style="font-family: verdana" class="dialogFormElt" size="5" value="1">
							</td>
						</tr>
						<tr><td colspan="2"></td></tr>
						<tr>
							<td colspan="2" align="center">
								<input type="button" value="    Ok    " onclick="doAction()" style="font-family: verdana" class="dialogFormElt">
							</td>
						</tr>
						<tr><td colspan="2"></td></tr>
	
					</table>

				</div>

			<?
				/*********************************************************************
				*	
				*	CreateLink
				*
				*********************************************************************/
			?>
				<div id="CreateLink">
		
					<table class="dialogText" align="center">
						<tr><td colspan="2"></td></tr>
						<tr>
							<td align="right" nowrap>
								<?= getMessage("Dialog_Link_URL") ?>
							</td>
							<td>
								<input type="text" id="createlink_address" style="font-family: verdana" class="dialogFormElt" size="45" value="http://">
							</td>
						</tr>
						<tr>
							<td align="right" nowrap>
								<?= getMessage("Dialog_Link_Target") ?>
							</td>
							<td>
								<table cellspacing="0" cellpadding="0"><tr><td>
								<select id="createlink_target" style="font-family: verdana" class="dialogFormElt"
									onchange="this.form.createlink_customtarget.style.display = this.value=='custom' ? 'block' : 'none'; if (this.value=='custom') this.form.createlink_customtarget.focus();">
									<option value="_blank"><?= getMessage("Dialog_Link_Target_NewWindow") ?></option>
									<option value="_self"><?= getMessage("Dialog_Link_Target_Self") ?></option>
									<option value="custom"><?= getMessage("Dialog_Link_Target_Custom") ?></option>
								</select>
								</td><td>
								<input type="text" id="createlink_customtarget" style="font-family: verdana; display: none" class="dialogFormElt" size="20">
								</td></tr></table>
							</td>
						</tr>
						<tr><td colspan="2"></td></tr>
						<tr>
							<td colspan="2" align="center">
								<input type="button" value="    Ok    " onclick="doAction()" style="font-family: verdana" class="dialogFormElt">
							</td>
						</tr>
						<tr><td colspan="2"></td></tr>
	
					</table>

				</div>

			<?
				/*********************************************************************
				*	
				*	EditCell
				*
				*********************************************************************/
			?>
				<div id="EditCell">
		
					<table class="dialogText" align="center">
						<tr><td colspan="2"></td></tr>
						<tr>
							<td align="right" nowrap>
								<?= getMessage("Dialog_Cell_AlignHorizontal") ?>
							</td>
							<td>
								<select id="new_cell_align" style="font-family: verdana" class="dialogFormElt">
									<option value=""><?= getMessage("Dialog_Cell_AlignHorizontalDefault") ?></option>
									<option value="left"><?= getMessage("Dialog_Cell_AlignHorizontalLeft") ?></option>
									<option value="center"><?= getMessage("Dialog_Cell_AlignHorizontalCenter") ?></option>
									<option value="right"><?= getMessage("Dialog_Cell_AlignHorizontalRight") ?></option>
								</select>
							</td>
						</tr>
						<tr>
							<td align="right" nowrap>
								<?= getMessage("Dialog_Cell_AlignVertical") ?>
							</td>
							<td>
								<select id="new_cell_valign" style="font-family: verdana" class="dialogFormElt">
									<option value=""><?= getMessage("Dialog_Cell_AlignVerticalDefault") ?></option>
									<option value="top"><?= getMessage("Dialog_Cell_AlignVerticalTop") ?></option>
									<option value="mniddle"><?= getMessage("Dialog_Cell_AlignVerticalMiddle") ?></option>
									<option value="bottom"><?= getMessage("Dialog_Cell_AlignVerticalBottom") ?></option>
								</select>
							</td>
						</tr>
						<tr>
							<td align="right" nowrap>
								<?= getMessage("Dialog_Cell_Width") ?>
							</td>
							<td nowrap>
								<input type="text" id="new_cell_width" style="font-family: verdana" class="dialogFormElt" size="5">
								<select id="new_cell_width_unit" style="font-family: verdana" class="dialogFormElt">
									<option value="px">pixels</option>
									<option value="%">%</option>
								</select>
							</td>
						</tr>
						<tr><td colspan="2"></td></tr>
						<tr>
							<td colspan="2" align="center">
								<input type="button" value="    Ok    " onclick="doAction()" style="font-family: verdana" class="dialogFormElt">
							</td>
						</tr>
						<tr><td colspan="2"></td></tr>
	
					</table>

				</div>

			<?  
				/***********************************************************************
				*	
				*	ColorPicker
				*
				***********************************************************************/
			?>
				<div id="ColorPicker">

					<table cellpadding="6" cellspacing="0" align="center"><tr unselectable="on"><td unselectable="on">
					<table cellpadding="0" cellspacing="0" id="colorTable" width="<?= ($x0*6+2)*$colorCellSize ?>">
					
					<script type="text/javascript">
						var x = <?= $x0 ?>;
						var y = <?= $y0 ?>;
						
						var colors = '<?= $colors ?>';
						var color_nb = 0;
						
						for (j=0; j<y; j++) {
							document.writeln('<tr unselectable="on">');
							for (i=0; i<(x*6); i++) {
								document.writeln('<td unselectable="on" bgcolor="'+nextColor()+'" class="colorCell" onclick="colorCellClick(this)" onmousemove="colorCellClick(this)"></td>');
							}	
							document.writeln('<td unselectable="on" class="spaceColorCell"></td>'); 
							document.writeln('<td unselectable="on" class="colorCell" onclick="colorCellClick(this, false)" onmousemove="colorCellClick(this, false)"></td>'); 
							document.writeln('</tr>');
						}
						
						document.writeln('<tr unselectable="on"><td unselectable="on" class="spaceColorCell"></td></tr>');
						
						for (i=0; i<x*6; i++) {
							b = Math.floor(i*255/(x*6-1)).toString(16);
							document.writeln('<td unselectable="on" bgcolor="'+b+b+b+'" class="colorCell" onclick="colorCellClick(this, false)" onmousemove="colorCellClick(this, false)"></td>'); 
						}	
					</script>
					
					</tr></table>
					</td></tr></table>
					
					<table align="center">
						<tr unselectable="on">
							<td unselectable="on">
								<span id="colorSample" style="height: 16px; width: 16px; border: 1px solid #000000; font-size: 1px"></span></td>
							<td unselectable="on">
								<input type="text" id="selectedColor" size="10" style="font-family: verdana" class="dialogFormElt" 
									   maxlength="7" style="font-family: verdana" class="dialogFormElt"
						   			   onkeyup="if (this.value.toLowerCase()!=colorSample.style.backgroundColor.toLowerCase()) { re = new RegExp('^#[0-9a-f]{6}$', 'i'); if (this.value.match(re)) selectColor(this.value); }">
								<input type="button" value="<?= getMessage("Dialog_ColorPicker_Select") ?>" onclick="doAction()"
						   			   style="font-family: verdana" class="dialogFormElt"></td>
						</tr>
					</table>

					<script>
						updateGradient('#0000ff');
						selectColor('#0000ff');					
					</script>
					
				</div>
				
			</td>
		</tr>
		
	</table>
</span>
