<?php

/******************************************************************************
*
*    VisualTextbox V1.1b - Online HTML Editor
*    Copyright (C) 2003  Nicolas Robert-Dehault 
*	 					 visualtextbox@free.fr
*						 http://visualtextbox.free.fr/
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
******************************************************************************/

	define("VISUALTEXTBOX_LANG", $_REQUEST['lang']);
	
	require_once dirname(__FILE__)."/config.inc.php";
	require_once dirname(__FILE__)."/utils.inc.php";

	function genButton($action, $two_state = FALSE) { ?>

		<? if ($two_state) { ?>
		<script> twoStateButton.push('<?= $action ?>'); </script>
		<? } ?>
	
	    <td unselectable="on" align="center"><img id="<?= $action ?>"
	    	     ondragstart="return false" 
	    		 alt="<?= getMessage("Description_$action") ?>"	
	    		 src="../<?= getImagePath(strtolower($action).".gif") ?>"
	    		 class="actionButton" 
	    		 onclick="mouseClickButton(this); performAction('<?= $action ?>');"	
	    		 onmouseover="mouseOverButton(this);" 
	    		 onmouseout="mouseOutButton(this);"	
	    		 onmousedown="mouseDownButton(this);" 
	    ></td>
	
	<? }

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=<?= getCharset() ?>">
	<meta http-equiv="Content-Style-Type" content="text/css">
	<title>VisualTextbox</title>
	<link rel="stylesheet" type="text/css" href="../css/controlPanel.css" />
	<script type="text/javascript" src="../js/controlPanel.js.php?lang=<?= VISUALTEXTBOX_LANG ?>"></script>
	<script type="text/javascript" src="../js/tableManager.js"></script>
	<script type="text/javascript">
	<!--
		function onLoad() {
			window.resizeTo(<?= VISUALTEXTBOX_CONTROL_PANEL_WIDTH ?>,<?= VISUALTEXTBOX_CONTROL_PANEL_HEIGHT ?>);
			if (parent&&parent.addHandle) {
				parent.addHandle(document.getElementById('movePanel'), window);
			}
			parent.saveVisualTextboxPanelState();
		}
	-->
	</script>
</head>

<body onload="onLoad()" oncontextmenu="return false" onscroll="return false">

<table style="background-color:#CCCCCC; border: 1px ridge #CCCCCC; padding: 0px; margin: 0px; spacing: 0px; width: 100%; height: <?= VISUALTEXTBOX_CONTROL_PANEL_HEIGHT ?>px"
	   summary="control panel table" cellpadding="0" cellspacing="0">
<tr unselectable="on"><td unselectable="on" valign="top">

<div id="movePanel" onclick="document.selection.clear()">
<table cellpadding="0" cellspacing="0" style="width: 100%; font-size: 1px; background-color:#848484">
	<tr unselectable="on">
		<td style="width: 100%; padding-left: 18px; background-image: url('../<?= getImagePath("handlepanel.gif") ?>'); background-repeat: no-repeat" unselectable="on">
			<span class="title"><?= getMessage("ControlPanel_Title") ?></span>
		</td>
		<td>
			<!-- DIV used as buffer during paste, please do not remove -->
			<div id="ClipboardBuffer" style="word-wrap: break-word; overflow: auto; height: 0px; width: 0px" contenteditable="true"></div>
		</td>
		<td unselectable="on">
			<img id="closePanel" 
				 src="../<?= getImagePath("closepanel.gif") ?>" 
				 onmousedown="window.focus(); parent.hideControlPanel()"
				 style="cursor: hand" ondragstart="return false" alt="Fermer">
		</td>
	</tr>
</table>
</div>

<table cellspacing="0" cellpadding="0"  style="width: 100%; border: 2px solid #CCCCCC; border-bottom-width: 1px" border="0">
  <tr unselectable="on" height="26">
    <td unselectable="on" style="font-size: 8px">&nbsp;</td>
    <td unselectable="on" width="1%"><select id="FontName" class="formElt" style="width: 160" onchange="performAction('FontName', this.value)">
    		<option value="Arial">Arial</option>
    		<option value="Courier New">Courier New</option>
    		<option value="Georgia">Georgia</option>
    		<option value="Impact">Impact</option>
    		<option value="Tahoma">Tahoma</option>
    		<option value="Times New Roman" selected>Times New Roman</option>
    		<option value="Verdana">Verdana</option>
    		<option value="Wingdings">Wingdings</option>
    	</select></td>
    <td unselectable="on" style="font-size: 8px">&nbsp;</td>
    <td unselectable="on"><select id="FontSize" class="formElt" style="width: 90" onchange="performAction('FontSize', this.value)">
    		<option value="1">1 (8pt)</option>
    		<option value="2">2 (10pt)</option>
    		<option value="3" selected>3 (12pt)</option>
    		<option value="4">4 (14pt)</option>
    		<option value="5">5 (18pt)</option>
    		<option value="6">6 (24pt)</option>
    		<option value="7">7 (36pt)</option>
    	</select></td>
    <? genButton("Bold", TRUE) ?>
    <? genButton("Italic", TRUE) ?>
    <? genButton("Underline", TRUE) ?>
    <? genButton("ForeColor") ?>
    <? genButton("RemoveFormat") ?>
  </tr>
</table>

<table cellspacing="0" cellpadding="0" border="0" style="width: 100%; border: 2px solid #CCCCCC; border-top-width: 0px">
  	<tr unselectable="on">
	    <? genButton("CreateLink") ?>
	    <? genButton("InsertHorizontalRule") ?>
	    <? genButton("InsertOrderedList", TRUE) ?>
	    <? genButton("InsertUnorderedList", TRUE) ?>
	    <? genButton("JustifyLeft", TRUE) ?>
	    <? genButton("JustifyCenter", TRUE) ?>
	    <? genButton("JustifyRight", TRUE) ?>
	    <? genButton("Outdent") ?>
	    <? genButton("Indent") ?>
	    <? genButton("InsertTable") ?>
	    <? genButton("DisplayTableBorders") ?>
	    <? genButton("HTML", TRUE) ?>
  	</tr>
</table>

</td></tr></table>

</body>

</html>
