/******************************************************************************
*
*    VisualTextbox V1.1b - Online HTML Editor
*    Copyright (C) 2003  Nicolas Robert-Dehault 
*	 					 visualtextbox@free.fr
*						 http://visualtextbox.free.fr/
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
******************************************************************************/

/**
*
*	Thanks to Karl Seguin (http://www.openmymind.net) for the tables handling functions
*
*/

//table manager object definition
function TableManager() {
	
	this.create = createTable;
	this.edit = editTable;
	this.editCell = editCell;
	this.deleteColumn = deleteColumn;
	this.insertColumn = insertColumn;
	this.insertRow = insertRow;
}

//creates a table object according with given parameters
function createTable(rows, cols, align, border, spacing, padding) {
	//checks parameters
	rows = (isNaN(rows) || rows<1) ? 1 : rows;
	cols = (isNaN(cols) || cols<1) ? 1 : cols;
	border = (isNaN(border)) ? 0 : border;
	spacing = (isNaN(spacing)) ? 0 : spacing;
	padding = (isNaN(padding)) ? 0 : padding;

	var table = document.createElement("TABLE");
	if (align!="") table.align = align;
	table.border = border;
	table.cellSpacing = spacing;
	table.cellPadding = padding;
	table.style.width = 100;
	for (r=0; r<rows; r++) {
		row = table.insertRow();
		for (c=0; c<cols; c++) {
			cell = row.insertCell();
			//cell.innerHTML = "&nbsp;";
		}
	}
	return table;
}

// updates given table with new border, cellspacing and cellpadding
function editTable(table, align, border, spacing, padding) {
	if (table) {
		border = (isNaN(border)) ? 0 : border;
		spacing = (isNaN(spacing)) ? 0 : spacing;
		padding = (isNaN(padding)) ? 0 : padding;
		table.align = align;
		table.border = border;
		table.cellSpacing = spacing;
		table.cellPadding = padding;
	}
}

// updates given table cell
function editCell(cell, align, valign, width) {
	if (cell) {
		if (align) cell.align = align;
		if (valign) cell.vAlign = valign;
		if (width) cell.style.width = width;
	}
}

function deleteColumn(td, table){
	var pos;
	td = td.previousSibling;
	for (pos = 1; td;pos+=td.colSpan, td = td.previousSibling);
	var parent = table.getElementsByTagName("TR")[0];
	var noCols = 0;
	for (var tr = parent;tr && tr.tagName.toUpperCase() == "TR"; tr = tr.nextSibling) {
		var currentCol = 0;
		var row = tr.getElementsByTagName("TD");
		if (row && row.length>noCols) noCols = row.length;
		var child = row[0];
		for (;child && child.tagName.toUpperCase() == "TD"; child = child.nextSibling) {
			currentCol += child.colSpan;
			if (currentCol >= pos) {
				if (child.colSpan > 1) child.colSpan -= 1;
				else child.removeNode(true);
				break;  
			}
		}
	}
	for (;parent && parent.tagName.toUpperCase() == "TR"; parent = parent.nextSibling) {
		var tds = parent.getElementsByTagName("TD");
		if (tds.length == 0) {
			parent.removeNode(true);
			if (table.rows.length==0) {
				table.removeNode(true);
			}
			--i;
		}
	} 
	// table auto-resize: disabled
	/*
	if (re = table.style.width.match(/^([0-9]+)(.*)$/i)) {
		table.style.width = Math.round(re[1]*(noCols-1)/noCols)+re[2];
	}
	*/
}

function insertColumn(td, table, loc){
	var pos;
	if (loc == 'left') td = td.previousSibling;
	for (pos = 1; td;pos+=td.colSpan, td = td.previousSibling);
	var trs = table.getElementsByTagName("TR");
	var noCols = 0;
	for (var i = 0; i < trs.length; ++i) {
		var tds = trs(i).getElementsByTagName("TD");
		var currentCol = 0;
		if (tds && tds.length>noCols) noCols = tds.length;
		for (var j = 0; j < tds.length; ++j) {
			currentCol += tds(j).colSpan;
			if ((currentCol+1) >= pos) {
				if (tds(j).colSpan > 1 && (currentCol + 1) != pos) {
					tds(j).colSpan += 1;
				} else {
					var neTD = document.createElement("TD");
					if (pos == 1) 
						tds(j).insertAdjacentElement('beforeBegin', neTD);
					else 
						tds(j).insertAdjacentElement('afterEnd', neTD);
				}
				break;  
			}
		}
	}
	// table auto-resize: disabled
	/*
	if (re = table.style.width.match(/^([0-9]+)(.*)$/i)) {
		table.style.width = Math.round(re[1]/noCols*(noCols+1))+re[2];
	}
	*/
}

function insertRow(tr, table, loc){
	var rowIndex = tr.rowIndex;
	if (loc && loc.toUpperCase()=="BELOW")
		rowIndex++;
	var newtr = table.insertRow(rowIndex);
	for (i=0; i<tr.cells.length; i++) {
		newtr.insertCell().colSpan = tr.cells[i].colSpan;
	}
}

var TableManager = new TableManager();
