/******************************************************************************
*
*    VisualTextbox V1.1b - Online HTML Editor
*    Copyright (C) 2003  Nicolas Robert-Dehault 
*	 					 visualtextbox@free.fr
*						 http://visualtextbox.free.fr/
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
******************************************************************************/

<?
	define("VISUALTEXTBOX_LANG", $_REQUEST['lang']);
	require_once dirname(__FILE__)."/../php/utils.inc.php";
	require_once dirname(__FILE__)."/../php/config.inc.php";
?>

// list of VisualTextbox controls in current page
var VisualTextboxList = new Array();
// active VisualTextbox control id
var activeVisualTextbox = <?= $_REQUEST['active']!="" ? '"'.$_REQUEST['active'].'"' : "null" ?>;
// active text range
var activeTextRange = null;

function keyPressed(controlName) {
	if (visualTextboxPanel.HTMLmode[controlName]!=1) {
		return true;
	} else if (!event.ctrlKey) {
		return true;
	} else {
		allowedKeys = new Array(36, 36, 37, 38, 39, 40, 65, 67, 86, 88, 89, 90);
		for (i=0; i<allowedKeys.length; i++) {
			if (event.keyCode==allowedKeys[i]) {
				return true;
			}
		}
	}
	return false;
}

// function to call on submit to set VisualTextbox content in hidden field
function submitVisualTextbox(_name) {
	re = /visualTextbox(.+)/;
	if (re.test(_name)) {
		var name = _name.replace(re, "$1");
		// copies editor content to hidden field
		if (visualTextboxForm!=null && visualTextboxForm.elements[name]!=null && frames["visualTextbox"+name]!=null) {
			if (visualTextboxPanel.isModeHTML(_name))
				visualTextboxForm.elements[name].value = frames["visualTextbox"+name].innerText;
			else
				visualTextboxForm.elements[name].value = frames["visualTextbox"+name].innerHTML;
			saveVisualTextboxPanelState();
			return true;
		}
	} 
	alert("<?= getMessage("Error_Submit") ?>"+_name);
	return false;
}

// function to call on submit to set VisualTextbox content in hidden field
function saveVisualTextboxPanelState() {
	if (controlPanel = document.getElementById('visualTextboxPanel')) {
		document.all.visualTextboxPanelX.value = controlPanel.style.left;
		document.all.visualTextboxPanelY.value = controlPanel.style.top;
		document.all.visualTextboxPanelDisplay.value = controlPanel.style.display;
	}
	if (activeVisualTextbox!=null)
		document.all.visualTextboxActive.value = activeVisualTextbox;
}

function hideControlPanel() {
	document.getElementById('visualTextboxPanel').style.display	= 'none';
}

// looks for form containing the VisualTextbox control
definedForms = new Array();
for (i=document.forms.length; i>0; i--)
	definedForms[document.forms[i-1].getAttribute('uniqueid')] = i-1;
visualTextboxParent = document.getElementById('visualTextboxPanel').parentElement;
while (visualTextboxParent!=null && definedForms[visualTextboxParent.getAttribute('uniqueid')]==null) {
	visualTextboxParent = visualTextboxParent.parentElement;
}
var visualTextboxForm = visualTextboxParent;

function setVisualTextboxPanelVisible() {
	_top = document.body.scrollTop+(iframesTop['visualTextboxPanel']?iframesTop['visualTextboxPanel']:<?= $_REQUEST['controlPanelY'] ?>);
	document.getElementById('visualTextboxPanel').style.top = _top;
}

/*******************************************************************
* onscroll event handling, used to keep control panel visible	
*******************************************************************/
var scrollTimeout = 200;
var lastScrollTime = null;
function onScroll() {
	hideFloatingWindow('visualTextboxDialog');
	lastScrollTime = (new Date()).getTime();
	setTimeout("testScroll()", scrollTimeout);
}
function testScroll() {
	if (lastScrollTime!=null && (new Date()).getTime()>=(lastScrollTime+scrollTimeout)) {
		lastScrollTime = null;
		onScrollEnd();
	}
}
window.onscroll = onScroll;

function onScrollEnd() {
	setVisualTextboxPanelVisible();
}

setVisualTextboxPanelVisible();

/*******************************************************************
* functions used to make an absolute positionned div/span movable
*******************************************************************/
var move_floating_window = false; var mouse_x; var mouse_y; var floating_window_x; var floating_window_y;
function moveFloatingWindow(id, down) {
	if (document.frames[id]==null) {
		return false;
	} else if (down==true) {
		move_floating_window=true; 
	  	document.onmousemove = new Function("moveFloatingWindow('"+id+"')");
	  	mouse_x=event.clientX; mouse_y=event.clientY; 
	  	floating_window_x=parseInt(document.frames[id].style.left.substr(0, document.frames[id].style.left.length-2)); 
	  	floating_window_y=parseInt(document.frames[id].style.top.substr(0, document.frames[id].style.top.length-2));
	} else if (move_floating_window && event.button==1) {
		document.frames[id].document.selection.empty();
		document.frames[id].style.left = floating_window_x + event.clientX - mouse_x;
		document.frames[id].style.top = floating_window_y + event.clientY - mouse_y;
	} else if (move_floating_window) {
		move_floating_window = false;
	}
}
function hideFloatingWindow(id) {
	if (document.frames[id]!=null) {
		document.frames[id].style.display='none';
	}
}
function showFloatingWindow(id) {
	if (document.frames[id]!=null)
		document.frames[id].style.display='block';
}

var editableElements = new Array();

/*******************************************************************
* finds out options needed for context menu and show menu
*******************************************************************/
function showContextMenu() {
	editableElements['TABLE'] = null;
	editableElements['TR'] = null;
	editableElements['TD'] = null;
	var menu = new Array();
	var element = null;
	if (document.selection.type.toLowerCase()=="control" && document.selection.createRange()(0).tagName.toUpperCase()=="TABLE") {
		editableElements['TABLE'] = document.selection.createRange()(0);
	} else if (document.selection.type.toLowerCase()=="none") {
		element = document.selection.createRange().parentElement();
		while (element && element.id!=activeVisualTextbox) {
			if (element.tagName.toUpperCase()=="TD") {
				editableElements['TD'] = element;
			} else if (element.tagName.toUpperCase()=="TR") {
				editableElements['TR'] = element;
			} else if (element.tagName.toUpperCase()=="TABLE") {
				editableElements['TABLE'] = element;
				break;
			}
			element = element.parentElement;
		}
	}

	if (editableElements['TABLE']) {
		menu.push('<?= getMessage("ContextMenu_EditTable") ?>');
		menu.push('showDialog("EditTable")');
		menu.push('<?= getMessage("ContextMenu_TableBackgroundColor") ?>');
		menu.push('showDialog("TableBackgroundColor")');
		menu.push('hr');
	}
	if (editableElements['TD']) {
		menu.push('<?= getMessage("ContextMenu_EditCell") ?>');
		menu.push('showDialog("EditCell")');
		menu.push('<?= getMessage("ContextMenu_CellBackgroundColor") ?>');
		menu.push('showDialog("CellBackgroundColor")');
		menu.push('hr');
		if (editableElements['TD'].previousSibling) {
			menu.push('<?= getMessage("ContextMenu_MergeCellLeft") ?>');
			menu.push('doAction("MergeCell", "left")');
		}
		if (editableElements['TD'].nextSibling) {
			menu.push('<?= getMessage("ContextMenu_MergeCellRight") ?>');
			menu.push('doAction("MergeCell", "right")');
		}
		if (editableElements['TD'].previousSibling || editableElements['TD'].nextSibling) {
			menu.push('hr');
		}
	}
	if (editableElements['TABLE'] && editableElements['TR'] && editableElements['TD']) {
		
		// delete rox
		if (editableElements['TABLE'].rows.length>1) {
			menu.push('<?= getMessage("ContextMenu_DeleteRow") ?>');
			menu.push('doAction("DeleteRow")');
		}
		
		// delete col
		if (editableElements['TR'].cells.length>1) {
			menu.push('<?= getMessage("ContextMenu_DeleteCol") ?>');
			menu.push('doAction("DeleteColumn")');
		}
		
		// delete table
		menu.push('<?= getMessage("ContextMenu_DeleteTable") ?>');
		menu.push('doAction("DeleteTable")');
		menu.push('hr');
		
		// insert row
		menu.push('<?= getMessage("ContextMenu_InsertRowAbove") ?>');
		menu.push('doAction("InsertRow", "above")');
		menu.push('<?= getMessage("ContextMenu_InsertRowBelow") ?>');
		menu.push('doAction("InsertRow", "below")');
		menu.push('hr');

		// insert col
		menu.push('<?= getMessage("ContextMenu_InsertColLeft") ?>');
		menu.push('doAction("InsertColumn", "left")');
		menu.push('<?= getMessage("ContextMenu_InsertColRight") ?>');
		menu.push('doAction("InsertColumn", "right")');
		menu.push('hr');
	}
	if (menu.length>0) ContextMenu.show(menu);
}