/******************************************************************************
*
*    VisualTextbox V1.1b - Online HTML Editor
*    Copyright (C) 2003  Nicolas Robert-Dehault 
*	 					 visualtextbox@free.fr
*						 http://visualtextbox.free.fr/
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
******************************************************************************/

<?
	define("VISUALTEXTBOX_LANG", $_REQUEST['lang']);
	require_once dirname(__FILE__)."/../php/utils.inc.php";
?>

// average dialog window size, used to center the window
var dialogAverageWidth = 200;
var dialogAverageHeight = 160;

// currently executing action
var currentAction;

// dialog titles
var dialogTitles = new Array();
dialogTitles['InsertTable'] = "<?= getMessage("Dialog_InsertTable_Title") ?>";
dialogTitles['EditTable'] = "<?= getMessage("Dialog_EditTable_Title") ?>";
dialogTitles['EditCell'] = "<?= getMessage("Dialog_EditCell_Title") ?>";
dialogTitles['ForeColor'] = "<?= getMessage("Dialog_ForeColor_Title") ?>";
dialogTitles['TableBackgroundColor'] = "<?= getMessage("Dialog_TableBackgroundColor_Title") ?>";
dialogTitles['CellBackgroundColor'] = "<?= getMessage("Dialog_CellBackgroundColor_Title") ?>";
dialogTitles['CreateLink'] = "<?= getMessage("Dialog_Link_Title") ?>";

// dialog divs name
var dialogDivs = new Array();
dialogDivs['ForeColor'] = 'ColorPicker';
dialogDivs['TableBackgroundColor'] = 'ColorPicker';
dialogDivs['CellBackgroundColor'] = 'ColorPicker';

// dialog options
var dialogOptions = new Array();
dialogOptions['ColorPicker'] = "noFocus";
dialogOptions['CreateLink'] = "noFocus";

// dialog actions
function doAction(action, option) {
	if (action)
		currentAction = action;
	if (frames[activeVisualTextbox]!=null) {
		if (!action && dialogDivs[currentAction]!='ColorPicker')
			document.selection.empty(); 
		switch (currentAction) {
			case "CreateLink":
				if (document.all.createlink_address.value.match(/"/)) {
					alert('<?= addslashes(getMessage("Dialog_Link_URL_Error_Quotes")) ?>');
					return;
				} else if (document.all.createlink_address.value.match(/^\s*$/) || document.all.createlink_address.value=='http://') {
					document.all.createlink_address.select();
					document.all.createlink_address.focus();
					alert('<?= getMessage("Dialog_Link_URL_Error_Empty") ?>');
					return;
				} else if (document.all.createlink_target.value=='custom' && document.all.createlink_customtarget.value.match(/"/)) {
					alert('<?= getMessage("Dialog_Link_Target_Error_Quotes") ?>');
					return;
				} else {
					if (document.all.createlink_address.value.toLowerCase().match(/^www\./)) {
						document.all.createlink_address.value = 'http://'+document.all.createlink_address.value
					}
					if (editableElements['A']) {
						editableElements['A'].href = document.all.createlink_address.value;
						editableElements['A'].target = document.all.createlink_target.value=='custom' ?
							document.all.createlink_customtarget.value : document.all.createlink_target.value;
					} else {
						link = frames[activeVisualTextbox].document.createElement("A");
						link.href = document.all.createlink_address.value;
						link.target = document.all.createlink_target.value=='custom' ?
							document.all.createlink_customtarget.value : document.all.createlink_target.value;
						link.innerText = document.all.createlink_address.value;
						visualTextboxPanel.insertCode(link.outerHTML);
					}
				}
				break;
			case "InsertTable":
				visualTextboxPanel.insertTable( 
						document.all.table_rows.value, 
						document.all.table_cols.value,
						document.all.table_align.value,
						document.all.table_border.value,
						document.all.table_cellspacing.value,
						document.all.table_cellpadding.value
				);
				break;
			case "EditTable":
				if (!editableElements['TABLE']) {
					alert("<?= getMessage("Action_Error_EditTable") ?>");
				} else {
					visualTextboxPanel.TableManager.edit(
							editableElements['TABLE'],
							document.all.new_table_align.value,
							document.all.new_table_border.value,
							document.all.new_table_cellspacing.value,
							document.all.new_table_cellpadding.value
					);
				}
				break;
			case "EditCell":
				if (!editableElements['TD']) {
					alert("<?= getMessage("Action_Error_EditCell") ?>");
				} else {
					visualTextboxPanel.TableManager.editCell(
							editableElements['TD'],
							document.all.new_cell_align.value,
							document.all.new_cell_valign.value,
							document.all.new_cell_width.value!="" ? document.all.new_cell_width.value+document.all.new_cell_width_unit.value : null
					);
				}
				break;
			case "TableBackgroundColor":
				if (editableElements['TABLE'])
					editableElements['TABLE'].style.backgroundColor = document.all.colorSample.style.backgroundColor;
				break;
			case "CellBackgroundColor":
				if (editableElements['TD'])
					editableElements['TD'].style.backgroundColor = document.all.colorSample.style.backgroundColor;
				break;
			case "DeleteTable":
				if (editableElements['TABLE']) {
					editableElements['TABLE'].removeNode(true);
					editableElements['TABLE'] = null
				}
				break;
			case "DeleteRow":
				if (editableElements['TABLE'] && editableElements['TR']) {
					editableElements['TR'].removeNode(true);
					if (editableElements['TABLE'].rows.length==0) {
						doAction("DeleteTable");
					}
				}
				break;
			case "InsertRow":
				if (editableElements['TABLE'] && editableElements['TR']) {
					visualTextboxPanel.TableManager.insertRow(
							editableElements['TR'],
							editableElements['TABLE'],
							option
					);
					visualTextboxPanel.refreshTableBorders();
				}
				break;
			case "DeleteColumn":
				if (editableElements['TABLE'] && editableElements['TR']) {
					visualTextboxPanel.TableManager.deleteColumn(
							editableElements['TD'],
							editableElements['TABLE']
					);
				}
				break;
			case "MergeCell":
				if (option && option.toUpperCase()=="RIGHT")
					sibling = editableElements['TD'].nextSibling;
				else
					sibling = editableElements['TD'].previousSibling;
				if (editableElements['TD'] && sibling) {
					var colSpan = parseInt(editableElements['TD'].colSpan) + parseInt(sibling.colSpan);
					sibling.removeNode(true);
					editableElements['TD'].colSpan = colSpan;
				}
				break;
			case "InsertColumn":
				if (editableElements['TABLE'] && editableElements['TD']) {
					visualTextboxPanel.TableManager.insertColumn(
							editableElements['TD'],
							editableElements['TABLE'],
							option
					);
					visualTextboxPanel.refreshTableBorders();
				}
				break;
			case "ForeColor":
				frames[activeVisualTextbox].focus();
				frames[activeVisualTextbox].document.execCommand('ForeColor', false, document.all.colorSample.style.backgroundColor);
				break;
			default:
				alert("<?= getMessage("Action_Error_UnknownAction", '"+currentAction+"') ?>");
		}
		hideFloatingWindow('visualTextboxDialog');
		submitVisualTextbox(activeVisualTextbox);
	} else {
		alert("<?= getMessage("Action_Error_NoControlSelected") ?>");
	}
	return false;
}

// shows dialog window showing div according to action
function showDialog(action) {
	currentAction = action;
	showFloatingWindow('visualTextboxDialog');
	// gets all divs in window
	var divs = visualTextboxDialog.getElementsByTagName("DIV");
	var divFound = false;
	// processes all divs
	for (var i = 0; i < divs.length; ++i) {
		var divId = dialogDivs[action]!=null ? dialogDivs[action] : action;
		var divOptions = (dialogOptions[divId]==null ? '' : dialogOptions[divId]).toLowerCase();
		// if this div is the good one...
		if (divs[i].id==divId) {
			// shows it
			divs[i].style.display = "block";
			divFound = true;
			
			// processes input controls
			inputs = divs[i].getElementsByTagName("INPUT");
			var focusSet = false;
			for (j=0; j<inputs.length; j++) {
				// set focus on first INPUT TEXT control
				if (!focusSet && divOptions.indexOf('nofocus')<0 && inputs[j].type.toUpperCase()=="TEXT") {
					inputs[j].focus();
					inputs[j].select();
					focusSet = true;
				} 				
				// set custom 'onkeypress' event, preventing the ENTER key to submit the form
				if (inputs[j].type.toUpperCase()=="TEXT") {
					inputs[j].onkeypress = new Function("if (window.event.keyCode==13) { return false; } else if (window.event.keyCode==27) { hideFloatingWindow('visualTextboxDialog'); return false; }");
				} 
			}
		} 
		// ...if not hides it
		else {
			divs[i].style.display = "none";
		}
	}
	if (divFound) {
		updateDialog();
		visualTextboxDialogTitle.innerText = dialogTitles[action] ? dialogTitles[action] : action;
		visualTextboxDialog.style.top = document.body.scrollTop + (document.body.clientHeight-dialogAverageHeight)/2;
		visualTextboxDialog.style.left = document.body.scrollLeft + (document.body.clientWidth-dialogAverageWidth)/2;
	} else {
		hideFloatingWindow('visualTextboxDialog');
		alert("<?= getMessage("Action_Error_CannotFindDialog", '"+action+"') ?>");
	}
}

//update dialog fields with the value of the object to edit
function updateDialog() {
	switch (currentAction) {
		case "EditTable":
			if (editableElements['TABLE']) {
				if (editableElements['TABLE'].align=="")
					document.all.new_table_align.selectedIndex = 0;
				else
					document.all.new_table_align.value = editableElements['TABLE'].align;
				document.all.new_table_border.value = editableElements['TABLE'].border;
				document.all.new_table_cellspacing.value = editableElements['TABLE'].cellSpacing;
				document.all.new_table_cellpadding.value = editableElements['TABLE'].cellPadding;
			}
			break;
		case "CreateLink":
			editableElements['A'] = null;
			if (!activeTextRange) activeTextRange = frames[activeVisualTextbox].document.selection.createRange();
			if (activeTextRange) {
				sel = activeTextRange.parentElement();
				while (sel && sel.tagName.toUpperCase()!="A" && sel.id!=activeVisualTextbox) {
					sel = sel.parentElement;
				}
				if (sel && sel.tagName.toUpperCase()=="A") {
					editableElements['A'] = sel;
					activeTextRange.moveToElementText(sel);
					activeTextRange.select();
					document.all.createlink_address.value = editableElements['A'].href;
					
					var target = editableElements['A'].target.toLowerCase();
					if (target=='_blank' || target=='_self') {
						document.all.createlink_target.value = editableElements['A'].target;
						document.all.createlink_customtarget.style.display = 'none';
					} else {
						document.all.createlink_target.value = 'custom';
						document.all.createlink_customtarget.value = editableElements['A'].target;
						document.all.createlink_customtarget.style.display = 'block';
					}
				} else {
					document.all.createlink_address.value = 'http://';
					document.all.createlink_target.value = '_blank';
				}
			}
			break;
	}
}

/*******************************************************
*
*	Color picker functions
*
*******************************************************/

<?

	// setup color picker
	$colorCellSize = 8;
	$y0 = 18;
	$x0 = 4;

	$colors = array();
	$y1 = $y0+2;

	// calculates colors	
	for ($j=$y1; $j>2; $j--) {
	    for ($m = 0; $m < 6; $m++) {
	        for ($i = 0; $i < $x0; $i++) {
	            switch ($m) {
		            case 0: $r = floor(0x7f * $j/$y1) + 0x80;	$b = floor(0x80 - ($r - 0x7f));		$g = floor((($r - $b) * $i/$x0) + $b);				break;
		            case 1: $g = floor(0x7f * $j/$y1) + 0x80;	$b = floor(0x80 - ($g - 0x7f));		$r = floor(($g - $b) - (($g - $b) * $i/$x0) + $b);	break;
		            case 2: $g = floor(0x7f * $j/$y1) + 0x80;	$r = floor(0x80 - ($g - 0x7f));		$b = floor((($g - $r) * $i/$x0) + $r);				break;
		            case 3: $b = floor(0x7f * $j/$y1) + 0x80;	$r = floor(0x80 - ($b - 0x7f));		$g = floor(($b - $r) - (($b - $r) * $i/$x0) + $r);	break;
		            case 4: $b = floor(0x7f * $j/$y1) + 0x80;	$g = floor(0x80 - ($b - 0x7f));		$r = floor((($b - $g) * $i/$x0) + $g);				break;
		            case 5: $r = floor(0x7f * $j/$y1) + 0x80;	$g = floor(0x80 - ($r - 0x7f));		$b = floor(($r - $g) - (($r - $g) * $i/$x0) + $g);	break;
	            }
	            $r = dechex($r);					$g = dechex($g);					$b = dechex($b);
	            if (strlen($r) < 2) $r = "0$r";		if (strlen($g) < 2) $g = "0$g";		if (strlen($b) < 2) $b = "0$b";
				array_push($colors, "$r$g$b");
	        }
	    }
	}	
	
	$colors = join("", $colors);
?>
function nextColor() {
	color = colors.substr(color_nb, 6);
	color_nb += 6;
	return color;
}

function updateGradient(color) {
	
    var red   = Number('0x' + color.substr(1, 2));
    var green = Number('0x' + color.substr(3, 2));
    var blue  = Number('0x' + color.substr(5, 2));
    var j = 0;
	var noGradients = y+4;
    for (i=3; i<(noGradients-1); i++) {
        if (i < (noGradients / 2)) {
            r = Math.floor(2*i*red/noGradients);
            g = Math.floor(2*i*green/noGradients);
            b = Math.floor(2*i*blue/noGradients);
        } else {
            r = Math.floor(red + 2*j*(0xff - red)/noGradients);
            g = Math.floor(green + 2*j*(0xff - green)/noGradients);
            b = Math.floor(blue + 2*j*(0xff - blue)/noGradients);
            j++;
        }
        r = r.toString(16);
        g = g.toString(16);
        b = b.toString(16);
        if (r.length < 2) r = "0" + r;
        if (g.length < 2) g = "0" + g;
        if (b.length < 2) b = "0" + b;
        colorTable.rows[ i-3 ].cells[ x*6+1 ].bgColor = "#" + r + g + b;
    }
}    

var selectingColor = false;

function colorCellClick(cell, updategradient) {
	if (event.type=='click' || event.type=='mousemove' && event.button==1) {
		selectColor(cell.bgColor);
		if (updategradient!=false) updateGradient(cell.bgColor);
		selectingColor = true;
	} else if (selectingColor) {
		selectingColor = false;
	}
}

function selectColor(color) {
	document.all.selectedColor.value=color;
	document.all.colorSample.style.backgroundColor=color;
}

