/******************************************************************************
*
*    VisualTextbox V1.1b - Online HTML Editor
*    Copyright (C) 2003  Nicolas Robert-Dehault 
*	 					 visualtextbox@free.fr
*						 http://visualtextbox.free.fr/
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
******************************************************************************/

<?
	define("VISUALTEXTBOX_LANG", $_REQUEST['lang']);
	require_once dirname(__FILE__)."/../php/utils.inc.php";
?>

var foreColorButtonDown = false;
var showTableBorders = false;
var selectingColor = false;
var HTMLmode = new Array();
var twoStateButton = new Array();
var buttonClicked = new Array();

// sets font name and size, bold, justify, etc... in the control panel 
// according to the attributes of the selected text in the editor
function updateTextFormatControls() {
	if (HTMLmode[parent.activeVisualTextbox]!=1) {
		if (editor = parent.frames[parent.activeVisualTextbox].document) {
			document.all.FontName.value = editor.queryCommandValue('FontName');
			document.all.FontSize.value = editor.queryCommandValue('FontSize');
			for (i=0; i<twoStateButton.length; i++) {
				if (button = document.getElementById(twoStateButton[i])) {
					if (editor.queryCommandSupported(twoStateButton[i])) {
						if (editor.queryCommandValue(twoStateButton[i])) {
							setButtonDown(button); 
							setButtonClicked(button, true);
						} else {
							setButtonMiddle(button);
							setButtonClicked(button, false);
						}
					}
				}
			}
		}
	}
}

// updates control panel interface according the the HTML mode state of the active editor
function checkHTMLmode(name) {
	images = document.getElementsByTagName("IMG");
	for (var i = 0; i < images.length; ++i) {
		if (images[i].id!="HTML" && images[i].id!="closePanel") {
			images[i].style.filter = HTMLmode[name]==1 ? "alpha(opacity=50), gray()" : "";
			if (HTMLmode[name]==1) {
				setButtonMiddle(images[i]);
				setButtonClicked(images[i], false);
			}
		}
	}
	selects = document.getElementsByTagName("SELECT");
	for (var i = 0; i < selects.length; ++i) {
		selects[i].disabled = HTMLmode[name]==1;
	}
}

// returns TRUE if HTML mode is actived for the editor with given name
function isModeHTML(name) { 
	return HTMLmode[name]==1; 
}

// inserts any HTML code in the active editor
function insertCode(code) {
	var tr = null;
	if (parent.activeTextRange!=null) {
		tr = parent.activeTextRange
	} else if (parent.frames[parent.activeVisualTextbox]) {
		parent.frames[parent.activeVisualTextbox].focus();
		tr = parent.frames[parent.activeVisualTextbox].document.selection.createRange();
	}
	if (tr!=null) {
		tr.pasteHTML(code);
		if (showTableBorders) setTimeout("displayTableBorders(true)", 1); 
		parent.submitVisualTextbox(parent.activeVisualTextbox);
		if (parent.frames[parent.activeVisualTextbox])
			parent.frames[parent.activeVisualTextbox].focus();
	}
}

//inserts a table in the active editor
function insertTable(rows, cols, align, border, spacing, padding) {
	var table = TableManager.create(rows, cols, align, border, spacing, padding);
	if (table)
		insertCode(table.outerHTML);
	else
		parent.alert("<?= getMessage("Error_TableCreation") ?>");
}

// displays table borders if needed on paste
function editorPaste() {
	if (HTMLmode[parent.activeVisualTextbox]!=1) {
		if (showTableBorders) setTimeout("displayTableBorders(true)", 1); 
		return true;
	} else {
		var buffer = document.getElementById('ClipboardBuffer');
		var tr = parent.frames[parent.activeVisualTextbox].document.selection.createRange();
		if (buffer && tr) {
			buffer.innerHTML = "";
			buffer.focus();
			buffer.document.execCommand("Paste");
			buffer.innerText = buffer.innerHTML;
			tr.pasteHTML(buffer.innerHTML);
		} else {
			parent.alert('Paste failed!');
		}
		return false;
	}
}

// performs action on the editor
function performAction(action, option) {
	if (HTMLmode[parent.activeVisualTextbox]!=1 || action=="HTML") {
		if (parent.frames[parent.activeVisualTextbox]!=null) {
			parent.focus();
			switch (action) {
				case "ForeColor":
				case "InsertTable":
				case "CreateLink":
					parent.showDialog(action);
					break;
				case "DisplayTableBorders":
					displayTableBorders();
					break;
				case "FontName":
				case "FontSize":
					parent.frames[parent.activeVisualTextbox].document.execCommand(action, false, option);
					break;
				case "HTML":
					if (HTMLmode[parent.activeVisualTextbox]==1) {
						parent.frames[parent.activeVisualTextbox].innerHTML = parent.frames[parent.activeVisualTextbox].innerText;
						refreshTableBorders();
						HTMLmode[parent.activeVisualTextbox] = 0;
						parent.frames[parent.activeVisualTextbox].focus();
						parent.frames[parent.activeVisualTextbox].blur();
						parent.frames[parent.activeVisualTextbox].focus();
						updateTextFormatControls();
					} else {
						parent.frames[parent.activeVisualTextbox].innerText = parent.frames[parent.activeVisualTextbox].innerHTML;
						HTMLmode[parent.activeVisualTextbox] = 1;
					}
					checkHTMLmode(parent.activeVisualTextbox);
					break;
				default:
					parent.frames[parent.activeVisualTextbox].document.execCommand(action);
			}
		}
	}
	parent.submitVisualTextbox(parent.activeVisualTextbox);
	updateTextFormatControls();
}

// refreshes tables borders
function refreshTableBorders() {
	if (showTableBorders) displayTableBorders(true);
}

// displays tables borders
function displayTableBorders(forceDisplay) {
	
	if (forceDisplay) {
		showTableBorders = true;
	} else {
		showTableBorders = !showTableBorders;
	}

	for (i=0; i<parent.VisualTextboxList.length; i++) {
		if (parent.frames[parent.VisualTextboxList[i]]) {
			if (showTableBorders)
				_showTableBorders(parent.frames[parent.VisualTextboxList[i]]);
			else
				_hideTableBorders(parent.frames[parent.VisualTextboxList[i]]);
		}
	}
}

// actually shows tables borders
function _showTableBorders(container) {
	if (container!=null) {
		//gets all tables from editor
		var tables = container.getElementsByTagName("TABLE");
		for (var i = 0; i < tables.length; ++i){
			if (tables[i].border == 0) {
				// gets cells from table
				var cells = tables[i].getElementsByTagName("td");
				for (var j = 0; j < cells.length; j++){
					// draws borders 
					cells[j].runtimeStyle.border = '1 dotted #909090';
				}
			}
		}
	}
}

// actually hides tables borders
function _hideTableBorders(container) {
	if (container!=null) {
		//gets all tables from editor
		var tables = container.getElementsByTagName("TABLE");
		for (var i = 0; i < tables.length; ++i){
			if (tables[i].border == 0) {
				// gets cells from table
				var cells = tables[i].getElementsByTagName("td");
				for (var j = 0; j < cells.length; j++){
					// removes borders 
					cells[j].runtimeStyle.cssText = '';
				}
			}
		}
	}
}

function mouseOverButton(button) { 
	if (isButtonActive(button) && !isButtonClicked(button)) {
		setButtonUp(button);
	}
}

function mouseOutButton(button) { 
	if (isButtonActive(button) && !isButtonClicked(button)) {
		setButtonMiddle(button);
	}
}

function mouseDownButton(button) { 
	if (isButtonActive(button)) {
		setButtonDown(button);
	}
}

function mouseClickButton(button) { 
	if (isButtonActive(button)) {
		if (isTwoStateButton(button) && isButtonClicked(button)) {
			setButtonUp(button);
			setButtonClicked(button, false);
		} else if (isTwoStateButton(button)) {
			setButtonDown(button);
			setButtonClicked(button, true);
		} else {
			setButtonUp(button);
		}
	}
}

function setButtonDown(button) { button.style.borderColor = "#666666 #FFFFFF #FFFFFF #666666"; button.style.backgroundColor='#EEEEEE'; }
function setButtonMiddle(button) { button.style.backgroundColor = "#CCCCCC"; button.style.borderColor = "#CCCCCC"; }
function setButtonUp(button) { button.style.borderColor = "#FFFFFF #666666 #666666 #FFFFFF"; button.style.backgroundColor = "#CCCCCC"; }
function isTwoStateButton(button) { for (i=0; i<twoStateButton.length && twoStateButton[i]!=button.id; i++); return i<twoStateButton.length; }
function isButtonActive(button) { return HTMLmode[parent.activeVisualTextbox]!=1 || button.id=="HTML"; }
function isButtonClicked(button) { return button && isTwoStateButton(button) && buttonClicked[button.id]; }
function setButtonClicked(button, clicked) { if (button && button.id!='') buttonClicked[button.id] = clicked; }