/******************************************************************************
*
*    VisualTextbox V1.1b - Online HTML Editor
*    Copyright (C) 2003  Nicolas Robert-Dehault 
*	 					 visualtextbox@free.fr
*						 http://visualtextbox.free.fr/
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
******************************************************************************/

/***********************************************************
*	context menu object definition
***********************************************************/
function ContextMenu() {
	
	// a random id is generated for the context menu object
	var menuId = "contextMenu_"+( Math.round(Math.random()*(new Date().getTime())) );

	// true if context menu has focus
	var hasFocus = true;
	
	// writes context menu HTML code to document
	function init() {
		// creates object that will contain the context menu
		var _contextMenu = document.createElement('<span oncontextmenu="return false" onblur="if (!ContextMenu.hasFocus) ContextMenu.hide()" onkeypress="if (window.event.keyCode==27) ContextMenu.hide()">');
		_contextMenu.id = this.menuId; 
		_contextMenu.style.display = "none";
		_contextMenu.style.position = "absolute";
		_contextMenu.style.backgroundColor = "#D4D0C8"; 
		_contextMenu.style.cursor = "default";
		_contextMenu.style.border = "2px outset";
		_contextMenu.style.left = "0px";
		_contextMenu.style.top = "0px";
		_contextMenu.style.padding = "2px";
		document.writeln(_contextMenu.outerHTML);
		if (!document.getElementById(this.menuId)) {
			alert("Cannot create context menu!\nImpossible de crer le menu contextuel !");
		}
	}
	
	// initializes the context menu
	init();
	this.hide = hideContextMenu;
	this.show = showContextMenu;
}

// hides context menu
function hideContextMenu() {
	if (menu = document.getElementById(this.menuId)) {
		menu.style.display = "none";
	} else {
		alert("Cannot find context menu!\nMenu contextuel introuvable !");
	}
}

// shows the context menu set up with given options where options is an array 
// like "new Array('text 1', 'jscode_1', 'hr', 'text 2', 'jscode_2', ...)"
// where 'hr' insert a horizontal separator
function showContextMenu(options) {
	if (options==null || options.length==0) {
		alert("Context menu options are not specified!\nLes options du menu contextuel ne sont pas spcifie !");
	} else if (menu = document.getElementById(this.menuId)) {
		if (window.event) {
			menu.style.left = window.event.clientX-10;
			menu.style.top = window.event.clientY-10;
		}

		//creates menu table
		table = document.createElement('<table cellspacing="0" cellpadding="0" border="0">');
		table.style.fontFamily = "tahoma";
		table.style.fontSize = "11px";
		table.style.color = "#000000";
		var i=0;
		while (i<options.length) {
			// insert a menu option
			if ((i+1)<options.length && options[i].toUpperCase()!="HR") {
				var row = table.insertRow();
				var cell = row.insertCell();
				cell.onmouseenter = "ContextMenu.hasFocus = true";
				cell.onmouseleave = "ContextMenu.hasFocus = false";
				cell.onblur = "if (!ContextMenu.hasFocus) ContextMenu.hide()";
				cell.nowrap = "true";
				// sets separator
				if (i>0 && options[i-1].toUpperCase()=="HR") {
					cell.style.borderTop = "1px solid #FFFFFF";
					cell.style.paddingTop = "2px";
				} 
				if ((i+3)<options.length && options[i+2].toUpperCase()=="HR") {
					cell.style.borderBottom = "1px solid #808080";
					cell.style.paddingBottom = "3px";
				}
				menuOption = document.createElement("span");
				menuOption.style.width = "100%";
				menuOption.style.padding = "1px";
				menuOption.onclick = 'ContextMenu.hide(); '+options[i+1];
				menuOption.onmouseenter = "this.style.backgroundColor = '#0A246A'; this.style.color = '#FFFFFF'";
				menuOption.onmouseleave = "this.style.backgroundColor = 'transparent'; this.style.color = '#000000'";
				menuOption.innerText = "      "+options[i]+"        ";
				cell.innerHTML = menuOption.outerHTML;
				i+=2;
			} else {
				i++;
			}
		}
		menu.innerHTML = table.outerHTML;

		menu.style.display = "block";
		menu.focus();

	} else {
		alert("Cannot find context menu!\nMenu contextuel introuvable !");
	}
	return true;
}

// initialize global scope context menu object
var ContextMenu = new ContextMenu();

