<?php 

/******************************************************************************
*
*    VisualTextbox V1.1b - Online HTML Editor
*    Copyright (C) 2003  Nicolas Robert-Dehault 
*	 					 visualtextbox@free.fr
*						 http://visualtextbox.free.fr/
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Lesser General Public
*    License as published by the Free Software Foundation; either
*    version 2.1 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Lesser General Public License for more details.
*
*    You should have received a copy of the GNU Lesser General Public
*    License along with this library; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
******************************************************************************/

require_once dirname(__FILE__)."/php/config.inc.php";
require_once dirname(__FILE__)."/php/utils.inc.php";

/**
*	writes HTML and Javascript for a VisualTextbox control according to given arguments
*/
function createVisualTextbox( $path, $name, $content, $class = NULL, $lang = NULL ) {
	
	if ($lang!="") {
		define("VISUALTEXTBOX_LANG", $lang);
	} else if ($_REQUEST['visualTextboxLang']!="") {
		define("VISUALTEXTBOX_LANG", $_REQUEST['visualTextboxLang']);
	} else {
		define("VISUALTEXTBOX_LANG", VISUALTEXTBOX_DEFAULT_LANG);
	}

	if (!preg_match("/MSIE/i", $_SERVER['HTTP_USER_AGENT'])) {
		return '<p style="color: #FF0000; font-family: verdana; font-size: 10px">'.getMessage("Error_Browser").'</p>';
	}
	
	$name = trim($name);
	if ($name=="") {
		return '<p style="color: #FF0000; font-family: verdana; font-size: 10px">'.getMessage("Error_NoControlName").'</p>';
	} else if (!preg_match("/^\w+$/", $name)) {
		return '<p style="color: #FF0000; font-family: verdana; font-size: 10px">'.getMessage("Error_InvalidControlName", $name).'</p>';
	}
	
	$textbox_name = "visualTextbox$name";
	
	$visualTextboxPanelX = ($_REQUEST['visualTextboxPanelX']=="") ? VISUALTEXTBOX_CONTROL_PANEL_DEFAULT_X : "left: {$_REQUEST['visualTextboxPanelX']}";
	$visualTextboxPanelY = ($_REQUEST['visualTextboxPanelY']=="") ? VISUALTEXTBOX_CONTROL_PANEL_DEFAULT_Y : "top: {$_REQUEST['visualTextboxPanelY']}";
	
	ob_start();
	
	?>

<? if (!defined("VISUALTEXTBOX_LOADED")) { ?>

<!-- BEGIN VISUALTEXTBOX CONTROL PANEL -->

	<script src="<?= $path ?>/js/iframeMove.js"></script>
	<script src="<?= $path ?>/js/contextMenu.js"></script>
	<input type="hidden" name="visualTextboxPanelX">
	<input type="hidden" name="visualTextboxPanelY">
	<input type="hidden" name="visualTextboxPanelDisplay">
	<input type="hidden" name="visualTextboxActive">
	<input type="hidden" name="visualTextboxLang" value="<?= VISUALTEXTBOX_LANG ?>">
	<iframe id="visualTextboxPanel" src="<?= $path ?>/php/controlPanel.php?lang=<?= VISUALTEXTBOX_LANG ?>" 
	style="position: absolute; <?= $visualTextboxPanelY ?>; <?= $visualTextboxPanelX ?>; width: 0; height: 0; display: <?= ($_REQUEST['visualTextboxPanelDisplay']=='block') ? 'block' : 'none' ?>" 
	frameborder="0" marginwidth="0" marginheight="0" scrolling="no" onblur="saveVisualTextboxPanelState()"></iframe>
	<script src="<?= $path ?>/js/scripts.js.php?active=<?= $_REQUEST['visualTextboxActive'] ?>&lang=<?= VISUALTEXTBOX_LANG ?>&controlPanelY=<?= preg_replace("/[^0-9]/","",$visualTextboxPanelY) ?>"></script>
	<script src="<?= $path ?>/js/dialog.js.php?lang=<?= VISUALTEXTBOX_LANG ?>"></script>
	<script src="<?= $path ?>/js/writeFile.js.php?file=<?= urlencode("../php/dialog.inc.php") ?>&lang=<?= VISUALTEXTBOX_LANG ?>&path=<?= urlencode($path) ?>"></script>

<!-- END VISUALTEXTBOX CONTROL PANEL -->

<? } ?>

<?
	/***************************************************************
	*
	*						The actual editor
	*
	***************************************************************/
?>
<!-- BEGIN VISUALTEXTBOX EDITOR AREA -->

	<input type="hidden" name="<?= $name ?>">
	<table cellspacing="0" cellpadding="0"><tr><td>
	<span id="<?= $textbox_name ?>" contentEditable="true" <?= $class!="" ? 'class="'.$class.'"' : 'style="border: 2px inset; padding: 3px; background-color: #FFFFFF; font-size: 13px; width: 300; height: 100; color: #000000; word-wrap: break-word; overflow: auto"' ?> 
	onfocus="activeVisualTextbox = this.id; visualTextboxPanel.updateTextFormatControls(); if (document.getElementById('visualTextboxPanel').style.display=='none') { document.getElementById('visualTextboxPanel').style.display = 'block'; saveVisualTextboxPanelState(); } visualTextboxPanel.checkHTMLmode(this.id);"
	onkeydown="return keyPressed(this.id);" onblur="submitVisualTextbox('<?= $textbox_name ?>');" 
	onmouseup="activeTextRange = document.selection.createRange()"
	onkeyup="activeTextRange = document.selection.createRange(); visualTextboxPanel.updateTextFormatControls();" 
	oncontextmenu="showContextMenu(); return false;"
	onclick="visualTextboxPanel.updateTextFormatControls()"
	onpaste="return visualTextboxPanel.editorPaste()"><?= str_replace("\r\n", "", $content) ?></span>
	</td></tr></table>
	<script> VisualTextboxList.push("<?= $textbox_name ?>"); submitVisualTextbox('<?= $textbox_name ?>'); visualTextboxPanel.displayTableBorders(true); </script>

<!-- END VISUALTEXTBOX EDITOR AREA -->

<?
	
	$output = ob_get_contents();
	ob_end_clean();
	
	define("VISUALTEXTBOX_LOADED", 1);
	
	return $output;
}
	
?>

