<?

require_once dirname(__FILE__)."/php/config.inc.php";

if (VISUALTEXTBOX_TEST_MODE!==TRUE) die("You are not allowed to access this ressource.");

?>

<html>
<head>
<style>
	body { font-family: verdana; font-size: 9px }
	td { font-size: 9px }
	.error { background-color: #FF0000; color: #FFFFFF; font-size: 14px; font-weight: bold; text-align: center; }
	.ok { background-color: #00FF00; color: #FFFFFF; font-size: 14px; font-weight: bold; text-align: center; }
	.title { font-size: 18px; text-align: center; font-weight: bold;  }
</style>
</head>
<body>

<?

if (!is_dir(dirname(__FILE__)."/language")) {
	
	echo "Language directory does not exist.";
	
} else {
	
	$languages_dir = dir(dirname(__FILE__)."/language");
	$languages = array();
	while (false !== ($entry = $languages_dir->read())) {
		if (is_dir(dirname(__FILE__)."/language/$entry") && $entry!="." && $entry!=".." && $entry!="common"
			&& is_file(dirname(__FILE__)."/language/$entry/msg.php")) {
			array_push($languages, $entry);
		}
	}
	$languages_dir->close();
	
	if (sizeOf($languages)==0) {
		echo "No language found.";
	} else {
		
		$messages_name = array();
		$messages = array();
		foreach ($languages as $language) {
			$msg = NULL;
			include dirname(__FILE__)."/language/$language/msg.php";
			if (is_array($msg)) {
				$messages_name = array_merge($messages_name, array_keys($msg));
				$messages[$language] = $msg;
			} else {
				$messages[$language] = array();
			}
		}
		$messages_name = array_unique($messages_name);
		sort($messages_name);

		$i = 0;
		echo "<table><tr><td>&nbsp;</td>";
		foreach ($languages as $language) {
			echo "<td class=\"title\">$language</td>";
		}
		echo "</tr>";
		foreach ($messages_name as $message_name) {
			echo '<tr'.(++$i%2 ? ' style="background-color: #BBBBBB"':'' ).'>';
			echo "<td>".htmlentities($message_name)."</td>";
			foreach ($languages as $language) {
				$message = $messages[$language][$message_name];
				if ($message=="") {
					echo '<td class="error">Undefined!</td>';
					$undefined_messages++;
				} else {
					echo "<td>".htmlentities($message)."</td>";
				}
			}
			echo "</tr>";
		}
		echo "</table>";
		
		echo '<p class="'.($undefined_messages==""?'ok':'error').'">'.($undefined_messages==""?0:$undefined_messages).' undefined messages!</p>';
		
	}
}

?>

</body>
</html>