<?php
/**
* Main, main app controller
*
* @name Main
* @verision ---
* @package ---
* @author Rashaud Teague <rashaud.teague@gmail.com>
* @since 03/05/2009
* @license GNU GPL
*/

include 'common.php';

if (!defined('CORE'))
	die('SYSTEM ERROR!');

if (!function_exists('main')) {
	
	function main($args = array()) {
		$p; //page
		$a; //page action
		
		//import important variables
		global $db, $security, $pc, $pv, $uv, $uc, $sys;
		
		if (sizeof($args) > 0) {
			if (!array_key_exists('p', $args))
				die('ERROR: ...');
			if (array_key_exists('a', $args)) {
				$security->validate_action_get($args['a']);
				$a = $args['a'];
			} else {
				$a = 'none';
			}
			$p = $args['p'];
		} else {
			$p = 'main';
			$a = 'none';
		}
		
		//make sure the user is still the user the logged in, in the first place
		if ($security->check_session()) {
			if (getenv('REMOTE_ADDR') != $_SESSION['session_ip'])
				$security->logout_user();
			if (getenv('HTTP_USER_AGENT') != $_SESSION['user_agent'])
				$security->logout_user();
		}
		//see if there is a logged in session on an access only page
		$security->check_page_access($p, $a);
		
		//session user data
		$session_user = array();
		if ($security->check_session())
			$session_user = $uc->user_data($_SESSION['docu_user']);
		
		switch ($p) {
			case 'main':
				$pc->get_sections($tblContents);
				$pc->get_children($tblContents);
				if ($pc->display_tbl_contents($tblContents) != '') {
					print '<div class = "tblc">
					<div class = "tblcontents">'.$pc->display_tbl_contents($tblContents).'
					</div>
					</div>';
				} else {
					print '<div class = "tblc">
					<div class = "tblcontents">There are no pages, <a href = "'.APP_DIR.'?p=new_page">add a page</a>.
					</div>
					</div>';
				}
				break;
			case 'register':
				if (!isset($_POST['submit'])) {
					$uv->register_form();
				} elseif (isset($_POST['submit'])) {
					$uc->validate_registration($_POST['username'], $_POST['email'], $_POST['pass1'], $_POST['pass2']);
				}
				break;
			case 'login':
				if (!isset($_POST['submit'])) {
					$uv->login_form();
				} elseif (isset($_POST['submit'])) {
					$uc->validate_login($_POST['username'], $_POST['password']);
				}
				break;
			case 'logout':
				$security->logout_user();
				break;
			case 'recover':
				if ($security->check_session())
					$security->redirect(APP_DIR.'?p=profile');
				
				if (!isset($_POST['submit'])) {
					$uv->recover_form();
				} elseif (isset($_POST['submit'])) {
					$uc->validate_recover($_POST['email']);
				}
				break;
			case 'profile':
				$sys->bread_crumbs(array(
				'' => 'Main',
				'?p=profile' => 'User Profile'
				));
				if (!isset($_POST['submit'])) {
					$uv->change_profile_form();
				} elseif (isset($_POST['submit'])) {
					$uc->validate_profile_change($_POST['email'],
					$_POST['original_email'], $_POST['pass1'], $_POST['pass2']);
				}
				break;
			case 'new_page':
				$security->validate_get_int($_GET['parent']);
				print '<h3>New Page</h3>';
				if (!isset($_POST['submit'])) {
					$pv->new_page_form(null, $_GET['parent']);
				} elseif (isset($_POST['submit'])) {
					$sys->log_it($session_user, 'New Page');
					$pc->validate_new_page($_POST['title'], $_POST['content'], $_POST['parent']);
				}
				break;
			case 'order':
				$security->validate_get_int($_GET['lvl']);
				print '<h3>Re-Order Pages</h3>';
				$sys->bread_crumbs(array(
				'' => 'Main',
				'#' => 'Re-order Pages'
				));
				$pv->reorder_form(null, $_GET['lvl']);
				break;
			case 'cp':
				if (!isset($_GET['tab']))
					$security->redirect(APP_DIR);
				if ($_GET['tab'] == '')
					$security->redirect(APP_DIR);
				print '<h3>Control Panel</h3>';
					if ($session_user['auth'] < 2)
						$security->redirect(APP_DIR);
					CPANEL::cpanel_main($_GET['tab'], $a);
				break;
			default:
				switch ($a) {
					case 'none':
						$pdata = $pc->get_page_data($p);
						$pc->get_sections($tblContents, $pdata['title']);
						$pc->get_children($tblContents);
						//if ($pc->display_tbl_contents($tblContents) != '')
							print '<div class = "tblc">
							<div class = "tblcontents">'
							.$pc->display_tbl_contents($tblContents, $pdata['id']).'
							</div>
							</div>';
						$pv->render_page($pdata);
						$pc->update_page_views($pdata);
						break;
					case 'edit':
						$pdata = $pc->get_page_data($p);
						$pv->edit_page_header($pdata['title']);
						if (!isset($_POST['submit'])) {
							$pv->edit_page_form(null, $pdata);
						} elseif (isset($_POST['submit'])) {
							$sys->log_it($session_user, 'Edit Page:'.$pdata['title']);
							$pc->validate_page_edit($_POST['title'],
							$_POST['content'], $_POST['parent'], $_POST['merge'], $pdata);
						}
						break;
					case 'show':
						$pdata = $pc->get_page_data($p);
						$pc->fill_page_que($pdata['title']);
						$pc->unhide();
						$sys->log_it($session_user, 'Show Page:'.$pdata['title']);
						$security->redirect(APP_DIR.'?p='.$p);
						break;
					case 'hide':
						$pdata = $pc->get_page_data($p);
						$pc->fill_page_que($pdata['title']);
						$pc->hide();
						$sys->log_it($session_user, 'Hide Page:'.$pdata['title']);
						$security->redirect(APP_DIR.'?p='.$p);
						break;
					case 'delete1':
						$pdata = $pc->get_page_data($p);
						$ppdata = $pc->get_page_data($pdata['parent']);
						$rtn_page = 'main';
						if (sizeof($ppdata) > 0)
							$rtn_page = $ppdata['title'];
						if (!isset($_POST['submit'])) {
							$pv->delete_confirm($pdata['title'], 'delete1');
						} elseif (isset($_POST['submit'])) {
							if ($_POST['backup'])
								$sys->backup(null, false);
							$pc->fill_page_que($pdata['title']);
							$pc->hide();
							$sys->log_it($session_user, 'Delete Page:'.$pdata['title']);
							$pc->delete_page($pdata);
							$security->redirect(APP_DIR.'?p='.$rtn_page);
						}
						break;
					case 'delete2':
						$pdata = $pc->get_page_data($p);
						$ppdata = $pc->get_page_data($pdata['parent']);
						$rtn_page = 'main';
						if (sizeof($ppdata) > 0)
							$rtn_page = $ppdata['title'];
						if (!isset($_POST['submit'])) {
							$pv->delete_confirm($pdata['title'], 'delete2');
						} elseif (isset($_POST['submit'])) {
							if ($_POST['backup'])
								$sys->backup(null, false);
							$pc->fill_page_que($pdata['title']);
							$sys->log_it($session_user, 'Delete Page[Children]:'.$pdata['title']);
							$pc->delete_page_tree();
							$security->redirect(APP_DIR.'?p='.$rtn_page);
						}
						break;
					default:
						print 'Uncharted area...';
				}
		}
	}
	
}
?>
