<?php
/**
* Users View, all interfaces and displays for users (login/register/password recovery/profile)
*
* @name Users View
* @verision --
* @package --
* @author Rashaud Teague <rashaud.teague@gmail.com>
* @since 03/07/2009
* @license GNU GPL
*/

class UserView {
	public function login_form($errors = array()) {
		print '<div class = "logincontainer">
		<div class = "logincontent">
		<div class = "loginheader">User Log in</div><br />
		Are you new here? <a href = "'.APP_DIR.'?p=register">Create an account</a><br />
		'.$this->parse_errors($errors).'
		<form action = "'.APP_DIR.'?p=login" method = "post">
		<table border = "0">
			<tr>
				<td align = "right">Username:</td>
				<td><input type = "text" name = "username" maxlength = "50" /></td>
			</tr>
			<tr>
				<td align = "right">Password:</td>
				<td><input type = "password" name = "password" maxlength = "100" /></td>
			</tr>
			<tr>
				<td></td>
				<td><input type = "submit" name = "submit" value = "Login" /></td>
			</tr>
			<tr>
				<td></td>
				<td><a href = "'.APP_DIR.'?p=recover">I forgot my password, click here</a></td>
			</tr>
		</table>
		</form>
		</div>
		</div>';
	}
	
	public function register_form($errors = array()) {
		global $sys;
		print '<div class = "logincontainer">
		<div class = "logincontent">
		<div class = "loginheader">User Registration</div><br />
		Already a user? <a href = "'.APP_DIR.'?p=login">Go to log in</a><br />
		'.$this->parse_errors($errors);
		if ($sys->get_allow_reg() == 1) {
			print '<form action = "'.APP_DIR.'?p=register" method = "post">
			<table border = "0">
				<tr>
					<td align = "right">Username:</td>
					<td><input type = "text" name = "username" maxlength = "50" /></td>
				</tr>
				<tr>
					<td align = "right">Email Address:</td>
					<td><input type = "text" name = "email" maxlength = "100" /></td>
				</tr>
				<tr>
					<td align = "right">Password:</td>
					<td><input type = "password" name = "pass1" maxlength = "100" /></td>
				</tr>
				<tr>
					<td align = "right">Verify Password:</td>
					<td><input type = "password" name = "pass2" maxlength = "100" /></td>
				</tr>
				<tr>
					<td></td>
					<td><input type = "submit" name = "submit" value = "Register" /></td>
				</tr>
			</table>
			</form>';
		} else {
			print 'We\'re sorry, user registration is blocked off by the admins. 
			You can only be entered into the system manually.';
		}
		print '</div>
		</div>';
	}
	
	public function recover_form($errors = array()) {
		print '<div class = "logincontainer">
		<div class = "logincontent">
		<div class = "loginheader">Password Recovery</div><br />
		< <a href = "'.APP_DIR.'?p=login">Back to log in</a><br />
		'.$this->parse_errors($errors).'
		<form action = "'.APP_DIR.'?p=recover" method = "post">
		<table border = "0">
			<tr>
				<td align = "right">Email Address:</td>
				<td><input type = "text" name = "email" maxlength = "100" /></td>
			</tr>
			<tr>
				<td></td>
				<td><input type = "submit" name = "submit" value = "Recover Password" /></td>
			</tr>
		</table>
		</form>
		</div>
		</div>';
	}
	
	public function change_profile_form($errors = array()) {
		global $uc;
		$udata = $uc->user_data($_SESSION['docu_user']);
		print $this->parse_errors($errors).'
		<form action = "'.APP_DIR.'?p=profile" method = "post">
		<table border = "0">
			<tr>
				<td align = "right">Email Address:</td>
				<td><input type = "text" name = "email" maxlength = "100" value = "'.$udata['email'].'" />
				<input type = "hidden" name = "original_email" value = "'.$udata['email'].'" /></td>
			</tr>
			<tr>
				<td align = "right">New Password:</td>
				<td><input type = "password" name = "pass1" maxlength = "100" /></td>
			</tr>
			<tr>
				<td align = "right">Verify New Password:</td>
				<td><input type = "password" name = "pass2" maxlength = "100" /></td>
			</tr>
			<tr>
				<td></td>
				<td><input type = "submit" name = "submit" value = "Change Profile" />
				<input type = "button" name = "cancel" value = "Cancel" onclick = "window.location = \''.APP_DIR.'\'" /></td>
			</tr>
		</table>
		</form>';
	}
	
	public function user_edit_form($errors = array(), $user) {
		global $uc;
		
		if (!is_numeric($user))
			die('Invalid type passed in UserView::user_edit_form().');
		$udata = $uc->user_data($user);
		
		if ($udata == NULL || sizeof($udata) == 0) {
			print 'This user does not exists.'; return;
		}
		
		print $this->parse_errors($errors).
		'<form action = "'.APP_DIR.'?p=cp&tab=users&a=edit&u='.$user.'" method = "post">
		<table border = "0">
			<tr>
				<td align = "right">Username:</td>
				<td><input type = "text" name = "username" maxlength = "50" value = "'.$udata['username'].'" />
				<input type = "hidden" name = "original_username" value = "'.$udata['username'].'" /></td>
			</tr>
			<tr>
				<td align = "right">Email Address:</td>
				<td><input type = "text" name = "email" maxlength = "100" value = "'.$udata['email'].'" />
				<input type = "hidden" name = "original_email" value = "'.$udata['email'].'" /></td>
			</tr>
			<tr>
				<td align = "right" valign = "top">Authorization Level:</td>
				<td>
				<input type = "radio" name = "auth"';
				if ($udata['auth'] == 0)
					print ' checked = "checked" ';
				print 'value = "0" /> Banned<br />
				<input type = "radio" name = "auth"';
				if ($udata['auth'] == 1)
					print ' checked = "checked" ';
				print 'value = "1" /> Regular User<br />
				<input type = "radio" name = "auth"';
				if ($udata['auth'] == 2)
					print ' checked = "checked" ';
				print 'value = "2" /> Administrator<br />
				<input type = "radio" name = "auth"';
				if ($udata['auth'] == 3)
					print ' checked = "checked" ';
				print 'value = "3" /> Super Administrator
				</td>
			</tr>
			<tr>
				<td></td>
				<td><input type = "submit" name = "submit" value = "Save" /> 
				<input type = "button" name = "cancel" value = "Cancel" onclick = "window.location = \''.APP_DIR.'?p=cp&tab=users\'" /> 
				<input type = "button" name = "delete" value = "Delete '.$udata['username'].'" onclick = "window.location = \''.APP_DIR.'?p=cp&tab=users&a=delete&u='.$user.'\'" /></td>
			</tr>
		</table>
		</form>';
	}
	
	public function list_users(Paginator $pag) {
		global $db;
		
		$sql = "SELECT id, username, email, reg_date, last_ip, auth FROM docu_users ORDER BY username";
		$pag->sql = $sql;
		$pag->display_data();
	}
	
	public function delete_user_confirm($user) {
		global $uc;
		if (!is_numeric($user))
			die('Invalid type passed in UserView::user_edit_form().');
		$udata = $uc->user_data($user);
		
		if ($udata == NULL || sizeof($udata) == 0) {
			print 'This user does not exists.'; return;
		}
		
		print '<form action = "'.APP_DIR.'?p=cp&tab=users&a=delete&u='.$user.'" method = "post">
		Are YOU sure about deleting <strong>'.$udata['username'].'</strong>?! 
		<input type = "submit" name = "submit" value = "Yes" /> 
		<input type = "button" name = "cancel" value = "Cancel" onclick = "window.location = \''.APP_DIR.'?p=cp&tab=users&a=edit&u='.$user.'\'" />
		</form>';
	}
	
	public function add_user_form($errors = array()) {
		print $this->parse_errors($errors).
		'<form action = "'.APP_DIR.'?p=cp&tab=users&a=new" method = "post">
		<table border = "0">
			<tr>
				<td align = "right">Username:</td>
				<td><input type = "text" name = "username" maxlength = "50" /></td>
			</tr>
			<tr>
				<td align = "right">Email Address:</td>
				<td><input type = "text" name = "email" maxlength = "100" /></td>
			</tr>
			<tr>
				<td></td>
				<td><input type = "submit" name = "submit" value = "Save" /> 
				<input type = "button" name = "cancel" value = "Cancel" onclick = "window.location = \''.APP_DIR.'?p=cp&tab=users\'" /></td>
			</tr>
		</table>
		</form>';
	}
	
	public function user_message_form($errors = array()) {
		print $this->parse_errors($errors).
		'<form action = "'.APP_DIR.'?p=cp&tab=users&a=message" method = "post">
		<table border = "0">
			<tr>
				<td>Subject:</td>
			</tr>
			<tr>
				<td><input type = "text" name = "subject" size = "40" /></td>
			</tr>
			<tr>
				<td>Message:</td>
			</tr>
			<tr>
				<td><textarea name = "message" rows = "15" cols = "60"></textarea></td>
			</tr>
			<tr>
				<td><input type = "submit" name = "submit" value = "Send Message" /></td>
			</tr>
		</table>
		</form>';
	}
	
	public function parse_errors($errors) {
		$op = '';
		if (sizeof($errors) > 0) {
			$op .= '<div class = "errors">';
			foreach ($errors as $error) {
				$op .= $error.'<br />';
			}
			$op .= '</div>';
		}
		return $op;
	}
}
?>
