<?php
/**
* Users, user controls and models (form validation and data gathering
*
* @name Users
* @verision --
* @package --
* @author Rashaud Teague <rashaud.teague@gmail.com>
* @since 03/07/2009
* @license GNU GPL
*/

class Users {
	public function validate_registration($username, $email, $pass1, $pass2) {
		global $security, $uv;
		
		$error_array = array();
		
		if (empty($username))
			$error_array[] = 'ERROR: Username field is empty.';
		if ($this->username_exists($username))
			$error_array[] = 'ERROR: This Username is alread in use.';
		if (!$security->is_email($email))
			$error_array[] = 'ERROR: Invalid email address.';
		if ($this->email_exists($email))
			$error_array[] = 'ERROR: An account with this email already exists.';
		if (strlen($pass1) < 5)
			$error_array[] = 'ERROR: Your password needs to be at least 5 characters.';
		if ($pass2 != $pass1)
			$error_array[] = 'ERROR: Your passwords don\'t match.';
		
		if (sizeof($error_array) < 1) {
			$this->save_registration($username, $email, $pass1);
			$security->redirect(APP_DIR.'?p=login');
		} else {
			$uv->register_form($error_array);
		}
	}
	
	private function save_registration($username, $email, $password) {
		global $db;
		
		$pass = trim($password);
		$password = md5($pass);
		unset($pass);
		$sql = "INSERT INTO docu_users (id, username, email, password, reg_date, last_ip) VALUES(
		'',
		'".mysql_real_escape_string(trim($username))."',
		'".mysql_real_escape_string(trim($email))."',
		'$password',
		'".time()."',
		'".getenv('REMOTE_ADDR')."'
		)";
		$db->exe_sql($sql);
	}
	
	public function validate_login($username, $password) {
		global $security, $uv, $uc;
		
		$error_array = array();
		
		if (!$this->account_exists($username, $password))
			$error_array[] = 'ERROR: Invalid username/password combination.';
		$udata = $this->user_data($username);
		if ($udata['auth'] == 0)
			$error_array[] = 'ERROR: You are currently banned.';
		
		if (sizeof($error_array) < 1) {
			$security->login_user($username);
		} else {
			$uv->login_form($error_array);
		}
	}
	
	public function email_exists($email) {
		global $db;
		
		$sql = "SELECT * FROM docu_users WHERE email = '".mysql_real_escape_string(trim($email))."'";
		$db->exe_sql($sql);
		
		if ($db->num_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}
	
	public function username_exists($username) {
		global $db;
		
		$sql = "SELECT * FROM docu_users WHERE username = '".mysql_real_escape_string(trim($username))."'";
		$db->exe_sql($sql);
		
		if ($db->num_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}
	
	public function account_exists($username, $password) {
		global $db;
		
		$sql = "SELECT * FROM docu_users WHERE username = '".mysql_real_escape_string(trim($username))."'
		AND password = '".md5($password)."'";
		$db->exe_sql($sql);
		
		if ($db->num_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}
	
	public function update_last_ip($username) {
		global $db;
		
		$sql = "UPDATE docu_users SET last_ip = '".getenv('REMOTE_ADDR')."'
		WHERE username = '".mysql_real_escape_string(trim($username))."'";
		$db->exe_sql($sql);
	}
	
	public function user_data($id_email_username) {
		global $db, $security;
		
		$sql = "SELECT * FROM docu_users WHERE ";
		if (is_numeric($id_email_username)) {
			$sql .= "id = '$id_email_username'";
		} else {
			if ($security->is_email($id_email_username)) {
				$sql .= "id = '".$this->get_id_by_email($id_email_username)."'";
			} else {
				$sql .= "id = '".$this->get_id_by_username($id_email_username)."'";
			}
		}
		//print $sql;die();
		$db->exe_sql($sql);
		$row = $db->fetch_array();
		
		$data = array();
		
		$data['id'] = $row['id'];
		$data['username'] = stripslashes($row['username']);
		$data['email'] = stripslashes($row['email']);
		$data['reg_date'] = date("M-d Y H:i:s a", $row['reg_date']);
		$data['last_ip'] = stripslashes($row['last_ip']);
		$data['auth'] = $row['auth'];
		//print_r($data);die();
		return $data;
	}
	
	public function get_id_by_email($email) {
		global $db;
		
		$sql = "SELECT id FROM docu_users WHERE email = '".mysql_real_escape_string(trim($email))."'";
		$db->exe_sql($sql);
		$row = $db->fetch_array();
		
		return $row['id'];
	}
	
	public function get_id_by_username($username) {
		global $db;
		
		$sql = "SELECT id FROM docu_users WHERE username = '".mysql_real_escape_string(trim($username))."'";
		$db->exe_sql($sql);
		$row = $db->fetch_array();
		
		return $row['id'];
	}
	
	public function validate_profile_change($email, $original_email, $pass1, $pass2) {
		global $security, $uv;
		
		$error_array = array();
		
		if (!$security->is_email($email))
			$error_array[] = 'ERROR: Invalid email address.';
		if ($email != $original_email)
			if ($this->email_exists($email))
				$error_array[] = 'ERROR: This email address is already in use.';
		if ($pass1 != '') {
			if (strlen($pass1) < 5)
				$error_array[] = 'ERROR: Your password needs to be at least 5 characters.';
			if ($pass2 != $pass1)
				$error_array[] = 'ERROR: Your passwords don\'t match.';
		}
		if (sizeof($error_array) < 1) {
			$this->save_profile($email, $pass1);
			//$security->redirect(APP_DIR.'?p=profile');
			print 'Your profile has been saved!<br />';
			$uv->change_profile_form();
		} else {
			$uv->change_profile_form($error_array);
		}
	}
	
	private function save_profile($email, $pass1) {
		global $db;
		
		$pass = trim($pass1);
		$password = md5($pass);
		
		$sql = "UPDATE docu_users SET email = '".mysql_real_escape_string(trim($email))."'";
		 if ($pass1 != '')
		 	$sql .= ", password = '$password' ";
		 $sql .= " WHERE id = '".$_SESSION['docu_user']."'";
		$db->exe_sql($sql);
	}
	
	public function validate_recover($email) {
		global $security, $uv;
		
		$error_array = array();
		
		if (!$this->email_exists($email))
			$error_array[] = 'ERROR: There is no account with this email address.';
		
		if (sizeof($error_array) < 1) {
			$this->reset_password($email);
			print 'Your new password has been sent to '.$email.'. Please wait...';
			$security->redirect(APP_DIR.'?p=login', 3000);
		} else {
			$uv->recover_form($error_array);
		}
	}
	
	private function reset_password($email) {
		global $db, $sys;
		
		$code = rand(100, 999);
		$password = md5('docu'.$code);
		
		$sql = "UPDATE docu_users SET password = '$password' WHERE email = '".mysql_real_escape_string(trim($email))."'";
		$db->exe_sql($sql);
		
		//include CORE.'emailer.php';
		$message = 'Your new password is: <strong>docu'.$code.'</strong>';
		$from = array('site' => $sys->get_org_name(), 'site_email' => $sys->get_org_email());
		$e = new emailer($email, 'Password Recovery', $message, $from);
	}
	
	public function validate_edit_user($username, $original_username, $email, $original_email, $auth, $user) {
		global $security, $uv;
		$error_array = array();
		
		if (empty($username))
			$error_array[] = 'ERROR: Username field is empty.';
		if ($username != $original_username)
			if ($this->username_exists($username))
				$error_array[] = 'ERROR: This username is already in use.';
		if (!$security->is_email($email))
			$error_array[] = 'ERROR: Invalid email address.';
		if ($email != $original_email)
			if ($this->email_exists($email))
				$error_array[] = 'ERROR: This email address is already in use.';
		
		if (sizeof($error_array) < 1) {
			$this->save_edit_user($username, $email, $auth, $user);
			$security->redirect(APP_DIR.'?p=cp&tab=users');
		} else {
			$uv->user_edit_form($error_array, $user);
		}
	}
	
	private function save_edit_user($username, $email, $auth, $user) {
		global $db;
		
		if (!is_numeric($auth))
			die('Invalid type passed in Users::save_edit_user().');
		if (!is_numeric($user))
			die('Invalid type passed in Users::save_edit_user().');
		
		$sql = "UPDATE docu_users SET
		username = '".mysql_real_escape_string(trim($username))."',
		email = '".mysql_real_escape_string(trim($email))."',
		auth = '$auth'
		WHERE id = '$user'";
		$db->exe_sql($sql);
	}
	
	public function delete_user($user) {
		global $db;
		if (!is_numeric($user))
			die('Invalid type passed in Users::delete_user().');
		
		$sql = "DELETE FROM docu_users WHERE id = '$user'";
		$db->exe_sql($sql);
	}
	
	public function validate_add_user($username, $email) {
		global $security, $uv;
		
		$error_array = array();
		
		if (empty($username))
			$error_array[] = 'ERROR: Username field is empty.';
		if ($this->username_exists($username))
			$error_array[] = 'ERROR: This Username is alread in use.';
		if (!$security->is_email($email))
			$error_array[] = 'ERROR: Invalid email address.';
		if ($this->email_exists($email))
			$error_array[] = 'ERROR: An account with this email already exists.';
		
		if (sizeof($error_array) < 1) {
			$this->save_add_user($username, $email);
			$security->redirect(APP_DIR.'?p=cp&tab=users');
		} else {
			$uv->add_user_form($error_array);
		}
	}
	
	private function save_add_user($username, $email) {
		global $db, $sys;
		
		$rand_code = rand(1000, 9999);
		$pass = trim('docu'.$rand_code);
		$password = md5($pass);
		unset($pass);
		$sql = "INSERT INTO docu_users (id, username, email, password, reg_date, last_ip) VALUES(
		'',
		'".mysql_real_escape_string(trim($username))."',
		'".mysql_real_escape_string(trim($email))."',
		'$password',
		'".time()."',
		'".getenv('REMOTE_ADDR')."'
		)";
		$db->exe_sql($sql);
		
		$message = 'You have been added to '.$sys->get_org_name().' Maris SimpleDocu Application<br />
		Your password is: <strong>docu'.$rand_code.'</strong><br />';
		$from = array('site' => $sys->get_org_name(), 'site_email' => $sys->get_org_email());
		$e = new emailer($email, 'New user to '.$sys->get_org_name().' Maris SimpleDocu Application', $message, $from);
	}
	
	public function user_count() {
		global $db;
		
		$sql = "SELECT * FROM docu_users";
		$db->exe_sql($sql);
		
		return ($db->num_rows() > 0) ? $db->num_rows() : 0;
	}
	
	public function validate_send_message($subject, $message) {
		global $uv;
		
		$error_array = array();
		
		if (empty($subject))
			$error_array[] = 'ERROR: Subject is empty.';
		if (empty($subject))
			$error_array[] = 'ERROR: Message is empty.';
		
		if (sizeof($error_array) < 1) {
			$this->send_message($subject, $message);
		} else {
			$uv->user_message_form($error_array);
		}
	}
	
	private function send_message($subject, $message) {
		global $db, $sys;
		
		$sql = "SELECT email FROM docu_users";
		$db->exe_sql($sql);
		
		while ($row = $db->fetch_array()) {
			$from = array('site' => $sys->get_org_name(), 'site_email' => $sys->get_org_email());
			$e = new emailer($row['email'], $subject, $message, $from);
		}
	}
}
?>
