<?php
/**
* Sys...short for System (obviously)
*
* @name Sys
* @verision ---
* @package ---
* @author Rashaud Teague <rashaud.teague@gmail.com>
* @since 03/12/2009
* @license GNU GPL
*/

class SYS {
	protected $org_name;
	protected $site_url;
	protected $org_email;
	protected $doc_title;
	protected $allow_registration;
	
	public $db_tables = array('docu_users', 'pages', 'sys_config');
	
	public function __construct() {
		global $db;
		
		$sql = "SELECT * FROM sys_config LIMIT 1";
		$db->exe_sql($sql);
		$row = $db->fetch_array();
		
		$this->org_name = stripslashes($row['org_name']);
		$this->site_url = stripslashes($row['site_url']);
		$this->org_email = stripslashes($row['org_email']);
		$this->doc_title = stripslashes($row['doc_title']);
		$this->allow_registration = $row['allow_registration'];
	}
	
	public function get_org_name() {
		return $this->org_name;
	}
	
	public function get_site_url() {
		return $this->site_url;
	}
	
	public function get_org_email() {
		return $this->org_email;
	}
	
	public function get_doc_title() {
		return $this->doc_title;
	}
	
	public function get_allow_reg() {
		return $this->allow_registration;
	}
	
	public function sys_edit_form($errors = array()) {
		print $this->parse_errors($errors).'
		<form action = "'.APP_DIR.'?p=cp&tab=sys" method = "post">
		<table border = "0">
			<tr>
				<td align = "right">Organization Name:</td>
				<td><input type = "text" name = "org_name" maxlength = "100" value = "'.$this->org_name.'" /></td>
			</tr>
			<tr>
				<td align = "right">Site URL:</td>
				<td><input type = "text" name = "site_url" maxlength = "150" value = "'.$this->site_url.'" /></td>
			</tr>
			<tr>
				<td align = "right">Organization Email:</td>
				<td><input type = "text" name = "org_email" maxlength = "100" value = "'.$this->org_email.'" /></td>
			</tr>
			<tr>
				<td align = "right">Documentation/Manual Title:</td>
				<td><input type = "text" name = "doc_title" maxlength = "50" value = "'.$this->doc_title.'" /></td>
			</tr>
			<tr>
				<td align = "right">Allow User Registration:</td>
				<td>Yes: <input type = "radio" name = "allow_registration"';
				if ($this->allow_registration == 1)
					print ' checked = "checked" ';
				print 'value = "1" /> 
				No: <input type = "radio" name = "allow_registration"';
				if ($this->allow_registration == 0)
					print ' checked = "checked" ';
				print 'value = "0" /></td>
			</tr>
			<tr>
				<td></td>
				<td><input type = "submit" name = "submit" value = "Save" /> 
				<input type = "button" name= "cancel" value = "Cancel" onclick = "window.location = \''.APP_DIR.'?p=cp&tab=main\'" /></td>
			</tr>
		</table>
		</form>';
	}
	
	public function validate_sys_edit($org_name, $site_url, $org_email, $doc_title, $allow_registration) {
		global $security;
		$error_array = array();
		if (empty($org_name))
			$error_array[] = 'ERROR: Organization Name is empty.';
		if (empty($site_url))
			$error_array[] = 'ERROR: Site URL is empty.';
		if (!$security->is_email($org_email))
			$error_array[] = 'ERROR: Invalid email address for Organization Email.';
		if (empty($doc_title))
			$error_array[] = 'ERROR: Documentation Title is empty.';
		
		if (sizeof($error_array) < 1) {
			$this->save_sys($org_name, $site_url, $org_email, $doc_title, $allow_registration);
			$security->redirect(APP_DIR.'?p=cp&tab=main');
		} else {
			$this->sys_edit_form($error_array);
		}
	}
	
	public function save_sys($org_name, $site_url, $org_email, $doc_title, $allow_registration) {
		global $db;
		
		$sql = "UPDATE sys_config SET
		org_name = '".mysql_real_escape_string(trim($org_name))."',
		site_url = '".mysql_real_escape_string(trim($site_url))."',
		org_email = '".mysql_real_escape_string(trim($org_email))."',
		doc_title = '".mysql_real_escape_string(trim($doc_title))."',
		allow_registration = '$allow_registration'
		LIMIT 1";
		
		$db->exe_sql($sql);
	}
	
	public function bread_crumbs($crumbs = array()) {
		if (gettype($crumbs) != 'array')
			die('ERROR: Invalid type passed in SYS::bread_crumbs().');
		
		$size = sizeof($crumbs);
		$count = 1;
		print '<p class = "breadcrumbs">';
		foreach ($crumbs as $key => $val) {
			print '<a href = "';
			if ($key == '#') { print '#'; } else { print APP_DIR.$key; }
			print '" title = "'.$val.'">'.$val.'</a>';
			if ($count < $size)
				print ' <small>>></small> ';
			$count++;
		}
		print '</p>';
	}
	
	public function check_version_update() {
		$app_dl_page = 'http://marislabs.org/ext/apps/?p=desc&app=18';
		$lines = file($app_dl_page);
		$version = '';
		for ($i = 0; $i < sizeof($lines); $i++) {
			if (preg_match("/\<td\>Version:\<\/td\>.*?/i", str_replace("\t", "", $lines[$i]))) {
				$version = str_replace("\t", "", $lines[$i+1]);
				break;
			}
		}
		preg_match("/^\<td\>v(.*?)\<\/td\>/", $version, $matches);
		$version = $matches[1];
		return (APP_VERSION < $version) ? true : false;
	}
	
	public function get_current_version() {
		$app_dl_page = 'http://marislabs.org/ext/apps/?p=desc&app=18';
		$lines = file($app_dl_page);
		$version = '';
		for ($i = 0; $i < sizeof($lines); $i++) {
			if (preg_match("/\<td\>Version:\<\/td\>.*?/i", str_replace("\t", "", $lines[$i]))) {
				$version = str_replace("\t", "", $lines[$i+1]);
				break;
			}
		}
		preg_match("/^\<td\>v(.*?)\<\/td\>/", $version, $matches);
		$version = $matches[1];
		return $version;
	}
	
	public function text_parse($text) {
		global $security;
		
		$text = preg_replace("/\t/i", "&nbsp;&nbsp;&nbsp;&nbsp;", $text);
		
		$pre_occurance = 0;
		
		$clines = preg_split("/\n/", $text);
		for ($i = 0; $i < sizeof($clines); $i++) {
			$cwords = preg_split("/\s+/", $clines[$i]);
			if (preg_match("/\[code[^\]]/i", $clines[$i])) $pre_occurance = 1;
			if (preg_match("/\[\/code\]/i", $clines[$i])) $pre_occurance = 0;
			for ($j = 0; $j < sizeof($cwords); $j++) {
				if ($pre_occurance == 0) {
					if (preg_match("/^[^\<a|i][fht]*t[tps]:\/\/.*?/i", $cwords[$j]))
						$cwords[$j] = str_replace($cwords[$j],
						'<a href = "'.$cwords[$j].'" title = "'.$cwords[$j].'">'.$cwords[$j].'</a>', $cwords[$j]);
					if ($security->is_email($cwords[$j]))
						$cwords[$j] = str_replace($cwords[$j],
						'<a href = "mailto:'.$cwords[$j].'" title = "'.$cwords[$j].'">'.$cwords[$j].'</a>', $cwords[$j]);
					if (preg_match("/^w{3}\.[\..]*/i", $cwords[$j]))
						$cwords[$j] = str_replace($cwords[$j],
						'<a href = "http://'.$cwords[$j].'" title = "'.$cwords[$j].'">'.$cwords[$j].'</a>', $cwords[$j]);
				}
			}
			$clines[$i] = implode(' ', $cwords);
		}
		$puts = implode("\n", $clines);
		
		$parsed_text = $puts;
		//bb code translation (the basic tags not the url, color, and img, those are parsed above)
		$bb_finds = array('/\[b\]/i', '/\[\/b\]/i', '/\[u\]/i', '/\[\/u\]/i',
						'/\[i\]/i', '/\[\/i\]/i', '/\[s\]/i','/\[\/s\]/i', '/\[quote\]/i', '/\[\/quote\]/i');
		$bb_replace = array('<strong>', '</strong>', '<u>', '</u>', '<em>',
						'</em>', '<strike>', '</strike>', '<div class = "quote">', '</div>');
		$parsed_text = preg_replace($bb_finds, $bb_replace, $parsed_text);
		//other bb code tags and other tags
		$obb_finds = array('/\[url](.*?)\[\/url]/i', '/\[img\](.*?)\[\/img\]/', '/\[url=(.*?)\](.*?)\[\/url\]/i',
							'/\[color=(.*?)\]/i', '/\[\/color\]/i', '/\[\[(.*?)\]\]/i', '/\[code=(.*?)\]/i',
							'/\[\/code\]/i');
		$obb_replace = array('<a href = "$1" title = "$1">$1</a>', '<img src = "$1" border = "0" />',
							'<a href = "$1" title = "$1">$2</a>', '<span style = "color: $1;">',
							'</span>', '<a href = "'.APP_DIR.'?p=$1" title = "$1">$1</a>',
							'<pre name = "code" class = "$1">', '</pre>');
		
		$parsed_text = preg_replace($obb_finds, $obb_replace, $parsed_text);
		$parsed_text = htmlspecialchars_decode(stripslashes($parsed_text));
		
		return $parsed_text;
	}
	
	public function nl2brPre($string, $is_xhtml = true) {
		$str = explode("\n", $string);
		$op = '';
		for ($i = 0; $i < sizeof($str); $i++) {
			if (preg_match("/\<pre[^\>]/i", $str[$i])) {
				$op .= trim($str[$i])."\n";
				$n = $i+1;
				for ($j = $n; $j < sizeof($str); $j++, $i++) {
					if (preg_match("/\<\/pre>/i", $str[$j])) {
						$op .= trim($str[$j]);//(($is_xhtml == true) ? '<br />' : '<br>');
						break;
					}
					if (preg_match("/\<\?php/i", $str[$j]))
						$str[$j] = preg_replace("/\<(\?php)/i", "&lt;$1", $str[$j]);
					$op .= trim($str[$j])."\n";
				}
			} else {
				$op .= trim($str[$i]).(($is_xhtml == true) ? '<br />' : '<br>');
			}
		}
		return $op;
	}
	
	public function backup($debug = 0, $redirect = true) {
		global $db, $security;
		
		$content = '';
		$nl = "\n";
		if ($debug)
			$nl = "<br />";
		
		for ($i = 0; $i < sizeof($this->db_tables); $i++) {
			$sql = "SELECT * FROM ".$this->db_tables[$i];
			$db->exe_sql($sql);
			$num_rows = $db->num_rows();
			$content .= 'INSERT INTO `'.$this->db_tables[$i].'` VALUES'.$nl;
			$fields = array();
			while ($field = $db->fetch_field())
				$fields[] = $field->name;
			
			$count = 1;
			while ($row = $db->fetch_array()) {
				$content .= '(';
				foreach ($fields as $f)
					$content .= '\''.$row[$f].'\', ';
				$content .= ')';
				if ($num_rows > 1)
					if ($count < $num_rows)
						$content .= ',';
				$content .= ($count == $num_rows) ? ';'.$nl : $nl;
				$count++;
			}
			$content .= $nl;
		}
		
		$content = preg_replace("/,\s\)/i", ")", $content);
		if ($debug) return $content;
		
		$backup_file = APP_DIR.'tmp_files/docu_backup_'.date('M-d-Y_H-i-s').'.sql';
		$backup_filename_split = explode('/', $backup_file);
		if (file_exists($backup_file)) unlink($backup_file);
		$pFile = fopen($backup_file, 'w');
		fwrite($pFile, $content);
		fclose($pFile);
		chdir('tmp_files');
		$command = 'tar -zcf '.str_replace('.sql', '.tar.gz', $backup_filename_split[(sizeof($backup_filename_split)-1)])
		.' '.$backup_filename_split[(sizeof($backup_filename_split)-1)];
		//return $command;
		exec($command);
		if ($redirect)
			$security->redirect(str_replace('.sql', '.tar.gz', $backup_file));
	}
	
	public function log_it($user, $action) {
		if (!is_array($user))
			die('ERROR: Invalid type passed to SYS::logit().');
		
		/*
		Log format
		----------
		username,action,authority,ip,datetime
		*/
		$line = $user['username'].','
		.trim($action).','
		.$user['auth'].','
		.$_SESSION['session_ip'].','
		.date('M-d Y H:i:s A')."\n";
		
		$pFile = fopen('logs/user_log.txt', 'a');
		fwrite($pFile, $line);
		fclose($pFile);
	}
	
	public function user_log_data() {
		$op = array();
		if (file_exists('logs/user_log.txt')) {
			$lines = file('logs/user_log.txt');
			if (sizeof($lines) > 0) { 
				$ordered = array_reverse($lines);
				unset($lines);
				foreach ($ordered as $r)
				$op[] = trim($r);
			}
		}
		return $op;
	}
	
	public function user_log_view($limit = 10) {
		$data = $this->user_log_data();
		print '<p>
		User activity log:<br />
		<table class = "datatbl" border = "0" width = "85%">
			<tr>
				<th>User</th>
				<th>Action</th>
				<th>Authorization</th>
				<th>IP Address</th>
				<th>Datetime</th>
			</tr>';
		$count = 1;
		if (sizeof($data) > 0) {
			foreach ($data as $dlines) {
				$fields = explode(',', $dlines);
				if ($count % 2 == 0) {
					print '<tr class = "datatblrow">';
				} else {
					print '<tr>';
				}
				foreach ($fields as $field) {
					print '<td>'.$field.'</td>';
				}
				print '</tr>';
				if ($count >= $limit)
					break;
				$count++;
			}
		} else {
			print '<tr>
			<td colspan = "5">No log data.</td>
			</tr>';
		}
		print '</table>
		</p>';
	}
	
	public function recent_backup_files() {
		$dir = opendir('tmp_files');
		$op = array();
		
		while ($files = readdir($dir)) {
			if ($files != '.' && $files != '..') {
				$fsplit = explode('.', $files);
				$type = $fsplit[(sizeof($fsplit)-2)].'.'.$fsplit[(sizeof($fsplit)-1)];
				if ($type == 'tar.gz')
					$op[] = $files;
			}
		}
		closedir($dir);
		return $op;
	}
	
	public function recent_backup_files_view($limit = 10) {
		$data = $this->recent_backup_files();
		sort($data);
		print '<p>
		<table class = "datatbl" border = "0" width = "30%">
			<tr>
				<th>Files</th>
			</tr>';
		$count = 1;
		foreach ($data as $d) {
			if ($count % 2 == 0) {
				print '<tr class = "datatblrow">';
			} else {
				print '<tr>';
			}
			print '<td><a href = "tmp_files/'.$d.'" title = "Download '.$d.'">'.$d.'</a></td>';
			print '</tr>';
			if ($count >= $limit)
				break;
			$count++;
		}
		print '</table>
		</p>';
	}
	
	public function empty_tmp() {
		exec('rm '.APP_DIR.'tmp_files/*.sql');
		exec('rm '.APP_DIR.'tmp_files/*.tar.gz');
	}
	
	public function parse_errors($errors) {
		$op = '';
		if (sizeof($errors) > 0) {
			$op .= '<div class = "errors">';
			foreach ($errors as $error) {
				$op .= $error.'<br />';
			}
			$op .= '</div>';
		}
		return $op;
	}
}
?>
