<?php
/**
* Paginator sorts data into pages...
*
* @name Paginator
* @verision 0.5.0
* @package Maris Engine
* @author Rashaud Teague <rashaud.teague@gmail.com>
* @since 02/23/2009
* @license GNU LGPL
* @Copyright (c) 2009 Maris Labs
*/

class Paginator {
	/**
	* @var $limit
	* Limit of records displayed per page.
	*/
	public $limit;
	
	/**
	* @var $page
	* Current page of the data display
	*/
	public $page;
	
	/**
	* @var $sql
	* The initial sql string
	*/
	public $sql;
	
	/**
	* void __construct($sql, $limit [, $page])
	*
	* Initiates standard class data to work with the paginator class
	*
	* @param string $sql
	* @param int $limit
	* @param int $page
	*/
	
	public function __construct($sql, $limit, $page = 0) {
		$this->limit = $limit;
		$this->sql .= $sql;
		
		if ($page == 0 || $page == NULL) {
			$this->page = 1;
		} else {
			if (!is_numeric($page)) {
				die('ERROR: Page number is not numeric.');
			}
			$this->page = $page;
		}
	}
	
	/**
	* void display_data()
	*
	* Displays "the" data
	*
	*/
	
	public function display_data() {
		$start = ($this->page - 1) * $this->limit;
		
		$this->sql .= " LIMIT ".$start.",".$this->limit;
		$result = mysql_query($this->sql) or die(mysql_error());
		
		preg_match("/^SELECT(.*?)FROM/i", $this->sql, $matches);
		
		$fields = explode(',', $matches[1]);
		$tblFields = array();
		
		foreach ($fields as $field) {
			$tblFields[] = trim($field);
		}
		/* MODIFIED FOR MARIS SIMPLEDOCU */
		print '<table class = "datatbl" border = "0" width = "85%">
			<tr>';
		
		foreach($tblFields as $tblField) {
			print '<th>'.ucfirst($tblField).'</th>';
		}
		print '</tr>';
		
		$count = 1;
		while ($row = mysql_fetch_array($result)) {
			if ($count % 2 == 0) {
				print '<tr class = "datatblrow">';
			} else {
				print '<tr>';
			}
			foreach($tblFields as $tblField) {
				/* MODIFIED FOR MARIS SIMPLEDOCU */
				if ($tblField == 'reg_date') {
					print '<td>'.date('M-d Y H:i:s A', $row[$tblField]).'</td>';
				} elseif ($tblField == 'id' || $tblField == 'username' || $tblField == 'email') {
					print '<td><a href = "'.APP_DIR.'?p=cp&tab=users&a=edit&u='.$row['id'].'" 
					title = "Edit '.stripslashes($row['username']).'">';
					if ($tblField == 'username' || $tblField == 'email') {
						print stripslashes($row[$tblField]);
					} else {
						print $row[$tblField];
					}
					print '</a></td>';
				} else {
					print '<td>'.$row[$tblField].'</td>';
				}
			}
			print '</tr>';
			$count++;
		}
		print '</table>';
		
		$this->paging();
	}
	
	/**
	* void paging()
	*
	* Prints out page links
	*/
	
	protected function paging() {
		
		$total_pages = ceil($this->row_count() / $this->limit);
		
		print '<br />';
		/* EDITED FOR MARIS SIMPLEDOCU */
		if ($this->page > 1) {
			$previous_page = $this->page - 1;
			print '<a href = "'.APP_DIR.'?';
				foreach ($_GET as $key => $val)
					if ($key != 'pagenum')
						print $key.'='.$val.'&';
			print 'pagenum=1">FIRST</a> ';
			print '<a href = "'.APP_DIR.'?';
				foreach ($_GET as $key => $val)
					if ($key != 'pagenum')
						print $key.'='.$val.'&';
			print 'pagenum='.$previous_page.'">PREV</a> ';
		}
		
		for ($i = 1; $i <= $total_pages; $i++) {
			if ($this->page == $i) {
				print '<strong>'.$i.'</strong> ';
			} else {
				print '<a href = "'.APP_DIR.'?';
				foreach ($_GET as $key => $val)
					if ($key != 'pagenum')
						print $key.'='.$val.'&';
				print 'pagenum='.$i.'">'.$i.'</a> ';
			}
		}
		
		if ($total_pages > 1) {
			if ($this->page < $total_pages) {
				$next_page = $this->page + 1;
				print '<a href = "'.APP_DIR.'?';
				foreach ($_GET as $key => $val)
					if ($key != 'pagenum')
						print $key.'='.$val.'&';
				print 'pagenum='.$next_page.'">NEXT</a> ';
				print '<a href = "'.APP_DIR.'?';
				foreach ($_GET as $key => $val)
					if ($key != 'pagenum')
						print $key.'='.$val.'&';
				print 'pagenum='.$total_pages.'">LAST</a>';
			}
		}
	}
	
	/**
	* int row_count()
	*
	* Returns the row count of the sql query
	*
	* @return int $count
	*/
	
	public function row_count() {
		if ($this->sql != '') {
			$result = mysql_query(preg_replace("/LIMIT.*$/i", "", $this->sql)) or die(mysql_error());
		} else {
			die('ERROR: For some reason the sql string is empty.');
		}
		
		$count = mysql_num_rows($result);
		return $count;
	}
}
?>
