<?php
/**
* Pages View, has all page interfaces, like forms and page rendering
*
* @name Pages
* @verision --
* @package --
* @author Rashaud Teague <rashaud.teague@gmail.com>
* @since 03/06/2009
* @license GNU GPL
*/

class PageViews {
	public function render_page($page_data) {
		global $security, $pc, $sys;
		if (gettype($page_data) != 'array')
			die('ERROR: Invalid type passed to PageViews::render_page().');
		
		//start rendering with the page_data
		print '<p>
		<div class = "pagecontainer">
		<h3>';
		if (sizeof($page_data) == 0) {
			print 'Page does not exists.';
		} else {
			print $page_data['title'];
		}
		print '</h3>';
		if ($security->check_session())
			if (sizeof($page_data) > 0)
				print '[ <a href = "'.APP_DIR.'?p='.str_replace(' ', '_', stripslashes($page_data['title'])).'&a=edit">Edit this Page</a> ]';
		print '<div class = "date_info">
		<em>
		Start Date '.$page_data['post_date'].', Last Update '.$page_data['last_update'].', From '.$page_data['last_ip'].'
		</em>
		</div><br />
		<div class = "pagecontent">';
		if (sizeof($page_data) == 0) {
			print 'Page does not exists.';
		} else {
			print $sys->nl2brPre($page_data['content']);
		}
		print '<br /><br />
		'.$this->page_nav($pc->get_left_page_nav($page_data['id']), $pc->get_up_page_nav($page_data['id']), $pc->get_right_page_nav($page_data['id'])).'
		</div>
		</div>
		</p>';
	}
	
	public function edit_page_header($page) {
		print '<h3>Editing '.$page.'</h3>';
	}
	
	public function edit_page_form($errors = array(), $data) {
		global $pc;
		
		if (!is_array($data))
			die('ERROR: Invalid type passed in second parameter in PageViews::edit_page_form().');
		
		print $this->parse_errors($errors).
		'<form action = "'.APP_DIR.'?p='.str_replace(' ', '_', $data['title']).'&a=edit" method = "post">
		<table border = "0">
			<tr>
				<td colspan = "2"><strong>Page Title:</strong></td>
			</tr>
			<tr>
				<td colspan = "2"><input type = "text" name = "title" size = "50" maxlength = "50" value = "'.$data['title'].'" /></td>
			</tr>
			<tr>
				<td colspan = "2"><strong>Content:</strong></td>
			</tr>
			<tr>
				<td colspan = "2"><script>edToolbar(\'content\'); </script>
				<textarea name = "content" id = "content" class = "ed">'.$data['content'].'</textarea></td>
			</tr>
			<tr>
				<td colspan = "2">Parent Page:</td>
			</tr>
			<tr>
				<td colspan = "2">'.$this->parent_options($data['parent'], $data['id']).'</td>
			</tr>
			<tr>
				<td colspan = "2">Page Operations:</td>
			</tr>
			<tr>
				<td colspan = "2">';
				if ($data['hidden'] == 0) {
					print '<input type = "button" name = "hide" value = "Hide" onclick = "window.location = \''.APP_DIR.'?p='.$data['title'].'&a=hide\'" />';
				} else {
					print '<input type = "button" name = "show" value = "Show" onclick = "window.location = \''.APP_DIR.'?p='.$data['title'].'&a=show\'" />';
				}
				print ' <input type = "button" name = "delete1" value = "Delete Page" onclick = "window.location = \''.APP_DIR.'?p='.$data['title'].'&a=delete1\'" /> <input type = "button" name = "delete2" value = "Delete Page AND Children" onclick = "window.location = \''.APP_DIR.'?p='.$data['title'].'&a=delete2\'" /> 
				'.$this->merge_options($data['id']).'
				</td>
			</tr>
			<tr>
				<td></td>
				<td><input type = "submit" name = "submit" value = "Save" /> <input type = "button" name = "cancel" value = "Cancel" onclick = "window.location = \''.APP_DIR.'?p='.$data['title'].'\'" /></td>
			</tr>
		</table>
		</form>';
	}
	
	public function new_page_form($errors = array(), $parent = 0) {
		global $pc;
		
		print $this->parse_errors($errors).
		'<form action = "'.APP_DIR.'?p=new_page&parent='.$parent.'" method = "post">
		<table border = "0">
			<tr>
				<td colspan = "2"><strong>Page Title:</strong></td>
			</tr>
			<tr>
				<td colspan = "2"><input type = "text" name = "title" size = "50" maxlength = "50" /></td>
			</tr>
			<tr>
				<td colspan = "2"><strong>Content:</strong></td>
			</tr>
			<tr>
				<td colspan = "2"><script>edToolbar(\'content\'); </script>
				<textarea name = "content" id = "content" class = "ed"></textarea></td>
			</tr>
			<tr>
				<td colspan = "2">Parent Page:</td>
			</tr>
			<tr>
				<td colspan = "2">'.$this->parent_options($parent).'</td>
			</tr>
			<tr>
				<td></td>
				<td><input type = "submit" name = "submit" value = "Save" /> <input type = "button" name = "cancel" value = "Cancel" onclick = "window.location = \''.APP_DIR.'\'" /></td>
			</tr>
		</table>
		</form>';
	}
	
	public function parent_options($current = 0, $page = 0) {
		global $db, $pc;
		
		if ($page != 0) {
			$sql = "SELECT id, title FROM pages WHERE id != '$page' ORDER BY title";
		} else {
			$sql = "SELECT id, title FROM pages ORDER BY title";
		}
		$db->exe_sql($sql);
		$op = '<select name = "parent">
		<option value = "0">None</option>';
		while ($row = $db->fetch_array()) {
			$op .= '<option value = "'.$row['id'].'"';
			if ($current != 0)
				if ($current == $row['id'])
					$op .= ' SELECTED';
			$op .= '>'.stripslashes($row['title']).'</option>';
		}
		$op .= '</select>';
		return $op;
	}
	
	public function merge_options($page = 0) {
		global $db, $pc;
		
		if ($page != 0) {
			$sql = "SELECT id, title FROM pages WHERE id != '$page' ORDER BY title";
		} else {
			$sql = "SELECT id, title FROM pages ORDER BY title";
		}
		$db->exe_sql($sql);
		$op = '<select name = "merge">
		<option value = "0">Merge with...</option>';
		while ($row = $db->fetch_array())
			$op .= '<option value = "'.$row['id'].'">'.stripslashes($row['title']).'</option>';
		$op .= '</select>';
		return $op;
	}
	
	public function reorder_form($errors = array(), $lvl) {
		global $db, $pc;
		
		$pages = $pc->iterate_pages_by_parent($lvl);
		
		print $this->parse_errors($errors).
		'<div id = "reorder">
		<form action = "'.APP_DIR.'?p=order&lvl='.$lvl.'" method = "post">
		<table border = "0">
		<tr>
			<td colspan = "3"><strong>Order</strong></td>
		</tr>';
		if (sizeof($pages) > 0) {
			foreach ($pages as $pID => $page) {
				print '<tr>
					<td><input type = "text" name = "p_order[]" size = "2" maxlength = "2" value  = "'.$page[1].'" 
					disabled = "disabled" />
					<input type = "hidden" name = "id[]" value = "'.$pID.'" /></td>
					<td><strong><a href = "'.APP_DIR.'?p=order&lvl='.$pID.'" title = "Re-order pages under: '.$page[0].'">'
					.$page[0].'</a></strong></td>
					<td><a href = "javascript:;" onclick = "reorder(\''.$pID.'\', \'up\')">Up</a>
					 / <a href = "javascript:;" onclick = "reorder(\''.$pID.'\', \'down\')">Down</a></td>
				</tr>';
			}
			print '<tr>
				<td></td>
				<td><input type = "button" name = "done" value = "Done" onclick = "window.location = \''.APP_DIR.'\'" /> <input type = "button" name = "cancel" value = "Cancel" onclick = "window.location = \''.APP_DIR.'\'" /></td>
			</tr>';
		} else {
			print '<tr>
				<td></td>
				<td>There are no pages under this level (parent).</td>
			</tr>';
		}
		print '</table>
		</form>
		</div>';
	}
	
	public function page_nav($left, $up, $right) {
		$op = '<table class = "pagenav" border = "0" width = "100%">
			<tr>
				<td align = "left" width = "45%">';
				foreach ($left as $l_uri => $l_title)
					$op .= '<a href = "'.$l_uri.'" title = "Go to '.$l_title.'">< '.$l_title.'</a>';
				$op .= '</td>
				<td width = "5%" align = "center">';
				foreach ($up as $u_uri => $u_title)
					$op .= '<a href = "'.$u_uri.'" title = "Go up to '.$u_title.'">up</a>';
				$op .= '</td>
				<td width = "45%" align = "right">';
				foreach ($right as $r_uri => $r_title)
					$op .= '<a href = "'.$r_uri.'" title = "Go to '.$r_title.'">'.$r_title.' ></a>';
				$op .= '</td>
			</tr>
		</table>';
		
		return $op;
	}
	
	public function delete_confirm($title, $action) {
		print '<form action = "'.APP_DIR.'?p='.$title.'&a='.$action.'" method = "post">
		<table border = "0">
			<tr>
				<td>Are YOU sure you want to delete?!</td>
				<td><input type = "submit" name = "submit" value = "Yes" /> 
				Back up system? <input type = "checkbox" name = "backup" value = "1" />
				</td>
			</tr>
			<tr>
				<td><input type = "button" name = "cancel" value = "Cancel" onclick = "window.location = \''.APP_DIR.'?p='.$title.'&a=edit\'" /></td>
			</tr>
		</table>
		</form>';
	}
	
	public function display_top_pages($limit = 5) {
		global $pc;
		
		$pages = $pc->top_pages($limit);
		print 'Top '.$limit.' pages:<br />';
		print '<table class = "datatbl" border = "0" width = "50%">
			<tr>
				<th>Page</th>
				<th>Views</th>
			</tr>';
		$count = 1;
		foreach ($pages as $key => $val) {
			if ($count % 2 == 0) {
				print '<tr class = "datatblrow">';
			} else {
				print '<tr>';
			}
			foreach ($val as $top)
				print '<td>'.$top.'</td>';
			print '</tr>';
			$count++;
		}
		print '</table>';
	}
	
	public function parse_errors($errors) {
		$op = '';
		if (sizeof($errors) > 0) {
			$op .= '<div class = "errors">';
			foreach ($errors as $error) {
				$op .= $error.'<br />';
			}
			$op .= '</div>';
		}
		return $op;
	}
}
?>
