<?php
/**
* HTML Cache, caches all pages into pure html, primarily used for downloading entire documentation
*
* @name HTML Cache
* @verision --
* @package --
* @author Rashaud Teague <rashaud.teague@gmail.com>
* @since 04/04/2009
* @license GNU GPL
*/

class HTML_cache extends Pages {
	public function update_html_cache() {
		global $db, $sys;
		
		//clear cache first
		//exec('rm -r html_cache/*');return;
		exec('rm -r html_cache/*.html; rm *.tar.gz; rm html_cache/*.css; rm html_cache/*.js');
		exec('cp -r bbeditor/ html_cache; cp -r data/ html_cache; cp -r highlighter/ html_cache');
		exec('cp jslib.js html_cache; cp style.css html_cache');
		
		$sql = "SELECT title FROM pages WHERE hidden = '0'";
		$db->exe_sql($sql);
		
		//main index page
		if ($sys->get_site_url() == '' || $sys->get_site_url() == NULL) {
			$page_url = 'http://'.$_SERVER['SERVER_NAME'].dirname($_SERVER['PHP_SELF']).'/';
		} else {
			$page_url = $sys->get_site_url().dirname($_SERVER['PHP_SELF']).'/';
		}
		$lines = file($page_url);
		$pFile = fopen('html_cache/index.html', 'w');
		foreach ($lines as $line) {
			if (preg_match("/^\<td align = \"right\"/i", trim($line)))
				$line = '<td></td>';
			if (preg_match("/^\<li\>None.../i", trim($line)))
				$line = '<li>None...';
			if (preg_match("/^title = \"Add a new page to the documentation\"/i", trim($line)))
				$line = '</li>';
			$line = preg_replace("/href = \"\.\/\?p=(.*?)\"/i", "href = \"$1.html\"", $line);
			//$line = preg_replace("/href = \"\.\/\"/i", "href = \"index.html\"", $line);
			//$line = str_replace('main.html', 'index.html', $line);
			fwrite($pFile, $line);
		}
		fclose($pFile);
		
		//now all pages from the database
		while ($row = $db->fetch_array()) {
			$title = str_replace(' ', '_', $row['title']);
			
			if ($sys->get_site_url() == '' || $sys->get_site_url() == NULL) {
				$page_url = 'http://'.$_SERVER['SERVER_NAME'].dirname($_SERVER['PHP_SELF']).'/?p='.$title;
			} else {
				$page_url = $sys->get_site_url().dirname($_SERVER['PHP_SELF']).'/?p='.$title;
			}
			
			$lines = file($page_url);
			$pFile = fopen('html_cache/'.$title.'.html', 'w');
			foreach ($lines as $line) {
				if (preg_match("/^\<td align = \"right\"/i", trim($line)))
					$line = '<td></td>';
				if (preg_match("/^\<li\>None.../i", trim($line)))
					$line = '<li>None...';
				if (preg_match("/^title = \"Add a new page to the documentation\"/i", trim($line)))
					$line = '</li>';
				$line = preg_replace("/href = \"\.\/\?p=(.*?)\"/i", "href = \"$1.html\"", $line);
				//$line = preg_replace("/href = \"\.\/\"/i", "href = \"index.html\"", $line);
				//$line = str_replace('main.html', 'index.html', $line);
				fwrite($pFile, $line);
			}
			
			fclose($pFile);
		}
		
		$pConfigFile = fopen('html_cache/config.txt', 'w');
		fwrite($pConfigFile, 'Last Update: '.date('M d Y H:i:s A'));
		fclose($pConfigFile);
		
		exec('tar -zcf '.str_replace(' ', '_', $sys->get_doc_title()).'.tar.gz html_cache/');
	}
	
	public function check_last_html_cache() {
		$lines = file('html_cache/config.txt');
		foreach ($lines as $line) {
			if (preg_match("/^Last Update:/i", $line)) {
				$lsplit = explode(':', $line, 2);
				$trim_last_update = trim($lsplit[1]);
				$last_update = strtotime($trim_last_update);
				break;
			}
		}
		
		if ((time() - $last_update) >= 300*6) {
			return true;
		} else {
			return false;
		}
	}
}

?>
