<?php
/**
* Emailer handles email sending...
*
* @name Emailer
* @verision 1.4.2
* @package Maris Engine
* @author Rashaud Teague <rashaud.teague@gmail.com>
* @since ??/??/2007 (forgot the exact date)
* @license GNU LGPL
* @Copyright (c) 2007 Maris Labs
*/


class emailer {
	/**
	* @var $to
	* The email address(es) you are sending the message to
	*/
	public $to;
	
	/**
	* @var $subject
	* Subject of the email
	*/
	public $subject;
	
	/**
	* @var $message
	* Message of the email
	*/
	protected $message;
	
	/**
	* @var $headers
	* Email headers (From/Reply-to...etc)
	*/
	public $headers = '';
	
	/**
	* @var $cc
	* Carbon copy
	*/
	public $cc;
	
	/**
	* @var $bcc
	* Blind carbon copy
	*/
	public $bcc;
	
	/**
	* @var $from
	* Array of $from values 'site' and/or 'site_email'
	*/
	public $from;
	
	/**
	* @var $htmlbody
	* Holds html body for send.
	*/
	public $htmlbody;
	
	/**
	* void __construct($to, $subject, $messBody, [, $from [, $cc [, $bcc]]])
	*
	* Collects the basic data to prepare email for send.
	*
	* @param string $to
	* @param string $subject
	* @param string $messBody
	* @param array $from
	* @param string $cc
	* @param string $bcc
	*/
	
	public function __construct($to, $subject, $messBody, $from = array(), $cc = '', $bcc = '') {
		$this->to = $to;
		$this->subject = $subject;
		
		
		/*
		basic $from entry
		$from = array(
				'site' => 'Site Name',
				'site_email' => 'site@site.com'
		);
		*/
		
		$this->headers .= 'MIME-Version: 1.0' ."\r\n".
		'Content-type: text/html; ' . 'charset=iso-8859-1'."\r\n";
		
		//begin validating $from
		if (sizeof($from) > 0) {
			if (sizeof($from) > 2) {
				die('ERROR: Invalid number of "from" arguments.');
			} else {
				if (!array_key_exists('site', $from) || !array_key_exists('site_email', $from)) {
					die('ERROR: Invalid "from" fields');
				} else {
					//ok so either key do exists...but do they have values?!?!?!
					//but still have to check for individual existance because either key can exists!
					if (array_key_exists('site', $from)) {
						if ($from['site'] == '') {
							die('ERROR: "site" field exists with no value.');
						}
					}
					
					if (array_key_exists('site_email', $from)) {
						if ($from['site_email'] == '') {
							die('ERROR: "site_email" field exists with no value.');
						} else {
							//so the site_email is not null or empty but did the code enter a valid email address?
							if (!$this->is_email($from['site_email'])) {
								die('ERROR: Invalid email address for your "site_email" field');
							}
						}
					}
				}
			}
			
			//if it gets this far go ahead and parse the $from header information
			$this->headers .= 'From:';
			foreach ($from as $key => $val) {
				if ($key == 'site') {
					$this->headers .= ' '.$val;
				}
				if ($key == 'site_email') {
					$this->headers .= ' <'.$val.'>';
				}
			}
			$this->headers .= "\r\n";
		} else {
			//if the $from param is not filled we will just use our servername
			$server = explode('.', $_SERVER['SERVER_NAME']);
			$this->headers .= 'From: ' . $server[0] . "\r\n";
		}
		
		if ($cc != '') {
			$this->headers .= 'Cc: '.$cc."\r\n";
		}
		
		if ($bcc != '') {
			$this->headers .= 'Bcc: '.$bcc."\r\n";
		}
		
		$this->headers .= 'Content-Transfer-Encoding: 8bit'."\r\n".
		'X-Mailer: PHP/'.phpversion()."\r\n";
		
		$this->htmlbody = $messBody; //<-- I want to do something with this...but don't know
		$this->setBody();
	}
	
	/**
	* bool is_email($email)
	*
	* Determines if an email address is valid.
	*
	* @param string $email
	*/
	
	public function is_email($email) {
		$check = ereg("^.+@.+\..+", $email);
		return $check;
	}
	
	/**
	* void setBody(void)
	*
	* Sets up the main message body and calls sendMail() function.
	*/
	
	protected function setBody() {
		$this->message = $this->htmlbody;
		//print $this->headers;die();
		//print ini_get('sendmail_path');die();
		$this->sendMail();
	}
	
	/**
	* void sendMail(void)
	*
	* Sends the email out to the recepient(s).
	*/
	
	protected function sendMail() {
		if (!mail(stripslashes(trim($this->to)), stripslashes(trim($this->subject)), stripslashes($this->message), $this->headers)) {
			die('ERROR: Email failed to send...');
		}
	}
}
?>
