<?php
/**
* Cpanel, control panel stuff...
*
* @name Cpanel
* @verision ---
* @package ---
* @author Rashaud Teague <rashaud.teague@gmail.com>
* @since 03/12/2009
* @license GNU GPL
*/

class CPANEL {
	public static function cpanel_main($tab, $action) {
		global $uc, $uv, $sys, $security, $pv;
		$session_user = $uc->user_data($_SESSION['docu_user']);
		print '<div class = "cpanelcontent">';
		if ($sys->check_version_update())
			print '<div class = "vupdate">
			WARNING: Version Update Detected! <a href = "http://marislabs.org/ext/apps/?p=desc&app=18">v'
			.$sys->get_current_version().'</a> 
			It is recommended that you install the <a href = "http://marislabs.org/ext/apps/?p=desc&app=18">update</a>.
			</div>';
		switch ($tab) {
			case 'main':
				print '<ul>
				<li><a href = "'.APP_DIR.'?p=cp&tab=main">Control Panel Main</a></li>
				<li><a href = "'.APP_DIR.'?p=cp&tab=sys">System Configuration</a></li>
				<li><a href = "'.APP_DIR.'?p=cp&tab=recent_backup">View recent backup files</a></li>
				<li><a href = "'.APP_DIR.'?p=cp&tab=users">Users</a></li>
				<!--<li><a href = "'.APP_DIR.'?p=cp&tab=pages">Pages</a></li>-->
				</ul>';
				
				$pv->display_top_pages();
				$sys->user_log_view();
				
				break;
			case 'sys':
				print '<strong>System Configuration</strong>';
				switch ($action) {
					case 'none':
						$sys->bread_crumbs(array(
						'?p=cp&tab=main' => 'Control Panel',
						'?p=cp&tab=sys' => 'System Configuration'));
						if (!isset($_POST['submit'])) {
							$sys->sys_edit_form();
						} elseif (isset($_POST['submit'])) {
							$sys->log_it($session_user, 'Edit System Configuration');
							$sys->validate_sys_edit($_POST['org_name'], $_POST['site_url'], $_POST['org_email'], $_POST['doc_title'],
							$_POST['allow_registration']);
						}
						print '<p>
						<input type = "button" name = "backup" value = "Backup System Data" onclick = "window.location = \''.APP_DIR.'?p=cp&tab=sys&a=backup\'" />
						<input type = "button" name = "backup" value = "Empty tmp_files/" onclick = "window.location = \''.APP_DIR.'?p=cp&tab=sys&a=tmp\'" />
						</p>';
						break;
					case 'backup':
						$sys->bread_crumbs(array(
						'?p=cp&tab=main' => 'Control Panel',
						'?p=cp&tab=sys' => 'System Configuration',
						'?p=cp&tab=sys&a=backup' => 'System Backup'));
						$sys->log_it($session_user, 'System Backup');
						print $sys->backup();
						
						break;
					case 'tmp':
						$sys->log_it($session_user, 'Empty tmp_files/ directory');
						$sys->empty_tmp();
						$security->redirect(APP_DIR.'?p=cp&tab=sys');
						break;
					default:
						print '...';
				}
				break;
			case 'recent_backup':
				$sys->bread_crumbs(array(
				'?p=cp&tab=main' => 'Control Panel',
				'?p=cp&tab=recent_backup' => 'Recent Backup Files'));
				
				$sys->recent_backup_files_view();
				break;
			case 'users':
				print '<strong>User Management</strong>';
				switch ($action) {
					case 'none':
						$sys->bread_crumbs(array(
						'?p=cp&tab=main' => 'Control Panel',
						'?p=cp&tab=users' => 'User Management'));
						print '<p><a href = "'.APP_DIR.'?p=cp&tab=users&a=new" title = "Add a new user">Add User</a> | 
						<a href = "'.APP_DIR.'?p=cp&tab=users&a=message">Message Users</a></p>';
						if (isset($_GET['pagenum'])) {
							if (!is_numeric($_GET['pagenum']))
								$security->redirect(APP_DIR.'?p=cp&tab=users');
							$pagenum = $_GET['pagenum'];
						} else {
							$pagenum = 1;
						}
						$uv->list_users(new Paginator("", 10, $pagenum));
						print '<p>There are number of <strong>'.$uc->user_count().'</strong> total users.</p>';
						break;
					case 'new':
						$sys->bread_crumbs(array(
						'?p=cp&tab=main' => 'Control Panel',
						'?p=cp&tab=users' => 'User Management',
						'?p=cp&tab=users&a=new' => 'Add New User'));
						
						if (!isset($_POST['submit'])) {
							$uv->add_user_form();
						} elseif (isset($_POST['submit'])) {
							$sys->log_it($session_user, 'Add user');
							$uc->validate_add_user($_POST['username'], $_POST['email']);
						}
						break;
					case 'edit':
						$security->validate_get_int($_GET['u']);
						$udata = $uc->user_data($_GET['u']);
						$sys->bread_crumbs(array(
						'?p=cp&tab=main' => 'Control Panel',
						'?p=cp&tab=users' => 'User Management',
						'?p=cp&tab=users&a=edit&u='.$_GET['u'] => 'Editing: '.$udata['username']));
						
						if (!isset($_POST['submit'])) {
							$uv->user_edit_form(null, $_GET['u']);
						} elseif (isset($_POST['submit'])) {
							$sys->log_it($session_user, 'Edit user:'.$udata['username']);
							$uc->validate_edit_user($_POST['username'],
							$_POST['original_username'],
							$_POST['email'],
							$_POST['original_email'],
							$_POST['auth'],
							$_GET['u']);
						}
						break;
					case 'delete':
						$security->validate_get_int($_GET['u']);
						$udata = $uc->user_data($_GET['u']);
						if (!isset($_POST['submit'])) {
							$uv->delete_user_confirm($_GET['u']);
						} elseif (isset($_POST['submit'])) {
							$sys->log_it($session_user, 'Delete user:'.$udata['username']);
							$uc->delete_user($_GET['u']);
							$security->redirect(APP_DIR.'?p=cp&tab=users');
						}
						break;
					case 'message':
						$sys->bread_crumbs(array(
						'?p=cp&tab=main' => 'Control Panel',
						'?p=cp&tab=users' => 'User Management',
						'?p=cp&tab=users&a=message' => 'Message Users'));
						
						if (!isset($_POST['submit'])) {
							$uv->user_message_form();
						} elseif (isset($_POST['submit'])) {
							$uc->validate_send_message($_POST['subject'], $_POST['message']);
							print 'Message sent! Please wait...';
							$security->redirect(APP_DIR.'?p=cp&tab=users', 3000);
						}
						break;
					default:
						print '<p>Uncharted Area...</p>';
				}
				break;
			default:
				print '<p>Uncharted Area...</p>';
		}
		print '</div>';
	}
}
?>
