<?php
/**
* Common, the central command.
*
* @name Common
* @verision ---
* @package ---
* @author Rashaud Teague <rashaud.teague@gmail.com>
* @contributors Tom Catullo <tom@cortello.com>
* @since 03/04/2009
* @license GNU GPL
*/

//set global constants
define('CORE', 'includes/');
define('APP_DIR', './');
define('APP_NAME', 'Maris SimpleDocu&trade;');
define('APP_VERSION', '1.3.8');

//include important files from the includes folder
include_once CORE.'db_connect.php';
include_once CORE.'emailer.php';
include_once CORE.'security.php';
include_once CORE.'pages.php';
include_once CORE.'pages_view.php';
include_once CORE.'users_view.php';
include_once CORE.'users.php';
include_once CORE.'cpanel.php';
include_once CORE.'sys.php';
include_once CORE.'paginator.php';
include_once CORE.'html_cache.php';

//include updates for database updates
include 'updates.php';

//initiate important classes
if (check_configs()) {
	$db = new DB('cached_config.php');
	$db->connect();
}
//security
$security = new Security();
//page controls
$pc = new Pages();
$pv = new PageViews();
//core user controls
$uv = new UserView();
$uc = new Users();
//system
if (check_install()) {
	$sys = new SYS();
}

/*
DO NOT UNCOMMENT THIS OR YOUR SYSTEM WILL CRASH...!!! WE ARE STILL WORKING ON THIS
$html_cache = new HTML_cache();
*/
//start the table of contents array
$tblContents = array();

//navigation functions...no class OOP needed for this...seriously
function nav() {
	global $security, $uc;
	
	$op = '<div class = "nav">';
	if ($security->check_session()) {
		$udata = $uc->user_data($_SESSION['docu_user']);
		$op .= 'Hello '.$udata['username'].'! ';
		if ($udata['auth'] > 1)
			$op .= '<a href = "'.APP_DIR.'?p=cp&tab=main">Control Panel</a> | ';
		$op .= '<a href = "http://marislabs.org/docu/?p=User_Guide" target = "_blank">Help</a> | ';
		$op .= '<a href = "'.APP_DIR.'?p=profile">Profile</a>/<a href = "'.APP_DIR.'?p=logout">Logout</a>';
	} else {
		$op .= '<a href = "http://marislabs.org/docu/?p=User_Guide" target = "_blank">Help</a> | ';
		$op .= '<a href = "'.APP_DIR.'?p=login">Login</a>/<a href = "'.APP_DIR.'?p=register">Register</a>';
	}
	$op .= '</div>';
	return $op;
}

//check if the data base setting variables are filled
function check_configs() {
	if (!file_exists(CORE.'cached_config.php') || filesize(CORE.'cached_config.php') == 0) {
		include CORE.'config.php';
		//print gettype($dbsettings);die();
		if (!is_array($dbsettings))
			die('ERROR: Invalid type in '.__FILE__.' on line: '.__LINE__);
		foreach ($dbsettings as $setting => $val) {
			if ($setting == 'servername')
				if ($val == '')
					return false;
			if ($setting == 'username')
				if ($val == '')
					return false;
			if ($setting == 'password')
				if ($val == '')
					return false;
			if ($setting == 'dbname')
				if ($val == '')
					return false;
		}
		$lines = file(CORE.'config.php');
		//create "cached_config.php"
		$pCachedFile = fopen(CORE.'cached_config.php', 'w');
		fwrite($pCachedFile, implode('', $lines));
		fclose($pCachedFile);
	}
	
	return true;
}

//check if the tables are installed
function check_install() {
	if (check_configs()) {
		global $db;
		
		include CORE.'cached_config.php';
		
		//required tables
		$req_tables = array('docu_users', 'pages', 'sys_config');
		
		if (!is_array($dbsettings))
			die('ERROR: Invalid type in '.__FILE__.' on line: '.__LINE__);
		
		$tables = @mysql_list_tables($dbsettings['dbname']) or die(mysql_error());
		$found_tbls = array();
		$table_num = 0;
		while ($table_num < mysql_num_rows($tables)) {
			if (in_array(mysql_tablename($tables, $table_num), $req_tables))
				$found_tbls[] = mysql_tablename($tables, $table_num);
			$table_num++;
		}
		//print_r($found_tbls);die();
		if (sizeof($found_tbls) != sizeof($req_tables))
			return false;
	} else {
		return false;
	}
	return true;
}

//check to see if the data tables and stuff are installed...if not redirect to install page
if (!check_install())
	if (!preg_match("/install/i", $_SERVER['PHP_SELF']))
		$security->redirect(APP_DIR.'install.php');

//header title
$header_title = '';
if (isset($_GET['p'])) {
	if ($_GET['p'] != '') {
		if ($_GET['p'] == 'main') {
			$header_title = 'Home';
		} elseif ($_GET['p'] == 'cp') {
			$header_title = 'Control Panel';
		} else {
			$header_title = str_replace('_', ' ', $_GET['p']);
			$header_title = ucwords($header_title);
		}
	}
} else {
	$header_title = 'Home';
}

//we can retrieve the organization site name through its own email
if (check_install())
	$org = explode('@', $sys->get_org_email());

//automatically update database tables (if needed) upon any user accessing any page
if (check_install())
	check_db_update();

//DO NOT UNCOMMENT THIS SECTION!!!
//check html cache update
//if ($html_cache->check_last_html_cache())
//	$html_cache->update_html_cache();
?>
