<?php
/*********************************************************
** Description : user page for PHP/MySQL Table Manager	**
** File Name   : users.php								**
** Version     : 1.01									**
** Modified    : 24 December 2008       			    **
** Author      : Tony Aslett							**
** Website     : http://bearsql.org 					**
** Email	   : tony@appcreator.com					**
**********************************************************/ 
/************************************************************************
    Bear SQL simplifies MySQL database management
    Copyright (C) 2008  Tony Aslett
    
    This file is part of Bear SQL.

    Bear SQL is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>
********************************************************************************/
/**
 * page control for user management functions
 *
 * @param navigation $nav
 * @return page output
 */
function user_control(&$nav){
  $output='';
  if(isset($_POST['cmd']) &&  $_POST['cmd'] !=""){
	$cmd=strtolower(str_replace(' ','', $_POST['cmd']));
	switch ($cmd){
	case 'createuser':
	  $output.=createuserform();
	break;
	case 'adduser':
	  $output.=createuser();
	break;
	case 'deleteuser':
	  $output.=dropuserform();
	break;
	case 'dropuser':
	  $output.=dropuser();
	break;
	case 'changeusername':
	  $output.=changenameform();
	break;
	case 'changename':
	  $output.=changename();
	break;
	case 'privileges':
	case 'edituser':  
	  $output.=grantform();
	break;
	case 'grantprivileges':
	  $output.=grantprivileges();
	break;
	case 'password':
	  $output.=passwordform();
	break;
	case 'changepassword':
	  $output.=changepassword();
	default:
	case 'manageusers':
	  $output.=showpriv();
	break;
	}
  }
  return $output;
}

/**
 * Show privileges
 *
 * @param username $user
 * @return table of privilege values
 */
function showpriv($user=""){
  $output='';
  if($user!=""){
	$query="SELECT * from mysql.db where user like '$user'";
  }else{
	$query="SELECT * from mysql.db";
  }
  $result=exequery($query);
  if($result){
	$dbname="mysql";
	$tablename="db";
	$z=0; 
	$x=0; 
	$pkfield=array(); 
	$num_rows = mysql_num_rows($result); 
	$flds = mysql_num_fields($result); 
	$fields = mysql_list_fields( $dbname, $tablename); 
	$output.='<table class="tables"><thead><tr><th></th>';
	for ($i = 0; $i < $flds; $i++) {	
	  $c=$i+1;
	  $coltitle=str_replace('_priv','', mysql_field_name($fields, $i));
	  $output.="<th class='c$c' title='column $coltitle'>$coltitle</th>"; 
	  //Find the primary key 
	  $flagstring = mysql_field_flags ($result, $i); 
	  if(eregi("primary",$flagstring )){ 
		$pk[$z] = $i; 
		$pkfield[$z]= mysql_field_name($fields, $i); 
		$z++; 
	  } 
	} 
	$v=$flds+1;
	$output.='<th></th></tr></thead>';	
	$output.='<tbody>';				
	if($z > 0){ 
	  $cpk=count($pk); 
	}else{ 
	  $cpk=0; 
	} 
	//************Display each row from the table.********************************
	for ($s=0; $s < $num_rows; $s++){	 
	  if (!mysql_data_seek ($result, $s)) { 
		$output.=MSG_CSR.' '. $s."\n"; 
		continue; 
	  } 
	  if($s%2==0){ /*remainder of $s/2=0 */
		$rclass="even";
	  }else{
		$rclass="odd";
	  }
	  $row=mysql_fetch_array($result); 
	  if(!isset($pk)){ 
		$pk=" "; 
		$pkfield= array(); 
	  } 
	  $output.=displayrow($dbname, $tablename, $pk, $pkfield, $cpk, $row, $flds, $rclass, 'user', 'user'); 
	}				
	$output.='</tbody></table>';	    
  }else{
	message(MSG_DHP,'warning') ;
  }
  return $output;
}

/**
 * Create User form
 *
 * @return Create User form
 */			
function createuserform(){
  $output='';
  $output.='<form name="creatuser" action="index.php" method="post" class="jscheck">';
  $output.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
  $output.='<div class="fieldset"><fieldset><legend>'.BTN_CUSR.'</legend>';
  $output.='<div class="cb"><label for="host">'.GEN_HOS.':</label><input type="text" id="host" name="host" value="'. $_SESSION['host'].'" />';
  $output.= message(MSG_BUL,'info', 'inline').'</div>'; 
  $output.='<div class="cb"><label for="username" class="required">'.GEN_USN.':</label><input type="text" name="username" id="username" /></div>';
  $output.='<div class="cb"><label for="password" class="required">'.GEN_PAS.':</label><input type="password" name="password" id="password" /></div>';
  $output.='<input type="hidden"  name="cmd" value="Add User" />';
  $output.='<input type="submit" class="but adduser" value="'.BTN_CUSR.'" />';
  $output.='</fieldset></div>';
  $output.='</form>';
  return $output;
}

/**
 * Create user
 * 
 * @return button to add privileges
 */
function createuser(){
  $output='';
  $user=cleanvar($_POST['username']);
  $pass=cleanvar($_POST['password']);
  $host=cleanvar($_POST['host']);
  $query="CREATE USER '$user'@'$host' identified by '".$pass."'";
  $result=exequery($query);	
  if($result){
	$output.="<p>User $user created</p>";
	$output.='<form method="post" action="index.php" >';
	$output.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
	$output.='<input type="hidden" name="username" value="'. $user.'" />';
	$output.='<input type="hidden" name="cmd" value="privileges" />';
	$output.='<input type="submit" class="but priv" value="'.BTN_GPV.'" />';
	$output.='</form>';
  }
  return $output;
}

/**
 * Drop User form
 *
 * @return form to drop a user
 */
function dropuserform(){
  $output='';
  $users=listusers();
  if($users){
	$output.='<form name="dropuser" action="index.php" method="post">';
	$output.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
	$output.='<div class="fieldset"><fieldset><legend>Delete User</legend>';
	$output.='<div class="cb"><label for="host">'.GEN_HOS.':</label><input type="text" name="host" id="host" value="" /></div>';
	
	$output.='<div class="cb"><label for="username">'.GEN_USN.':</label><select type="text" name="username" >';
	$output.="<option>Select User</option>";
	foreach($users as $key=>$user){
	  $output.='<option value="'.$user.'">'.$user.'</option>';
	}
	$output.='</select></div>';
		$output.='<input type="hidden" name="cmd" value="dropuser" />';
	$output.='<input type="submit" class="but dropuser" value="Drop User" />';
	$output.='</fieldset></div>';
	$output.='</form>';
  }
  return $output;
}

/**
 * Drop user
 */
function dropuser(){
  if(isset($_POST['username'])){
	$user=cleanvar($_POST['username']);
	$host=cleanvar($_POST['host']);
	$query="DROP USER '".$user."'@'".$host."'";
	$result=exequery($query);	
	if($result){
	  message(MSG_UDL .': '.$user);
	}
  }
}

/**
 * List users
 * 
 * @return list of users
 */
function listusers(){
  $rt=array();
  $query="SELECT user from mysql.user";
  $result=exequery($query);	
  while($u=mysql_fetch_array($result)){
    $rt[]=$u[0];		
  }
  return removearraycopy($rt);
}

/**
 * Change name form
 * 
 * @return Change name form
 */
function changenameform(){
  $output='';
  $users=listusers();
  if($users){ 
	$output.='<form name="changename" action="index.php" method="post" class="jscheck">';
	$output.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
	$output.='<div class="fieldset"><fieldset class="lone"><legend>'.LBL_RNU.'</legend>';
	$output.='<div class="cb"><label for="host" class="required">'.GEN_HOS.':</label><input type="text" name="host" id="host" value="localhost" title="Use % for all hosts" /></div>';
	$output.='<div class="cb"><label for="oldname" class="required">'.LBL_OUN.':</label>';
	$output.='<select type="text" name="oldname" id="oldname" title="'.LBL_SUN.'">';
	$output.="<option></option>";
	foreach($users as $key=>$user){
	  $output.='<option value="'.$user.'">'.$user.'</option>';
	}
	$output.='</select></div>';
	$output.='<div class="cb"><label for="username" class="required">'.LBL_NUN.':</label><input type="text" name="username" id="username" /></div>';
	$output.='<input type="hidden" name="cmd" value="changename" />';
	$output.='<input type="submit" class="but cname" value="'.BTN_CNAM.'" />';	
	$output.='</fieldset></div>';
	$output.='</form>';
  }
  return $output;
}

/**
 * Change name
 */
function changename(){
 $host=cleanvar($_POST['host']);
 $newuser=cleanvar($_POST['username']);
 $olduser=cleanvar($_POST['oldname']);
 $query="RENAME USER '$olduser'@'".$host."' to '$newuser'@'".$host."'";
 $result=exequery($query);	
 if($result){
   message("Username $olduser changed to $newuser");
 }
}

/**
 * Grant form
 * 
 * @return Grant privileges form
 */
function grantform(){
 if((isset($_POST['pk']) && is_array($_POST['pk']) ) && (isset($_POST['pk']) && is_array($_POST['pk']))){
   foreach( $_POST['pk'] as $key => $value){
     $value = strtolower($value);
     $$value = $_POST['pv'][$key];
   }   
 }
  
 $output='';
 $output.='<form name="grant" action="index.php" method="post" class="jscheck">';
 $output.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
 $output.='<div class="fieldset"><fieldset><legend>'.BTN_GPV.'</legend>';
 $output.= message( MSG_STU ,'info' );
 $output.= message( MSG_OPD ,'info' );
 if(!isset($host)){
   $host = 'localhost';  
 }
 $output.='<div class="cb"><label for="host" class="required">'.GEN_HOS.':</label><input type="text" name="host" id="host" value="'.$host.'" /></div>';
 $output.='<div class="cb"><label for="username" class="required">'.GEN_USN.':</label>';
 if(isset($_POST['username']) && $_POST['username'] != ""){
   $output.='<input type="text" id="username" name="username" value="'.$_POST['username'].'" /></div>';
 }else if(isset($user) ){
   $output.='<input type="text" id="username" name="username" value="'.$user.'" /></div>'; 
 }else{
   $users=listusers();
   if($users){ 
     $output.='<select type="text" name="username" id="username" title="'.LBL_SLN.'">';
     $output.='<option></option>';
     foreach($users as $key=>$user){
       $output.='<option value="'.$user.'">'.$user.'</option>';
     }
     $output.='</select></div>';	
   }
 }
 $output.='<div class="cb"><label for="database" class="required">'.GEN_DB.':</label>';
 if(isset($db)){
   $output.='<input type="text" name="database" id="database" value="'.$db.'" /></div>';
 }else{
   $output.='<select name="database" id="database" title="'.GEN_SDB.'">';
   $output.="<option></option>";
   include_once("settings.php");
   $dbnamearray=dbrestrict();
   for($i =0; $i < count($dbnamearray); $i++){
     $output.="<option>$dbnamearray[$i]</option>"; 
   }
   $output.='</select></div>';
 }
 $output.='<div class="cb">'.LBL_GNT;
 
 $output.='<label for="all">'.LBL_ALL.':<input type="checkbox" name="all" id="all" value="all" /></label></div>';
 $output.=LBL_SPF;
 $output.='<table id="grants"><tr>';
 $grants=array('Select', 'Insert', 'Update','Delete', 'Index', 'Alter', 'Create','Drop','Grant', 'Create_view', 
	'Show_view', 'Create_routine', 'Alter_routine', 'Execute', 'Trigger', 'Event', 'Create_tmp_table', 
	'Lock_tables', 'References');
//, 'Reload','Shutdown', 'Process','File','Show_db','Super', 'Repl_slave','Repl_client');

  for($i = 0; $i < count($grants); $i++){
	if($i%4=='0'){
	  $output.="</tr><tr>";
	}
	$output.='<td align="right"><label>'.$grants[$i].' <input type="checkbox" name="grants[]" value="'.$grants[$i].'" /></label></td>';	
  }
  $output.='</tr></table>';
  $output.='<input type="hidden" name="cmd"  value="grantprivileges" />';
  $output.='<input type="submit"  class="but priv" value="'.BTN_GPV.'" />';
  $output.='</fieldset></div>';
  $output.='</form>';
  return $output;
}

/**
 * Grant privileges
 * 
 * @return list of new privileges
 */
function grantprivileges(){
  $grants='';
  $output='';
  if(isset($_POST['all']) && $_POST['all']=='all'){
	$grants="all";
  }else if(isset($_POST['grants'])){  
	$g=cleanvar($_POST['grants']); 
	$c=count($g);
	for($s=0; $s < $c; $s++){
	  if($s == $c-1){
		$grants.= $g[$s];
	  }else{
		$grants.= $g[$s].", ";
	  }
	}
	$grants = str_replace('_', ' ', $grants);
  }else{
    message(MSG_YMS, 'warning');
    return;
  }
  $db=cleanvar($_POST['database']);
  $user=cleanvar($_POST['username']);
  $host=cleanvar($_POST['host']);
  //$pass=cleanvar($_POST['password']);
  $query ="REVOKE ALL PRIVILEGES, GRANT OPTION FROM '".$user."'@'".$host."'";
  $result=exequery($query);	
  $query="Grant $grants on $db.* to '".$user."'@'".$host."'";
  //$output.=$query;
  $result=exequery($query);	
  if($result){
	exequery("FLUSH privileges");
	message(MSG_PVC);
	$output.=showpriv($user);
	}
	return $output;
}

/**
 * Password Form
 * 
 * @return change password form
 */
function passwordform(){
  $output='';
  $output.='<form name="pass" action="index.php" method="post" class="jscheck">';
  $output.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
  $output.='<div class="fieldset"><fieldset class="lone"><legend>'.BTN_CPAS.'</legend>';	
  $output.='<div class="cb"><label for="host" class="required" >'.GEN_HOS.':</label><input type="text" name="host" id="host" value="localhost" /></div>';
	
  $users=listusers();
  if($users){
	$output.='<div class="cb"><label for="username" class="required">Username:</label><select name="username" id="username" title="'.LBL_SLN.'">';
    $output.='<option></option>';
	foreach($users as $key=>$user){
	  $output.='<option value="'.$user.'">'.$user.'</option>';
	}
	$output.='</select></div>';
	$output.='<div class="cb"><label for="password" class="required" >'.GEN_PAS.':</label><input type="password" name="password" id="password" /></div>';
	$output.='<input type="hidden" name="cmd" value="changepassword" />';	
	$output.='<input type="submit" class="but cpass" value="'.BTN_CPAS.'" />';
	$output.='</fieldset></div>';
	$output.='</form>';
  }
  return $output;
}

/**
 * Change Password
 */
function changepassword(){
  $user=isset($_POST['username'])? cleanvar($_POST['username']):'';
  $pass=isset($_POST['password'])? cleanvar($_POST['password']):'';
  $host=isset($_POST['HOST'])? cleanvar($_POST['HOST']):'';
  if($user && $pass){
    //$query="SET PASSWORD for $user = PASSWORD('".$pass."')";
    $query="UPDATE mysql.user SET Password=PASSWORD('".$pass."') WHERE User='".$user."' AND Host='".$host."'";

    $result=exequery($query);
    exequery("FLUSH PRIVILEGES");
    if($result){
      message(MSG_PCU.' '. $user, 'notice');
    }
  }
}