<?php
/*********************************************************
** Description : Save query functions MySQL Table Manager**
** File Name   : Savedqueries.php						**
** Version     : 1.00									**
** Modified    : 12 December 2008   	   			    **
** Author      : Tony Aslett							**
** Website     : http://bearsql.org 					**
** Email	   : tony@appcreator.com					**
**********************************************************/ 
/************************************************************************
    Bear SQL simplifies MySQL database management
    Copyright (C) 2008  Tony Aslett
    
    This file is part of Bear SQL.

    Bear SQL is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>
********************************************************************************/

/*
 * Write query file
 */ 
function writeQueryFile($query){
  $output='';
  $save=true;
  $qas=filetoarray('savedqueries.xml');
  for($q=0; $q < count($qas) ;$q++){
	if($qas[$q]['sql']==$query){
	  $save=false;
	  $output.= MSG_QEX;
	}
  }
  if($save){
	$c= count($qas);
	$qas[$c]['user']=$_SESSION['user'];
	$qas[$c]['db']=$_SESSION['dbname'];  
	$qas[$c]['sql']=$query;
	xmltofile($qas, 'savedqueries.xml'); //write back to the file
	$output.= MSG_QSV.': '. $query;
  }	
  return $output;
}

/*
 * Delete saved queries
 */ 
function delsavedquery($query){
  //echo"del:$query";
  $qas=filetoarray('savedqueries.xml');
  for($q=0; $q < count($qas); $q++ ){
    if($qas[$q]['sql']==$query){
      unset($qas[$q]);
      message( MSG_QDL );
	}
  }
  xmltofile($qas, 'savedqueries.xml'); //write back to the file 
}

/*
 * List saved queries
 */ 
function listSavedQueries(){
  $trs='';
  $output='<div class="space">';
  $qas=filetoarray('savedqueries.xml');
  if(count($qas)>0){
    foreach($qas as $qa){
      if($qa['user']==$_SESSION['user'] && $qa['db']==$_SESSION['dbname']){
		$trs.='<tr><td><form name="runquery" method="post" action="index.php">';
		$trs.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
		$trs.='<textarea name="wyoqta" cols="40" rows="2" >'.$qa['sql'].'</textarea>';
		$trs.='</td><td><input type="submit" class="but exec" name="cmd" value="'.BTN_RQ.'" />';
		$trs.='<input type="submit" class="but del"  name="cmd" value="'.BTN_DQ.'" /></form>';
		$trs.="</td></tr>\n";
      }
	}
	if($trs !=""){
	  $output.='<table id="saveq">';
	  $output.='<caption>'.LBL_SVQ.'</caption>';
	  $output.='<thead>';
	  $output.='<tr><th>'.LBL_SDQ.'</th><th>'.LBL_ACT.'</th></tr>';
	  $output.='</thead>';
	  $output.=$trs;
	  $output.='</table>';
	}
  }else{
	//$output.= message(MSG_NSQ.' '.$_SESSION['user'].' : '. $_SESSION['dbname'], 'notice', 'inline');
  }
  $output.='</div>';
  return $output;
}

/*
 * XML to File
 */ 
function xmltofile($sqs, $file){
	$doc = new DOMDocument('1.0');
	$doc->formatOutput = true;
  
	$r = $doc->createElement( "queries" );
	$doc->appendChild( $r );
  
	foreach( $sqs as $query ){
		$q = $doc->createElement( "query" );
  
		$user = $doc->createElement( "user" );
		$user->appendChild($doc->createTextNode( $query['user'] ));
		$q->appendChild( $user );
  
		$db = $doc->createElement( "db" );
		$db->appendChild($doc->createTextNode( $query['db'] ));
		$q->appendChild( $db );
  
		$sql = $doc->createElement( "sql" );
		$sql->appendChild($doc->createTextNode( $query['sql'] ));
		$q->appendChild( $sql );
		$r->appendChild( $q );
	}
	$doc->appendChild( $r );
	unlink($file);
	$doc->save($file);
	return MSG_FSD.': '.$file;
}

/*
 * Read xml file into array
 */ 
function filetoarray($file){
 $qa=array();
 $doc = new DOMDocument();
 $trs='';
   $doc->load( $file );
   $q=0;
   $queries = $doc->getElementsByTagName( "query" );
   foreach(  $queries as $query ){
     $users = $query->getElementsByTagName( "user" );
     $user = $users->item(0)->nodeValue;
     $qa[$q]['user']=$user;
     $dbs = $query->getElementsByTagName( "db" );
     $db = $dbs->item(0)->nodeValue;
     $qa[$q]['db']=$db;  
     $sqls = $query->getElementsByTagName( "sql" );
     $sql = $sqls->item(0)->nodeValue;
     $qa[$q]['sql']=$sql;
     $q++;
   }
    return $qa;
}

/*
 * Save results of a query
 */ 
function saveresults($query){
 
  $date=date("Y-m-d");
  $results=exequery($query);
  $filename='sq'.$date.".csv";
  if ($f = fopen($filename,"w")){ 
	$data='';
	if($results){
	  $rn = mysql_num_fields($results);
	  while($row = mysql_fetch_row($results)){
	    $data='';
	    for($j=0; $j < $rn; $j++) {
	      $data.= $row[$j].",";
	    }
	    $data.="\n";
	    fwrite($f, $data);			
	  }
	 // fwrite ($f,"#EOF");
	  filesaveheaders($filename);
	  fclose($f); 
	}	
  }
}