<?php 
/********************************************************* 
** Description : Reuseable functions etc.               ** 
** File Name   : reuseable.php							** 
** Version     : 1.01									**
** Modified    : 24 December 2008       			    **
** Author      : Tony Aslett							**
** Website     : http://bearsql.org 					**
** Email	   : tony@appcreator.com					**
**********************************************************/ 
/************************************************************************
    Bear SQL simplifies MySQL database management
    Copyright (C) 2008  Tony Aslett
    
    This file is part of Bear SQL.

    Bear SQL is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>
********************************************************************************/


/* *******************************************************************
** If you use more than one server you can uncomment the array below **
** and add to the host addresses. This will give you a drop down box **
** with the host values to select from when loggin on.               **
** Make sure you then comment out the variable below the array.      **
** *******************************************************************/
/**
 * Show login form
 *
 * @param restricted list of database names $dbnamearray
 * @return login form
 */
function show_login($dbnamearray){
  $output="";
  //$hostdefault=array("localhost", "127.0.0.1"); 
  $hostdefault="localhost";
		
  $output.='<form id="login" name="showlogin" method="post" action="index.php" >'; 
  $output.='<div class="fieldset"><fieldset><legend>'.GEN_LOG.'</legend>';
  $output.='<div class="cb"><label for="host">'.GEN_HOS.':</label>';
  if(count($hostdefault) > 1){
    $output.='<select name="host" id="host">';
    for($x=0; $x < count($hostdefault);$x++){
      $output.='<option value="'.$hostdefault[$x].'">'.$hostdefault[$x].'</option>';
    }
    $output.='</select></div>';
  }else{
    $output.='<input type="text" name="host" id="host" size="15" value="'.$hostdefault.'" /></div>'; 
  }
  $output.='<div class="cb"><label for="userid">'.GEN_USN.':</label><input type="text" id="userid" name="userid" size="15" /></div>';
  $output.='<div class="cb"><label for="pword">'.GEN_PAS.':</label><input type="password" id="pword" name="pword" size="15" /></div>';
  if($dbnamearray != ""){
	$output.='<div class="cb"><label for="dbna">'.GEN_DB.':</label><select name="dbna" id="dbna">';
	for ($i =0; $i < count($dbnamearray); $i++) { 
	    $dbn=$dbnamearray[$i]; 
		$output.='<option value="'. $dbn.'">'.$dbn.'</option>';
	} 
	$output.='</select></div>';
  }
  if(isset($GLOBALS['language']) && $GLOBALS['language'] ==""){
    $langs = get_filelist('languages', 'php');
    if(count($langs)>1){
      $output.='<div class="cb"><label for="language">'.GEN_LANG.':</label><select name="language" id="language">';
      foreach($langs as $lg) { 
        $output.='<option value="'. $lg.'">'.$lg.'</option>';
      }
      $output.='</select></div>';
    }else{
      $output.='<input type="hidden" name="language" value="'.$langs[0].'" />';  	
    }
  }else{
    $output.='<input type="hidden" name="language" value="'.$GLOBALS['language'].'" />';
  }
  $output.='<div class="cb"><input type="submit" class="ser logon" name="cmd" value="Login" />';
  $output.='<input class="ser clear" type="reset" name="reset" value="Clear" /></div>';	
  $output.='</fieldset></div>';
  $output.='</form>';	 
  return $output;
} 

/**
 *  List databases
 * 
 * @return table of database names with controls
 */
function listdbs(){
  //Restrict the database for users
  $dbnamearray= dbrestrict();
  $output='';
  $output.='<table id="dblist">';
  $output.='<caption>'.GEN_CYD.'</caption>';
  for ($i =0; $i < count($dbnamearray); $i++) {
	$output.='<tr><td>';
    $dbn=$dbnamearray[$i];
	$va='List Tables';        
	$output.= goto(array('db'=>$dbn,'class'=> 'but dbstart', 'value'=>$dbn, 'cmd'=>$va, 'id'=>"db$dbn")); 
	$output.='</td>';
	if($GLOBALS['allow']['all']['showdbsize']){
		$dbs=mysize($dbnamearray[$i],"");
		$output.='<td>'.$dbs.'</td>';
	}
	$output.='<td>';
	$output.= goto(array('db'=>$dbn,'class'=> 'icon drdb', 'cmd'=>'deletedb',  'alt'=>"Drop $dbn", 'id'=>"drop$dbn"));
	$output.='</td><td>';
	$output.=goto(array('db'=>$dbn, 'type'=>'icon', 'class'=>'icon bkup', 'cmd'=> 'Backup', 'alt'=> "backup $dbn", 'id'=> "bkup$dbn"));
	$output.='</td></tr>';
  }
  $output.='</table>';
  return $output;
}

/**
 * Connect to MySQL
 * 
 * @return connection $link
 */
function connectmysql(){ 
  $link = FALSE;
  //Connects to the MySQL Database. 
  if (isset($_SESSION['user']) && isset($_SESSION['password'])){
	$user = $_SESSION['user'];
	$pass = $_SESSION['password'];
	if(isset($_POST['host'])){
	  $host = $_POST['host'];
	}else if(isset($_SESSION['host']))  {
	  $host = $_SESSION['host']; 
	}else{
	  $host='localhost'; 
	}
	$link = @mysql_connect($host, $user, $pass);
  }
  return $link;
}

/**
 * Connect to a database
 *
 * @param database name $db
 * @param connection $link
 */
function connectdb($db, $link){
  if(! mysql_select_db($db,$link)){ 
		message(MSG_ULD.' '.$db, 'warning');	
		message( MSG_TAL, 'notice');	
		exit(); 
	} 
	priv($db);
} 

/**
 * Execute a query
 *
 * @param query $sql
 * @return $result or FALSE
 */
function exequery($sql =''){ 
  $output='';
  if($sql !=''){
    $result= @mysql_query( $sql ); 
    if($result){ 
      //message($sql);		 
      return $result; 
    }else{	
      if(check_priv('debug', 'tbm')){	 
        message(MSG_SQF.':<code> '.$sql.' </code><br /> Error:'. mysql_error(), 'error');
      }else{
        message(MSG_SQF, 'error');
      }
      return FALSE; 	
    }
  }else{
    message(MSG_EQ);
    return FALSE; 	 
  }
} 

/**
 * Clean up variables
 *
 * @param variable $var
 * @return clean variable
 */
function cleanvar($var){
  /* Clean user submitted variables */
  /*Reverse magic_quotes_gpc effects on those vars if ON.*/
  if(!isset($var)){
	$var="";
  }else{
	$link=connectmysql();
	if($link){
	  if(get_magic_quotes_gpc()) {
    	 if(is_array($var)){
    	   foreach ($var as $key => $value) {
    		 $var[$key] = stripslashes($value);
    	   }
    	 }else{
    	   $var=stripslashes($var);
    	 }
	  }
	  if(is_array($var)){
    	foreach ($var as $key => $value) {
    	  if(!is_array($value)){
    		$var[$key] = mysql_real_escape_string($value, $link);
    	  }else{
    		foreach ($value as $key => $val) {	
    		  $var[$key] = mysql_real_escape_string($val, $link);
    		}
    	  }
    	}
	  }else{
    	$var=mysql_real_escape_string($var, $link);
	  }
	}
  }
  return $var;
}
 
/**
 * Search Form
 *
 * @param table name $tablename
 * @param database name $dbname
 * @return search form
 */
function searchtableform($tablename, $dbname){ 
  $output='';
  $output.='<form method="post" action="index.php">';
  $output.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
  $output.='<input type="hidden" name="dbname" value="'.$dbname.'" />';
  $output.='<input type="hidden" name="tablename" value="'.$tablename.'" />';
  $output.='<input type="text" name="searchval" id="searchval'.$tablename.'" />';
  $output.='<input type="hidden" name="cmd" value="'.BTN_SER.'" />';
  $output.='<input class="icon ser" type="submit" name="search" value=" " title="'.BTN_SER.' '. $tablename.'" id="search'.$tablename.'" />';
  $output.='</form>';
  return $output;	 
} 

/**
 * Search
 *
 * @param tablename $tablename
 * @param database name $dbname
 * @param search string $searchval
 * @return query
 */
function searcht($tablename, $dbname, $searchval){ 
  if(! empty($searchval)){  
    $result=exequery("Select * from $tablename"); 
	$num = mysql_num_fields($result); 
	$fields = mysql_list_fields($dbname, $tablename);
	$whr="where "; 
	$tok=explode(" ",$searchval); 
	for ($t =0; $t < count($tok); $t++){
		for ( $c = 0; $c < $num; $c++){ 
			$fn =mysql_field_name($fields, $c);
			$whr .=" $fn like '%$tok[$t]%' or "; 
		} 
	} 
	$whr=trim(substr_replace($whr, " ", -3));
	$query="Select * from $tablename $whr"; 
	return $query;
  }		 
} 

/**
 * Advanced Search form
 *
 * @param table name $tablename
 * @param database name $dbname
 * @param search term $term
 * @return advanced search form
 */
function advancedSearchForm($tablename, $dbname, $term =''){ 
  $output='<form method="post" action="index.php" class="jscheck">';
  $output.='<div class="fieldset"><fieldset><legend>'.BTN_AVS.'</legend>';
  $output.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
  $output.='<input type="hidden" name="dbname" value="'.$dbname.'" />';
  if(!$tablename){
	$tablename = $_POST['tablename'];
  }
  $output.='<input type="hidden" name="tablename" value="'.$tablename.'" />';
	$output.= '<p>'.GEN_FLD.':</p>';
	$output.= message(GEN_XFS, 'info', 'inline');
		
	$res=exequery("Show columns from $tablename");
	if($res){
	  for($f=0; $f< mysql_num_rows($res); $f++){
		$fields = mysql_fetch_object($res);
		$fname=$fields->Field;
		$output.='<div class="cb"><label for="f'.$fname.'" class="chkrdo"><input type="checkbox" name="field[]" id="f'.$fname.'" value="'.$fname.'" />'.$fname.'</label>';
		$output.='</div>';
	  }
	}
	$output.='<br /><label for="advancedsearchval" class="required">'.LBL_ST.':</label>';
	$output.='<input type="text" name="advancedsearchval" id="advancedsearchval" title="search term" value="'.$term.'" />';
	
	$output.='<input class="ser adv" type="submit" name="cmd" value="'.BTN_AVS.'" title="'.BTN_SER .' '. $tablename.'"/>';
	$output.='</fieldset></div>';
	$output.='</form>';
	
	return $output;
}
 
/**
 *  Advanced Search
 *
 * @param table name $tablename
 * @param database name $dbname
 * @param search value $advancedsearchval
 * @return query
 */
function advancedSearch($tablename, $dbname, $advancedsearchval){ 
  if(! empty($advancedsearchval)){ 
    if(!$tablename){
      $tablename = $_POST['tablename'];
	}	
	$fields=isset($_POST['field'])? cleanvar($_POST['field']):array();
	$num=count($fields);
	if($num < 1){ //No fields checked 
	  $res=exequery("Select * from $tablename");
	  if($res){ 
		$flds = mysql_list_fields($dbname, $tablename);		  
		$num = mysql_num_fields($res); 
		for($f=0; $f < $num; $f++){
		  $fields[$f] = mysql_field_name($flds, $f);	
		}
	  }
	}
	$whr="where "; 
	$tok=explode(" ",$advancedsearchval); 
	for ($t =0; $t < count($tok); $t++){					 
	  for ( $c = 0; $c < $num; $c++){ 
		$fn=$fields[$c];
		$whr .=" $fn like '%$tok[$t]%' or ";													 
	  } 
	} 
	$whr=trim(substr_replace($whr, " ", -3));		 
	$query="Select * from $tablename $whr"; 
	return $query;	 
  }		 
} 

/**
 * Provides form navigation
 *
 * @param array of values $item
 * @return navigation form
 */
function goto($item = array()){ 
   $id = (isset($item['id']))? ' id="'.$item['id'].'"': '';
   $db = (isset($item['db']))? $item['db']: '';
   $cmd	= (isset($item['cmd']))? $item['cmd']: '';	
   $alt	= (isset($item['alt']))? $item['alt']: '';	
   $dis = (isset($item['dis']))? 'disabled="disabled"':'';
   $type = (isset($item['type']))? $item['type']: '';	
   $class = (isset($item['class']))? $item['class']: '';	
   $table = (isset($item['table']))? $item['table']: '';
   $value = (isset($item['value']))? $item['value']: '';
   $action = (isset($item['action']))? $item['action']: 'index.php';
    
   $rt='<form action="'.$action.'" method="post">'; 
   $rt.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
   $rt.='<input type="hidden" name="dbname" value="'.$db.'" />';  
   $rt.='<input type="hidden" name="tablename" value="'.$table.'" />'; 
   switch ($type){
	 case 'check':
	   $rt.='<input type="checkbox" name="check" title="'.$alt.'" />'; 
	   break;
	 case 'icon':
	   $rt.='<input type="hidden" name="cmd" value="'.$cmd.'"/>'; 
	   $rt.='<input class="'.$class.'" type="submit"  value="" title="'.$alt.'" '.$id.' '.$dis.' />'; 	
	   break;
	 default:
	   $rt.='<input type="hidden"  name="cmd" value="'.$cmd.'" />'; 
	   $rt.='<input class="'.$class.'" type="submit"  value="'.$value.'" title="'.$alt.'" '.$id.' '.$dis.' />'; 	
	   break;
   }
   $rt.='</form>'."\n"; 
   return $rt;
} 


/**
 * Show database list the available database and forms to create or restore a database. (Home)
 *
 * @return List of available database with backup and restore forms
 */
function showdb(){
  $output='';
  $link=connectmysql();
  if ($link){    
    $output.='<div class="db">'; 
    $output.=listdbs();
    $output.='</div>'; 
    $output.='<div class="dbfs">'; 
    $output.='<form name="cdb" action="index.php" method="post" class="jscheck">';
    $output.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
    $output.='<div class="fieldset"><fieldset><legend>'.LBL_CND.'</legend>';
    $output.='<div class="cb"><label for="ndbname" class="required">'.LBL_NDN.':</label><input type="text" name="ndbname" id="ndbname" /></div>';
    $output.='<input type="hidden" name="cmd" value="createdatabase" />';
    $output.='<input class="but createdb" type="submit" name="cmd" value="'.LBL_CDB.'" />';
    $output.='</fieldset></div>';
    $output.='</form>';
    		
    $output.='<form action="index.php" method="post" enctype="multipart/form-data" class="jscheck">';
    $output.='<div class="fieldset"><fieldset><legend>'.LBL_RBD.'</legend>';
    $output.= message(MSG_CBF, 'info', 'inline');
    $output.='<div class="cb"><label for="rdbname" class="required">'.GEN_DB.':</label>';
    $output.='<select id="rdbname" name="dbname" title="'.LBL_SDR.'">';
    $output.='<option></option>';
    include_once("settings.php");
    $dbnamearray=dbrestrict();
    for($i =0; $i < count($dbnamearray); $i++){
    	$output.="<option>$dbnamearray[$i]</option>"; 
    }
    $output.='</select></div>';

    
    $backupdir=$GLOBALS['backupdir'];
    $files = get_filelist($backupdir, 'sql');
    if(count($files) > 0){
      $output.='<div class="cb"><label>'.LBL_RSF.':</label></div>';
      $output.= message(  MSG_RSO, 'info', 'inline');
      $output.='<div class="cb"><label for="local"><input type="radio" name="restorefrom" id="local" value="local" />'.LBL_LOC.'</label>';
      $output.='<label for="backupdir"><input type="radio" name="restorefrom" id="backupdir" value="backupdir" />'.LBL_RBK.'</label> </div>';
      
      $output.='<div id="bkdirfiles" class="cb"><label for="bkupfile">'.LBL_BKF.'</label><select id="bkupfile" name="bkupfile" title="'.LBL_BKF.'">';
      $output.='<option></option>';
      foreach($files as $file){
    	$output.="<option>$file</option>"; 
      }
      $output.='</select></div>';
      $output.='<div class="cb" id="filebkup"><label for="rfile">'.LBL_RFF.':</label><input type="file" id="rfile" name="file" /></div>';
 
    }else{
      $output.='<div class="cb" id="files"><label for="rfile">'.LBL_RFF.':</label><input type="file" id="rfile" name="file" /></div>';
    }  
    $output.='<input type="hidden" name="cmd" value="Restore" />';
    $output.='<input class="sml restore" type="submit" title="'.BTN_RDB.'"  value="'.BTN_RSR.'"/>';
    $output.='</fieldset></div>';
    $output.='</form>';
	$output.='</div>';	
  } 
  return $output;
}

/**
 * Builds the Where part of queries.
 *
 * @param Primary key field $pk
 * @param Primary key value $pv
 * @return where part of query.
 */
function buildwhr($pk, $pv){ 
  $whr=""; 
  $pn =count($pv); 
  for($t =0; $t < $pn; $t++){		
	if(empty($pv[$t])){
	  $whr.="( $pk[$t] IS NULL || $pk[$t] ='')";
	}else{  
	  $whr.="$pk[$t]='$pv[$t]'"; 
	}
	if($t < $pn-1){ 
	  $whr.=" and "; 
	} 
  } 
  if ($whr !=" "){ 
	return $whr; 
  }else{ 
	return false; 
  } 
} 

/**
 * Add Edit record
 *
 * @param add or edit $ae
 * @return results or False
 */
function addeditrecord($ae = 'add'){ 
  $tablename =$_POST['tablename'];
  $dbname = $_POST['dbname'];
  $pk=(isset($_POST['pk']))?cleanvar($_POST['pk']):'';
  $pv=(isset($_POST['pv']))?cleanvar($_POST['pv']):'';
  $farray=$_POST['array'];
  $result=exequery("Select * from $tablename");	 

  $nflds = mysql_num_fields($result); 
  $fields = mysql_list_fields($dbname, $tablename); 
  $qry=""; 
  if($ae == 'edit'){
   	$query = "UPDATE $tablename set "; 
  }else{
   	$query = "Insert into $tablename Values( "; 
  }
  for ($x =0; $x < $nflds; $x++){ 
    //Multiple Select values for SET
    if(isset($farray[$x]) ){
      if(is_array($farray[$x])){
        $mval="";
        $mc = count($farray[$x]);
        for($m=0; $m < $mc; $m++){
          if($m+1 == $mc){
            $mval.= cleanvar($farray[$x][$m]); 
          }else{
            $mval.= cleanvar($farray[$x][$m]).","; 
          }
          $fval = $mval;
        }
      }else{
        $fval = cleanvar($farray[$x]); 
      }
    }else{
       $fval =''; 
    }
    if($ae == 'add'){
      $qry .= "'$fval'"; 
    }else{
      $fie = mysql_field_name($fields, $x ); 
      $qry .= "$fie = '$fval'"; 
    }
    if ($x < $nflds-1){ 
      $qry.= ", "; 
    } 
  } 
  if($ae == 'add'){
	$query .= $qry.")"; 
  }else{
	$whr = buildwhr( $pk, $pv); 
	$whr =StripSlashes($whr); 
	$query .= "$qry"; 
	$query .= " where $whr"; 
  }
  $result=exequery($query); 
  if($result){ 
	return $result; 
  }else{ 
	return false; 
  }		
} 


/**
 * Add and Edit Record form
 *
 * @param $tablename
 * @param $query
 * @param Primary key fields $pk
 * @param Primary key values $pv
 * @return Add or Edit record form
 */
function addeditform($tablename, $query, $ae='', $pk ='', $pv= '' ){ 
  if($ae == 'add'){
    $legend= BTN_ART_ALT. ' '.$tablename;
    $cmd='submitaddrecord';
    $sub=BTN_SAR;
  }else{
    $legend= BTN_ERC;
    $cmd='update';
    $sub=BTN_UPD;
  }
  
  $output='';
  $output.='<form action="index.php"  method="post">';
  $output.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';

  $dbname=$_SESSION['dbname'];
  $result=exequery($query);

  $row=mysql_fetch_array($result); 
  $flds = mysql_num_fields($result); 
  $fields = mysql_list_fields($dbname, $tablename); 
  $output.='<input type="hidden" name="tablename" value="'.$tablename.'" />'; 
  $output.='<input type="hidden" name="dbname" value="'.$dbname.'" />';	 
  $output.='<div class="fieldset"><fieldset>';
  $output.='<legend>'.$legend.'</legend>';
  $mxlen = 80;//max width of the form fields 
  for($i=0; $i < $flds; $i++){ 
    $auto = "false";
    $fname=mysql_field_name($fields, $i);
	$output.='<div class="cb"><label for="array['.$i.']">'.$fname.': </label>'; 
	$type  = mysql_field_type($result, $i);
    $flen = mysql_field_len($result, $i);//length of the field  
    if($flen){
      $type.='('.$flen.')';
    }
    $flagstring = mysql_field_flags ($result, $i);
	if($ae == 'add'){
	  $fval= "";
	}else{
	  $fval = "$row[$i]";	 
	}
	$newsql = "show columns from $tablename like '%".$fname."'";
	$newresult = exequery($newsql); 
	$arr=mysql_fetch_array($newresult);
	 if (eregi('primary',$flagstring )){
       $type .= ' PK ';
    }
    if(eregi('auto',$flagstring )){
      $type .= ' auto_increment';
      $auto = 'true';
    }
    if ($auto=='true'){
      if($ae == 'add'){
        $output.='<input type="text" name="array['.$i.']" size="'.$flen.'" value="0" />';
      }else{
        $output.='<input type="text" name="array['.$i.']" size="'.$flen.'" value='.$fval.' />';
      }
    }elseif($flen > $mxlen){
	  $rws= $flen/$mxlen; 
	  if($rws>10){ 
		$rws=10; //max length of textarea 
	  } 
	  $output.='<textarea name="array['.$i.']" rows="'.$rws.'" cols="'.$mxlen.'">'.$fval.'</textarea>'."\n"; 
	  	  
	}elseif (strncmp($arr[1],'set',3)==0 || strncmp($arr[1],'enum',4)==0){  // We have a field type of set or enum
      $num=substr_count($arr[1],',') + 1;  // count the number of entries
      $pos=strpos($arr[1],'(' ); //find the position of '('
      $newstring=substr($arr[1],$pos+1);  // get rid of the '???('
      $snewstring=str_replace(')','',$newstring); // get rid of the last ')'
      $snewstring=str_replace("'",'',$snewstring); // get rid of the '
      $nnewstring=explode(',',$snewstring,$num); // stick into an array
      if(strncmp($arr[1],'set',3)==0 ){//Sets can have combinations of values
        $output.='<select name="array['.$i.'][]" multiple size="3">';
      }else{//Enum one value only
        $output.='<select name="array['.$i.']">';
      }
      $nsel=explode(",",$fval);
      for($y=0; $y<$num;$y++){
        //geteach value 'a,b,c'   
        $sel='';
        for($e=0; $e<count($nsel);$e++){        
          if($nnewstring[$y]== $nsel[$e] ){
            $sel="selected";
          }
        }
        $output.='<option value="'.$nnewstring[$y].'" '.$sel.'>'.$nnewstring[$y].'</option>';
      }
      $output.='</select>';
		// End of new code block for set drop down
	}else{    
	  $output.='<input type="text" name="array['.$i.']" size="'.$flen.'" value="'.$fval.'" />'; 
	}
	 $output.='<span class="type"> '.$type.'</span></div>';	 
  } 
  if(is_array($pk)){
    for($f =0; $f< count($pk);$f++){			 
      $output.='<input type="hidden" name="pk['.$f.']" value="'.$pk[$f].'" />'; 
      $output.='<input type="hidden" name="pv['.$f.']" value="'.$pv[$f].'" />'; 
    }
  }
  $output.='<input type="hidden" name="cmd" value="'.$cmd.'" />';
  $output.='<div class="cb pl"><input class="but editrec" type="submit" value="'.$sub.'" />';
  $output.='<input class="but reset" type="reset" name="Reset" /></div>';
  $output.='</fieldset></div>';
  $output.='</form>';
  return $output;
} 


/**
 * Number of Primary Keys
 *
 * @param resultset $result
 * @return numvber of primary keys
 */ 
function numpk( $result ){ 
	$z =0; 
	for ($i = 0; $i < $flds; $i++) {			 		 	 
		//Find the primary key 
		$flagstring = mysql_field_flags ($result, $i); 
		if(eregi("primary",$flagstring )){ 
			$z++; 
		} 
	} 
	return $z; 
} 

/**
 * Field size form items
 *
 * @param Field type $ft
 * @param number of the field $i
 * @param length $l
 * @return Field size form item
 */
function fieldformsize($ft, $i, $l){ 
  $output='';
  $ft= trim(strtoupper($ft)); 
  switch($ft){
    case 'TINYTEXT': 
    case 'BLOB': 
    case 'TEXT': 
    case 'MEDIUMBLOB':
    case 'MEDIUMTEXT': 
    case 'LONGBLOB': 
    case 'LONGTEXT': 
    case 'TINYBLOB': 
	  $output.='<input type="hidden" name="leng['.$i.']" value="'.$l.'" />';
	break;
	case 'INT':
	case 'TINYINT':
	case 'SMALLINT':
	case 'MEDIUMINT': 
	case 'BIGINT': 
	case 'INTEGER':	   
	$output.='<input type="text" id="leng" name="leng['.$i.']" value="'.$l.'" size ="5" />';
	break;
	case 'YEAR':
	$output.='<select id="leng" name="leng['.$i.']">'; 
	$output.='<option value="4">4</option>'; 
	$output.='<option value="2">2</option>';
	$output.='</select>'."\n";
	break;
	case 'SET':
	case 'ENUM':
    $output.='<input type="text" name="leng['.$i.']" id="leng" size="10" title="values eg: \'apple\', \'banana\', \'carrot\'" value="" />'; 
    break;
	default:
	  $output.='<input type="text" name="leng['.$i.']" id="leng" size="5" value="'.$l.'" />';
	break;  			
  }
  return $output;
} 

/**
 * Make field
 *
 * @param field name $fie
 * @param value $nslash
 * @param field type $ftyp
 * @param length $flen
 * @param $extras
 * @return form field item
 */
function makefield($fie, $nslash, $ftyp, $flen, $extras=""){ 
  $ft= trim(strtoupper($ftyp)); 
  if($ft=="BLOB" ||   $ft =="MEDIUMBLOB" || $ft=="MEDIUMTEXT" || $ft=="LONGBLOB"|| $ft=="LONGTEXT" || $ft=="TINYBLOB" || $flen > 50){ 
	$rfield="<textarea name='$fie' $extras>$nslash</textarea>"; 			 
  }else{		 
	$rfield="<input type='text' name='$fie' size='$flen' value='$nslash' $extras />";				 
  } 
  return $rfield;
}  


/**
 * Display table row
 *
 * @param $dbname
 * @param tablename $tbl
 * @param $pk
 * @param $pkfield
 * @param $cpk
 * @param $row
 * @param $flds
 * @param $rclass
 * @param $id
 * @param $context
 * @return table row with controls
 */
function displayrow($dbname, $tbl, $pk, $pkfield, $cpk, $row, $flds, $rclass, $id='', $context=''){ 
  $output='';
  $pkfs=''; 
  $hv=''; 
  $hf=''; 
  $token = ($_SESSION['token'])?$_SESSION['token']:'';
  $fields = mysql_list_fields($dbname, $tbl); 
	
  if($cpk >0 && !empty($pkfield)){ 
	for($a = 0; $a < $cpk; $a++){ 
	  $fieldn = $pkfield[$a];			 
		$hf .= "<input type='hidden' name='pk[$a]' value='$pkfield[$a]' />"; 
		$hv .= "<input type='hidden' name='pv[$a]' value='$row[$fieldn]' />"; 
	} 
  }else{ //No Primary Key so use all fields 
		//$fields = mysql_list_fields($dbname, $tbl); 
	for($b = 0; $b < $flds; $b++){ 
	  $fie = mysql_field_name($fields, $b );	 
	  $hf .= "<input type='hidden' name='pk[$b]' value='$fie' />"; 
	  $hv .= "<input type='hidden' name='pv[$b]' value='$row[$b]' />";	 
	} 
  }
  $dbf="<input type='hidden' name='dbname' value='$dbname' />";
  $tblf="<input type='hidden' name='tablename' value='$tbl' />"; 
  $npksf="<input type='hidden' name='npkeys' value='$cpk' />"; 
						 
  $output.="<tr class='$rclass'>"; 
	//edit Record 
  $output.='<td class="c0 action">';
  if(check_priv('UPDATE', 'mysql')|| check_priv('USAGE', 'mysql')){
    $output.='<form action="index.php" method="post">'; 
    $output.='<input type="hidden" name="token" value="'.$token .'" />';
    $output.="$dbf";
    $output.="$tblf";
    $output.="$npksf";
    $output.="$hf"; 
    $output.="$hv"; 
    if($context == 'user'){
       $output.='<input type="hidden" name="cmd" value="edituser" />'; 
    }else{
      $output.='<input type="hidden" name="cmd" value="edit" />'; 
    }
    $output.='<input class="icon editrec" type="submit" name="edit" value="" id="edit'.$id.'" title="'.BTN_ERC.'" />'; 
    $output.='</form>';
  }
  $output.="</td>\n"; 
				 
	//Display all the columns.			 
  for($col = 0; $col < $flds; $col ++){ 
	$nslash = StripSlashes($row[$col]); 
	$fie = mysql_field_name($fields, $col );
	$ftyp=mysql_field_type($fields, $col );
	$flen=mysql_field_len($fields, $col );
		
	$c=$col+1;
	if($context == 'user'){
	  $output.="<td class='c$c'>";
	}else{
	  $output.="<td class='c$c' axis='$fie' >";
	}
	$output.="$nslash";
	$output.="</td>\n";				 
  }
  $c++;
	//Delete record 
   
  $output.="<td class='c$c action'>";
  if(check_priv('DELETE', 'mysql')){
    $output.='<form action="index.php" method="post">';
    $output.='<input type="hidden" name="token" value="'.$token .'" />'; 
    $output.="$dbf";
    $output.="$tblf";
    $output.="$npksf";
    $output.="$hf"; 
    $output.="$hv"; 
  
    $output.='<input type="hidden" name="cmd" value="delete" />';
    $output.='<input type="submit" name="delete" class="icon delrow" value=" " id="del'.$id.'" title="'.BTN_DRC.'" />';
    $output.='</form>';
  }
  $output.='</td>';
  $output.="</tr>\n";
  return $output;
} 

/**
 * removes copies from an array $x. 
 *
 * @param array $x
 * @return unique value array $x
 */
function removearraycopy($x){	 
  $leng= count($x); 
  sort($x); 
  $farr=array(); 
	 
  for ($i =0; $i < $leng; $i++){ 
	$flag=false;	 
	for ($s =0; $s < count($farr); $s++){ 
	  if($x[$i]==$farr[$s]){ 
		$flag=true; 
	  } 
	} 
	if ($flag == false){ 
	  $farr[count($farr)] = $x[$i];			 
	} 
  } 
  return $farr;	 
} 

/**
 * Which page, provides page navigation for tables
 *
 * @param $num_rows
 * @param $pagemax
 * @param $pg
 * @param $tablename
 * @param $searchval
 * @param $query
 * @return page navigation controls
 */
function whichpage($num_rows, $pagemax, $pg, $tablename, $searchval, $query){
  $output='';
  $pgs = $num_rows/$pagemax; 
  $pgs=ceil($pgs);//round up the number of pages. 
  $output.='<form action="index.php" class="recspage" method="post" name="recspage">';
  $output.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
  $output.='<span class="info">Total number of records '.$num_rows.', displayed on '.$pgs.' pages of </span>';
  $output.='<input type="text"  name="pagemax" class="pagemax" value="'.$pagemax.'" size="4"  title="'.MSG_TNR.'" />'; 			 
  $output.='<input type="hidden" name="searchval" value="'.$searchval.'" />'; 
  $output.='<input type="hidden" name="tablename" value="'.$tablename.'" />'; 
  $output.='<input type="hidden" name="query" value="'.$query.'" />'; 
  $output.='<input type="hidden" name="cmd" value="showpage" />'; 
  $output.='<span class="info"> '.GEN_RPP.'.</span></form>';
  $pagescrol='';
  $sval='';													 
  if($pgs >1){    
    $pagescrol='<div class="pagecount">';
	$nxt=$pg+1;
    $bk=$pg-1;
    $lst=$pgs;
    $end=$lst-1;
    $showp=$pg+1;
    if($searchval !=''){
      $sval="&amp;searchval=$searchval";
    }           	
		   
	$pagescrol .= '<form action="index.php" method="post">'; 
	$pagescrol.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
    if($pg>=1){ 
      $pagescrol .= '<input type="submit" name="first" value="'.BTN_FST.'" title="'.BTN_FST_ALT.'" class="nav first" />'; 	
      $pagescrol .= '<input type="submit" name="back" value="'.BTN_BCK.'" title="'.BTN_BCK_ALT.'" class="nav back" /> ';
	}		   			
	$pagescrol .= '<input type="hidden" name="pg" class="pagemax" value="'.$showp.'" size="4" title="'.MSG_TNR.'" />'; 
	$pagescrol .= '<input type="hidden" name="pback" value="true" />'; 
	$pagescrol .= '<input type="hidden" name="searchval" value="'.$searchval.'" />'; 
	$pagescrol .= '<input type="hidden" name="tablename" value="'.$tablename.'" />'; 
	$pagescrol .= '<input type="hidden" name="query" value="'.$query.'" />'; 
	$pagescrol .= '<input type="hidden" name="cmd" value="showpage" />'; 
			
    if($showp < $lst){ 
      $pagescrol .= ' <input type="submit" name="next" value="'.BTN_NXT.'" title="'.BTN_NXT_ALT.'" class="nav next" />'; 	
      $pagescrol .= ' <input type="submit" name="last" value="'.BTN_LST.'" title="'.BTN_LST_ALT.'" class="nav last" />'; 			   
    }   
    $pagescrol.= '</form>'; 
    $pagescrol.='</div>';   
	}
	$output.=$pagescrol;
	return $output;
} 

/**
 * Display footer
 *
 * @return footer
 */
function display_foot(){
  $output='';
  if(check_priv('debug', 'tbm')){
    $output .= showpassingvars();
  }
  $version=$GLOBALS['version'];
  $output.='<div id="foot">'.GEN_VER.' '.$version.' &copy; '.date('Y').' <a href="http://bearsql.org/">Bear SQL</a></div>';
  return $output;
}

/**
 * Size of a table or database
 *
 * @param $dbname
 * @param $tablename
 * @return size
 */
function mysize($dbname, $tablename){
  $like="";
  $total="";
  $t=0;
  if($tablename !=""){
    $like=" like '$tablename'";
  }
  $sql= "SHOW TABLE STATUS FROM $dbname $like";
  //$result = mysql_query($sql);
  $result=exequery($sql);
  if($result){  
    while($rec = mysql_fetch_array($result)){
      $t+=($rec['Data_length'] + $rec['Index_length']);
    }
    $total ="<span class='bytes'>$t bytes</span>";
  }else{
    $total=GEN_UKN;
  }
  return($total);
}

/**
 * Write your own query form
 *
 * @param $dbname
 * @param $value
 * @param $hasresult
 * @return form to write query
 */
function wyoq($dbname, $value, $hasresult=false){
  $wyoqf='<form method="post" action="index.php">';
  $wyoqf.='<div class="fieldset"><fieldset class="lone"><legend>'.BTN_WYOQ_ALT.'</legend>';
  $wyoqf.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
  $wyoqf.='<input type="hidden" name="dbname" value="'.$dbname.'" />';
  $wyoqf.='<textarea name="wyoqta" cols="60" rows="5" >'.$value.'</textarea>';
  $wyoqf.='<div class="cb">';
  $wyoqf.='<input class="but exec" type="submit" name="cmd" value="'.BTN_RQ.'" />'; 
  $wyoqf.='<input class="but svq" type="submit" name="cmd" value="'.BTN_SQ.'" />'; 
  if($hasresult){
	$wyoqf.='<input class="but svres" type="submit" name="cmd" value="'.BTN_SR.'" /></p>'; 	
  }
  $wyoqf.='</div></fieldset></div></form>'; 
  return $wyoqf;
}


/**
 * Run your query
 *
 * @param query $wyoqta
 * @param $dbname
 * @return query results with wyoq form
 */
function wyoqta($wyoqta, $dbname){
  $output='';
  require_once('savedqueries.php');
  $output.='<h3>'.BTN_WYOQ_ALT.': <span>'.GEN_RLT.'</span></h3>';
  $result=exequery($wyoqta); 
  if(@mysql_num_rows($result) >0){ 
	$numrows=mysql_num_rows($result); 
	$flds=mysql_num_fields($result); 
	$output.='<table class="wyo">';	 
	for($r=0; $r < $numrows; $r++){ 
	  $output.='<tr>'; 
	  $row=mysql_fetch_array($result); 
	  for($col = 0; $col < $flds; $col ++){ 
		$nslash = StripSlashes($row[$col]); 
		$output.="<td>$nslash</td>";				 
	  } 
	  $output.='</tr>'; 
	} 
	$output.='</table>';
  }elseif (mysql_affected_rows()){ 
	message(GEN_NRA.': '.mysql_affected_rows(), 'notice');	 
  }else{
	message(GEN_NRQ, 'notice'); 
  }
  if(isset($_POST['cmd'])){
	$cmd=strtolower(str_replace(' ','', $_POST['cmd']));
	switch($cmd){
	  case 'savequery':
	  case strtolower(str_replace(' ','', BTN_SQ)):
		writeQueryFile($wyoqta);
		break;
	  case 'deletequery':
	  case strtolower(str_replace(' ','', BTN_DQ)):
		delsavedquery($wyoqta);
		break;
	  case 'saveresults':
	  case strtolower(str_replace(' ','', BTN_SR)):
		saveresults($wyoqta);
		break;
	}
  }
  $output.= wyoq($dbname, $wyoqta, true);
  $output.= listSavedQueries();
  return $output;
} 

/**
 * Create database
 *
 * @param database name $ndb
 */
function createdb($ndb){
  connectmysql();
  $sql="create database $ndb";
  $result=exequery($sql); 
  if ($result){
    $_SESSION['dbname'] = $ndb;
    $sql="Use $ndb";
	$result=exequery($sql); 
    if($result){
     message(GEN_DB.'<span> '.$_SESSION[dbname].'</span>');
    }
  }
}

/**
 * navigation
 *
 * @param array of navigation items $nav
 * @return navigation
 */
function nav($nav){
  if(!isset($nav)){
    return FALSE;
    exit();
  }
  $o='';
  $m='';
  $rt='';
  if(is_array($nav)){
    foreach($nav as $nk => $n){  
      if(is_array($n)){
        foreach($n as  $bk => $b){          
            $m.=navitem($bk, $b);         
        }
        if($m !=''){
          $o.='<ul class="menu cb">'.$m.'</ul>';
          $m='';
        }
      }else{ 
        $rt.=navitem($nk, $n);
      }
    }
  } 
  if($rt !=''){
    $o.='<ul class="menu cb">'.$rt.'</ul>';
  }
  return $o;
}
/**
 * Navigation item
 *
 * @param single navigation item $but
 * @return navigation item
 */
function navitem($but, $status){
 //$privs = $GLOBALS['privilege'];
 $rt='';
 $tablename=(isset($_POST['tablename']))? cleanvar($_POST['tablename']):'';
 $dbname=(isset($_SESSION['dbname']))? $_SESSION['dbname'] : '';
 $class = 'but '.$status;
  switch ($but){
    case 'createtable':
       if(check_priv('CREATE', 'mysql')|| check_priv('USAGE', 'mysql')){ 
        $rt.=goto(array('db'=> $dbname, 'class'=>'create '.$class, 'cmd'=> 'createtable', 'value'=> BTN_CTB )); 
      }
    break;
    case 'home':
      $rt.=goto(array('class'=> 'home '.$class, 'cmd'=>'home', 'value'=> BTN_HOME )); 
	break;
	
	case'wyoq':
	  if(check_priv('wyoq', 'tbm') && check_priv('USAGE', 'mysql')){
	    $rt.=goto(array('db'=> $dbname, 'class'=>'wyoq '.$class, 'cmd'=>'writequery','value'=> BTN_WYOQ, 'alt'=>BTN_WYOQ_ALT)); 
	  }
	break;
	case 'dbstart':
	  if($dbname){
	    $va=BTN_LTF_ALT.' '. $dbname; 
	    $rt.=goto(array('table'=>$tablename,'db'=> $dbname, 'class'=> 'dbstart '.$class, 'cmd'=>'listtables','value'=> BTN_LTF)); 
      }
	break;
	case 'addrec':
	  if(check_priv('INSERT', 'mysql') || check_priv('USAGE', 'mysql')){
	    $va=BTN_ART_ALT.' '.$tablename; 
	    $rt.=goto(array('table'=>$tablename,'db'=> $dbname, 'class'=>'addrecord '.$class, 'cmd'=>'addrecord', 'value'=>BTN_ART, 'alt'=>$va )); 
	  }
	break;
	case 'altertable':
	  if(check_priv('ALTER', 'mysql') || check_priv('USAGE', 'mysql')){
	    $va=BTN_ALTR.' '.$tablename; 
	    $rt.=goto(array('table'=>$tablename,'db'=> $dbname, 'class'=>'alter '.$class, 'cmd'=>'altertable', 'value'=>BTN_ALTR, 'alt'=>$va ));
	  } 
	break;
	case 'searchtab':
	  if(check_priv('SELECT', 'mysql') || check_priv('USAGE', 'mysql')){
	    $rt.=searchtableform($tablename, $dbname); 
	  }
	break;
	case 'renametab':
	  if(check_priv('ALTER', 'mysql') || check_priv('USAGE', 'mysql')){
	    $va= BTN_RNT.' '.$tablename; 
	    $rt.=goto(array('table'=>$tablename,'db'=> $dbname, 'class'=>'rename '.$class, 'cmd'=>'renametable', 'value'=>BTN_RNT, 'alt'=> $va )); 
	  }
	break;
	case 'addindex':
	  if(check_priv('INDEX', 'mysql') || check_priv('USAGE', 'mysql')){
	    $va=BTN_AIX_ALT.' '. $tablename; 
	    $rt.=goto( array('table'=>$tablename,'db'=> $dbname, 'class'=>'addidx '.$class, 'cmd'=>'addindex', 'value'=>BTN_AIX, 'alt'=>$va) ); 
	  }
	break;
	case 'dropidx':
	  if(check_priv('ALTER', 'mysql') || check_priv('USAGE', 'mysql')){
	    $rt.=goto(array('table'=>$tablename,'db'=> $dbname, 'class'=>'dropidx '.$class, 'cmd'=>'dropindex', 'value'=>BTN_DIX )); 
	  }
	break;
	case 'addpk':
	  if(check_priv('ALTER', 'mysql') || check_priv('USAGE', 'mysql')){
	    $va=BTN_APK_ALT.' '. $tablename; 
	    $rt.=goto(array('table'=>$tablename,'db'=> $dbname, 'class'=>'addpk '.$class, 'cmd'=>'addprimarykey', 'value'=>BTN_APK,'alt'=>$va )); 
	  }
	break;
	case 'droppk':
	  if(check_priv('DROP', 'mysql') ){
	    $va=BTN_DPK_ALT.' '. $tablename; 
	    $rt.=goto(array('table'=>$tablename,'db'=> $dbname, 'class'=>'droppk '.$class, 'cmd'=>'dropprimarykey', 'value'=>BTN_DPK, 'alt'=>$va )); 
	  }
	break;
	case 'addcol':
	  if(check_priv('ALTER', 'mysql') || check_priv('USAGE', 'mysql')){
	    $va=BTN_ACOL_ALT.' '. $tablename; 
	    $rt.=goto(array('table'=>$tablename,'db'=> $dbname, 'class'=>'addcol '.$class, 'cmd'=>'addcolumn', 'value'=>BTN_ACOL ,'alt'=>$va )); 
	  }
	break;
	case 'changecol':
	  if(check_priv('ALTER', 'mysql') || check_priv('USAGE', 'mysql')){
	    $va=BTN_CCOL_ALT.' '. $tablename; 
	    $rt.=goto(array('table'=>$tablename,'db'=> $dbname, 'class'=>'changecol '.$class, 'cmd'=>'changecolumn','value'=>BTN_CCOL, 'alt'=> $va ));
	  } 
	break;
	case 'dropcol':
	  if(check_priv('DROP', 'mysql')){
	    $va=BTN_DCOL_ALT.' '.$tablename; 
	    $rt.=goto(array('table'=>$tablename,'db'=> $dbname, 'class'=>'dropcol '.$class, 'cmd'=>'dropcolumn', 'value'=>BTN_DCOL, 'alt'=>$va ));
	  } 
	break;
	case 'adduser':
	   if(check_priv('CREATE USER', 'mysql')){
	    $rt.=goto(array('table'=>$tablename,'db'=> $dbname, 'class'=>'adduser '.$class,  'cmd'=>'createuser',  'value'=>BTN_CUSR, 'alt'=>BTN_CUSR_ALT  )); 
	  }
	break;
	case'dropuser':
	  if(check_priv('CREATE USER', 'mysql')){	    
	    $rt.=goto(array('table'=>$tablename,'db'=> $dbname, 'class'=>'dropuser '.$class, 'cmd'=>'deleteuser', 'value'=>BTN_DUSR )); 
	  }
	break;
	case'changename':
	  if(check_priv('CREATE USER', 'mysql')){
	    $rt.=goto(array('table'=>$tablename,'db'=> $dbname, 'class'=>'cname '.$class, 'cmd'=>'changeusername', 'value'=>BTN_CNAM )); 
	  }
	break;
	case 'changepass':
	  $rt.=goto(array('table'=>$tablename,'db'=> $dbname, 'class'=>'cpass '.$class, 'cmd'=>'password', 'value'=>BTN_PAS )); 
	break;
	case 'grant':
	  if(check_priv('CREATE USER', 'mysql')){
	    $rt.=goto(array('table'=>$tablename,'db'=> $dbname, 'class'=>'priv '.$class, 'cmd'=>'privileges','value'=> BTN_PRIV ,'alt'=> BTN_PRIV_ALT ));
	  } 
	break;
	case 'users':
	  if(check_priv('CREATE USER', 'mysql')){  
	    $rt.=goto(array('db'=> $dbname, 'class'=>'users '.$class, 'cmd'=>'manageusers', 'value'=>BTN_MUSR )); 
	  }
	break;
	case 'logout': 
	  $rt.=goto(array('class'=>'logout '.$class, 'cmd'=>'logout', 'value'=>BTN_LOUT )); 
	break;	
	}
	if($rt !=''){
	  $rt="<li>$rt</li>";
	}
	return $rt;
}

/**
 * List tables
 *
 * @return table displaying tablenames and controls
 */
function listtables(){
  $output='';
  $dbname=$_SESSION['dbname'];
  $result = mysql_list_tables($dbname); 
  $numtab = mysql_num_rows ($result); 
  if($numtab == 1){ 
	$_SESSION['tablename'] =mysql_tablename($result, 0);	 
  }   
  $output.='<table class="tables">'; 
  $output.='<caption>'.GEN_LOT.'</caption>';
  $output.='<thead><tr><th>'.GEN_TBL.'</th><th>'.LBL_VW.'</th><th>'.LBL_DRP.'</th><th>'.LBL_ATR.'</th><th>'.LBL_SRC.'</th><th>'.LBL_SZE.'</th><th>';
  if(check_priv('SELECT', 'mysql') || check_priv('USAGE', 'mysql')){
    $output.='<input type="checkbox" title="Select all" id="checkall" />';
    $output.=goto(array('db'=>$dbname,'class'=> 'icon optimize','cmd'=>'optimizechecked', 'alt'=>BTN_OPC_ALT, 'id'=>"optckd" )); 
    $output.=goto(array('db'=>$dbname,/*'action'=>'backup.php',*/'class'=> 'icon saveButton', 'cmd'=>'backupchecked',  'alt'=> BTN_BKC_ALT, 'id'=>"savetables" )); 
  }
  $output.='</th></tr></thead>';

  for ($i =0; $i < $numtab; $i++) { 
	$table = trim(mysql_tablename($result, $i));	 
	$output.='<tr class="frow"><td>'; 
	$output.= $table;
	$output.='</td><td>'; 
	if(check_priv('SELECT', 'mysql') || check_priv('USAGE', 'mysql')){ 
	  $output.= goto(array('table'=>$table, 'db'=>$dbname,'class'=>'icon tablego', 'cmd'=>'showtable',  'alt'=>BTN_GOT.' '. $table, 'id'=>"show$table"));	 
	}
	$output.='</td><td>';
	if(check_priv('DROP', 'mysql')){  
	  $output.=goto(array('table'=>$table, 'db'=>$dbname,'class'=>'icon deltable','cmd'=> 'deletetable', 'alt'=>BTN_DRP.' '.$table, 'id'=>"drop$table")); 
	}
	$output.='</td><td>';
	if(check_priv('ALTER', 'mysql') || check_priv('USAGE', 'mysql')){ 
	  $output.=goto(array('table'=>$table, 'db'=>$dbname,'class'=>'icon alter','cmd'=> 'altertable', 'alt'=>LBL_ATR.' '. $table, 'id'=>"alter$table")); 
	}
	$output.='</td><td>'; 
	if(check_priv('SELECT', 'mysql') || check_priv('USAGE', 'mysql')){
	  $output.=searchtableform($table, $_SESSION['dbname']); 
	}
	$output.='</td><td>';
    //Table size in bytes
    $output.= mysize($_SESSION['dbname'],$table);
	$output.='</td><td>'; 
	if(check_priv('SELECT', 'mysql') || check_priv('USAGE', 'mysql')){
	  //checkbox
	  $output.= goto(array('table'=>$table, 'db'=>$dbname,  'alt'=>BTN_CHK.' '. $table, 'type'=>'check' )); 
	  
	  $output.= goto(array('table'=>$table, 'db'=>$dbname,'class'=>'icon optimize check','cmd'=> 'optimizetable',  'alt'=>BTN_OPT.' '. $table, 'id'=>"opt$table")); 
	}
	$output.='</td>';
    $output.='</tr>';	 
  }//for 
  $output.='</table>';		 
  return $output;
}

/**
 * Show records from a query
 *
 * @param $query
 * @param $searchval
 * @return table of records
 */
function showrecords($query, $searchval='' ){
  $output='';
  $tablename= isset($_POST['tablename'])? cleanvar($_POST['tablename']):'';
  include_once("settings.php");
  $dbname=$_SESSION['dbname'];
  $result=exequery($query);
  if($result){
    $pagemax=$GLOBALS['pagemax'];
    if(isset($_POST['pagemax'])){
        $pagemax=cleanvar($_POST['pagemax']);
    } 	
    $num_rows = mysql_num_rows($result); 
    //Workout whick page to display
    if(!isset($_POST['pg']) && !isset($pg)){ 
      $beg=0; 
      $pg=0;
    }else{
      $pg=cleanvar($_POST['pg'])-1;
    	if(isset($_POST['first'])){
    	  $pg=0;
    	}else if(isset($_POST['back'])){
    	  $pg=$pg-1;
    	}else if(isset($_POST['next'])){
    	  $pg++;
    	}else if(isset($_POST['last'])){
    	  $pgs = $num_rows/$pagemax; 
    	  $pg=ceil($pgs)-1;
    	}
    	if($pg < 0 ){
    	  $pg=0;
    	}
    	if($pg > $num_rows/$pagemax){
    	  $pg=ceil($num_rows/$pagemax)-1;
    	}
    	$beg = $pg * $pagemax;
    }
    $pscrol=' '; 
    $pagescrol=' ';  
    $pagescrol= whichpage($num_rows, $pagemax, $pg, $tablename, $searchval, $query);
    $output.='<br />'.$pagescrol; //Display next Top page menu 
 
   
    $flds = mysql_num_fields($result); 
    $fields = mysql_list_fields( $dbname, $tablename); 
    $z=0; 
    $x=0; 
    $pkfield=array(); 
    $output.='<table class="result">';
    $output.='<thead><tr><th></th>';
    
  //*************Display each of the field names.*************************** 
    for ($i = 0; $i < $flds; $i++) {	
      $c=$i+1;
      $title=mysql_field_name($fields, $i);
      $output.= '<th class="c'.$c.'" title="'.LBL_COL.' '. $title.'">'.$title.'</th>'; 
 
      //Find the primary key 
      $flagstring = mysql_field_flags ($result, $i); 
      if(eregi("primary",$flagstring )){ 
        $pk[$z] = $i; 
        $pkfield[$z]= mysql_field_name($fields, $i); 
        $z++; 
      } 
    } 
    $v=$flds+1;
    $output.='<th></th></tr></thead>';	
    $output.='<tbody>';				
			 
    if($z > 0){ 
      $cpk=count($pk); 
    }else{ 
      $cpk=0; 
    } 
 
  //************Display each row from the table.******************************** 
			 
    for ($s=$beg; $s < $beg + $pagemax; $s++){	 
      if($s < $num_rows){ 
        if (!mysql_data_seek ($result, $s)) { 
          $output.=MSG_CSR .' '.$s; 
          continue; 
        } 
        if($s%2==0){ /*remainder of $s/2=0 */
          $rclass="even";
        }else{
          $rclass="odd";
        }
        $row=mysql_fetch_array($result); 
        if(!isset($pk)){ 
          $pk=' '; 
          $pkfield= array(); 
        } 
        $output.=displayrow($dbname, $tablename, $pk, $pkfield, $cpk, $row, $flds, $rclass, $tablename.$s); 
      }			 
    }					    
    $output.='</tbody></table>'; 
    $output.= "$pagescrol"; //Display bottom next page menu 
    $output.="<br /><br />"; 
  }
  if($searchval !=''){
    $advsearch = advancedSearchForm($tablename, $dbname, $searchval);
    $output = $output.$advsearch;
  }
  return $output;
}

/**
 * DEBUG to show all variables being passed to the page
 *
 */
function showpassingvars(){
  echo'<div id="debug">';
  echo"Get: ";
  foreach($_GET as $pram=>$value){
 	echo"$pram: $value, ";
  }
  if($_POST){
    echo"<br />Post: ";
    foreach($_POST as $pram=>$value){
      if($pram =='password'){
        $value ='xxxxx';
      }
      echo"$pram: $value, ";
    }
    echo"<br />Clean Post: ";
    foreach($_POST as $pram=>$value){
      if($pram =='password'){
        $value ='xxxxx';
      }
      echo"$pram: ".cleanvar($value).", ";
    }
  }
  echo"<br />Session: ";
  foreach($_SESSION as $pram=>$value){
 	if($pram =='password'){
 	  $value ='xxxxx';
 	}
 	echo"$pram: $value, ";
  }
  echo"<br />Files: ";
  foreach($_FILES as $pram=>$value){
    if(is_array($value)){
      foreach($value as $key=>$val){
        echo"$key: $val, ";
      }
 	}else{
 	  echo"$pram: $value, ";
 	}
  }
  echo"<br />Privileges <pre>";
  print_r( $GLOBALS['privilege'] );
  echo"</pre>";
  echo'</div>';
}

/** 
 * Message
 * @param message $text
 * @param $type = notice, error, warning, info 
 * @param how to display $out = inline, top
 * @return message 
 */
function message($text, $type='notice', $out='top'){
  if($out == 'inline'){
    return '<p class="mesg '.$type.'">'.$text.'</p>';   
  }else{
    $GLOBALS['message'][] = '<li class="mesg '.$type.'">'.$text.'</li>'; 
    if($type == 'error' && check_priv('debug', 'tbm')){
      if($link = connectmysql() ){
        $output= "MySQL Server: ".mysql_get_server_info() ."<br />";
        $output.= "MySQL Client: ".mysql_get_client_info()."<br />";
      }
      $output.= 'PHP version: ' . phpversion();
      $GLOBALS['message'][] = '<p class="mesg info">'.$output.'</p>'; 
    }
  }
}

/**
 * Message display
 *
 * @return messages to display top.
 */
function message_display(){
  $output='';
  $messages = array_unique ($GLOBALS['message']);
  foreach( $messages as $mes){
    $output.= $mes;
  }
  if($output !=''){
    return '<ul>'. $output .'</ul>';
  }else{
    return;
  }
}

/**
 * Logout User
 *
 * @return login page
 */
function logout_user(){ 
  unset($_POST);
  session_unset();
  session_destroy();
  unset($lang);
  if(!isset($dbnamearray)){
	$dbnamearray="";
  }
  return show_login($dbnamearray);
}

/**
 * Get the privilege info for the db and current user
 *
 * @param database $db
 */
function priv( $db ){
  $GLOBALS['privilege'] = array();
  $privileges = array();
  $user= $_SESSION['user'];
  $host= $_SESSION['host'];
 
  if(@mysql_get_server_info() > '5.0.2'){  
    $query="select PRIVILEGE_TYPE from information_schema.SCHEMA_PRIVILEGES WHERE TABLE_SCHEMA ='$db' and GRANTEE like '".$user."%'";
    $result = exequery($query);
    while($prv = mysql_fetch_array($result)){
       $privileges[] = $prv[0];
    }
    if(count($privileges)< 1){ // no db specific privs so look at user
      $query="select PRIVILEGE_TYPE from information_schema.USER_PRIVILEGES";
      $result = exequery($query);
      while($prv = mysql_fetch_object($result)){
        $privileges[] = $prv->PRIVILEGE_TYPE;
      }
    }
  }else{ // Try to get privileges from mysql.db etc
    if(@mysql_select_db('mysql')){
      $query ="SELECT * from mysql.user where user = '$user' and host = '$host'";
      $result = exequery($query);
      $prv = mysql_fetch_array($result);
      if(is_array($prv)){
        foreach($prv as $key => $val){
          if($val == 'Y') {         
            $privileges[] = strtoupper(str_replace('_', ' ',substr($key, 0, -5)));
          }
        }
      }
      $query ="SELECT * from mysql.db where user = '$user' and host = '$host' and db = '$db'";
      $result = exequery($query);
      $prv = mysql_fetch_array($result);
      if(is_array($prv)){
        foreach($prv as $key => $val){
          if($val == 'Y') {         
            $privileges[] = strtoupper(str_replace('_', ' ',substr($key, 0, -5)));
          }else if($val == 'N'){ 
            if(in_array($val, $privileges )){
              $key = array_search($val, $privileges);
              unset($privileges[$key]);
            }
          }
        }
      }
      @mysql_select_db($db);
    }
  }
  $privileges = removearraycopy($privileges);
  $GLOBALS['privilege'] = $privileges;
}


/**
 * Check privileges for current user
 *
 * @param privilege to check $priv
 * @param type of privilege $ptype
 * @return TRUE if privilege allowed
 */
function check_priv($priv, $ptype='mysql'){
  if(isset($GLOBALS['privilege'])){
    $privs = $GLOBALS['privilege'];
  }else{
    return FALSE;
    exit();
  }
  $rt =FALSE;
  $user = $_SESSION['user'];
  
  $restrict = $GLOBALS['allow'];
  
  switch ($ptype) {
    case 'tbm': 
      if(is_array($restrict)){   
        if(isset($restrict[$user]->$priv)) { // Tablemgr Privleges for user (overrides all user settings)
          $rt = $restrict[$user]->$priv;
        }else if(isset($restrict['all'][$priv])) { // Tablemgr Privleges for ALL users
          $rt = $restrict['all'][$priv];
        }
      }
      
    break;
    case 'mysql':
    default:    
      if((isset($restrict[$user]) && !$restrict[$user]['use_privilege']) || !$restrict['all']['use_privilege'] ){
        return TRUE;
        exit();  
      }
      $dbprivs =(@mysql_get_server_info() > '5.0.2')?TRUE:FALSE;
      //message($dbprivs .': '. @mysql_get_server_info());
      if($dbprivs){
        if(is_array($privs) && in_array($priv, $privs)){ // Database Privleges
          $rt = TRUE;
        }
      }else{
        $rt = TRUE; // no dbprivs to check;
      } 
    break;  
  }
  
  return $rt;
}

/**
 * Make token
 *
 * @return token  
 */
function maketoken(){
   $token = md5(uniqid(rand(), true));
   $_SESSION['token'] = $token;
   return $token;
}

/**
 * Check token compairs the form token with the session token
 * 
 * @param string $token
 * @return TRUE if tokens match
 */
function checktoken($token){
  //if we dont have a valid token, return invalid;
  if(!$token){
    return FALSE;
  }elseif($_SESSION['token'] !== $token ){       
    //if we have a token check that is is valid
    return FALSE;
  }else{
    return TRUE;
  }   
}

/**
 * Change nav status
 *
 * @param array of navigation items $nav
 * @param name of nav item to change $name
 * @param status to set for nav item $status (active, current or disabled)
 * @return modified $nav
 */
function change_nav_status($nav, $name, $status){
  if(is_array($nav)){
    foreach($nav as $key => $n){    
      if(isset($n[$name]) ){
      	 $nav[$key][$name] = $status;
      	 return $nav;
   	  }
    }  
  }else{  
     if(isset($nav[$name]) ){
      	 $nav[$name] = $status;
      	 return $nav;
   	  }
  }
}

/**
 *  Restore database or tables.
 */
function restore(){
  $qend=$GLOBALS['bkupsplit'];
  require_once("settings.php");
  
  if(isset($_POST['restorefrom'])&& $_POST['restorefrom'] == 'backupdir'){
    $dir =$GLOBALS['backupdir'];
    $bkfile = $_POST['bkupfile'];
    $filetmp = $dir.'/'.$bkfile.'.sql';
  }else{
    $filetmp=$_FILES['file']['tmp_name'];
    $filename=$_FILES['file']['name'];
  }
  if ($filetmp!="" && is_file($filetmp)) {
	flush();
	set_time_limit(1000);
	$fsize=filesize($filetmp);
	if($file=fread(fopen($filetmp, "rb"), $fsize)){
	  $qa=explode($qend,$file);
	  for ($i=0;$i < count($qa)-1;$i++) {
		exequery($qa[$i]);
	  }
	  message(MSG_RSF.', '.$i .' '.MSG_QUR.' '.$filetmp.', '.LBL_SZE.' '.$fsize, 'notice');
	}else{
	  message(MSG_URQ.' '. $filetmp, 'warning');
	}
  }else{
    message(MSG_URQ.' '. $filetmp, 'warning');
  }
}

/**
 * Headers sent to prompt for file save.
 * 
 * @return headers 
 */
function filesaveheaders($filename){
	// fix for IE catching or PHP bug issue
  header("Pragma: public");
  header("Expires: 0"); // set expiration time
  header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
  header("Cache-Control: private",false); // required for certain browsers
		
  header("Content-Type: application/force-download");
  header("Content-Type: application/octet-stream");
  header("Content-Type: application/download");

  header('Content-Disposition: attachment; filename="'.$filename.'";');

  header("Content-Transfer-Encoding: binary");
  header("Content-Length: ".filesize($filename));
  @readfile($filename);
}		


/**
 * Return an array of filenames of type ext from directory
 *
 * @param string path $directory
 * @param srting file extension $ext
 * @return array of filenames
 */
function get_filelist($directory, $ext){
  $files=array();
  if(is_dir($directory)){
    $dir = opendir( $directory ); 
    while ($file = readdir($dir)) { 
      if (eregi("\.$ext",$file)) { 
        $files[] = substr($file,0,-4);
      }
  	}
  	closedir($dir);
  }
  return $files;
}
